/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.console.SQLPlusConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Messages;

public class EditCommand
extends CommandListener
implements IHelp {
    private static final String CMD = "edit";
    private static final String AFIEDT = "afiedt.buf";
    private static final String EDITOR = "_EDITOR";
    private static final String INLINE = "inline";
    private static final String DOT = ".";
    private ScriptRunnerContext ctx;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getProperty("script.runner.restrict_level") != null) {
            try {
                int x = Integer.parseInt(ctx.getProperty("script.runner.restrict_level").toString());
                if (x > 0) {
                    ctx.write(MessageFormat.format(Messages.getString("EditCommand.4"), CMD));
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        this.ctx = ctx;
        StringTokenizer st = new StringTokenizer(cmd.getSql());
        String filename = "";
        String editfile = (String)ctx.getProperty("script.runner.file.editfile");
        if (editfile != null) {
            filename = editfile;
        }
        if (st.countTokens() == 1) {
            if (filename.lastIndexOf(DOT) == -1) {
                filename = filename + DOT + ctx.getProperty("script.runner.file.suffix");
            }
            File f = new File(ctx.prependCD(filename));
            return this.processFile(cmd, ctx.prependCD(filename), true);
        }
        if (st.countTokens() == 2) {
            st.nextToken();
            String token2 = st.nextToken();
            if (token2.trim().equalsIgnoreCase(INLINE)) {
                this.processInternalEditor();
                return true;
            }
            filename = token2.lastIndexOf(DOT) == -1 ? token2 + DOT + ctx.getProperty("script.runner.file.suffix") : token2;
            File f = new File(ctx.prependCD(filename));
            return this.processFile(cmd, ctx.prependCD(filename));
        }
        if (st.countTokens() > 3) {
            ctx.write(Messages.getString("EditCommand.5"));
            ctx.write(Messages.getString("EditCommand.6"));
            return true;
        }
        return this.processFile(cmd, System.getProperty("user.home") + File.separator + AFIEDT);
    }

    private boolean processFile(ISQLCommand cmd, String filename) {
        return this.processFile(cmd, filename, false);
    }

    private boolean processFile(ISQLCommand cmd, String filename, boolean editBuffer) {
        IBuffer buf = this.ctx.getSQLPlusBuffer().getBufferSafe();
        if (cmd.getSql().trim().equalsIgnoreCase(CMD) && buf == null || buf != null && buf.size() == 0) {
            if (this.ctx.getTopLevel()) {
                this.ctx.write(buf.getBufferSafe().list(false));
            } else {
                this.ctx.write(Messages.getString("EditCommand.2"));
            }
            return true;
        }
        try {
            File file = new File(filename);
            if (!file.exists() || editBuffer) {
                FileWriter f = new FileWriter(filename);
                f.write(buf.getBuffer());
                f.flush();
                f.close();
            }
            if (this.ctx.getMap().get(EDITOR).toLowerCase().equals(INLINE)) {
                this.processInternalEditor();
            } else {
                this.processExternalEditor(filename);
                if (file.exists()) {
                    String line;
                    FileReader fr = new FileReader(filename);
                    BufferedReader br = new BufferedReader(fr);
                    buf.clear();
                    while ((line = br.readLine()) != null) {
                        buf.add(line);
                    }
                    buf.setBufferSafe(buf.getBufferList());
                    br.close();
                    this.ctx.write(buf.getBufferSafe().list(false));
                }
            }
        }
        catch (IOException e) {
            this.ctx.write(e.getMessage() + "\n");
        }
        return true;
    }

    private void processInternalEditor() {
        SQLPlusConsoleReader reader = (SQLPlusConsoleReader)this.ctx.getSQLPlusConsoleReader();
        reader.setRedit(true);
    }

    private void processExternalEditor(String filename) {
        String editor = this.ctx.getMap().get(EDITOR);
        ProcessBuilder builder = null;
        builder = editor != null && editor.equalsIgnoreCase("wordpad") && System.getProperty("os.name").startsWith("Windows") ? new ProcessBuilder("cmd", "/C", "start", "/WAIT", "wordpad", filename) : new ProcessBuilder(editor, filename);
        builder.directory(new File(FileUtils.getCWD(this.ctx)));
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        try {
            Process process = builder.start();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isCommandLine()) {
            ctx.getSQLPlusConsoleReader().pauseReader(true);
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isCommandLine()) {
            ctx.getSQLPlusConsoleReader().pauseReader(false);
        }
    }

    @Override
    public String getCommand() {
        return "EDIT";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

