/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import oracle.ide.print.misc.Macro;
import oracle.ide.print.misc.Percent;
import oracle.ide.print.misc.Util;
import oracle.ide.print.ui.Chooser;
import oracle.ide.print.ui.Dialog;
import oracle.ide.print.ui.Preview;

final class Option
extends Dialog
implements Macro.Listener,
Percent.Listener,
FocusListener {
    private JCheckBox myHeader;
    private JTextField myHeaderLeft;
    private JTextField myHeaderCenter;
    private JTextField myHeaderRight;
    private JButton myHeaderFont;
    private JButton myHeaderColor;
    private Color myHeaderColorValue;
    private Font myHeaderFontValue;
    private JCheckBox myFooter;
    private JTextField myFooterLeft;
    private JTextField myFooterCenter;
    private JTextField myFooterRight;
    private JButton myFooterFont;
    private JButton myFooterColor;
    private Color myFooterColorValue;
    private Font myFooterFontValue;
    private JCheckBox myBorder;
    private JButton myBorderColor;
    private Color myBorderColorValue;
    private JCheckBox myLineNumbers;
    private JCheckBox myWrapLongLines;
    private JCheckBox myFontStyle;
    private JCheckBox myForegroundColors;
    private JButton myTextFont;
    private JButton myTextColor;
    private JButton myBackgroundColor;
    private JSpinner myLineSpacing;
    private Font myTextFontValue;
    private Color myTextColorValue;
    private Color myBackgroundColorValue;
    private JCheckBox mySelection;
    private JCheckBox myPrintAsShownInEditor;
    private JLabel myTextFontColorLabel;
    private JLabel myBackgroundColorLabel;
    private JLabel myLineSpacingLabel;
    private Percent myZoomFactor;
    private JTextField myZoomWidth;
    private JTextField myZoomHeight;
    private JRadioButton myFitToPage;
    private Preview myPreview;
    private List<JButton> myMacro;
    private static final int TEXT_WIDTH = 30;
    private static final int FIELD_WIDTH = 136;
    private static final int MACRO_WIDTH = 41;
    private static final int MAX_PAGE_NUBER = 32;
    private static final int MAX_HEADER_LENGTH = 100;
    private static final int MAX_FOOTER_LENGTH = 100;
    private static final double SPACING_MIN = 0.1;
    private static final double SPACING_MAX = 10.0;
    private static final double SPACING_STEP = 0.1;
    private static final int[] PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 200, 300, 500};

    Option(Preview preview) {
        super("LBL_Print_Options", false);
        this.myPreview = preview;
        this.myBorderColorValue = Util.getConfig().getBorderColor();
        this.myTextColorValue = Util.getConfig().getTextColor();
        this.myTextFontValue = Util.getConfig().getTextFont();
        this.myBackgroundColorValue = Util.getConfig().getBackgroundColor();
        this.myHeaderColorValue = Util.getConfig().getHeaderColor();
        this.myHeaderFontValue = Util.getConfig().getHeaderFont();
        this.myFooterColorValue = Util.getConfig().getFooterColor();
        this.myFooterFontValue = Util.getConfig().getFooterFont();
    }

    @Override
    protected String getHelpTopic() {
        return "f1_idedprintoptions_html";
    }

    @Override
    protected JButton[] getButtons() {
        JButton apply = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_Apply"), this.i18n("TLT_Apply")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.updatePreview();
            }
        });
        JButton ok = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_OK"), this.i18n("TLT_OK")){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Option.this.updatePreview()) {
                    Option.this.close();
                }
            }
        });
        JButton cancel = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_Cancel"), this.i18n("TLT_Cancel")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.close();
            }
        });
        this.markAsDefault(ok);
        return new JButton[]{apply, ok, cancel};
    }

    @Override
    protected Component getInnerComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        this.createSection(this.getBorderSection(), "LBL_Border", panel, c);
        this.createSection(this.getTitleSection(), "LBL_Header_Footer", panel, c);
        this.createSection(this.getTextAndZoomSection(), "LBL_Text", panel, c);
        this.updateAllControls();
        return panel;
    }

    @Override
    public void invalidValue(String value) {
        this.printError(this.i18n("ERR_Zoom_Value_Is_Invalid"));
    }

    private boolean updatePreview() {
        int zoomHeight;
        String macro = this.checkMacro();
        if (macro != null) {
            this.printError(this.i18n("ERR_Invalid_Macro", macro));
            return false;
        }
        int zoomWidth = Util.getInt(this.myZoomWidth.getText());
        if (!this.checkValue(zoomWidth, zoomHeight = Util.getInt(this.myZoomHeight.getText()))) {
            return false;
        }
        Util.getConfig().setBorder(this.myBorder.isSelected());
        Util.getConfig().setBorderColor(this.myBorderColorValue);
        Util.getConfig().setHeader(this.myHeader.isSelected());
        Util.getConfig().setHeaderLeft(this.myHeaderLeft.getText());
        Util.getConfig().setHeaderCenter(this.myHeaderCenter.getText());
        Util.getConfig().setHeaderRight(this.myHeaderRight.getText());
        Util.getConfig().setHeaderColor(this.myHeaderColorValue);
        Util.getConfig().setHeaderFont(this.myHeaderFontValue);
        Util.getConfig().setFooter(this.myFooter.isSelected());
        Util.getConfig().setFooterLeft(this.myFooterLeft.getText());
        Util.getConfig().setFooterCenter(this.myFooterCenter.getText());
        Util.getConfig().setFooterRight(this.myFooterRight.getText());
        Util.getConfig().setFooterColor(this.myFooterColorValue);
        Util.getConfig().setFooterFont(this.myFooterFontValue);
        Util.getConfig().setWrapLongLines(this.myWrapLongLines.isSelected());
        Util.getConfig().setLineNumbers(this.myLineNumbers.isSelected());
        Util.getConfig().setFontStyle(this.myFontStyle.isSelected());
        Util.getConfig().setForegroundColors(this.myForegroundColors.isSelected());
        Util.getConfig().setTextColor(this.myTextColorValue);
        Util.getConfig().setTextFont(this.myTextFontValue);
        Util.getConfig().setBackgroundColor(this.myBackgroundColorValue);
        Util.getConfig().setLineSpacing((Double)this.myLineSpacing.getValue());
        Util.getConfig().setSelection(this.mySelection.isSelected());
        Util.getConfig().setPrintAsShownInEditor(this.myPrintAsShownInEditor.isSelected());
        double zoom = 0.0;
        if (this.myZoomFactor.isEnabled()) {
            zoom = this.myZoomFactor.getValue();
        } else if (this.myZoomWidth.isEnabled()) {
            zoom = Percent.createZoomWidth(zoomWidth);
        } else if (this.myZoomHeight.isEnabled()) {
            zoom = Percent.createZoomHeight(zoomHeight);
        } else if (this.myFitToPage.isSelected()) {
            zoom = 0.0;
        }
        Util.getConfig().setZoom(zoom);
        this.myPreview.updatePapers();
        return true;
    }

    private String checkMacro() {
        JTextField[] fields;
        for (JTextField field : fields = new JTextField[]{this.myHeaderLeft, this.myHeaderCenter, this.myHeaderRight, this.myFooterLeft, this.myFooterCenter, this.myFooterRight}) {
            String macro = this.checkMacro(field.getText());
            if (macro == null) continue;
            return macro;
        }
        return null;
    }

    private String checkMacro(String value) {
        int k1;
        String name;
        if (value == null) {
            return null;
        }
        int k2 = 0;
        do {
            if ((k2 = value.indexOf("%", k2)) == -1) {
                return null;
            }
            k1 = k2;
            if ((k2 = value.indexOf("%", k1 + 1)) != -1) continue;
            return null;
        } while (this.isMacro(name = value.substring(k1 + 1, k2++)));
        return "%" + name + "%";
    }

    private boolean isMacro(String name) {
        for (Macro macro : Macro.values()) {
            if (!macro.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean checkValue(int zoomWidth, int zoomHeight) {
        if (this.myHeaderFontValue.getSize() > 100) {
            this.printError(this.i18n("ERR_Header_Size_Is_Too_Big"));
            return false;
        }
        if (this.myFooterFontValue.getSize() > 100) {
            this.printError(this.i18n("ERR_Footer_Size_Is_Too_Big"));
            return false;
        }
        if (zoomWidth <= 0 || zoomHeight <= 0) {
            this.printError(this.i18n("ERR_Page_Number_Is_Invalid"));
            return false;
        }
        if (zoomWidth > 32 || zoomHeight > 32) {
            this.printError(this.i18n("ERR_Page_Number_Is_Too_Big"));
            return false;
        }
        return true;
    }

    private void createSection(JPanel section, String key, JPanel panel, GridBagConstraints c) {
        c.insets = new Insets(8, 0, 0, 0);
        panel.add((Component)this.createTitledSeparator(this.i18n(key)), c);
        c.insets = new Insets(8, 0, 0, 0);
        panel.add((Component)section, c);
        c.insets = new Insets(2, 0, 0, 0);
    }

    private JPanel getBorderSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.myBorder = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_Print_Border")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myBorderColor.setEnabled(Option.this.myBorder.isSelected());
            }
        });
        panel.add((Component)this.myBorder, c);
        c.weightx = 1.0;
        c.insets = new Insets(0, 8, 2, 0);
        this.myBorderColor = this.createButton(new Dialog.ButtonAction(this.icon("color"), this.i18n("TLT_Border_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myBorderColorValue = Option.this.color(Option.this.myBorderColorValue);
            }
        });
        panel.add((Component)this.myBorderColor, c);
        return panel;
    }

    private JPanel getTitleSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.setLabelPanel(panel, c);
        this.setHeaderPanel(panel, c);
        this.setFooterPanel(panel, c);
        this.setMacroPanel(panel, c);
        return panel;
    }

    private void setLabelPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.anchor = 10;
        c.insets = new Insets(0, 8, 2, 0);
        panel.add((Component)new JLabel(), c);
        panel.add((Component)this.createLabel(this.i18n("LBL_Left")), c);
        panel.add((Component)this.createLabel(this.i18n("LBL_Center")), c);
        panel.add((Component)this.createLabel(this.i18n("LBL_Right")), c);
    }

    private void setHeaderPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        this.myHeader = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_Print_Header")){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean enabled = Option.this.myHeader.isSelected();
                Option.this.myHeaderLeft.setEnabled(enabled);
                Option.this.myHeaderCenter.setEnabled(enabled);
                Option.this.myHeaderRight.setEnabled(enabled);
                Option.this.myHeaderColor.setEnabled(enabled);
                Option.this.myHeaderFont.setEnabled(enabled);
            }
        });
        panel.add((Component)this.myHeader, c);
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 8, 2, 0);
        this.myHeaderLeft = new JTextField();
        this.myHeaderLeft.addFocusListener(this);
        this.setWidth(this.myHeaderLeft, 136);
        panel.add((Component)this.myHeaderLeft, c);
        this.myHeaderCenter = new JTextField();
        this.myHeaderCenter.addFocusListener(this);
        this.setWidth(this.myHeaderCenter, 136);
        panel.add((Component)this.myHeaderCenter, c);
        this.myHeaderRight = new JTextField();
        this.myHeaderRight.addFocusListener(this);
        this.setWidth(this.myHeaderRight, 136);
        panel.add((Component)this.myHeaderRight, c);
        c.weightx = 0.0;
        c.fill = 0;
        this.myHeaderColor = this.createButton(new Dialog.ButtonAction(this.icon("color"), this.i18n("TLT_Header_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myHeaderColorValue = Option.this.color(Option.this.myHeaderColorValue);
            }
        });
        panel.add((Component)this.myHeaderColor, c);
        this.myHeaderFont = this.createButton(new Dialog.ButtonAction(this.icon("font"), this.i18n("TLT_Header_Font")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myHeaderFontValue = Option.this.font(Option.this.myHeaderFontValue, true);
            }
        });
        panel.add((Component)this.myHeaderFont, c);
    }

    private void setFooterPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        this.myFooter = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_Print_Footer")){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean enabled = Option.this.myFooter.isSelected();
                Option.this.myFooterLeft.setEnabled(enabled);
                Option.this.myFooterCenter.setEnabled(enabled);
                Option.this.myFooterRight.setEnabled(enabled);
                Option.this.myFooterColor.setEnabled(enabled);
                Option.this.myFooterFont.setEnabled(enabled);
            }
        });
        panel.add((Component)this.myFooter, c);
        c.weightx = 1.0;
        c.insets = new Insets(0, 8, 2, 0);
        c.fill = 2;
        this.myFooterLeft = new JTextField();
        this.myFooterLeft.addFocusListener(this);
        this.setWidth(this.myFooterLeft, 136);
        panel.add((Component)this.myFooterLeft, c);
        this.myFooterCenter = new JTextField();
        this.myFooterCenter.addFocusListener(this);
        this.setWidth(this.myFooterCenter, 136);
        panel.add((Component)this.myFooterCenter, c);
        this.myFooterRight = new JTextField();
        this.myFooterRight.addFocusListener(this);
        this.setWidth(this.myFooterRight, 136);
        panel.add((Component)this.myFooterRight, c);
        c.weightx = 0.0;
        c.fill = 0;
        this.myFooterColor = this.createButton(new Dialog.ButtonAction(this.icon("color"), this.i18n("TLT_Footer_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myFooterColorValue = Option.this.color(Option.this.myFooterColorValue);
            }
        });
        panel.add((Component)this.myFooterColor, c);
        this.myFooterFont = this.createButton(new Dialog.ButtonAction(this.icon("font"), this.i18n("TLT_Footer_Font")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myFooterFontValue = Option.this.font(Option.this.myFooterFontValue, true);
            }
        });
        panel.add((Component)this.myFooterFont, c);
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.updateMacro(true);
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.updateMacro(false);
    }

    private void updateMacro(boolean enabled) {
        for (JButton macro : this.myMacro) {
            macro.setEnabled(enabled);
        }
    }

    private void setMacroPanel(JPanel panel, GridBagConstraints c) {
        JPanel p = new JPanel(new GridBagLayout());
        ++c.gridy;
        c.insets = new Insets(8, 0, 0, 0);
        c.anchor = 17;
        panel.add((Component)this.createLabel(this.i18n("LBL_Insert_Macros")), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        this.myMacro = new ArrayList<JButton>();
        for (Macro macro : Macro.values()) {
            JButton button = macro.createButton(this, this.i18n(macro.name()), this.icon(macro.name().toLowerCase()));
            this.setWidth(button, 41);
            this.myMacro.add(button);
            button.setEnabled(false);
            p.add((Component)button, c);
        }
        c.weightx = 1.0;
        c.insets = new Insets(8, 8, 2, 0);
        c.gridwidth = 3;
        panel.add((Component)p, c);
    }

    @Override
    public void pressed(Macro macro) {
        JTextField focusable = this.getFocusableTextField();
        String text = focusable.getText();
        String head = text.substring(0, focusable.getSelectionStart());
        String tail = text.substring(focusable.getSelectionEnd(), text.length());
        focusable.setText(head + macro.getName() + tail);
    }

    private JTextField getFocusableTextField() {
        if (this.myHeaderLeft.hasFocus()) {
            return this.myHeaderLeft;
        }
        if (this.myHeaderCenter.hasFocus()) {
            return this.myHeaderCenter;
        }
        if (this.myHeaderRight.hasFocus()) {
            return this.myHeaderRight;
        }
        if (this.myFooterLeft.hasFocus()) {
            return this.myFooterLeft;
        }
        if (this.myFooterCenter.hasFocus()) {
            return this.myFooterCenter;
        }
        if (this.myFooterRight.hasFocus()) {
            return this.myFooterRight;
        }
        return null;
    }

    private JPanel getTextAndZoomSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.createTopTextPanel(panel, c);
        this.createBottomTextPanel(panel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 7;
        c.insets = new Insets(8, 0, 8, 0);
        panel.add((Component)this.createTitledSeparator(this.i18n("LBL_Zoom")), c);
        this.createZoomSection(panel, c);
        return panel;
    }

    private void createTopTextPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        this.myLineNumbers = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_Line_Numbers")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.myLineNumbers, c);
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.myForegroundColors = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_Foreground_Colors"), this.i18n("TLT_Foreground_Colors")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.updateTextControls();
            }
        });
        panel.add((Component)this.myForegroundColors, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.myTextFontColorLabel = this.createLabel(this.i18n("LBL_Text_Color_and_Font"));
        panel.add((Component)this.myTextFontColorLabel, c);
        c.insets = new Insets(0, 8, 2, 0);
        this.myTextColor = this.createButton(new Dialog.ButtonAction(this.icon("color"), this.i18n("TLT_Text_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myTextColorValue = Option.this.color(Option.this.myTextColorValue);
            }
        });
        panel.add((Component)this.myTextColor, c);
        this.myTextFont = this.createButton(new Dialog.ButtonAction(this.icon("font"), this.i18n("TLT_Text_Font")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myTextFontValue = Option.this.font(Option.this.myTextFontValue, !Option.this.myFontStyle.isSelected());
            }
        });
        panel.add((Component)this.myTextFont, c);
    }

    private void createBottomTextPanel(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        this.myWrapLongLines = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_Wrap_Long_Lines")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.myWrapLongLines, c);
        c.gridwidth = 3;
        this.myFontStyle = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_Font_Styles"), this.i18n("TLT_Font_Styles")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.myFontStyle, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.myBackgroundColorLabel = this.createLabel(this.i18n("LBL_Background_Color"));
        panel.add((Component)this.myBackgroundColorLabel, c);
        c.insets = new Insets(0, 8, 2, 0);
        this.myBackgroundColor = this.createButton(new Dialog.ButtonAction(this.icon("color"), this.i18n("TLT_Background_Color")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.myBackgroundColorValue = Option.this.color(Option.this.myBackgroundColorValue);
            }
        });
        panel.add((Component)this.myBackgroundColor, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        this.myPrintAsShownInEditor = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_As_Shown_In_Editor"), this.i18n("TLT_As_Shown_In_Editor")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Option.this.updateTextControls();
            }
        });
        panel.add((Component)this.myPrintAsShownInEditor, c);
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.mySelection = this.createCheckBox(new Dialog.ButtonAction(this.i18n("LBL_Selection"), this.i18n("TLT_Selection")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        panel.add((Component)this.mySelection, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.myLineSpacingLabel = this.createLabel(this.i18n("LBL_Line_Spacing"));
        panel.add((Component)this.myLineSpacingLabel, c);
        double value = Util.getConfig().getLineSpacing();
        if (value < 0.0) {
            value = 1.0;
        }
        c.insets = new Insets(0, 8, 2, 0);
        this.myLineSpacing = new JSpinner(new SpinnerNumberModel(value, 0.1, 10.0, 0.1));
        this.setWidth(this.myLineSpacing, this.myTextColor.getPreferredSize().width);
        this.setHeight(this.myLineSpacing, this.myTextColor.getPreferredSize().height);
        this.myLineSpacingLabel.setLabelFor(this.myLineSpacing);
        panel.add((Component)this.myLineSpacing, c);
    }

    private void createZoomSection(JPanel panel, GridBagConstraints c) {
        ButtonGroup group = new ButtonGroup();
        double zoom = Util.getConfig().getZoom();
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 0;
        JRadioButton buttonFactor = this.createRadioButton(this.i18n("LBL_Zoom_to"), this.i18n("TLT_Zoom_to"));
        buttonFactor.addItemListener(this.createItemListener(false, false, true));
        group.add(buttonFactor);
        this.myZoomFactor = new Percent(true, this, Percent.getZoomFactor(zoom, 1.0), PERCENTS, 0, null, this.i18n("TLT_Zoom"));
        panel.add((Component)this.createPanel(buttonFactor, this.myZoomFactor), c);
        JRadioButton buttonWidth = this.createRadioButton(this.i18n("LBL_Fit_Width_to"), this.i18n("TLT_Fit_Width_to"));
        buttonWidth.addItemListener(this.createItemListener(true, false, false));
        panel.add((Component)buttonWidth, c);
        group.add(buttonWidth);
        c.insets = new Insets(5, 5, 5, 0);
        this.myZoomWidth = new JTextField(this.getString(Percent.getZoomWidth(zoom, 1)));
        this.setWidth(this.myZoomWidth, 30);
        panel.add((Component)this.myZoomWidth, c);
        c.weightx = 1.0;
        c.insets = new Insets(5, 8, 5, 0);
        panel.add((Component)this.createLabel(this.i18n("LBL_Pages")), c);
        ++c.gridy;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.myFitToPage = this.createRadioButton(this.i18n("LBL_Fit_to_Page"), this.i18n("TLT_Fit_to_Page"));
        this.myFitToPage.addItemListener(this.createItemListener(false, false, false));
        panel.add((Component)this.myFitToPage, c);
        group.add(this.myFitToPage);
        JRadioButton buttonHeight = this.createRadioButton(this.i18n("LBL_Fit_Height_to"), this.i18n("TLT_Fit_Height_to"));
        buttonHeight.addItemListener(this.createItemListener(false, true, false));
        panel.add((Component)buttonHeight, c);
        group.add(buttonHeight);
        c.insets = new Insets(5, 5, 5, 0);
        this.myZoomHeight = new JTextField(this.getString(Percent.getZoomHeight(zoom, 1)));
        this.setWidth(this.myZoomHeight, 30);
        panel.add((Component)this.myZoomHeight, c);
        c.weightx = 1.0;
        c.insets = new Insets(5, 8, 5, 0);
        panel.add((Component)this.createLabel(this.i18n("LBL_Pages")), c);
        buttonFactor.setSelected(Percent.isZoomFactor(zoom));
        buttonWidth.setSelected(Percent.isZoomWidth(zoom));
        buttonHeight.setSelected(Percent.isZoomHeight(zoom));
        this.myFitToPage.setSelected(Percent.isZoomPage(zoom));
    }

    private ItemListener createItemListener(final boolean width, final boolean height, final boolean factor) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (Option.this.myZoomWidth != null) {
                    Option.this.myZoomWidth.setEnabled(width);
                }
                if (Option.this.myZoomHeight != null) {
                    Option.this.myZoomHeight.setEnabled(height);
                }
                if (Option.this.myZoomFactor != null) {
                    Option.this.myZoomFactor.setEnabled(factor);
                }
            }
        };
    }

    private void updateAttribute() {
    }

    private void updateTextControls() {
        boolean enabled = !this.myPrintAsShownInEditor.isSelected();
        this.mySelection.setEnabled(enabled);
        this.myWrapLongLines.setEnabled(enabled);
        this.myForegroundColors.setEnabled(enabled);
        this.myFontStyle.setEnabled(enabled);
        this.myTextFont.setEnabled(enabled);
        this.myBackgroundColor.setEnabled(enabled);
        this.myBackgroundColorLabel.setEnabled(enabled);
        this.myLineSpacing.setEnabled(enabled);
        this.myLineSpacingLabel.setEnabled(enabled);
        this.myTextColor.setEnabled(enabled && !this.myForegroundColors.isSelected());
        this.myTextFontColorLabel.setEnabled(enabled && !this.myForegroundColors.isSelected());
    }

    private String getString(int value) {
        if (value < 0) {
            return Integer.toString(-value);
        }
        return Integer.toString(value);
    }

    private Font font(Font font, boolean isStyleEnabled) {
        return new Chooser.FontDialog(font, isStyleEnabled).getValue();
    }

    private Color color(Color color) {
        return new Chooser.ColorDialog(color).getValue();
    }

    private void updateAllControls() {
        this.myBorder.setSelected(Util.getConfig().hasBorder());
        this.myBorderColor.setEnabled(Util.getConfig().hasBorder());
        this.myHeader.setSelected(Util.getConfig().hasHeader());
        this.myHeaderLeft.setText(Util.getConfig().getHeaderLeft());
        this.myHeaderLeft.setEnabled(Util.getConfig().hasHeader());
        this.myHeaderCenter.setText(Util.getConfig().getHeaderCenter());
        this.myHeaderCenter.setEnabled(Util.getConfig().hasHeader());
        this.myHeaderRight.setText(Util.getConfig().getHeaderRight());
        this.myHeaderRight.setEnabled(Util.getConfig().hasHeader());
        this.myHeaderColor.setEnabled(Util.getConfig().hasHeader());
        this.myHeaderFont.setEnabled(Util.getConfig().hasHeader());
        this.myFooter.setSelected(Util.getConfig().hasFooter());
        this.myFooterLeft.setText(Util.getConfig().getFooterLeft());
        this.myFooterLeft.setEnabled(Util.getConfig().hasFooter());
        this.myFooterCenter.setText(Util.getConfig().getFooterCenter());
        this.myFooterCenter.setEnabled(Util.getConfig().hasFooter());
        this.myFooterRight.setText(Util.getConfig().getFooterRight());
        this.myFooterRight.setEnabled(Util.getConfig().hasFooter());
        this.myFooterColor.setEnabled(Util.getConfig().hasFooter());
        this.myFooterFont.setEnabled(Util.getConfig().hasFooter());
        this.myLineNumbers.setSelected(Util.getConfig().hasLineNumbers());
        this.myWrapLongLines.setSelected(Util.getConfig().isWrapLongLines());
        this.myFontStyle.setSelected(Util.getConfig().hasFontStyle());
        this.myForegroundColors.setSelected(Util.getConfig().hasForegroundColors());
        this.mySelection.setSelected(Util.getConfig().hasSelection());
        this.myPrintAsShownInEditor.setSelected(Util.getConfig().isPrintAsShownInEditor());
        this.updateTextControls();
    }

    @Override
    public double getCustomValue(int index) {
        return 0.0;
    }

    @Override
    public void valueChanged(double value, int index) {
    }
}

