
EXECUTE dbms_output.put_line('');
EXECUTE dbms_output.put_line('<WORKFLOW_NODE_NAME> node started: ' || SYSTIMESTAMP);
EXECUTE dbms_output.put_line('');

DECLARE
  v_caseid                  VARCHAR2(130);
  v_caseid_alias            VARCHAR2(130);
  v_target                  VARCHAR2(130);
  v_input_data              VARCHAR2(130);
  v_build_data              VARCHAR2(130);
  v_test_data               VARCHAR2(130);
  v_apply_data              VARCHAR2(130);
  v_index                   VARCHAR2(130);
  v_data_usage              VARCHAR2(130);
  v_weights_setting         VARCHAR2(130);
  v_build_setting           VARCHAR2(130);
  v_cost_setting            VARCHAR2(130);
  v_test_metric             VARCHAR2(130);
  v_confusion_matrix        VARCHAR2(130);
  v_confusion_matrix_part   VARCHAR2(130);
  v_lift                    VARCHAR2(130);
  v_lift_part               VARCHAR2(130);
  v_roc                     VARCHAR2(130);
  v_roc_part                VARCHAR2(130);
  v_lexer_name              VARCHAR2(130);
  v_auto_filter_name        VARCHAR2(130);
  v_stoplist_name           VARCHAR2(130);
  v_policy_name             VARCHAR2(130);
  v_row_diag_table          VARCHAR2(130);
  v_accuracy                NUMBER;
  v_accuracy_nested         DM_NESTED_NUMERICALS;
  v_avg_accuracy            NUMBER;
  v_predictive_conf         NUMBER;
  v_area_under_curve        NUMBER;
  v_area_under_curve_nested DM_NESTED_NUMERICALS;
  v_area_under_curve_result VARCHAR2(130);
  v_num_row_alias           VARCHAR2(130);
  TYPE ODMR_OBJECT_VALUES is TABLE OF VARCHAR2(4000);
  v_partitions              ODMR_OBJECT_VALUES;
  v_targets                 ODMR_OBJECT_VALUES;
  v_xlst                    dbms_data_mining_transform.TRANSFORM_LIST;
  v_sql                     CLOB;
  v_sql2                    CLOB;
  v_user_session            VARCHAR2(130) := SYS_CONTEXT ('USERENV', 'SESSION_USER');
  v_drop                    VARCHAR2(30) := '&DROP_EXISTING_OBJECTS';
  
  FUNCTION generateUniqueName RETURN VARCHAR2 IS
    v_uniqueName  VARCHAR2(130);
  BEGIN
    SELECT 'ODMR$'||TO_CHAR(SYSTIMESTAMP,'HH24_MI_SS_FF')||dbms_random.string(NULL, 7) INTO v_uniqueName FROM dual;
    RETURN v_uniqueName;
  END;
    
  FUNCTION getInputSource(p_nodeId VARCHAR2) RETURN VARCHAR2 IS
    v_output  VARCHAR2(261);
  BEGIN
    SELECT OUTPUT_NAME INTO v_output FROM "&WORKFLOW_OUTPUT" WHERE NODE_ID = p_nodeId AND COMMENTS = 'Output Data';
    RETURN v_output;
  END;

  FUNCTION getTextPolicy(p_nodeId VARCHAR2, p_column VARCHAR2 DEFAULT NULL) RETURN VARCHAR2 IS
    v_output  VARCHAR2(130);
  BEGIN
    IF (p_column IS NULL) THEN
      SELECT OUTPUT_NAME INTO v_output FROM "&WORKFLOW_OUTPUT" WHERE NODE_ID = p_nodeId AND OUTPUT_TYPE = 'POLICY' AND ADDITIONAL_INFO IS NULL;
    ELSE
      SELECT OUTPUT_NAME INTO v_output FROM "&WORKFLOW_OUTPUT" WHERE NODE_ID = p_nodeId AND OUTPUT_TYPE = 'POLICY' AND ADDITIONAL_INFO = 'Column='||p_column;
    END IF;
    RETURN v_output;
  END;

  PROCEDURE recordOutput(p_NODE_ID VARCHAR2, p_NODE_NAME VARCHAR2, p_NODE_TYPE VARCHAR2, 
                         p_MODEL_ID VARCHAR2, p_MODEL_NAME VARCHAR2, p_MODEL_TYPE VARCHAR2, 
                         p_OUTPUT_NAME VARCHAR2, p_OUTPUT_TYPE VARCHAR2, p_ADDITIONAL_INFO VARCHAR2, p_COMMENTS VARCHAR2) IS
  BEGIN
    INSERT INTO "&WORKFLOW_OUTPUT" VALUES (p_NODE_ID, p_NODE_NAME, p_NODE_TYPE, p_MODEL_ID, REPLACE(REPLACE(p_MODEL_NAME,'"',''), (v_user_session||'.'), ''), p_MODEL_TYPE, p_OUTPUT_NAME, p_OUTPUT_TYPE, p_ADDITIONAL_INFO, SYSTIMESTAMP, p_COMMENTS);
    COMMIT;
  END;

  PROCEDURE execSQL(p_sql CLOB) IS
    curid         INTEGER;
    ignoreid      INTEGER;    
  BEGIN
    curid := DBMS_SQL.OPEN_CURSOR;
    DBMS_SQL.PARSE(curid, p_sql, DBMS_SQL.NATIVE);
    ignoreid := DBMS_SQL.EXECUTE(curid);
    DBMS_SQL.CLOSE_CURSOR(curid);
  EXCEPTION WHEN OTHERS THEN
    IF DBMS_SQL.IS_OPEN(curid) THEN
      DBMS_SQL.CLOSE_CURSOR(curid);
    END IF;
    RAISE;
  END;

  FUNCTION formatErrorStack(
    p_node_name IN VARCHAR2,
    p_sqlerr        IN VARCHAR2,
    p_error_stack   IN VARCHAR2 ) RETURN VARCHAR2
  IS
  BEGIN
    RETURN SUBSTR('Error in ' || p_node_name || ': ' || CHR(13) || CHR(10) || p_sqlerr || 
                   CHR(13) || CHR(10) || p_error_stack, 1, 4000);
  END;

BEGIN
  -- input view
  v_caseid := '<CASEID>';
  v_target := '<TARGET>';
  
  v_input_data := generateUniqueName;
<INPUT_DATA>
<BUILD_TEST_DATA>
<BUILD_TEXT_SETTING>
<BUILD_MODELS>
EXCEPTION WHEN OTHERS THEN
  RAISE_APPLICATION_ERROR(-20999, formatErrorStack('<WORKFLOW_NODE_NAME>', SQLERRM, DBMS_UTILITY.FORMAT_ERROR_BACKTRACE()));
END;
/
EXECUTE dbms_output.put_line('');
EXECUTE dbms_output.put_line('<WORKFLOW_NODE_NAME> node completed: ' || SYSTIMESTAMP);
EXECUTE dbms_output.put_line('');
