<COST_SETTING>

  -- apply result for test
  v_apply_data := generateUniqueName;
  execSQL('CREATE TABLE '||v_apply_data||' <TABLE_PARALLEL_HINT> AS SELECT <PARALLEL_HINT> "'||v_caseid||'", t.*, ora_dm_partition_name(<MODEL_NAME_PARAM> USING *) PARTITION_NAME FROM '||v_test_data||' s, TABLE(PREDICTION_SET(<MODEL_NAME_PARAM> <TEST_APPLY_COST_OPTION>)) t');
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_apply_data, 'TABLE', NULL, 'Apply Data');

  v_index := generateUniqueName;
  execSQL('CREATE INDEX '||v_index||' ON '||v_apply_data||'(PARTITION_NAME) <TABLE_PARALLEL_HINT>');

  -- test metric
  v_test_metric := generateUniqueName;
  execSQL('CREATE TABLE '||v_test_metric||' (METRIC_NAME VARCHAR2(30), PARTITION_NAME VARCHAR2(128), METRIC_VARCHAR_VALUE VARCHAR2(128), METRIC_NUM_VALUE NUMBER) <TABLE_PARALLEL_HINT> <COMPRESSION_METHOD> <PRIORITY_LEVEL>');
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_test_metric, 'TABLE', NULL, 'Test Metric');

  v_index := generateUniqueName;
  execSQL('CREATE INDEX '||v_index||' ON '||v_test_metric||'(PARTITION_NAME) <TABLE_PARALLEL_HINT>');

  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_SCHEMA'', NULL, SUBSTR(''<MODEL_NAME_PARAM>'', 1 ,INSTR(''<MODEL_NAME_PARAM>'', ''.'', 1, 1)-1))');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_NAME'', NULL, SUBSTR(''<MODEL_NAME_PARAM>'', INSTR(''<MODEL_NAME_PARAM>'',''.'', -1, 1)+1))');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''MINING_FUNCTION'', NULL, ''CLASSIFICATION'')');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''TARGET_ATTRIBUTE'', NULL, '''||v_target||''')');

  EXECUTE IMMEDIATE 'SELECT "'||v_target||'" FROM '||v_test_data||' GROUP BY "'||v_target||'" ORDER BY count(*) ASC' BULK COLLECT INTO v_targets;
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_VARCHAR_VALUE) VALUES (''LEAST_TARGET_VALUE'', NULL, '''||v_targets(1)||''')');

  v_sql := 
   'INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
    SELECT ''TEST_ROWS'', NVL(ora_dm_partition_name(<MODEL_NAME_PARAM> using *), ''DM$$UNKNOWN''), count(*)
    FROM '||v_test_data||'
    GROUP BY ora_dm_partition_name(<MODEL_NAME_PARAM> using *)
    UNION
    SELECT ''TEST_ROWS'', NULL, count(*) FROM '||v_test_data;
  execSQL(v_sql);

  -- global confusion matrix
  v_confusion_matrix := generateUniqueName;
  DBMS_DATA_MINING.COMPUTE_CONFUSION_MATRIX (
    accuracy                    => v_accuracy,
    apply_result_table_name     => v_apply_data,
    target_table_name           => v_test_data,
    case_id_column_name         => '"'||v_caseid||'"',
    target_column_name          => '"'||v_target||'"',
    confusion_matrix_table_name => v_confusion_matrix,
    score_column_name           => 'PREDICTION',
    score_criterion_column_name => '<SCORE_CRITERION>',
    score_criterion_type        => '<SCORE_CRITERION>');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE) VALUES (''ACCURACY'', NULL, NVL('||v_accuracy||', 0)*100)');
    
  -- partition confusion matrix
  v_confusion_matrix_part := generateUniqueName;
  DBMS_DATA_MINING.COMPUTE_CONFUSION_MATRIX_PART (
    accuracy                    => v_accuracy_nested,
    apply_result_table_name     => v_apply_data,
    target_table_name           => v_test_data,
    case_id_column_name         => '"'||v_caseid||'"',
    target_column_name          => '"'||v_target||'"',
    confusion_matrix_table_name => v_confusion_matrix_part,
    score_column_name           => 'PREDICTION',
    score_criterion_column_name => '<SCORE_CRITERION>',
    score_criterion_type        => '<SCORE_CRITERION>',
    score_partition_column_name => 'PARTITION_NAME');
  EXECUTE IMMEDIATE 'INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
                    SELECT ''ACCURACY'', t.attribute_name, NVL(t.value, 0)*100 FROM TABLE(:1) t' USING v_accuracy_nested;
  execSQL('INSERT INTO '||v_confusion_matrix_part||' (ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE, VALUE, PARTITION_NAME)
          SELECT ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE, VALUE, NULL FROM '||v_confusion_matrix);
  execSQL('DROP TABLE '||v_confusion_matrix||' PURGE');
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_confusion_matrix_part, 'TABLE', NULL, 'Confusion Matrix');
  
  -- global average accuracy
  v_sql := 
    'INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE)
    WITH
    a as
      (SELECT a.actual_target_value, sum(a.value) recall_total
         FROM '||v_confusion_matrix_part||' a
         WHERE PARTITION_NAME IS NULL
         GROUP BY a.actual_target_value)
      ,
    b as
      (SELECT count(distinct b.actual_target_value) num_recalls
         FROM '||v_confusion_matrix_part||' b
         WHERE PARTITION_NAME IS NULL)
      ,
    c as
      (SELECT c.actual_target_value, value
         FROM '||v_confusion_matrix_part||' c
         WHERE PARTITION_NAME IS NULL 
         AND actual_target_value = predicted_target_value)
      ,
    d as
      (SELECT NVL(sum(c.value/GREATEST(0.0001, a.recall_total)), 0) tot_accuracy
         FROM a, c
         WHERE a.actual_target_value = c.actual_target_value(+))
    SELECT ''AVG_ACCURACY'', d.tot_accuracy/GREATEST(0.0001, b.num_recalls) * 100 avg_accuracy
    FROM b, d';
  execSQL(v_sql);

  -- partition average accuracy
  v_sql := 
    'INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
    WITH
    a as
      (SELECT a.PARTITION_NAME, a.actual_target_value, sum(a.value) recall_total
         FROM '||v_confusion_matrix_part||' a
         WHERE a.PARTITION_NAME IS NOT NULL
         group by a.PARTITION_NAME, a.actual_target_value)
      ,
    b as
      (SELECT b.PARTITION_NAME, count(distinct b.actual_target_value) num_recalls
         FROM '||v_confusion_matrix_part||' b 
         WHERE b.PARTITION_NAME IS NOT NULL
         group by b.PARTITION_NAME)
      ,
    c as
      (SELECT c.PARTITION_NAME, c.actual_target_value, value
         FROM '||v_confusion_matrix_part||' c
         WHERE c.PARTITION_NAME IS NOT NULL AND c.actual_target_value = c.predicted_target_value)
      ,
    d as
      (SELECT a.PARTITION_NAME, NVL(sum(c.value/GREATEST(0.0001, a.recall_total)), 0) tot_accuracy
         FROM a, c
         WHERE a.PARTITION_NAME = c.PARTITION_NAME(+) AND a.actual_target_value = c.actual_target_value(+) GROUP BY a.PARTITION_NAME)
    SELECT <PARALLEL_HINT> ''AVG_ACCURACY'', b.PARTITION_NAME, d.tot_accuracy/GREATEST(0.0001, b.num_recalls) * 100 avg_accuracy
    FROM b, d WHERE b.PARTITION_NAME = d.PARTITION_NAME';
  execSQL(v_sql);

  -- global predictive confidence
  v_sql := 
    'INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE)
    WITH
    a as
      (SELECT a.actual_target_value, sum(a.value) recall_total
         FROM '||v_confusion_matrix_part||' a
         WHERE PARTITION_NAME IS NULL 
         GROUP BY a.actual_target_value)
      ,
    b as
      (SELECT count(distinct b.actual_target_value) num_classes
         FROM '||v_confusion_matrix_part||' b
         WHERE PARTITION_NAME IS NULL)
      ,
    c as
      (SELECT c.actual_target_value, value
         FROM '||v_confusion_matrix_part||' c
         WHERE PARTITION_NAME IS NULL 
         AND actual_target_value = predicted_target_value)
      ,
    d as
      (SELECT NVL(sum(c.value/a.recall_total), 0) tot_accuracy
         FROM a, c
         WHERE a.actual_target_value = c.actual_target_value(+))
    SELECT ''PREDICTIVE_CONFIDENCE'', GREATEST(0, ((1 - (1 - d.tot_accuracy/GREATEST(0.0001, b.num_classes)) / GREATEST(0.0001, ((b.num_classes-1)/GREATEST(0.0001, b.num_classes)))) * 100))
    FROM b, d';
  execSQL(v_sql);

  -- partition predictive confidence
  v_sql := 
    'INSERT <PARALLEL_HINT> INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE)
    WITH
    a as
      (SELECT a.PARTITION_NAME, a.actual_target_value, sum(a.value) recall_total
         FROM '||v_confusion_matrix_part||' a
         WHERE a.PARTITION_NAME IS NOT NULL
         group by a.PARTITION_NAME, a.actual_target_value)
      ,
    b as
      (SELECT b.PARTITION_NAME, count(distinct b.actual_target_value) num_classes
         FROM '||v_confusion_matrix_part||' b 
         WHERE b.PARTITION_NAME IS NOT NULL
         group by b.PARTITION_NAME)
      ,
    c as
      (SELECT c.PARTITION_NAME, c.actual_target_value, value
         FROM '||v_confusion_matrix_part||' c
         where c.PARTITION_NAME IS NOT NULL AND actual_target_value = predicted_target_value)
      ,
    d as
      (SELECT a.PARTITION_NAME, NVL(sum(c.value/GREATEST(0.0001, a.recall_total)), 0) tot_accuracy
         FROM a, c
         WHERE a.PARTITION_NAME = c.PARTITION_NAME(+) AND a.actual_target_value = c.actual_target_value(+) group by a.PARTITION_NAME)
    SELECT <PARALLEL_HINT> ''PREDICTIVE_CONFIDENCE'', b.PARTITION_NAME, GREATEST(0, ((1 - (1 - d.tot_accuracy/GREATEST(0.0001, b.num_classes)) / GREATEST(0.0001, ((b.num_classes-1)/GREATEST(0.0001, b.num_classes)))) * 100))
    FROM b, d WHERE b.PARTITION_NAME = d.PARTITION_NAME';
  execSQL(v_sql);

<COMPUTE_TOTAL_COST>
<TEST_TARGET_VALUES>
<GEN_LIFT_RESULT>
<GEN_ROC_RESULT>