
  
  FUNCTION INTEGER_(expression  NUMBER)
  RETURN NUMBER
  IS
  BEGIN
  return trunc(to_number(expression));
  END INTEGER_;
 
  FUNCTION INTEGER_(expression VARCHAR2)
  RETURN NUMBER
  IS
  BEGIN
  return trunc(to_number(expression));
  END INTEGER_;
  
  FUNCTION INTEGER_(expression  TIMESTAMP)
  RETURN NUMBER
  IS
  BEGIN
  if to_char(expression,'YYYYMMDD') = '19700101' then
    return to_number(to_char(expression,'HH24MISS'));
  else
    return to_number(to_char(expression,'YYYYMMDD'));
  END IF;
  END INTEGER_;
  
  FUNCTION INTEGER_(expression  DATE)
  RETURN NUMBER
  IS
  BEGIN
  if to_char(expression,'YYYYMMDD') = '19700101' then
    return to_number(to_char(expression,'HH24MISS'));
  else
    return to_number(to_char(expression,'YYYYMMDD'));
  END IF;
  END INTEGER_;
  
  FUNCTION DECIMAL_(expression  NUMBER)
  RETURN NUMBER
  IS
  BEGIN
  return trunc(to_number(expression));
  END DECIMAL_;
 
  FUNCTION DECIMAL_(expression VARCHAR2)
  RETURN NUMBER
  IS
  BEGIN
  return trunc(to_number(expression));
  END DECIMAL_;
  
  FUNCTION DECIMAL_(expression  TIMESTAMP)
  RETURN NUMBER
  IS
  BEGIN
  if to_char(expression,'YYYYMMDD') = '19700101' then
    return to_number(to_char(expression,'HH24MISS'));
  else
    return to_number(to_char(expression,'YYYYMMDDHH24MISS.FF'));
  END IF;
  END DECIMAL_;
  
  FUNCTION DECIMAL_(expression  DATE)
  RETURN NUMBER
  IS
  BEGIN
  if to_char(expression,'YYYYMMDD') = '19700101' then
    return to_number(to_char(expression,'HH24MISS'));
  else
    return to_number(to_char(expression,'YYYYMMDD'));
  END IF;
  END DECIMAL_;
  
  Function DECIMAL_(expression  NUMBER,len NUMBER, prec NUMBER) 
    RETURN NUMBER
    IS
  BEGIN
  return trunc(to_number(expression),prec);
  END DECIMAL_;
  
  Function DECIMAL_(expression  NUMBER,len NUMBER) 
    RETURN NUMBER
  IS
  BEGIN
  return trunc(to_number(expression));
  END DECIMAL_;
  
  FUNCTION DEGREES_(pin_Degree IN NUMBER)
      RETURN NUMBER 
  IS
    BEGIN
      RETURN (pin_Degree / 3.14159265430711) * 180;
  END DEGREES_;
  
  FUNCTION RADIANS_(pin_Degree IN NUMBER)
      RETURN NUMBER 
  IS
    BEGIN
      RETURN (pin_Degree / 180 ) *3.14159265430711 ;
  END RADIANS_;  
  
  FUNCTION TIMESTAMP_(exp1 VARCHAR2, exp2 VARCHAR2) 
  RETURN TIMESTAMP
  IS
    BEGIN
      RETURN TO_TIMESTAMP(exp1 || ' ' || exp2 , 'YYYY-MM-DD HH24:MI:SS');
  END TIMESTAMP_;
  
  FUNCTION TIMESTAMP_(exp1 DATE, exp2 TIMESTAMP) 
  RETURN TIMESTAMP
  IS
    BEGIN
      RETURN TO_TIMESTAMP(to_Char(exp1,'YYYY-MM-DD') || ' ' || to_Char(exp2,'HH24:MI:SS') , 'YYYY-MM-DD HH24:MI:SS');
  END TIMESTAMP_;
  
  FUNCTION TIMESTAMP_(exp1 TIMESTAMP) 
  RETURN TIMESTAMP
  IS
    BEGIN
      RETURN TO_TIMESTAMP(exp1);
  END TIMESTAMP_;
  
  
  FUNCTION RAND_(p_seed NUMBER DEFAULT NULL)
  RETURN NUMBER
  IS
    v_rand_num NUMBER;
  BEGIN
      IF p_seed IS NOT NULL THEN
         DBMS_RANDOM.SEED(p_seed);
      END IF;
      
      v_rand_num := DBMS_RANDOM.VALUE();
      
      RETURN v_rand_num;
  EXCEPTION
     WHEN OTHERS THEN
       raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
  END RAND_;

  
  FUNCTION REVERSE_(exp1 varchar2) 
  RETURN VARCHAR2
  IS
    v_temp varchar2(30);
    BEGIN
    select reverse(exp1) into v_temp from dual;
      RETURN v_temp;
  END REVERSE_;
  
  FUNCTION SECONDS_(exp1 TIMESTAMP) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN TO_NUMBER(TO_CHAR(exp1,  'SS'));
  END SECONDS_;
  
  FUNCTION SECONDS_(exp1 DATE) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN TO_NUMBER(TO_CHAR(exp1,  'SS'));
  END SECONDS_;
  
  FUNCTION SECONDS_(exp1 varchar2) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN to_number(REVERSE_(substr(trim(regexp_substr(REVERSE_(exp1),'( )?[^\:]+\:')),1,2)));
  END SECONDS_;
  
    FUNCTION MINUTES_(exp1 TIMESTAMP) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN TO_NUMBER(TO_CHAR(exp1,  'MI'));
  END MINUTES_;
  
  FUNCTION MINUTES_(exp1 DATE) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN TO_NUMBER(TO_CHAR(exp1,  'MI'));
  END MINUTES_;
  
  FUNCTION MINUTES_(exp1 varchar2) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN to_number(substr(regexp_substr(exp1,'\:[^\:]+\:'),2,2));
  END MINUTES_;
  
      FUNCTION HOURS_(exp1 TIMESTAMP) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN TO_NUMBER(TO_CHAR(exp1,  'HH24'));
  END HOURS_;
  
  FUNCTION HOURS_(exp1 DATE) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN TO_NUMBER(TO_CHAR(exp1,  'HH24'));
  END HOURS_;
  
  FUNCTION HOURS_(exp1 varchar2) 
  RETURN NUMBER
  IS
    BEGIN
      RETURN to_number(substr(trim(regexp_substr(exp1,'( )?[^\:]+\:')),1,2));
  END HOURS_;
  
    FUNCTION TIMESTAMPDIFF_(exp1 NUMBER, exp2  VARCHAR2) 
  RETURN NUMBER
  IS
    BEGIN
    case exp1
    when 1 then return (to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384)*24*60*60*1000000;
    when 2 then return (to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384)*24*60*60;
    when 4 then return (to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384)*24*60;
    when 8 then return (to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384)*24;
    when 16 then return to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384;
    when 32 then return trunc((to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384)/7);
    when 64 then return trunc((to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384)/30);
    when 128 then return trunc((to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384)/(30*3));
    when 256 then return trunc((to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384)/365);
    else return to_number(substr((to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00')),1, instr(to_TIMESTAMP(exp2) - to_TIMESTAMP('0001-01-01-01.00.00.00'),' ') )) -384;
      END case;
      
  END TIMESTAMPDIFF_;
