package javax.ide.extension;

/**
 * A listener for ElementVisitor start and end events. This listener
 * can be added to a specific ElementVisitor to receive start and
 * end event notifications.
 */
public interface OnDemandElementVisitorListener
{
  /**
   * Signifies that menu registration is about to start. This notification
   * happens before registration of elements in given tag begins.
   * @param extensionId the id of the extension being processed
   */
  public void starting(String extensionId);

  /**
   * Called from {@link ElementVisitor#end} after all processing is
   * complete. Signifies that registration has finished. Note that this
   * does not necessarily mean that all occurrences of a given element
   * have been registered; there may be more than one occurrence of the
   * element in a hook. You will be notified each time the element's
   * visitor is started and finished.
   * @param extensionId the id of the extension being processed
   */
  public void ended(String extensionId);
}
