package javax.ide.extension;

/**
 * An exception indicating that an element was encountered that was 
 * unexpected. This exception is only thrown in cases where an unrecognized
 * element is considered an error (for example, an immediate child of the 
 * &lt;hooks> element that is not a recognized hook.<p>
 * 
 * The message of this exception should explain the reason why this is an
 * error. The IDE may display this message to users.
 * 
 * @since 2.0
 */
public final class UnrecognizedElementException extends Exception
{
  public UnrecognizedElementException( String message )
  {
    super( message );
  }  
}
