package javax.ide.menu;

import javax.ide.view.GUIPanel;

/**
 * An <tt>ItemFactory</tt> provides a custom GUI component for a menu item or
 * toolbar item. In the current release of JSR-198, only toolbar items 
 * support customizability.<p>
 */
public abstract class ItemFactory
{
  /**
   * Create the GUI item for the specified menu or toolbar item.
   * 
   * @param path the path to the menu or toolbar pattern. This is a 
   *    forward slash (/) separated list of the ids of all parent menu
   *    containers for this item. For example, an item in the main window 
   *    toolbar might have a path 
   *    <code>javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/javax.ide.OPEN_SECTION_ID/someActionId</code>
   * @return a GUIPanel containing the custom component to use for this item. 
   *    May be null, in which case the default standard component is used.
   */
  public abstract GUIPanel createItem( String path );
}