/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.menu.spi;

import java.util.List;

/**
 * A section is a collection of Items and Menus.
 */
public final class Section extends Positionable
{
  private String _displayName;
  private boolean _sortSectionAlphabetically;
  private boolean _resolveMnemonics;
  private final PositionMap _items = new PositionMap();

  public Section( String id )
  {
    super( id );
  }

  /**
   * Get the content of this section. The items in the list may be instances
   * of either Item or Menu.
   *
   * @return the items in this section.
   */
  public List getContent()
  {
    return _items.getSortedItems();
  }

  public Positionable getItem( String id )
  {
    return _items.get( id );
  }

  void addItem( Positionable item )
  {
    _items.add( item );
  }

  public boolean isSortSectionAlphabetically()
  {
    return _sortSectionAlphabetically;
  }

  void setSortSectionAlphabetically( boolean sortSectionAlphabetically )
  {
    _sortSectionAlphabetically = sortSectionAlphabetically;
  }

  public boolean isResolveMnemonics()
  {
    return _resolveMnemonics;
  }

  void setResolveMnemonics( boolean resolveMnemonics )
  {
    _resolveMnemonics = resolveMnemonics;
  }

  public void setDisplayName( String displayName )
  {
    this._displayName = displayName;
  }

  public String getDisplayName()
  {
    return _displayName;
  }
}
