/*
 * @(#)JavaSource.java
 */
package javax.ide.model.java;

import java.io.IOException;

import javax.ide.model.Project;
import javax.ide.model.spi.JavaSourceImpl;
import javax.ide.model.text.TextDocument;

import javax.ide.model.java.declaration.ClassD;

/**
 *  The <CODE>JavaSource</CODE> class.
 */
public final class JavaSource extends TextDocument 
{

  private JavaSourceImpl getJavaSourceImpl()
  {
    return (JavaSourceImpl)getElementImpl();
  }

  /**
   * Fetches a ClassD for the given fully qualified name in source format,
   * null if none. The name may denote a primitive type,
   * <code>void</code> return type, array type, or class type. <p/>
   * 
   * If multiple sources of class information are available, the most
   * up-to-date one is returned. For example, suppose we have
   * both a class file C.class and a source file C.java that both
   * provide class information for a class C. If C.class has a more
   * recent timestamp than C.java, then a ClassD built from C.class
   * should be returned. <p/>
   *
   * @param project The project used to resolve class.
   * @return A ClassD for the given fully qualified name, null if none can
   *         be found.
   * @exception IOException If the document cannot be opened.
   */
  public final ClassD getClass(Project project) throws IOException
  {
    return getJavaSourceImpl().getClass( project );
  }
}
