/*
 * @(#)ExecutableD.java
 */

package javax.ide.model.java.declaration;

import java.util.Collection;

/**
 * Common supertype for constructor and method declarations.
 *
 * @author Andy Yu
 */
public interface ExecutableD
  extends MemberD, GenericD, HasAnnotationsD
{
  // ----------------------------------------------------------------------

  /**
   * True if this method takes a variable number of arguments.
   *
   * @return True if this method takes a variable number of arguments.
   */
  public boolean isVarArgs();


  // ----------------------------------------------------------------------

  /**
   * Gets the formal parameters, including synthetic ones.
   *
   * @return The collection of parameter declarations for the formal
   * parameters of this method, including the synthetic
   * <code>this$0</code>. <p/>
   *
   * Collection of ParameterDs.
   */
  public Collection getParameters();

  /**
   * Gets the formal parameter types, including synthetic ones.
   *
   * @return The collection of type declarations for the types of the
   * formal parameters of this method, including the synthetic
   * <code>this$0</code>. <p/>
   *
   * Collection of TypeDs.
   */
  public Collection getParameterTypes();

  /**
   * Gets the checked exception types. Note that, like reflection, all
   * declared checked exceptions are listed, even RuntimeException
   * subtypes.
   *
   * @return The collection of type declarations for the checked exceptions.
   * <p/>
   *
   * Collection of TypeDs.
   */
  public Collection getExceptionTypes();
}
