/*
 * @(#)WildcardTypeD.java
 */

package javax.ide.model.java.declaration;

import java.util.Collection;

/**
 * Represents a wildcard type. <p/>
 *
 * @author Andy Yu
 */
public interface WildcardTypeD
  extends TypeD
{
  /**
   * Returns the upper bounds. Upper bounds are "extends" bounds. <p/>
   *
   * @return The type declarations for the upper bounds of this wildcard
   * type. <p/>
   *
   * Collection of TypeDs.
   */
  public Collection getUpperBounds();

  /**
   * Returns the lower bounds. Lower bounds are "super" bounds. <p/>
   *
   * @return The type declarations for the lower bounds of this wildcard
   * type. <p/>
   *
   * Collection of TypeDs.
   */
  public Collection getLowerBounds();
}
