/*
 * @(#)DocCommentT.java
 */

package javax.ide.model.java.source.tree;

/**
 * A doc comment (short for "documentation comment"). Corresponds to
 * com.sun.javadoc.Doc in the Doclet API.
 *
 * @author Andy Yu
 */
public interface DocCommentT
  extends Tree, HasNameT
{
  // ----------------------------------------------------------------------

  /**
   * Gets the declaration this doc element is associated with, null if
   * none. For example, if this doc element is associated with a
   * method declaration, this will return that method declaration.
   *
   * @return The associated declaration element, null if none.
   */
  public Tree getOwningDeclaration();

  /**
   * Gets the processed comment text for this doc element, commonly
   * called the "description", using '\n' line terminators.
   *
   * @return The processed text for this comment.
   */
  public String getCommentText();

  /**
   * Gets the unprocessed comment text for this doc element, using
   * '\n' line terminators.
   *
   * @return The unprocessed text for this comment.
   */
  public String getRawCommentText();
}
