/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */

package javax.ide.net;

import java.net.URI;

/**
 *  An instance of <CODE>URIFilter</CODE> can be used to select
 *  certain URIs out of a set of URIs.
 */
public interface URIFilter
{
  /**
   *  @param  uri  The {@link URI} that is being filtered.
   *
   *  @return  <CODE>true</CODE> if this filter allows the specified
   *  {@link URI} is allowed to be displayed or included.  Returns
   *  <CODE>false</CODE> otherwise.
   *
   *  @exception  NullPointerException  if the specified {@link URI}
   *  is <CODE>null</CODE>.
   */
  public boolean accept( URI uri );

  /**
   *  A concrete <CODE>URIFilter</CODE> must provide an implementation
   *  for the <CODE>equals()</CODE> method that compares the
   *  <CODE>URIFilter</CODE> to another one.  A return value of
   *  <CODE>true</CODE> means that both this <CODE>URIFilter</CODE> and
   *  the specified <CODE>URIFilter</CODE> will accept identical sets
   *  of {@link URI}s and that the descriptions used to identify the
   *  filters are equal.
   */
  public boolean equals( Object o );

  /**
   *  The implementation of <CODE>toString()</CODE> must return a
   *  short description that can be shown to the user describing what
   *  the filter is filter for.  For example: "JPG and GIF images".
   */
  public String toString();
}
