package javax.ide.util;

import java.util.ResourceBundle;

public class MetaResourceString
{
  private final ResourceBundle m_resourceBundle;
  private final String m_resourceBundleKey;

  public MetaResourceString(final ResourceBundle resourceBundle, final String resourceBundleKey)
  {
    if (resourceBundle == null) 
    {
      throw new NullPointerException("resourceBundle should not be null");  
    }
    if (resourceBundleKey == null) 
    {
      throw new NullPointerException("resourceBundleKey should not be null");  
    }
    m_resourceBundle = resourceBundle;
    m_resourceBundleKey = resourceBundleKey;
  }
  
  /**
   * Looks up the resource.
   *
   * @return the value of the resource
   * @throws {@code MissingResourceException} if the resource is missing
   */
  public String getValue() 
  {
    return m_resourceBundle.getString(m_resourceBundleKey);
  }
}
