<?xml version="1.0"?>
<!-- 

 Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuclus.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_cluster_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     01/10/09 - bug 7595899: incorporate CM fixes for BLOCKSIZE
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      08/08/05 - bug 3560220: get correct behavior from processor 
    lbarton     07/15/05 - trim all WS when trimming hash string 
    rapayne     06/13/05 - Bug 4321610: allow constraint conditions to
                           exceed 4k chars.
    lbarton     06/10/04 - Bug 3675944: PCTSPACE
    htseng      03/31/04 - move ROWDEPENDENCIES to template DoParallel 
    htseng      04/16/03 - bug 2907529: hash is clause greater than 4000 char
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    lbarton     08/02/02 - transportable export
    lbarton     06/13/02 - define EXPORT param
    lbarton	01/16/02 - formatting
    htseng 	10/11/01 - trim hash function space.
    htseng 	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	06/21/01 - Creation 

 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kucolumn.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="SIZE_BYTE_KEYWORD">0</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="PCTSPACE">100</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_TABLESPACE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="CLUSTER_T">
  <xsl:if test="$PRS_TABLESPACE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ATABLESPACE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:choose>
    <xsl:when test="(PART_OBJ)">
     <xsl:value-of select="PART_OBJ/PARTOBJ/DEFTS_NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="TS_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">CLUSTER</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text> CREATE CLUSTER </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:text> ( </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="COL_LIST"/>
  <xsl:text> ) </xsl:text>
  <xsl:if test="SIZE_T >0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;    </xsl:text>
   </xsl:if>
   <xsl:text> SIZE </xsl:text>
   <xsl:value-of select="SIZE_T"/>
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="PCT_FREE"/>
  <xsl:apply-templates select="STORAGE">
    <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
   <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
  </xsl:apply-templates>
  <xsl:if test="FLAGS mod 131072>=65536">
   <!-- Single table 0x010000-->
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> SINGLE TABLE </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="FUNCTION=0 and HASHKEYS !=0">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> HASH IS </xsl:text>
    <xsl:value-of select="COL_LIST/COL_LIST_ITEM/NAME"/>
   </xsl:when>
   <xsl:when test="FUNCTION=2 and string-length(FUNCLEN)> 0">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> HASH IS </xsl:text>
    <xsl:choose>
     <xsl:when test="FUNC_CLOB">
      <xsl:call-template name="Trim_string">
       <xsl:with-param name="String" select="FUNC_CLOB"/>
       <xsl:with-param name="TrimAllWS">1</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="FUNCLEN>4000">
      <xsl:call-template name="Trim_string">
       <xsl:with-param name="String" select="FUNC_VCNT"/>
       <xsl:with-param name="TrimAllWS">1</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="Trim_string">
       <xsl:with-param name="String" select="FUNCTXT"/>
       <xsl:with-param name="TrimAllWS">1</xsl:with-param>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="HASHKEYS!=0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> HASHKEYS </xsl:text>
   <xsl:value-of select="HASHKEYS"/>
   <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:call-template name="DoParallel">
   <xsl:with-param name="FlagsParent" select="current()"/>
  </xsl:call-template>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
