<?xml version="1.0"?>
<!-- 
NAME
    kurefgrp.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_refgrp_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayn      11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      07/11/03 - bug 3043955 fix sqlterminator for BEGIN-END block
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      04/22/02 - htseng_ad_export
    htseng	04/02/02 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="DBA">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="REFGROUP_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_REFRESH</xsl:with-param>
   <xsl:with-param name="ObjectType">REFRESH_GROUP</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="REFOWNER"/>
   <xsl:with-param name="NameNode" select="REFNAME"/>
  </xsl:call-template>
  <xsl:text> BEGIN </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="$DBA=1">
    <xsl:value-of select="REF_MAKE_DBA"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="REF_MAKE_USER"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="REF_CHILD"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text> END; </xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>&#xa;</xsl:text>
   <xsl:text>/</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="REF_CHILD">
  <xsl:for-each select="REF_CHILD_ITEM">
   <xsl:text>&#xa;</xsl:text>
   <xsl:choose>
    <xsl:when test="$DBA=1">
     <xsl:value-of select="REF_ADD_DBA"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="REF_ADD_USER"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
