<?xml version="1.0"?>
<!--
NAME
    kusqtabd.xsl
DESCRIPTION
    Convert AQ_QUEUE (SXML) document to creation DDL.

MODIFIED        MM/DD/YY
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton    08/10/05 - lbarton_mddiff
    htseng     07/26/05 - change QUEUE_COMMNET to COMMENT 
    lbarton    07/08/05 - 
    htseng     05/03/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: top-level template for  AQ_QUEUE.


******************************************************************** -->
 <xsl:template match="sxml:AQ_QUEUE">
  <xsl:text> BEGIN DBMS_AQADM.CREATE_QUEUE(</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>Queue_name          => '</xsl:text>
  <xsl:value-of select="sxml:SCHEMA"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>',</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>Queue_table         => '</xsl:text>
  <xsl:value-of select="sxml:QUEUE_TABLE/sxml:SCHEMA"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="sxml:QUEUE_TABLE/sxml:NAME"/>
  <xsl:text>',</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text>Queue_type          => </xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:EXCEPTION_QUEUE">
    <xsl:text> 1</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> 0</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="sxml:MAX_RETRIES">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Max_retries         =>  </xsl:text>
   <xsl:value-of select="sxml:MAX_RETRIES"/>
  </xsl:if>
  <xsl:if test="sxml:RETRY_DELAY">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Retry_delay         =>  </xsl:text>
   <xsl:value-of select="sxml:RETRY_DELAY"/>
  </xsl:if>
  <xsl:if test="sxml:RETENTION">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Retention_time      =>  </xsl:text>
   <xsl:value-of select="sxml:RETENTION"/>
  </xsl:if>
  <!-- documentation says dependency_tracking is reserved for future use,
      defaults to FALSE and must not be TRUE,
      but reg tests require it -->
  <xsl:choose>
   <xsl:when test="sxml:DEPENDENCY_TRACKING">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>dependency_tracking =>  TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>dependency_tracking =>  FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="sxml:COMMENT">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>comment             => '</xsl:text>
   <xsl:value-of select="sxml:COMMENT"/>
   <xsl:text>'</xsl:text>
  </xsl:if>
  <xsl:text>);</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> END;</xsl:text>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
