
-- loads INSUR_CUST_LTV_SAMPLE table for Data Miner OBE Demo
--
-- Paramters:
-- 1. User account - account to load the table into
-- Example:
-- @instInsurCustData.sql DMUSER
--------------------------------------------------------

EXECUTE dbms_output.put_line('');
EXECUTE dbms_output.put_line('Load Data Miner demo table INSUR_CUST_LTV_SAMPLE.');
EXECUTE dbms_output.put_line('');

-- Drop table if it already exists
-- NOTE: ERRORS ARE OK FOR THE DROP TABLE AS IT CONFIRMS THE TABLE DOES NOT EXIST
DECLARE
v_sql varchar2(100); 
user_account_value varchar2(120);
BEGIN

user_account_value := q'[&&1]';

-- Change to the new user schema
BEGIN
v_sql := 'ALTER session set current_schema = "' || user_account_value || '" ' ; -- Enter the user schema
EXECUTE IMMEDIATE v_sql;
DBMS_OUTPUT.PUT_LINE (v_sql ||': succeeded');
EXCEPTION
WHEN OTHERS THEN
DBMS_OUTPUT.PUT_LINE (v_sql ||': ***  Failed ***');
raise;
END;

v_sql := 'DROP TABLE INSUR_CUST_LTV_SAMPLE cascade constraints';
EXECUTE IMMEDIATE v_sql;
DBMS_OUTPUT.PUT_LINE (v_sql ||': succeeded');
EXCEPTION
WHEN OTHERS THEN
DBMS_OUTPUT.PUT_LINE (v_sql ||': drop unneccessary - no table/view exists');
END;
/

--------------------------------------------------------
--  DDL for Table INSUR_CUST_LTV_SAMPLE
--------------------------------------------------------

  CREATE TABLE INSUR_CUST_LTV_SAMPLE
   (	"CUSTOMER_ID" VARCHAR2(100 BYTE), 
	"LAST" VARCHAR2(100 BYTE), 
	"FIRST" VARCHAR2(100 BYTE), 
	"STATE" VARCHAR2(100 BYTE), 
	"REGION" VARCHAR2(100 BYTE), 
	"SEX" VARCHAR2(100 BYTE), 
	"PROFESSION" VARCHAR2(100 BYTE), 
	"BUY_INSURANCE" VARCHAR2(100 BYTE), 
	"AGE" NUMBER, 
	"HAS_CHILDREN" NUMBER, 
	"SALARY" NUMBER, 
	"N_OF_DEPENDENTS" NUMBER, 
	"CAR_OWNERSHIP" NUMBER, 
	"HOUSE_OWNERSHIP" NUMBER, 
	"TIME_AS_CUSTOMER" NUMBER, 
	"MARITAL_STATUS" VARCHAR2(100 BYTE), 
	"CREDIT_BALANCE" NUMBER, 
	"BANK_FUNDS" NUMBER, 
	"CHECKING_AMOUNT" NUMBER, 
	"MONEY_MONTLY_OVERDRAWN" NUMBER, 
	"T_AMOUNT_AUTOM_PAYMENTS" NUMBER, 
	"MONTHLY_CHECKS_WRITTEN" NUMBER, 
	"MORTGAGE_AMOUNT" NUMBER, 
	"N_TRANS_ATM" NUMBER, 
	"N_MORTGAGES" NUMBER, 
	"N_TRANS_TELLER" NUMBER, 
	"CREDIT_CARD_LIMITS" NUMBER, 
	"N_TRANS_KIOSK" NUMBER, 
	"N_TRANS_WEB_BANK" NUMBER, 
	"LTV" NUMBER, 
	"LTV_BIN" VARCHAR2(100 BYTE)
   ) NOLOGGING;
REM INSERTING into INSUR_CUST_LTV_SAMPLE
INSERT ALL
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','LA',0,1,'CU7854',700,0,1,1,69838,'M','Childcare Worker',1500,'South',1,700,'No',0,1,33,53.06,24259.5,0,0,25,0,'HIGH','BRENTON',1,1,'ROJAS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,5,'CU12993',300,0,5,0,75409,'F','First-line Manager',2500,'NorthEast',1,300,'No',0,1,23,53.06,23652.25,0,0,25,0,'HIGH','GABRIELE',1,1,'ATKINSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU608',2700,6574,1,1,72953,'M','Secretary',1500,'West',2,1287,'No',2,0,27,53.46,34438.25,634,2,568,4,'VERY HIGH','ALEJANDRO',2,1,'PAULSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,3,'CU10025',1840,0,3,0,72196,'M','DBA',1500,'West',1,1840,'No',0,1,36,53.06,27149,506,1,25,0,'HIGH','DIRK',1,1,'DYE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU11680',0,0,0,0,54836,'M','PROF-5',1500,'NorthEast',0,0,'No',0,4,20,53.06,16709,0,0,25,0,'MEDIUM','JUAN',0,0,'ROARK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU10706',700,0,3,0,68436,'M','PROF-20',1000,'NorthEast',1,700,'No',0,1,26,53.06,25209,0,0,25,0,'HIGH','RANDY',1,1,'BARRON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','MI',4315,1,'CU6752',6300,14100,1,1,62499,'F','Author',800,'Midwest',1,3000,'No',2,2,68,54.47,25924.75,18785,2,7467,5,'HIGH','ELEONOR',1,1,'COLLIER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,4,'CU6932',547,0,6,1,65042,'M','PROF-30',800,'West',1,547,'No',2,1,48,53.09,16060.5,592,0,25,1,'MEDIUM','TYRELL',1,1,'LOONEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','TX',0,1,'CU9555',2000,0,1,0,69052,'M','Not specified',1500,'Southwest',1,2000,'No',0,1,33,53.06,29063,506,1,25,0,'HIGH','ZACK',1,1,'DANIEL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','IL',0,5,'CU475',3000,0,5,0,68490,'F','PROF-58',2000,'Midwest',1,3000,'No',2,0,54,53.62,25022.5,504,1,25,4,'HIGH','SIERRA',1,1,'VANCE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,4,'CU4188',0,0,1,0,60341,'M','PROF-25',700,'Midwest',0,0,'No',0,3,32,53.06,18285.25,506,1,25,0,'MEDIUM','TERRANCE',0,1,'WORKMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MS',0,3,'CU12337',0,0,3,0,76895,'M','PROF-3',1500,'South',0,0,'No',1,4,20,53.06,16723.75,0,0,25,0,'MEDIUM','IAN',0,0,'BELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU4603',729,0,3,1,60045,'M','Nurse',1700,'West',1,729,'No',1,3,48,53.08,20311.25,623,1,25,1,'MEDIUM','FERNANDO',1,1,'GUY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU7694',448,0,1,0,58592,'F','Sales Representative',2500,'NorthEast',1,448,'No',0,1,23,53.07,25448,0,0,25,1,'HIGH','FRANSISCA',1,1,'HIGH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU6846',0,0,0,1,61085,'M','Nurse',800,'West',0,0,'No',0,1,67,53.06,17971.25,504,0,25,0,'MEDIUM','EDISON',0,1,'CONTRERAS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,2,'CU5916',10000,15900,2,1,65190,'F','Software Engineer',500,'NorthEast',1,2800,'No',2,0,44,57.47,22697.5,8868,4,7702,6,'HIGH','LEZLIE',1,1,'PEDERSEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MN',0,1,'CU3229',6000,22700,1,1,57638,'F','IT Staff',900,'West',1,3700,'No',4,3,37,53.35,21609.5,23870,3,18779,3,'MEDIUM','USHA',1,1,'BEAULIEU')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,3,'CU10180',176,0,3,0,63053,'M','Nurse',1000,'West',1,176,'No',0,1,18,53.07,23063.25,0,0,25,1,'HIGH','GARTH',1,1,'PICKENS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU10989',633,0,1,0,65007,'M','PROF-1',600,'NorthEast',1,633,'No',0,1,31,53.06,27851.75,0,0,25,0,'HIGH','FRED',1,1,'COYLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU8662',2600,0,1,1,66889,'F','Homemaker',1000,'NorthEast',1,2600,'No',4,1,31,53.26,24822.25,0,0,25,3,'HIGH','TAMMIE',1,1,'FIGUEROA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU1371',0,0,3,0,61758,'M','PROF-5',1000,'NorthEast',0,0,'No',0,2,31,53.06,14039.5,503,0,25,0,'MEDIUM','ROBIN',0,1,'HOGUE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU6818',1300,0,1,0,61703,'M','PROF-32',1500,'West',1,1300,'No',0,1,46,53.06,28525.75,506,1,25,0,'HIGH','ANDERSON',1,1,'GORMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU12217',1200,1550,1,0,65080,'M','DBA',1500,'West',1,1200,'No',18,4,34,53.13,28170,1304,3,1291,2,'HIGH','SYDNEY',1,1,'LANDERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU10228',1000,1600,3,0,59135,'M','PROF-33',1000,'NorthEast',1,300,'No',3,3,27,53.3,22983.75,548,3,303,3,'HIGH','MATT',1,1,'BAGLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NC',0,4,'CU5589',1050,1201,6,1,62786,'F','Author',700,'South',1,1,'No',2,0,76,53.2,18296.5,3018,3,2459,3,'MEDIUM','SAMIRA',1,1,'CHIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU8819',0,0,3,0,59513,'M','Programmer/Developer',1500,'NorthEast',0,0,'No',0,1,22,53.06,12578.25,0,0,25,0,'LOW','ISAIAH',0,0,'FLYNN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU3039',6000,0,1,1,65586,'F','Homemaker',500,'NorthEast',1,6000,'No',0,2,41,53.06,23996.5,504,0,25,0,'HIGH','CARLEEN',1,1,'BENITEZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','OH',0,1,'CU493',2100,0,1,1,72753,'M','Waiter/Waitress',1500,'Midwest',1,2100,'No',11,4,49,54.83,26588.25,571,1,32,5,'HIGH','JACQUES',1,1,'ATWOOD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU4923',0,0,0,0,62801,'M','Cashier',500,'West',0,0,'No',11,3,38,53.01,20500.25,525,1,25,2,'MEDIUM','SYLVESTER',0,1,'REEDER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',5378,1,'CU2410',3070,7300,1,1,71744,'F','Cashier',1400,'West',1,1500,'No',11,2,49,54.23,26336,19225,6,13334,5,'HIGH','LAURENCE',1,1,'BAER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU740',1509,2151,3,1,60513,'F','Author',1500,'West',1,531,'No',1,0,72,53.62,23328.25,7226,1,4103,4,'HIGH','KANDACE',1,1,'VICK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',0,2,'CU3093',0,0,0,0,61661,'M','PROF-32',500,'Southwest',0,0,'No',0,2,56,53.17,22015.25,593,1,25,2,'HIGH','DOUGLAS',0,1,'PHIPPS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU9156',0,0,0,0,66900,'M','PROF-18',1000,'NorthEast',0,0,'No',0,1,17,53.06,19425,0,0,25,0,'MEDIUM','MAYNARD',0,0,'HOGUE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,4,'CU1161',0,601,0,1,63049,'M','PROF-6',500,'West',0,0,'No',13,0,26,53.14,15362.25,2628,2,2095,2,'MEDIUM','DARWIN',0,1,'SEYMOUR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU8633',3800,0,3,1,60409,'M','Cashier',800,'West',1,3800,'No',3,1,41,53.18,20202.25,7897,0,7027,3,'MEDIUM','EMANUEL',1,1,'SUGGS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU8920',1000,201,1,1,63132,'F','Technical Writer',1000,'NorthEast',1,1000,'No',8,1,30,53.13,22283,631,1,619,2,'HIGH','SAMIRA',1,1,'TRIPLETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WA',0,4,'CU513',2000,0,3,0,71120,'M','Cashier',1000,'West',1,2000,'No',0,0,51,53.06,28880,504,1,25,0,'HIGH','JARRETT',1,1,'BAIRD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',6705,1,'CU15745',0,0,1,0,74542,'F','PROF-46',2500,'West',0,0,'No',2,4,38,53.26,20935.5,14368,0,7634,3,'MEDIUM','MISTI',0,1,'SPRAGUE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MN',0,4,'CU3976',800,0,4,0,61165,'M','PROF-29',900,'West',2,800,'No',1,3,43,53.08,33591.25,0,0,25,1,'VERY HIGH','LENARD',2,1,'KELLY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,5,'CU5206',3000,5300,5,1,58142,'F','PROF-6',1500,'Midwest',2,900,'No',4,0,28,53.47,24835.5,4664,4,4126,4,'HIGH','ARLETTE',2,1,'FRANKLIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,5,'CU12026',1800,1350,5,1,73569,'F','Fireman',1500,'Midwest',1,1800,'No',15,2,33,53.05,19192.25,390,2,361,2,'MEDIUM','RUBI',1,1,'FITZPATRICK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU14493',0,0,3,0,57313,'M','Programmer/Developer',1000,'South',0,0,'No',3,1,22,53.03,12028.25,0,1,25,2,'LOW','VICENTE',0,0,'ZAPATA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',783,3,'CU10208',0,300,3,0,62105,'M','Programmer/Developer',1000,'West',0,0,'No',5,1,25,53.17,13526.25,2171,2,1293,2,'LOW','PABLO',0,1,'BENJAMIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,4,'CU4102',5000,0,4,1,66417,'M','PROF-25',3500,'Midwest',1,5000,'No',0,3,31,53.12,18704.25,508,1,25,2,'MEDIUM','ALFONZO',1,1,'VILLANUEVA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU1202',1089,3060,0,1,55182,'M','Veterinarian',1400,'NorthEast',1,960,'No',13,0,38,53.7,24595.5,3746,2,2400,4,'HIGH','ROLLAND',1,1,'SHEA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU8212',0,0,3,0,58283,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',0,1,23,53.06,12370.75,0,1,25,0,'LOW','LAWERENCE',0,0,'ESPINOZA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU4090',787,0,0,0,62089,'M','Waiter/Waitress',1000,'West',1,787,'No',18,3,0,53.02,0,509,1,25,2,'LOW','RICH',1,1,'HANCOCK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',0,1,'CU2870',2500,7225,1,1,60129,'M','Bank Teller',1000,'Southwest',1,1625,'No',2,2,50,53.16,23532.25,1747,4,25,2,'HIGH','JERROD',1,1,'BECKER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU13042',1200,900,1,1,72173,'F','IT Staff',1500,'NorthEast',1,250,'No',2,1,42,53.53,25743.25,1520,3,305,4,'HIGH','PIEDAD',1,1,'JONES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU15084',280,0,3,0,71832,'M','PROF-44',1000,'NorthEast',1,280,'No',0,1,27,53.07,26158,0,0,25,1,'HIGH','ELIJAH',1,1,'VANG')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',64674,2,'CU3913',0,0,0,1,63643,'M','Fireman',900,'West',0,0,'No',15,3,43,56.71,16210.75,65300,3,25,6,'MEDIUM','LLOYD',0,1,'SEXTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU6304',0,0,0,1,62358,'M','IT Staff',500,'Midwest',0,0,'No',1,0,42,53.08,15789.5,720,0,25,1,'MEDIUM','CASEY',0,1,'NEWTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','NY',27449,1,'CU726',15000,23000,1,1,88555,'F','IT Staff',5000,'NorthEast',1,5000,'No',1,0,69,55.06,32538.75,30329,1,25,5,'VERY HIGH','LUISA',1,1,'HUNT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU1427',0,0,3,0,63088,'M','Truck Driver',1500,'West',0,0,'No',1,2,60,53.08,17272,611,1,25,1,'MEDIUM','GERALD',0,1,'SOSA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',14343,1,'CU848',6500,20500,1,0,66390,'F','Publisher',1300,'West',1,4000,'No',4,6,54,53.36,30497.5,26330,2,9943,3,'VERY HIGH','ANTONINA',1,1,'BONILLA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU12406',700,750,3,0,64895,'M','Sales Representative',1000,'NorthEast',1,700,'No',9,1,20,53.09,23723.75,925,3,916,1,'HIGH','BURL',1,1,'PARRIS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU1141',3500,8450,1,0,70805,'F','Waiter/Waitress',1500,'NorthEast',2,3500,'No',3,0,69,54.31,43101.25,13972,6,13752,5,'VERY HIGH','BARBARA',2,1,'DOUGHERTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU6623',0,4309,0,1,69702,'M','School Teacher',800,'NorthEast',0,1959,'No',4,1,49,53.01,18325.5,1828,1,1321,2,'MEDIUM','EMERSON',0,1,'BELTRAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU10020',2500,0,1,1,75571,'M','IT Staff',1500,'NorthEast',1,2500,'No',14,1,27,53.11,25092.75,679,1,25,2,'HIGH','TRACEY',1,1,'WHITNEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',580,1,'CU2703',3700,6700,1,1,63334,'F','Not specified',500,'Midwest',1,1200,'No',2,2,40,54.08,23333.5,29373,2,2166,5,'HIGH','MILLY',1,1,'CRENSHAW')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU885',874,0,1,1,61102,'M','Lab Technician',1300,'West',1,874,'No',2,0,73,53.28,26075.5,3998,1,3307,3,'HIGH','NEAL',1,1,'SALINAS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,1,'CU3239',5000,6501,1,1,80956,'F','IT Staff',2000,'West',1,5000,'No',1,3,50,53.94,28739,760,4,25,4,'HIGH','KEIKO',1,1,'MABRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU3441',1000,300,3,0,61654,'M','School Teacher',500,'West',1,1000,'No',1,2,46,53.1,25513.5,2122,2,625,2,'HIGH','GALE',1,1,'RILEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,1,'CU7412',7000,2201,1,0,58398,'F','Software Engineer',3500,'West',1,7000,'No',0,1,55,53.08,28599.5,431,1,25,1,'HIGH','BERRY',1,1,'OAKLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU3147',0,1956,0,0,71740,'M','Nurse',2500,'Midwest',0,506,'No',1,3,43,53.74,23235,717,1,25,4,'HIGH','BERNIE',0,1,'HILL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14708',250,650,3,0,64194,'M','Programmer/Developer',1000,'NorthEast',1,250,'No',7,1,20,53.39,23548.5,0,2,25,4,'HIGH','JUDE',1,1,'COOLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',0,2,'CU3461',0,8900,0,1,70484,'M','PROF-38',1500,'Southwest',0,3500,'No',12,2,40,53.78,17621,8282,4,7549,4,'MEDIUM','ANTONIA',0,1,'SHEETS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',26370,1,'CU8520',1000,4450,1,1,68781,'M','Cashier',900,'West',1,1800,'No',13,1,43,54.29,24995.25,29042,2,25,5,'HIGH','DONOVAN',1,1,'DURAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU4009',0,0,0,0,61029,'M','Mason',500,'West',0,0,'No',0,3,52,53.06,21457.25,506,0,25,0,'MEDIUM','HUEY',0,1,'LILLY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,2,'CU3587',780,0,0,0,68734,'M','Construction Laborer',900,'Midwest',1,780,'No',0,3,43,53.06,32483.5,529,1,25,0,'VERY HIGH','OCTAVIO',1,1,'FENTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,2,'CU6758',5000,4040,0,1,56578,'M','Administrative Assistant',3000,'NorthEast',1,1290,'No',0,1,62,54.07,26344.5,20226,1,19357,5,'HIGH','MASON',1,1,'ALONZO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU14746',1500,500,3,0,59885,'M','PROF-26',1500,'NorthEast',1,1500,'No',12,1,21,53.53,22571.25,224,2,25,4,'HIGH','ROMAN',1,1,'LILES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NC',0,3,'CU13188',250,0,3,1,63492,'M','Programmer/Developer',1000,'South',1,250,'No',3,1,19,53.09,18273,0,1,25,1,'MEDIUM','ABEL',1,1,'RUBIO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU14965',3500,2100,1,0,62654,'F','Cashier',2000,'West',1,3500,'No',2,1,34,52.96,27563.5,1375,1,1367,2,'HIGH','MEGHANN',1,1,'MATLOCK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU15852',330,0,3,0,66813,'M','PROF-12',1500,'West',1,330,'No',0,4,25,53.06,24703.25,0,0,25,0,'HIGH','ALDEN',1,1,'RICHMOND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,2,'CU6275',800,0,2,0,61384,'M','Not specified',900,'Midwest',1,800,'No',4,0,50,53.28,27346,2793,0,25,3,'HIGH','LESTER',1,1,'FLETCHER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU12404',170,0,3,0,58545,'M','Nurse',700,'West',1,170,'No',0,1,31,53.06,23236.25,0,0,25,0,'HIGH','REFUGIO',1,1,'BURKS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14487',0,500,3,0,71198,'M','Waiter/Waitress',1000,'West',0,0,'No',2,3,28,53.05,16099.5,311,2,288,2,'MEDIUM','RODNEY',0,1,'DORAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,1,'CU9791',900,0,1,0,59176,'F','Cashier',800,'NorthEast',1,900,'No',2,1,55,53.34,28794,564,1,25,3,'HIGH','ETHELENE',1,1,'HYATT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU8696',2000,1950,1,1,58644,'F','Secretary',1000,'West',1,350,'No',1,1,39,53.21,22061,265,1,25,3,'HIGH','LEESA',1,1,'BRADSHAW')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU4715',1066,900,3,1,65744,'M','Waiter/Waitress',900,'West',1,1066,'No',10,3,37,53.11,20636,1115,3,608,2,'MEDIUM','DANA',1,1,'HACKETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',2836,2,'CU4020',0,14000,0,1,64175,'M','Administrative Assistant',700,'NorthEast',0,5000,'No',8,3,48,53.81,16843.75,11201,5,7776,4,'MEDIUM','ALVIN',0,1,'KENNEDY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NC',45524,4,'CU6365',3500,8500,6,1,57293,'F','Author',1200,'South',2,1400,'No',9,0,54,55.29,24723.25,0,1,25,5,'HIGH','KATTIE',2,1,'LYLES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU7974',205,0,3,0,64028,'M','Nurse',1000,'South',1,205,'No',0,1,27,53.06,24207,0,0,25,0,'HIGH','BYRON',1,1,'CLEVENGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,4,'CU5712',0,0,1,1,67081,'M','Software Engineer',600,'Midwest',0,0,'No',0,0,69,53.06,18670.25,554,1,25,0,'MEDIUM','MARCUS',0,1,'BLANTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MO',0,5,'CU14018',1780,1400,5,1,74018,'F','PROF-30',1500,'Midwest',1,1780,'No',3,1,67,53.59,22704.5,5409,3,25,4,'HIGH','CRISTIN',1,1,'LOFTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11034',600,0,3,0,67283,'M','Accountant',1500,'NorthEast',1,600,'No',1,1,28,53.07,25120.75,0,0,25,1,'HIGH','LESTER',1,1,'ALLISON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,3,'CU3197',3600,4900,3,0,69999,'M','PROF-24',800,'West',1,850,'No',3,8,41,54.61,27099.75,4643,1,3375,5,'HIGH','ANGEL',1,1,'PLATT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU11501',1500,500,3,1,57415,'M','First-line Manager',1500,'West',1,1500,'No',8,1,25,53.8,17353.75,667,2,25,4,'MEDIUM','BILL',1,1,'MIZE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','WA',0,1,'CU3044',1012,0,1,1,65520,'F','Cashier',1000,'West',1,1012,'No',1,2,49,53.07,24780,514,1,25,1,'HIGH','SHELIA',1,1,'BARTH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','IL',0,5,'CU9404',1500,0,5,1,69868,'F','Bank Teller',1000,'Midwest',1,1500,'No',0,1,21,53.06,17067,0,0,25,0,'MEDIUM','LENNA',1,1,'DUGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU9988',600,0,3,1,64887,'M','PROF-2',1000,'Midwest',1,600,'No',0,1,18,53.07,18521.75,0,0,25,1,'MEDIUM','HILARIO',1,1,'ELLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU12672',1350,400,1,0,66765,'F','PROF-7',700,'Midwest',1,1350,'No',4,1,41,53.1,29291.25,152,2,140,2,'HIGH','ALISON',1,1,'BUTCHER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU14893',1000,200,3,0,66250,'M','PROF-29',1000,'NorthEast',1,1000,'No',1,1,20,53.07,24062.5,0,1,25,1,'HIGH','BRICE',1,1,'KENT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU2491',1700,0,1,1,62741,'F','PROF-30',500,'West',1,1700,'No',3,1,55,53.1,24685.25,534,1,25,2,'HIGH','UTE',1,1,'RAMOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU12216',350,0,3,0,59108,'M','PROF-3',600,'NorthEast',1,350,'No',1,4,33,53.07,23577,0,0,25,1,'HIGH','DEAN',1,1,'BOWEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,2,'CU5319',3000,0,0,0,69742,'M','Nurse',900,'West',1,3000,'No',0,0,34,53.17,31835.5,504,1,25,2,'VERY HIGH','MELVIN',1,1,'SHERWOOD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','UT',0,3,'CU15879',300,0,3,0,61674,'M','Technical Writer',1500,'Southwest',1,300,'No',0,5,26,53.06,23518.5,0,0,25,0,'HIGH','MICHEL',1,1,'MCKEE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MO',0,1,'CU2269',2000,5100,1,0,65418,'F','Cashier',1000,'Midwest',1,1500,'No',3,2,44,53.19,29254.5,3822,4,3298,3,'HIGH','BECKI',1,1,'HELM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU7814',0,0,0,0,58456,'M','Administrative Assistant',1200,'NorthEast',0,0,'No',1,1,0,53.08,0,579,0,25,1,'LOW','RAFAEL',0,1,'GREENBERG')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU12180',900,0,3,0,62560,'M','Dentist',600,'NorthEast',1,900,'No',4,4,44,53.07,25540,123,1,116,1,'HIGH','DUANE',1,1,'BRYSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',0,3,'CU8450',533,0,3,0,70993,'M','Professor',1500,'Southwest',1,533,'No',1,1,24,53.06,25648.25,0,0,25,0,'HIGH','CARTER',1,1,'BERNIER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2536',0,0,0,0,59065,'M','PROF-57',900,'NorthEast',0,0,'No',0,2,33,53.06,19066.25,0,0,25,0,'MEDIUM','GERMAN',0,0,'FRIEDMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,4,'CU4153',2000,0,6,1,63222,'M','PROF-38',1000,'Midwest',1,2000,'No',1,3,32,52.48,14005.5,933,1,25,2,'MEDIUM','STACY',1,1,'ROSALES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU10477',250,0,3,0,57733,'M','First-line Manager',1000,'Midwest',1,250,'No',4,1,21,53.05,22033.25,292,1,281,2,'HIGH','OMAR',1,1,'MAGUIRE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','LA',0,1,'CU13221',4663,0,1,0,77971,'F','Veterinarian',3500,'South',1,4663,'No',0,1,39,53.06,31892.75,0,1,25,0,'VERY HIGH','ILANA',1,1,'STEWART')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU12128',1700,0,3,0,55385,'M','PROF-37',1500,'Midwest',1,1700,'No',1,4,19,53.23,21246.25,0,1,25,3,'MEDIUM','RILEY',1,1,'PEPPER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OR',0,3,'CU12235',122,0,3,0,70272,'M','Waiter/Waitress',1000,'West',1,122,'No',3,4,19,53.08,24968,0,0,25,1,'HIGH','DARRON',1,1,'NOBLES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,2,'CU1935',2500,0,6,1,58873,'M','Accountant',800,'West',1,2500,'No',6,2,66,53.25,15318.25,1991,1,25,3,'MEDIUM','ERASMO',1,1,'BRAND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','WI',0,1,'CU8589',5500,16100,1,1,68696,'F','PROF-9',800,'Midwest',1,3700,'No',4,1,49,53.14,25574,1749,5,25,2,'HIGH','KALA',1,1,'IVERSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU9823',0,0,0,0,73850,'M','Nurse',1500,'West',0,0,'No',0,1,24,53.06,21862.5,504,0,25,0,'MEDIUM','NESTOR',0,1,'HORTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',452,2,'CU12175',1036,500,2,1,60249,'M','Programmer/Developer',1000,'Midwest',1,1036,'No',4,4,26,53.42,19662.25,625,2,134,4,'MEDIUM','DWIGHT',1,1,'ROLLINS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU7924',0,650,1,0,60466,'M','Programmer/Developer',700,'NorthEast',0,0,'No',17,3,32,53.18,16816.5,278,2,265,3,'MEDIUM','GRADY',0,1,'STATON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14284',358,0,3,0,76570,'M','Construction Laborer',1500,'NorthEast',1,358,'No',1,1,24,53.06,27042.5,0,0,25,0,'HIGH','DOMINICK',1,1,'LAW')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','UT',0,1,'CU14620',1500,501,1,1,62756,'M','Truck Driver',500,'Southwest',1,1500,'No',8,1,35,53.32,22689,1636,2,1382,3,'HIGH','DANIAL',1,1,'CORLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU15186',1020,600,1,1,62886,'F','IT Staff',1000,'NorthEast',1,1020,'No',2,1,36,53.22,22821.5,757,2,25,3,'HIGH','VERNON',1,1,'NIETO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU5165',1300,2400,1,1,61012,'F','Truck Driver',1100,'Midwest',1,1300,'No',3,0,26,53.27,21353,2299,1,1314,3,'MEDIUM','KITTY',1,1,'COFFEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU5938',0,0,0,1,65134,'M','Author',900,'West',0,0,'No',4,0,78,53.08,20083.5,514,0,25,1,'MEDIUM','TEDDY',0,1,'MURILLO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',30650,4,'CU3296',6500,9550,3,1,60322,'F','Not specified',900,'West',1,1700,'No',12,2,49,53.73,20980.5,33850,4,266,4,'MEDIUM','MARYLEE',1,1,'HATHAWAY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,2,'CU1069',0,0,0,1,63067,'M','PROF-15',1400,'West',0,0,'No',0,0,80,53.06,19766.75,504,1,25,0,'MEDIUM','THURMAN',0,1,'VAUGHAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WA',0,5,'CU13543',2728,1750,5,1,73090,'F','PROF-39',1500,'West',2,2728,'No',10,1,52,53.33,30972.5,249,3,25,3,'VERY HIGH','DARYL',2,1,'ADDISON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU11717',2200,0,5,0,71782,'F','Publisher',1500,'NorthEast',1,2200,'No',0,1,31,53.02,23545.5,0,1,34,2,'HIGH','LAVETA',1,1,'CASEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU5928',2200,0,1,1,61056,'M','Childcare Worker',1000,'NorthEast',1,2200,'No',0,0,44,53.15,23164,965,1,461,2,'HIGH','ROBERTO',1,1,'CORNELIUS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NM',0,4,'CU10012',1001,0,3,0,59480,'M','Cashier',700,'Southwest',1,1001,'No',0,1,52,53.06,26070,0,0,25,0,'HIGH','DORSEY',1,1,'PRIEST')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU197',0,0,0,0,73461,'M','Nurse',2500,'Midwest',0,0,'No',0,0,77,53.06,27065.25,598,0,25,0,'HIGH','ENRIQUE',0,1,'BARRIOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU476',909,0,0,1,61943,'M','Administrative Assistant',600,'West',1,909,'No',0,0,69,53.12,28385.75,1971,1,1466,2,'HIGH','CHONG',1,1,'CROWDER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,2,'CU9110',2500,0,0,1,64648,'M','Administrative Assistant',800,'NorthEast',1,2500,'No',0,1,46,53.06,26762,0,1,25,0,'HIGH','JOHN',1,1,'CLARK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,4,'CU7291',0,5100,0,1,58327,'M','Nurse',800,'Midwest',0,1500,'No',4,1,42,53.45,15781.75,2570,2,1926,4,'MEDIUM','LAUREN',0,1,'LAYNE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OK',0,2,'CU7148',700,750,2,0,60968,'M','Programmer/Developer',900,'Midwest',1,700,'No',3,1,28,53,25042,725,3,206,2,'HIGH','VINCENT',1,1,'COBB')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU9648',400,0,3,1,66717,'M','Programmer/Developer',700,'South',1,400,'No',5,1,34,53.3,20579.25,0,1,25,3,'MEDIUM','FRANKLIN',1,1,'ADLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU1055',2500,0,3,1,65837,'M','Clerical',900,'NorthEast',1,2500,'No',13,0,36,53.36,20559.25,618,1,91,3,'MEDIUM','OLIVER',1,1,'ESTRADA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','CA',12214,1,'CU749',38974,24500,1,1,94589,'F','Homemaker',5000,'West',1,3500,'No',3,0,71,54.13,34247.25,52378,5,427,5,'VERY HIGH','NATACHA',1,1,'KILGORE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU12581',800,1200,5,1,71368,'F','Programmer/Developer',1000,'NorthEast',1,200,'No',4,1,21,53.03,17442,683,3,25,2,'MEDIUM','SAMARA',1,1,'KIMBLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','IL',0,1,'CU1731',5000,24000,1,1,56506,'F','Clerical',1800,'Midwest',1,4000,'No',3,2,49,54.35,22526.5,46108,4,13125,5,'HIGH','ANASTASIA',1,1,'FISCHER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','AK',0,5,'CU1881',6755,0,5,0,71142,'M','Medical Doctor',1500,'West',1,6755,'No',1,2,37,55.53,23985.5,532,1,25,6,'HIGH','WILLARD',1,1,'WEEKS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU400',0,3333,0,1,60752,'M','Nurse',700,'West',0,1333,'No',4,10,52,54.83,16388,14559,1,11301,5,'MEDIUM','EZEKIEL',0,1,'HARGROVE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU4172',1000,401,1,1,75114,'F','Administrative Assistant',1600,'NorthEast',1,1000,'No',2,2,48,53.09,27078.5,1899,2,1388,1,'HIGH','SAMMY',1,1,'KANG')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NV',0,3,'CU10006',2000,0,3,0,60554,'M','Lab Technician',1000,'Southwest',1,2000,'No',0,1,30,53.06,23638.5,0,1,25,0,'HIGH','GREGORIO',1,1,'LAWRENCE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','UT',0,1,'CU15957',5000,0,1,0,51837,'M','PROF-3',4000,'Southwest',1,5000,'No',12,5,34,53.29,24859.25,0,0,25,3,'HIGH','LAVERN',1,1,'DODGE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU10540',0,0,0,0,58408,'M','Nurse',1500,'NorthEast',0,0,'No',0,1,33,53.06,18902,0,0,25,0,'MEDIUM','WILBER',0,0,'ANDERSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU11020',2151,0,1,0,72865,'M','PROF-42',1500,'NorthEast',1,2151,'No',2,3,37,53.04,30416.25,507,1,223,2,'VERY HIGH','ASA',1,1,'LEAVITT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU3091',2700,0,3,1,65594,'M','Publisher',900,'NorthEast',1,2700,'No',1,2,25,54.24,19398.5,510,1,25,5,'MEDIUM','VAN',1,1,'LAMB')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU4994',5600,4000,1,1,63640,'F','Lab Technician',1000,'NorthEast',1,1000,'No',2,0,42,53.95,23610,5674,1,2908,4,'HIGH','ROLANDA',1,1,'WAGNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WA',0,4,'CU11201',474,201,4,0,64207,'M','PROF-28',600,'West',1,474,'No',0,1,38,53.07,23851.75,0,1,25,1,'HIGH','FREDRIC',1,1,'WARDEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU11171',1050,0,3,0,63465,'M','First-line Manager',1000,'NorthEast',1,1050,'No',0,1,0,53.06,0,0,0,25,0,'LOW','MARIO',1,1,'CUTLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,1,'CU1245',5000,14001,1,1,91279,'F','Law Enforcement Officer',3000,'West',1,1,'No',4,0,58,53.7,32119.75,1101,5,570,4,'VERY HIGH','MARIETTA',1,1,'BINGHAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','UT',0,1,'CU15866',960,250,1,0,58193,'M','Professor',1500,'Southwest',1,960,'No',2,5,22,53.06,25248.25,0,2,25,0,'HIGH','MEL',1,1,'YANCEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,1,'CU14631',0,500,1,0,57902,'F','Programmer/Developer',1000,'South',0,0,'No',4,1,28,53.13,15775.5,451,2,429,2,'MEDIUM','TANDRA',0,1,'BALLARD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU8908',0,0,0,0,63625,'M','PROF-18',1000,'NorthEast',0,0,'No',3,1,21,53.08,19006.25,161,0,25,1,'MEDIUM','ABRAHAM',0,1,'PRATT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,4,'CU929',2702,0,1,0,59463,'M','Homemaker',1300,'Midwest',1,2702,'No',0,0,60,53.06,30865.75,507,1,25,0,'VERY HIGH','BEAU',1,1,'MCKINNON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU11849',700,0,3,1,68889,'M','Sales Representative',1000,'NorthEast',1,700,'No',8,4,28,53.24,20522.25,2024,1,1962,3,'MEDIUM','JOSH',1,1,'FOX')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU12777',0,550,3,1,69382,'M','Programmer/Developer',1000,'West',0,0,'No',8,1,29,53.02,10745.5,935,2,25,2,'LOW','RAYMUNDO',0,1,'COYLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU6027',800,0,4,1,62253,'M','Accountant',800,'West',1,800,'No',0,1,77,53.06,22263.25,504,0,25,0,'HIGH','DANILO',1,1,'BARAJAS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NC',0,3,'CU672',980,1600,3,1,57724,'M','Waiter/Waitress',1000,'South',2,980,'No',9,0,26,53.24,27531,246,1,207,3,'HIGH','MARCO',2,1,'NORTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU4165',0,0,0,0,64671,'M','Author',1300,'Midwest',0,0,'No',0,3,35,53.06,20667.75,507,1,25,0,'MEDIUM','DARRICK',0,1,'MICHAEL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU11854',1000,750,3,0,59210,'M','Programmer/Developer',1000,'Midwest',1,1000,'No',2,4,21,53.05,22402.5,0,3,25,2,'HIGH','GRANVILLE',1,1,'BECK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,4,'CU1832',10000,19500,3,1,74752,'F','Not specified',1300,'West',1,3500,'No',3,2,50,54.25,24688,2914,2,25,5,'HIGH','ISELA',1,1,'SHOEMAKER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU12518',0,500,3,0,69229,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',7,1,22,53.05,15007.25,106,2,98,2,'MEDIUM','AMOS',0,1,'EASLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,4,'CU10801',300,350,4,0,70065,'M','Waiter/Waitress',1500,'West',1,300,'No',3,1,22,53.22,23716.25,0,2,25,3,'HIGH','ROB',1,1,'KOEHLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU8880',0,0,2,0,72354,'M','Waiter/Waitress',1500,'West',0,0,'No',0,1,34,52.81,18488.5,168,0,159,2,'MEDIUM','MOSE',0,1,'MAHONEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU1745',0,0,0,1,64905,'M','Bank Teller',900,'NorthEast',0,0,'No',1,0,32,53.07,15426.25,605,0,25,1,'MEDIUM','JACKIE',0,1,'HIGHTOWER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU6439',0,0,0,1,66001,'M','Nurse',900,'West',0,0,'No',3,10,59,53.69,18400.25,2254,1,25,4,'MEDIUM','DONALD',0,1,'MICHAEL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU6117',1500,2250,5,1,52067,'F','Author',2400,'NorthEast',1,750,'No',2,0,0,54.12,0,20571,4,18683,5,'LOW','BERNADINE',1,1,'PRITCHETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,2,'CU15015',4000,0,2,0,56610,'M','PROF-18',2000,'NorthEast',1,4000,'No',0,1,39,53.06,25052.5,0,0,25,0,'HIGH','RANDOLPH',1,1,'MCMANUS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU9590',0,650,3,1,71649,'M','PROF-17',1500,'NorthEast',0,0,'No',1,1,24,53.74,10812.25,603,2,595,4,'LOW','WILBER',0,1,'EMERY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU2507',0,28300,0,0,67082,'M','Administrative Assistant',900,'West',0,5000,'No',1,2,0,53.18,0,1693,6,1185,3,'LOW','RUSTY',0,1,'HILLMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU13551',0,250,3,0,71809,'M','Programmer/Developer',1000,'South',0,0,'No',4,1,21,53.05,15552.25,0,2,25,2,'MEDIUM','BRANDON',0,0,'FOSS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU7788',250,0,3,0,64703,'M','PROF-12',1000,'Midwest',1,250,'No',1,1,22,53.06,23875.75,0,0,25,0,'HIGH','BRYAN',1,1,'GARCIA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',6611,3,'CU12361',913,251,3,1,64441,'M','Bank Teller',700,'Midwest',1,913,'No',14,4,62,53.36,22810.25,8314,2,25,3,'HIGH','OMER',1,1,'STOCKTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,4,'CU10508',1000,0,4,0,64900,'M','Clerical',1000,'South',1,1000,'No',1,1,62,53.06,26425,0,1,25,0,'HIGH','LEANDRO',1,1,'ALONSO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OH',0,3,'CU14309',1200,0,3,0,61500,'M','PROF-6',2500,'Midwest',1,1200,'No',0,1,19,53.06,22775,0,0,25,0,'HIGH','ALONSO',1,1,'MCDERMOTT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',586,2,'CU5679',0,1100,0,1,60946,'M','Professor',1000,'West',0,0,'No',3,0,61,53.13,17336.5,1566,6,431,2,'MEDIUM','LUPE',0,1,'FARRELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','UT',0,3,'CU15979',850,0,3,0,59864,'M','Mason',1500,'Southwest',1,850,'No',4,5,19,53.01,22366,0,0,25,2,'HIGH','RAY',1,1,'SNODGRASS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU12527',3500,0,1,1,64553,'F','IT Staff',1000,'NorthEast',1,3500,'No',14,1,39,53.48,23538.25,903,1,25,4,'HIGH','MIRNA',1,1,'WAITE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,1,'CU1140',0,0,1,0,65736,'M','PROF-18',900,'West',0,0,'No',0,0,27,53.07,17634,798,0,25,1,'MEDIUM','ANDY',0,1,'COOK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU6871',1100,0,3,1,56137,'F','Author',1500,'West',1,1100,'No',4,1,61,53.14,21134.25,1645,1,25,2,'MEDIUM','KATHYRN',1,1,'PICKETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WA',0,2,'CU3070',3000,10300,0,1,61789,'M','Truck Driver',1300,'West',1,2400,'No',3,3,33,54.36,24747.25,12132,4,11174,5,'HIGH','ROBERTO',1,1,'PATTEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU2941',0,0,0,0,59461,'M','IT Staff',900,'West',0,0,'No',0,2,63,53.06,22165.25,504,0,25,0,'HIGH','VAL',0,1,'HACKETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MN',0,4,'CU11032',0,9000,4,1,62658,'M','Software Engineer',500,'West',0,1500,'No',4,1,31,53.81,7764.5,9718,4,8493,4,'LOW','ELVIS',0,1,'HULL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',3425,2,'CU3996',900,2877,0,1,57616,'M','Bank Teller',900,'West',1,477,'No',1,3,42,53.41,24604,5183,1,25,4,'HIGH','SEAN',1,1,'DOWNING')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU3065',2300,6282,1,1,66372,'F','PROF-1',1300,'NorthEast',1,1495,'No',12,2,53,53.8,25393,15036,6,14522,4,'HIGH','RISA',1,1,'TUCKER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WI',0,3,'CU15033',0,700,3,1,57064,'M','Programmer/Developer',1000,'Midwest',0,0,'No',7,1,19,53.1,6666,185,3,25,2,'LOW','MARC',0,1,'HARRIS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU11319',0,0,3,0,75031,'M','PROF-18',1500,'West',0,0,'No',0,1,20,53.05,16257.75,0,0,25,2,'MEDIUM','ANDREW',0,0,'DUFFY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU15694',2380,0,4,1,60073,'F','PROF-1',1500,'NorthEast',1,2380,'No',2,4,32,54.28,17218.25,0,1,25,5,'MEDIUM','SHAY',1,1,'FARRELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU14045',1000,450,1,0,71214,'F','Truck Driver',1000,'West',1,1000,'No',18,1,50,53.2,31303.5,1159,2,170,3,'VERY HIGH','GENNY',1,1,'VALENZUELA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2088',0,0,0,0,61807,'M','PROF-57',500,'NorthEast',0,0,'No',0,2,27,53.06,19151.75,506,0,25,0,'MEDIUM','DOMENIC',0,1,'MIXON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,5,'CU14690',0,0,5,0,63272,'F','Programmer/Developer',700,'Midwest',0,0,'No',2,1,39,52.94,12218,360,1,25,2,'LOW','THEA',0,1,'KELSEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU3486',2200,3550,1,1,70243,'F','Cashier',1700,'West',1,650,'No',17,4,48,53.69,25860.75,3040,2,1947,4,'HIGH','LAVETA',1,1,'ALSTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',963,2,'CU2417',0,1156,0,0,64964,'M','Sales Representative',1000,'NorthEast',0,506,'No',4,2,27,53.15,19941,4276,3,2420,2,'MEDIUM','ALEX',0,1,'BEAL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OR',0,1,'CU4125',0,13602,1,1,68407,'M','Administrator',1000,'West',0,4352,'No',2,3,42,54.07,14801.75,24350,5,23324,5,'MEDIUM','CLEMENTE',0,1,'CLOUTIER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','MI',0,2,'CU5600',5000,1501,2,0,94542,'F','Clerical',4000,'Midwest',1,5000,'No',11,0,61,53.54,36735.5,1470,3,373,4,'VERY HIGH','SANG',1,1,'DUTTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',7357,4,'CU15532',3000,2400,3,0,61148,'M','Homemaker',1500,'NorthEast',1,300,'No',4,4,35,54.32,24787,7939,1,25,5,'HIGH','TYLER',1,1,'BURDICK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU15782',2000,1000,1,0,86041,'F','Administrator',2500,'West',1,2000,'No',0,5,49,53.06,34910.25,0,3,25,0,'VERY HIGH','NELLIE',1,1,'MOHR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,5,'CU11615',450,500,5,1,63248,'F','Programmer/Developer',1000,'NorthEast',1,450,'No',4,2,21,53.12,15412,214,2,25,2,'MEDIUM','DEMETRICE',1,1,'PEREZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU6097',0,0,3,0,59990,'M','Author',700,'West',0,0,'No',1,0,62,53.11,16697.5,1080,0,25,2,'MEDIUM','OMER',0,1,'YORK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',1896,3,'CU8359',2000,1200,3,1,56237,'M','Technical Writer',1500,'NorthEast',1,2000,'No',3,3,39,53.15,18459.25,3783,3,1820,2,'MEDIUM','WILLY',1,1,'BYRNE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU5511',2000,2900,1,1,76355,'M','IT Staff',1500,'NorthEast',1,500,'No',4,0,45,53.33,27088.75,849,5,25,3,'HIGH','ORLANDO',1,1,'GUNTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',98076,2,'CU847',0,7644,0,1,59581,'M','PROF-61',600,'NorthEast',0,3322,'No',2,0,46,57.84,15495.25,98590,1,25,6,'MEDIUM','EMILIO',0,1,'SHIPP')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,1,'CU13966',330,0,1,0,59743,'M','Nurse',600,'West',1,330,'No',3,1,40,53.07,27435.75,0,0,25,1,'HIGH','WALLACE',1,1,'MEREDITH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU11048',4000,0,1,1,65179,'F','IT Staff',800,'NorthEast',1,4000,'No',3,2,52,53.15,24994.75,0,0,25,2,'HIGH','ARLINE',1,1,'ALTMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU12283',1055,600,1,1,79782,'F','PROF-21',2500,'West',1,1055,'No',12,4,44,53.42,27845.5,566,2,25,4,'HIGH','COLLEEN',1,1,'YEAGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','MI',0,1,'CU34',10000,11500,1,1,61090,'F','Law Enforcement Officer',1200,'Midwest',1,10000,'No',10,0,84,53.6,27172.5,1581,6,141,4,'HIGH','CARMELIA',1,1,'SIMMONS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU8014',700,251,3,0,69368,'M','Programmer/Developer',1000,'West',1,700,'No',11,3,21,53.1,24942,2425,2,2289,2,'HIGH','ELLIOTT',1,1,'MADDOX')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU13411',224,0,3,0,61659,'M','PROF-22',1000,'Midwest',1,224,'No',0,1,30,53.07,23914.75,0,0,25,1,'HIGH','BOOKER',1,1,'BEAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU14768',0,250,3,0,66738,'M','Programmer/Developer',600,'South',0,0,'No',0,1,31,53.06,15284.5,0,2,25,0,'MEDIUM','CORNELIUS',0,0,'SIMON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',52123,4,'CU9789',6000,22001,1,0,65584,'F','PROF-58',800,'NorthEast',1,1,'No',2,1,55,57.88,31896,107253,1,25,6,'VERY HIGH','LINDSY',1,1,'VICK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2144',0,0,0,0,58490,'M','PROF-24',900,'NorthEast',0,0,'No',0,2,31,53.06,18722.5,506,1,25,0,'MEDIUM','DOMINGO',0,1,'STEVENS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','FL',0,4,'CU4291',4800,0,1,1,66079,'M','Waiter/Waitress',500,'South',2,4800,'No',9,3,30,53.4,34519.75,232,1,189,4,'VERY HIGH','IRVING',2,1,'LOVETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,2,'CU2654',727,0,0,1,65727,'M','IT Staff',800,'NorthEast',1,727,'No',0,2,61,53.06,28531.75,511,1,25,0,'HIGH','HUBERT',1,1,'COYLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU15784',0,8500,1,1,63277,'M','Clerical',600,'NorthEast',0,2000,'No',3,5,42,53.63,13519.25,12812,4,11998,4,'LOW','CALVIN',0,1,'BURTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NV',0,1,'CU654',8000,6200,1,1,61816,'F','Publisher',500,'Southwest',1,900,'No',1,0,37,54.04,22654,655,4,136,5,'HIGH','SHEILAH',1,1,'COMBS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','TX',0,4,'CU12127',6000,3600,6,1,63137,'F','Homemaker',5000,'Southwest',1,6000,'No',12,4,29,54.03,13684.25,1800,1,1532,5,'LOW','MAYBELL',1,1,'CARTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2966',0,0,0,0,63968,'M','Administrative Assistant',500,'NorthEast',0,0,'No',4,2,21,53.09,19092,599,0,25,1,'MEDIUM','BOYD',0,1,'SHOCKLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,3,'CU11392',2200,0,3,0,60915,'M','Truck Driver',1500,'NorthEast',1,2200,'No',13,3,23,53.41,23028.75,111,0,25,4,'HIGH','SOL',1,1,'SCHMIDT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11983',200,0,3,0,63963,'M','PROF-29',1000,'NorthEast',1,200,'No',0,4,18,53.06,23290.75,0,0,25,0,'HIGH','RENE',1,1,'CHASTAIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',23030,4,'CU6028',3000,2200,3,1,58770,'F','IT Staff',1300,'NorthEast',1,3000,'No',0,1,38,53.7,19492.5,24614,1,996,4,'MEDIUM','LAVERNA',1,1,'SCHMITZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU13388',0,0,2,0,54484,'M','PROF-2',2500,'Midwest',0,0,'No',0,1,70,53.33,17621,1632,0,25,3,'MEDIUM','LEIF',0,1,'ARNOLD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','OK',0,3,'CU13386',3000,1850,3,0,57132,'M','PROF-18',2500,'Midwest',1,450,'No',9,1,24,53.82,22183,313,1,270,4,'HIGH','ALVA',1,1,'VERNON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU6607',980,1450,3,1,61221,'M','Veterinarian',500,'Midwest',1,250,'No',2,1,30,53.87,18805.25,2131,3,1241,4,'MEDIUM','HECTOR',1,1,'SUMMERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU7331',0,0,0,0,69099,'M','PROF-46',800,'West',0,0,'No',4,1,43,53.11,22574.75,1707,1,25,2,'HIGH','PATRICK',0,1,'GARRETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',2178,5,'CU2624',5000,8850,5,1,68069,'F','Clerical',3000,'NorthEast',1,1500,'No',4,2,27,53.84,17217.25,16470,2,13091,4,'MEDIUM','CAITLYN',1,1,'LOVE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU6389',0,0,0,1,62163,'M','Accountant',500,'West',0,0,'No',4,0,46,53.12,16140.75,636,0,25,2,'MEDIUM','TOMMIE',0,1,'RANGEL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,2,'CU100',2000,0,0,1,58365,'M','Not specified',1000,'Midwest',1,2000,'No',2,0,43,53.36,24891.25,8628,0,7863,3,'HIGH','RANDELL',1,1,'POLLOCK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NV',0,3,'CU8653',1000,0,3,1,61753,'M','Truck Driver',700,'Southwest',1,1000,'No',0,1,33,53.06,19238.25,0,0,25,0,'MEDIUM','BRODERICK',1,1,'FULTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU2639',0,0,0,0,62391,'M','Administrative Assistant',700,'Midwest',0,0,'No',3,9,40,54.93,20597.75,2463,1,25,5,'MEDIUM','CHARLIE',0,1,'ENGEL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,1,'CU1330',0,7662,1,0,63012,'M','Truck Driver',700,'Midwest',0,2662,'No',4,2,53,53.82,19553,1745,2,25,4,'MEDIUM','TERENCE',0,1,'ELMORE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU6308',7000,8400,3,1,109943,'F','PROF-55',5000,'NorthEast',1,3000,'No',3,8,47,53.46,33185.75,2786,4,25,4,'VERY HIGH','HANNA',1,1,'WILKINSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU15141',2500,2700,4,0,63642,'F','Clerical',1500,'NorthEast',1,2500,'No',1,4,43,43.91,24210.5,2690,1,25,2,'HIGH','LAURYN',1,1,'WATERMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','UT',0,4,'CU15960',250,0,4,0,61708,'M','PROF-28',2500,'Southwest',1,250,'No',1,5,41,53.06,23527,0,0,25,0,'HIGH','GERARDO',1,1,'SHERRILL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,2,'CU2806',2000,0,1,0,66820,'M','PROF-55',500,'Midwest',1,2000,'No',2,2,45,53.12,30205,702,0,25,2,'VERY HIGH','ALONSO',1,1,'GEIGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU7171',0,0,1,0,68242,'M','Nurse',2500,'NorthEast',0,0,'No',1,1,74,53.07,22960.5,513,0,25,1,'HIGH','RUSS',0,1,'TOBIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',0,3,'CU11941',0,0,3,1,58238,'M','Programmer/Developer',1000,'Southwest',0,0,'No',1,4,27,53.03,7759.5,990,1,25,2,'LOW','MIQUEL',0,1,'LONDON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU165',0,2452,0,1,60163,'M','PROF-48',500,'West',0,552,'No',4,0,32,53.43,14240.75,4963,1,4451,4,'MEDIUM','DUDLEY',0,1,'GUERRA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU8559',700,0,1,0,69353,'F','Construction Laborer',800,'NorthEast',1,700,'No',4,1,46,53.1,30438.25,1661,2,1151,2,'VERY HIGH','VENUS',1,1,'SCHMIDT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU12595',4750,2700,1,1,54661,'F','Technical Writer',3000,'NorthEast',1,500,'No',4,1,31,53.31,20265.25,5662,2,5642,3,'MEDIUM','MATILDA',1,1,'VELASQUEZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,1,'CU4385',500,0,1,0,63666,'M','Fireman',500,'West',1,500,'No',7,3,46,53.08,29016.5,638,0,129,1,'HIGH','DOYLE',1,1,'BREWSTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU5852',0,0,0,1,59849,'M','Administrative Assistant',800,'NorthEast',0,0,'No',1,0,41,53.33,15062.25,4336,0,3682,3,'MEDIUM','MAN',0,1,'BURKETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU5859',200,0,3,0,70245,'M','PROF-3',900,'Midwest',1,200,'No',0,0,24,53.06,25461.25,508,1,25,0,'HIGH','JAMEL',1,1,'KIRKPATRICK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,2,'CU1891',2000,0,0,0,68002,'M','PROF-3',1500,'NorthEast',1,2000,'No',1,2,29,53.07,30900.5,549,1,25,1,'VERY HIGH','EARL',1,1,'SYLVESTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU3889',2000,0,1,1,66712,'F','Plumber',500,'Midwest',1,2000,'No',0,3,36,53.06,23778,506,1,25,0,'HIGH','DOLLY',1,1,'REAVES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU14108',2873,0,4,0,67145,'F','PROF-15',1000,'West',1,2873,'No',0,1,64,53.84,27186.25,0,1,25,4,'HIGH','PHUNG',1,1,'BURROUGHS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',0,2,'CU6575',3000,0,0,0,64793,'M','Administrator',900,'Southwest',1,3000,'No',0,1,33,53.51,30498.25,10547,1,10040,4,'VERY HIGH','DIRK',1,1,'WAGNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',8286,1,'CU5548',3000,5200,1,1,55600,'M','Childcare Worker',1500,'West',1,850,'No',10,0,29,53.71,20300,20375,4,10308,4,'MEDIUM','HUNTER',1,1,'DEJESUS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU5632',0,5036,2,0,67607,'M','Mason',2500,'West',0,1086,'No',9,0,66,54.47,20501.75,24628,9,23476,5,'MEDIUM','WILBURN',0,1,'SHIPMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,4,'CU10961',0,0,6,0,61228,'M','PROF-5',600,'West',0,0,'No',2,1,63,53.08,11607,0,0,25,1,'LOW','MARC',0,0,'CASSIDY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU6522',1200,1200,3,1,68811,'M','PROF-62',900,'NorthEast',1,1200,'No',15,1,26,53.37,20302.75,396,3,25,3,'MEDIUM','CLARK',1,1,'SHIPLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU15421',5000,0,5,1,59923,'F','IT Staff',3500,'NorthEast',1,5000,'No',0,4,33,53.06,15780.75,0,1,25,0,'MEDIUM','VELVET',1,1,'BRYSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11086',300,0,3,0,71140,'M','Programmer/Developer',1000,'NorthEast',1,300,'No',0,1,22,53.06,25485,0,1,25,0,'HIGH','DUSTIN',1,1,'ROGERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MN',0,4,'CU3971',5000,7400,1,1,59502,'F','IT Staff',900,'West',1,2000,'No',4,3,37,53.78,23575.5,4082,4,3561,4,'HIGH','MARTY',1,1,'COLEMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU10565',0,0,0,0,59200,'M','Nurse',1500,'NorthEast',0,0,'No',0,1,22,53.06,18000,0,0,25,0,'MEDIUM','BERNARDO',0,0,'WILSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU2587',0,5369,1,0,64371,'M','Clerical',900,'NorthEast',0,969,'No',4,5,30,53.86,17592.75,5775,2,5262,4,'MEDIUM','MITCHELL',0,1,'KESSLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU4668',0,0,0,1,67267,'M','Waiter/Waitress',900,'West',0,0,'No',13,0,36,53.13,16416.75,2113,1,1598,2,'MEDIUM','EARL',0,1,'LAY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NV',0,1,'CU14336',700,0,1,0,79450,'F','PROF-12',2500,'Southwest',1,700,'No',1,1,69,53.08,35262.5,372,0,25,1,'VERY HIGH','MARTINE',1,1,'RIDDLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU6781',1600,1500,1,1,63775,'M','Medical Doctor',500,'West',1,300,'No',11,2,58,53.54,25243.75,277,6,166,4,'HIGH','BOB',1,1,'WOMACK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU491',1100,3686,0,1,67265,'M','Administrative Assistant',1000,'West',1,836,'No',1,0,55,53.18,28316.25,958,1,25,3,'HIGH','ELWOOD',1,1,'MCLEOD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,2,'CU1037',10000,0,0,1,66039,'M','Administrative Assistant',500,'NorthEast',2,10000,'No',0,0,35,53.06,36009.75,504,1,25,0,'VERY HIGH','CALEB',2,1,'SPIVEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NC',108,3,'CU14713',1500,600,3,1,69428,'M','PROF-37',1500,'South',2,1500,'No',2,1,21,52.76,29957,328,2,55,2,'HIGH','STACY',2,1,'ROMERO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU11028',5000,0,0,1,62350,'M','DBA',1500,'West',1,5000,'No',1,1,34,53.07,24987.5,260,1,25,1,'HIGH','TERRANCE',1,1,'BRANDON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU10370',238,0,3,0,76050,'M','Mason',1500,'NorthEast',1,238,'No',2,1,21,53.16,26612.5,0,0,25,2,'HIGH','LANE',1,1,'SAMUELS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU10377',1000,0,3,0,64032,'M','IT Staff',1500,'NorthEast',1,1000,'No',0,1,33,53.15,24808,0,1,25,2,'HIGH','MAN',1,1,'STARNES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU6040',1600,6000,0,1,61290,'M','Professor',900,'West',1,1500,'No',17,1,54,53.57,26722.5,9623,4,422,4,'HIGH','KRAIG',1,1,'SINGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2605',0,0,0,1,59189,'M','First-line Manager',1000,'NorthEast',0,0,'No',0,2,26,53.06,13397.25,506,0,25,0,'LOW','VAL',0,1,'EARLY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU13713',1700,500,1,0,62356,'F','PROF-26',1000,'NorthEast',1,1700,'No',2,3,29,53.77,26989,729,2,25,4,'HIGH','DIMPLE',1,1,'OLEARY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,3,'CU9913',1000,200,3,0,68223,'M','PROF-7',1000,'South',1,1000,'No',11,2,29,53.23,25455.75,147,1,25,3,'HIGH','HARLEY',1,1,'DORAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,4,'CU790',0,16141,3,1,62391,'M','Clerical',900,'NorthEast',0,3691,'No',2,0,80,53.61,14597.75,560,5,25,4,'MEDIUM','MYRON',0,1,'SNIDER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU1531',0,1293,0,1,62765,'M','Truck Driver',900,'NorthEast',0,0,'No',6,0,34,53.67,15091.25,9170,3,8342,4,'MEDIUM','VAL',0,1,'MATTSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU6957',0,2056,0,1,69550,'M','Nurse',1000,'Midwest',0,506,'No',4,1,31,53.6,16487.5,4866,1,4357,4,'MEDIUM','DELMER',0,1,'HEALY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU10308',4500,0,1,1,69376,'F','PROF-24',800,'NorthEast',1,4500,'No',2,1,42,53.81,25044,0,1,25,4,'HIGH','JESSIKA',1,1,'ANDERSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','AK',0,1,'CU2714',1300,1000,1,1,63974,'F','Medical Doctor',700,'West',1,250,'No',4,2,31,53.69,22593.5,624,3,32,4,'HIGH','ALTHA',1,1,'MAYO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU13730',0,0,3,0,60685,'M','Programmer/Developer',1000,'Midwest',0,0,'No',0,1,21,53.06,12771.25,0,1,25,0,'LOW','CLIFTON',0,0,'CAIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU1228',0,0,0,1,64714,'M','Administrative Assistant',600,'NorthEast',0,0,'No',0,0,39,53.06,16078.5,502,1,25,0,'MEDIUM','ZACHERY',0,1,'CHILDRESS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU6620',3000,0,1,0,61725,'F','PROF-5',900,'NorthEast',1,3000,'No',3,2,51,53.28,29031.25,6320,1,3907,3,'HIGH','NATISHA',1,1,'HENRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14833',600,401,3,1,60405,'M','Waiter/Waitress',1000,'West',1,600,'No',11,1,23,53.05,17901.25,103,2,89,2,'MEDIUM','ERICH',1,1,'LAND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU7107',0,0,0,1,67617,'M','Nurse',900,'West',0,0,'No',1,1,63,53.11,19204.25,1457,0,25,2,'MEDIUM','ISRAEL',0,1,'BRANCH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,4,'CU1861',6000,4001,6,1,67415,'F','IT Staff',5000,'West',1,6000,'No',2,2,56,52.91,17453.75,7784,4,5824,2,'MEDIUM','DELORA',1,1,'BEGAY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11260',0,0,3,0,59140,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',18,6,23,53.25,12585,292,1,222,3,'LOW','CHARLIE',0,1,'STEWARD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU11693',2700,1600,5,0,67598,'F','Truck Driver',2500,'NorthEast',1,2700,'No',3,4,31,52.97,22499.5,3271,3,25,2,'HIGH','JANYCE',1,1,'HUNTLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU11143',1200,251,3,0,63463,'M','Programmer/Developer',1000,'NorthEast',1,1200,'No',14,1,23,53.29,23665.75,809,2,801,3,'HIGH','BUSTER',1,1,'BEATY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU10505',0,250,3,0,67794,'M','Programmer/Developer',1000,'Midwest',0,0,'No',11,1,27,53.02,15148.5,142,2,25,2,'MEDIUM','JEFFREY',0,1,'LESLIE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,2,'CU11355',2500,0,2,0,72509,'M','First-line Manager',1500,'NorthEast',1,2500,'No',0,1,32,53.06,28327.25,0,0,25,0,'HIGH','KENETH',1,1,'RADFORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU14664',2000,3000,1,0,50175,'F','PROF-54',2500,'NorthEast',1,1000,'No',1,1,28,53.42,23843.75,1416,1,542,4,'HIGH','SASHA',1,1,'MOSHER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU13245',3000,1600,1,1,60692,'F','PROF-14',1000,'Midwest',1,300,'No',3,1,31,53.61,21773,1499,3,1476,4,'MEDIUM','MAEGAN',1,1,'GROVE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU12107',0,0,3,0,61515,'M','Sales Representative',1000,'Midwest',0,0,'No',0,4,27,53.07,13578.75,0,0,25,1,'LOW','CHANG',0,0,'VALENTIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU9138',2500,0,4,1,67015,'F','Administrator',800,'West',1,2500,'No',6,1,51,53.12,20853.75,206,1,25,2,'MEDIUM','MAGALI',1,1,'COVINGTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',88499,2,'CU5676',0,10200,2,1,72385,'M','Administrative Assistant',1400,'West',0,1600,'No',2,0,63,58.75,16396.25,105507,6,25,6,'MEDIUM','JOESPH',0,1,'KESSLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU3921',1000,0,1,0,61460,'M','PROF-40',500,'West',1,1000,'No',7,3,43,53.11,28165,777,1,25,2,'HIGH','HARVEY',1,1,'LAU')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU6825',0,2520,0,1,65742,'M','Administrative Assistant',600,'NorthEast',0,720,'No',2,1,49,53.09,17335.5,1229,1,673,1,'MEDIUM','TAD',0,1,'OGDEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU6641',200,0,0,0,67907,'M','Administrative Assistant',900,'NorthEast',1,200,'No',0,1,24,53.06,30376.75,504,0,25,0,'VERY HIGH','RYAN',1,1,'MCKINNEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NV',0,1,'CU10597',2000,1200,1,1,60151,'F','IT Staff',1000,'Southwest',1,2000,'No',4,1,34,53.99,21937.75,3503,3,25,5,'MEDIUM','CODI',1,1,'BLANCHARD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MS',0,2,'CU6928',2500,0,1,1,58069,'F','PROF-13',1500,'South',1,2500,'No',3,1,36,52.98,22117.25,700,1,188,2,'HIGH','VIOLETTE',1,1,'CHRISTIANSEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WA',0,3,'CU12331',0,250,3,0,75415,'M','Programmer/Developer',1500,'West',0,0,'No',0,4,21,53.06,16453.75,257,2,25,0,'MEDIUM','AL',0,1,'FRANK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU544',0,0,0,0,70097,'M','Administrative Assistant',1500,'Midwest',0,0,'No',0,0,0,53.06,0,503,0,25,0,'LOW','BRET',0,1,'SHULTZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU3569',2000,6484,1,0,69003,'M','Not specified',1000,'West',1,2934,'No',3,3,47,53.54,30450.75,5304,4,4366,4,'VERY HIGH','DESMOND',1,1,'HANKS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU4828',1300,2350,1,0,61914,'F','Veterinarian',1800,'NorthEast',1,350,'No',2,3,47,53.35,28678.5,9592,1,8872,3,'HIGH','CLARISA',1,1,'OROURKE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OH',0,3,'CU12112',340,300,3,1,62520,'M','Veterinarian',1000,'Midwest',1,340,'No',18,4,26,53.09,18730,504,2,487,1,'MEDIUM','GERALDO',1,1,'DUGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU3003',1500,301,3,1,63061,'M','Programmer/Developer',500,'NorthEast',1,1500,'No',2,4,21,53.18,18365.25,588,2,25,3,'MEDIUM','TEDDY',1,1,'GAY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OR',5554,4,'CU3421',731,1300,1,1,62277,'M','Veterinarian',600,'West',2,731,'No',13,2,40,53.3,34569.25,11016,2,3596,3,'VERY HIGH','WILBURN',2,1,'SPAULDING')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU13562',530,0,3,0,60726,'M','Mason',1000,'NorthEast',1,530,'No',4,1,28,53.18,23481.5,1016,1,1001,3,'HIGH','MATT',1,1,'PERRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU8726',0,650,3,1,61628,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',17,3,27,53.05,8607,283,2,270,2,'LOW','DREW',0,1,'VANCE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','UT',0,3,'CU15798',176,0,3,0,60866,'M','PROF-17',1500,'Southwest',1,176,'No',2,5,17,53.06,22416.5,0,0,25,0,'HIGH','BERT',1,1,'VELAZQUEZ')
SELECT * FROM DUAL;
INSERT ALL
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,4,'CU2880',2100,3900,1,1,69326,'F','PROF-52',900,'Midwest',2,800,'No',2,2,43,54.78,36631.5,1793,2,735,5,'VERY HIGH','DOTTY',2,1,'RITCHIE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU14514',774,0,3,1,62566,'M','PROF-12',600,'NorthEast',1,774,'No',0,1,64,53.5,22541.5,0,1,25,4,'HIGH','AMBROSE',1,1,'ROPER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',63310,2,'CU3040',0,0,0,1,60674,'M','Sales Representative',700,'Southwest',0,0,'No',4,2,50,56.01,16168.5,63932,1,25,6,'MEDIUM','JACOB',0,1,'WILEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,1,'CU6286',3100,9200,1,1,81059,'M','Secretary',2000,'NorthEast',1,1500,'No',4,0,49,53.52,28664.75,2461,4,1946,4,'HIGH','LUCIEN',1,1,'GIFFORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU9024',3000,4150,3,1,66248,'M','Programmer/Developer',1500,'NorthEast',1,1500,'No',4,7,26,53.41,19662,8599,1,7805,4,'MEDIUM','JESSE',1,1,'MORELAND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU12515',837,0,3,0,59015,'M','Dentist',1000,'NorthEast',1,837,'No',3,1,23,53.08,22553.75,0,1,45,1,'HIGH','CEDRIC',1,1,'LILES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU14140',259,0,1,0,59948,'M','Nurse',700,'NorthEast',1,259,'No',1,1,36,53.12,27087,101,0,25,2,'HIGH','VERN',1,1,'BARRERA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU1516',0,0,0,0,66523,'M','Sales Representative',900,'West',0,0,'No',1,0,0,53.08,0,760,0,25,1,'LOW','JOESPH',0,1,'POOLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU6927',0,0,0,0,76159,'M','Nurse',1500,'NorthEast',0,0,'No',0,1,34,53.06,23439.75,502,0,25,0,'HIGH','DESHAWN',0,1,'PEREIRA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MN',8237,4,'CU4758',2500,4050,1,0,63778,'M','PROF-14',500,'West',1,750,'No',15,3,46,53.52,30544.5,14589,1,2643,4,'VERY HIGH','DOMINGO',1,1,'TANNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',0,2,'CU13357',0,0,0,0,72725,'M','PROF-24',1300,'Southwest',0,0,'No',1,1,0,53.07,0,517,0,25,1,'LOW','FAUSTINO',0,1,'ALLISON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14304',0,500,3,0,75233,'M','Programmer/Developer',1500,'NorthEast',0,0,'No',16,1,22,52.95,16508.25,0,2,25,2,'MEDIUM','THEODORE',0,0,'GALLEGOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,1,'CU8617',5000,0,1,1,63760,'M','Cashier',800,'NorthEast',2,5000,'No',0,1,46,52.77,34040,0,1,25,2,'VERY HIGH','JESS',2,1,'CURRAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,1,'CU10339',1800,3850,1,0,64128,'F','PROF-23',800,'South',1,650,'No',13,1,44,53.49,28932,4939,4,4918,4,'HIGH','STEPHENIE',1,1,'FOLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MN',3714,1,'CU3799',2430,3950,1,1,59435,'M','DBA',1500,'West',1,700,'No',2,10,33,53.13,21658.75,5424,1,1160,2,'MEDIUM','HOMER',1,1,'KIRKLAND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11886',400,0,3,0,60646,'M','Nurse',1000,'NorthEast',1,400,'No',0,4,22,53.06,22861.5,0,0,25,0,'HIGH','ULYSSES',1,1,'DOUGHERTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,5,'CU3935',1200,1001,5,0,68955,'F','PROF-16',1100,'West',1,1,'No',2,1,44,53.01,24138.75,2948,1,2102,2,'HIGH','DAHLIA',1,1,'KILGORE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU5700',0,720,0,1,65713,'M','Administrative Assistant',800,'NorthEast',0,0,'No',4,0,71,53.58,19528.25,6591,3,925,4,'MEDIUM','SAMMIE',0,1,'DICK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,3,'CU5110',3000,2728,3,1,60352,'M','PROF-65',1300,'Midwest',1,614,'No',4,0,28,53.6,18388,6902,1,5000,4,'MEDIUM','ARLIE',1,1,'LEHMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,2,'CU3646',0,0,0,0,62688,'M','Not specified',1000,'South',0,0,'No',0,3,0,53.06,0,504,1,25,0,'LOW','MCKINLEY',0,1,'GILMORE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,1,'CU14011',7000,0,1,0,79336,'M','Cashier',5000,'NorthEast',1,7000,'No',0,1,45,53.06,32834,0,1,25,0,'VERY HIGH','JAVIER',1,1,'BUCKNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',111088,5,'CU1091',3081,5501,5,1,59819,'F','Administrative Assistant',1700,'NorthEast',1,1201,'No',0,0,65,56.37,18954.75,112822,2,25,6,'MEDIUM','APRYL',1,1,'DODGE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NV',0,3,'CU4843',1200,0,3,1,70435,'M','Not specified',900,'Southwest',1,1200,'No',0,3,29,53.06,21008.75,507,1,25,0,'MEDIUM','CECIL',1,1,'STONE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU15839',0,0,3,0,56929,'M','Professor',1500,'NorthEast',0,0,'No',0,4,22,53.06,11932.25,0,0,25,0,'LOW','HARLAN',0,0,'SILVER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU13956',1400,500,1,0,74323,'M','PROF-1',1500,'NorthEast',1,1400,'No',13,1,28,53.42,29880.75,2591,2,25,4,'HIGH','NEIL',1,1,'CLEMENTS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WI',0,2,'CU4147',0,0,0,0,61649,'M','Waiter/Waitress',900,'Midwest',0,0,'No',0,3,23,53.06,18712.25,506,0,25,0,'MEDIUM','FLETCHER',0,1,'DIETZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','UT',0,1,'CU15889',1000,0,1,0,76984,'M','First-line Manager',2500,'Southwest',1,1000,'No',0,5,36,53.06,31346,0,0,25,0,'VERY HIGH','EVERETTE',1,1,'JENNINGS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OR',0,3,'CU11850',400,650,3,0,59517,'M','Programmer/Developer',1000,'West',1,400,'No',13,2,28,53.28,23179.25,100,2,69,3,'HIGH','EDGAR',1,1,'WHEELER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU15161',250,0,3,0,71233,'M','Programmer/Developer',1000,'West',1,250,'No',0,1,22,53.06,25508.25,0,1,25,0,'HIGH','TYRELL',1,1,'PARHAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU10784',1500,3025,1,1,66675,'M','Cashier',800,'West',1,675,'No',3,1,49,54.32,25068.75,2858,1,2774,5,'HIGH','MIKEL',1,1,'CRANE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,3,'CU1829',2800,5500,3,1,65943,'M','Cashier',1500,'NorthEast',1,2800,'No',1,2,49,53.11,21885.75,966,4,25,2,'MEDIUM','NATHANIEL',1,1,'DONAHUE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU9313',2339,0,1,0,60373,'F','PROF-34',1500,'Midwest',1,2339,'No',0,1,28,53.07,26393.25,508,1,25,1,'HIGH','GENEVA',1,1,'LI')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU13795',1100,850,1,0,67990,'M','Fireman',1000,'NorthEast',1,1100,'No',3,1,28,53.1,28297.5,479,3,458,2,'HIGH','ABRAM',1,1,'ESTRADA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU4985',2600,3500,1,1,63970,'F','Professor',800,'NorthEast',1,1500,'No',2,6,46,54.02,24092.5,2870,2,1436,5,'HIGH','JOANNA',1,1,'BYRNE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU5643',2000,700,6,1,62462,'M','PROF-15',1000,'West',1,2000,'No',2,3,61,53.54,16715.5,5807,4,4556,4,'MEDIUM','WARNER',1,1,'DICKSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','DC',0,3,'CU12982',0,0,3,0,85570,'M','School Teacher',2500,'NorthEast',0,0,'No',4,1,37,54.7,20592.5,704,0,25,5,'MEDIUM','AARON',0,1,'PARROTT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU7187',0,0,0,0,58036,'M','Nurse',1500,'West',0,0,'No',0,1,27,53.06,18209,506,0,25,0,'MEDIUM','MILLARD',0,1,'DICKENS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU2245',3000,0,3,1,59099,'M','Programmer/Developer',900,'NorthEast',1,3000,'No',8,2,25,53.25,17774.75,3241,1,43,3,'MEDIUM','COLUMBUS',1,1,'BROOKS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU4140',0,2053,3,1,61815,'M','PROF-39',700,'Midwest',0,553,'No',2,3,34,53.08,9353.75,2470,3,1955,1,'LOW','LAWRENCE',0,1,'GUNTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU14470',1200,0,1,1,55493,'F','Lab Technician',1500,'Midwest',1,1200,'No',4,1,50,53.61,22373.25,281,1,25,4,'HIGH','DANIKA',1,1,'DOTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU12070',300,500,3,1,64527,'M','PROF-26',1000,'Midwest',1,300,'No',4,4,23,53.07,18931.75,117,2,71,1,'MEDIUM','ELMER',1,1,'VICK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MO',0,2,'CU7079',0,0,0,0,66946,'M','Nurse',500,'Midwest',0,0,'No',0,1,46,53.11,22336.5,505,1,25,2,'HIGH','DARRICK',0,1,'SANDERSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2235',0,0,0,1,63842,'M','PROF-36',1000,'NorthEast',0,0,'No',0,2,25,53.06,14460.5,506,0,25,0,'MEDIUM','WILLIS',0,1,'TIDWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU6469',0,0,0,0,66360,'M','Construction Laborer',900,'West',0,0,'No',2,1,25,53.07,20090,133,0,25,1,'MEDIUM','DESHAWN',0,1,'DOW')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','IL',0,2,'CU6293',0,0,0,0,60570,'M','PROF-20',900,'Midwest',0,0,'No',0,0,34,53.06,19542.5,506,0,25,0,'MEDIUM','FRANCIS',0,1,'BRITTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU7028',2000,3400,5,1,62519,'F','Veterinarian',900,'NorthEast',1,1000,'No',2,1,25,54.09,15629.75,11129,6,10615,5,'MEDIUM','DORTHA',1,1,'OJEDA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU5248',0,0,0,0,64483,'M','IT Staff',900,'West',0,0,'No',0,3,0,53.06,0,509,0,25,0,'LOW','MILES',0,1,'MCKINNON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',4447,1,'CU4143',6750,24700,1,1,59768,'F','Administrator',900,'NorthEast',1,4700,'No',4,1,64,53.52,24842,14333,1,7130,4,'HIGH','RIKKI',1,1,'FOWLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CO',0,4,'CU998',2500,0,3,1,71464,'F','Clerical',1500,'West',1,2500,'No',4,0,49,53.42,23766,2424,0,1427,4,'HIGH','TESSIE',1,1,'COATES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU8169',1600,1400,1,0,74091,'M','Publisher',1500,'NorthEast',1,300,'No',4,1,49,53.09,31922.75,1362,3,882,1,'VERY HIGH','ALVARO',1,1,'ADAMS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,1,'CU4344',5000,0,1,1,70326,'F','DBA',3000,'NorthEast',1,5000,'No',3,3,49,54.07,25981.5,662,5,124,5,'HIGH','OLIVE',1,1,'BEARDEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',1025,3,'CU13503',0,750,3,1,70926,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',4,1,29,53,11131.5,1850,3,127,2,'LOW','EMILE',0,1,'FRANKS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','UT',0,1,'CU15886',1100,250,1,0,57767,'F','Technical Writer',2500,'Southwest',1,1100,'No',4,5,37,52.94,26641.75,0,2,25,2,'HIGH','ELISABETH',1,1,'MERCHANT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WA',0,1,'CU289',2500,2250,1,1,57340,'F','IT Staff',1500,'West',1,750,'No',2,0,0,53.98,0,17441,1,13398,5,'LOW','WINDY',1,1,'CABRERA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11683',0,250,3,0,60150,'M','Programmer/Developer',1500,'NorthEast',0,0,'No',13,4,19,53.17,12437.5,114,2,95,2,'LOW','DANIAL',0,1,'ZIEGLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU6523',1800,2150,3,1,73935,'M','School Teacher',1500,'Midwest',1,350,'No',18,1,47,53.4,23683.75,2098,1,1155,4,'HIGH','MILO',1,1,'PAGE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU5246',800,0,1,1,63304,'M','Veterinarian',600,'West',1,800,'No',1,3,35,46.95,22826,1036,1,25,2,'HIGH','SAM',1,1,'BRANCH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU14806',700,500,3,0,68004,'M','Author',700,'Midwest',1,700,'No',6,1,66,53.23,29101,923,2,25,3,'HIGH','SONNY',1,1,'ARTHUR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU5442',1600,0,2,0,58297,'M','PROF-33',900,'West',1,1600,'No',0,0,33,53.06,24874.25,522,0,25,0,'HIGH','VITO',1,1,'SLADE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MO',0,5,'CU9544',0,700,5,0,74398,'F','Programmer/Developer',1500,'Midwest',0,0,'No',11,1,29,53.24,13999.5,3819,3,25,3,'LOW','KERRIE',0,1,'RIDER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',0,2,'CU12451',0,0,2,0,61262,'M','Nurse',1000,'Southwest',0,0,'No',0,1,29,53.06,15215.5,0,0,25,0,'MEDIUM','CHAS',0,0,'LUCAS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14068',396,0,3,0,70937,'M','PROF-4',1000,'West',1,396,'No',2,1,24,53.04,25634.25,0,0,25,2,'HIGH','DUSTY',1,1,'MITCHELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU2620',1590,1501,1,0,67163,'F','Technical Writer',1500,'Midwest',1,1590,'No',4,2,49,53.08,30190.75,1113,3,181,1,'VERY HIGH','STEPHEN',1,1,'QUEEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,5,'CU10813',1160,696,5,0,59688,'F','First-line Manager',1500,'Midwest',1,1160,'No',14,1,26,53.82,20022,159,3,25,4,'MEDIUM','ELLYN',1,1,'DREW')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU15198',1000,1750,4,1,69813,'F','Waiter/Waitress',900,'West',2,1000,'No',3,1,33,53.34,29753.25,3954,3,2642,3,'HIGH','ASHLIE',2,1,'MCALLISTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',11779,2,'CU2713',5000,14800,0,1,45774,'F','Not specified',3500,'West',1,3600,'No',2,4,44,52.86,21843.5,13495,2,643,2,'MEDIUM','AURELIA',1,1,'BLAND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU1134',3000,3900,1,1,62359,'F','PROF-13',900,'NorthEast',1,1700,'No',2,0,32,53.14,23789.75,5975,1,5456,2,'HIGH','ALLIE',1,1,'PRYOR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU13508',0,0,0,0,61102,'M','Programmer/Developer',700,'NorthEast',0,0,'No',1,1,32,53.07,19475.5,0,0,25,1,'MEDIUM','TRUMAN',0,0,'PRADO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','IL',0,3,'CU6769',500,0,3,0,66090,'M','Fireman',600,'Midwest',1,500,'No',0,1,54,53.06,27422.5,506,0,25,0,'HIGH','WAYNE',1,1,'ACKER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU7416',3680,0,1,0,65412,'F','DBA',1000,'West',1,3680,'No',0,1,47,53.06,29553,0,2,25,0,'HIGH','CARL',1,1,'DARBY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU2604',700,0,3,0,58200,'F','Lab Technician',900,'NorthEast',1,700,'No',3,2,26,53.1,23150,0,0,25,2,'HIGH','MADGE',1,1,'HILLS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU5065',4200,0,5,1,84910,'M','School Teacher',3500,'NorthEast',1,4200,'No',6,0,52,53.49,23927.5,629,1,25,4,'HIGH','MICAH',1,1,'CORBIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','NY',0,4,'CU2313',20000,13000,3,1,66930,'F','IT Staff',900,'NorthEast',1,20000,'No',2,3,46,55.69,22332.5,4375,6,3860,6,'HIGH','MORA',1,1,'PIERCE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU14770',1500,250,1,0,73401,'M','First-line Manager',1500,'NorthEast',1,1500,'No',1,3,25,53.35,29350.25,245,2,25,3,'HIGH','WILMER',1,1,'REAGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OR',0,1,'CU13889',5000,0,1,0,88816,'F','Clerical',3500,'West',1,5000,'No',0,1,43,53.06,35004,0,0,25,0,'VERY HIGH','VINITA',1,1,'WERNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU9437',1458,0,1,1,68105,'M','PROF-13',700,'West',1,1458,'No',0,1,46,53.07,25126.25,0,0,25,1,'HIGH','BARRETT',1,1,'JORDAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','WA',0,2,'CU3433',890,0,0,0,69545,'M','Professor',1000,'West',1,890,'No',0,2,31,53.06,31486.25,506,1,25,0,'VERY HIGH','MARY',1,1,'GARY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,4,'CU1901',4000,3900,6,1,87333,'F','PROF-62',4000,'Midwest',1,4000,'No',12,1,0,53.24,0,989,1,221,3,'LOW','KARINA',1,1,'FLANAGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU4549',5000,0,1,1,56452,'F','PROF-65',3000,'Midwest',1,5000,'No',0,3,42,53.38,21813,506,1,25,3,'MEDIUM','MARTINA',1,1,'PEACHEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NC',0,3,'CU9143',650,0,3,0,59245,'M','Dentist',1000,'South',1,650,'No',0,1,21,53.06,22411.25,0,0,25,0,'HIGH','STEPHEN',1,1,'NUGENT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU14215',0,0,0,0,64916,'M','Sales Representative',600,'NorthEast',0,0,'No',0,1,37,53.04,20929,314,0,25,2,'MEDIUM','SAM',0,1,'BOUCHARD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU13111',0,0,0,0,61935,'M','Construction Laborer',600,'NorthEast',0,0,'No',1,1,47,53.06,21183.75,0,0,25,0,'MEDIUM','ELBERT',0,0,'DOTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU3777',0,0,0,1,66134,'M','Medical Doctor',600,'West',0,0,'No',0,3,57,54.31,18233.5,504,0,25,5,'MEDIUM','JORGE',0,1,'CASSIDY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,2,'CU4410',5000,14455,0,0,60547,'M','Clerical',500,'NorthEast',1,4505,'No',7,3,43,53.18,30436.75,1263,5,458,3,'VERY HIGH','JC',1,1,'KLINE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OR',41148,4,'CU2332',0,4650,0,1,68214,'M','Not specified',900,'West',0,1500,'No',11,2,51,55.5,19153.5,41670,1,25,6,'MEDIUM','LELAND',0,1,'GRIMM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU4877',1000,1250,3,0,60061,'M','Homemaker',900,'Midwest',1,400,'No',9,0,33,53.23,23815.25,1775,3,25,3,'HIGH','MARION',1,1,'PEPPER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU172',2430,1201,4,1,60675,'F','Author',500,'NorthEast',1,2430,'No',1,0,76,53.09,21768.75,683,3,174,1,'MEDIUM','DAN',1,1,'BLAIR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU9897',1000,0,4,0,59079,'M','Dentist',2500,'NorthEast',1,1000,'No',2,1,46,53.21,23369.75,0,1,25,3,'HIGH','BRODERICK',1,1,'CARDONA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','DC',0,2,'CU5458',0,0,0,1,65459,'M','Cashier',600,'NorthEast',0,0,'No',1,0,45,53.06,16864.75,513,0,25,0,'MEDIUM','JAMISON',0,1,'HOOKS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,3,'CU9328',2000,0,3,0,60258,'M','Veterinarian',800,'West',1,2000,'No',1,1,48,53.08,25364.5,1303,1,25,1,'HIGH','LAUREN',1,1,'SNYDER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MN',0,3,'CU8983',3000,0,3,0,61034,'M','Law Enforcement Officer',1000,'West',1,3000,'No',0,1,35,53.06,24258.5,0,1,25,0,'HIGH','LANE',1,1,'RIGGS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,4,'CU1655',700,501,3,0,59188,'M','First-line Manager',700,'South',1,700,'No',1,0,50,53.43,25797,668,2,160,4,'HIGH','CECIL',1,1,'MACDONALD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU13483',0,750,1,0,68442,'F','Programmer/Developer',700,'NorthEast',0,0,'No',14,1,32,53.02,18810.5,161,3,25,2,'MEDIUM','DORETHEA',0,1,'ADAMS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU9863',2500,0,1,1,61884,'F','IT Staff',800,'Midwest',1,2500,'No',0,1,48,53.06,23771,0,1,25,0,'HIGH','NIESHA',1,1,'GIRARD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU4584',0,0,0,1,59724,'M','Administrative Assistant',900,'NorthEast',0,0,'No',0,3,50,53.06,15931,509,1,25,0,'MEDIUM','MICKEY',0,1,'MIMS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU14034',746,450,1,1,61929,'F','Author',600,'NorthEast',1,746,'No',2,10,61,53.01,25082.25,959,2,25,2,'HIGH','MIRANDA',1,1,'HAGEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',7095,3,'CU8512',0,750,3,1,57204,'M','Programmer/Developer',1000,'Midwest',0,0,'No',4,9,25,53.11,7301,7226,3,112,2,'LOW','SCOTTY',0,1,'HUYNH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU13369',0,0,0,0,61123,'M','Administrative Assistant',1500,'Midwest',0,0,'No',0,1,19,53.06,18180.75,0,0,25,0,'MEDIUM','CALEB',0,0,'GREEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,1,'CU3715',1216,0,1,1,59982,'M','Cashier',500,'NorthEast',1,1216,'No',0,3,31,53.06,21595.5,509,2,25,0,'MEDIUM','MALCOLM',1,1,'WEIR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU10361',350,0,0,0,58896,'M','Nurse',800,'West',1,350,'No',12,1,41,53.07,29824,0,0,37,1,'HIGH','HONG',1,1,'PURCELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU4118',4000,0,1,1,58375,'F','PROF-35',1300,'NorthEast',1,4000,'No',1,3,50,53.08,23093.75,702,1,191,1,'HIGH','SUNDAY',1,1,'WALKER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU12921',0,0,3,0,70799,'M','Programmer/Developer',1000,'West',0,0,'No',2,1,21,53.07,15299.75,0,1,25,1,'MEDIUM','OSVALDO',0,0,'UNGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU9729',4000,0,5,0,68358,'M','Technical Writer',1000,'NorthEast',1,4000,'No',0,1,55,53.06,25089.5,0,0,25,0,'HIGH','ROGER',1,1,'PRYOR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU2206',0,0,0,0,68924,'M','Not specified',900,'Midwest',0,0,'No',0,2,42,53.34,22931,506,0,25,3,'HIGH','DANILO',0,1,'TOWNSEND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU15635',2500,2100,1,0,58942,'F','Author',1500,'Midwest',1,700,'No',2,4,67,54.46,29935.5,23180,1,23122,5,'HIGH','REBECA',1,1,'BRADFORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU15148',759,700,4,0,61997,'M','Veterinarian',600,'West',1,759,'No',6,4,59,53.22,25399.25,681,3,672,3,'HIGH','BEAU',1,1,'DARBY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MO',0,5,'CU15175',1400,501,5,1,61197,'F','Cashier',1500,'Midwest',1,1400,'No',11,1,40,53.07,16799.25,243,2,228,1,'MEDIUM','CARLEY',1,1,'BUCHANAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2055',255,0,0,1,68011,'M','Sales Representative',900,'NorthEast',1,255,'No',10,2,29,53.38,25902.75,6692,0,6178,3,'HIGH','OTTO',1,1,'SULLIVAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,1,'CU1720',5000,9200,1,1,59255,'M','Author',900,'NorthEast',1,5000,'No',9,2,72,53.83,25513.75,2006,4,25,4,'HIGH','ALVARO',1,1,'WILEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','CA',0,2,'CU2788',15000,0,0,1,60508,'M','IT Staff',500,'West',2,15000,'No',5,2,56,53.16,36727,629,2,25,2,'VERY HIGH','VAUGHN',2,1,'MCKINNEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU14938',1900,0,1,0,63799,'F','Technical Writer',1000,'NorthEast',1,1900,'No',0,1,26,53.06,27049.75,0,1,25,0,'HIGH','FE',1,1,'CHANCE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU12859',350,0,3,0,60647,'M','Fireman',1000,'NorthEast',1,350,'No',0,1,19,53.06,22561.75,0,0,25,0,'HIGH','REX',1,1,'BURGOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU13885',369,0,3,0,65326,'M','Nurse',700,'Midwest',1,369,'No',0,1,32,53.05,25031.5,0,0,25,2,'HIGH','RORY',1,1,'STOUT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU15133',1050,0,1,1,62694,'M','Dentist',1000,'NorthEast',1,1050,'No',7,4,36,53.13,22773.5,663,0,651,2,'HIGH','DEWITT',1,1,'ROBLES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU7666',0,0,0,0,68528,'M','PROF-28',1500,'West',0,0,'No',2,1,22,53.07,20332,0,0,25,1,'MEDIUM','GARRET',0,0,'STANLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU8286',0,0,0,0,67941,'M','Construction Laborer',600,'Midwest',0,0,'No',0,1,48,53.06,22785.25,0,0,25,0,'HIGH','DONNY',0,0,'THOMSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU3751',4000,12000,3,1,73217,'F','Not specified',1200,'West',1,2000,'No',5,3,46,55.09,23904.25,10995,9,10426,5,'HIGH','BRIANA',1,1,'DEWITT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU2005',700,1600,3,1,62948,'M','Dentist',1500,'NorthEast',1,400,'No',18,2,44,53.13,20637,6032,6,4992,2,'MEDIUM','KIETH',1,1,'CHANEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU11347',1000,500,3,1,67752,'M','Sales Representative',1000,'NorthEast',1,1000,'No',2,1,42,53.34,21638,2576,2,25,3,'MEDIUM','TROY',1,1,'RUFF')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,2,'CU2804',0,0,0,0,58370,'M','PROF-11',900,'West',0,0,'No',4,2,43,53.07,19892.5,515,0,25,1,'MEDIUM','RONALD',0,1,'LAIRD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU13492',1910,1250,1,0,61329,'F','PROF-7',1000,'Midwest',1,1910,'No',12,1,33,53.1,27132.25,365,3,349,2,'HIGH','SAMATHA',1,1,'JACOBS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU7970',4348,0,1,0,68131,'F','Publisher',3500,'Midwest',1,4348,'No',0,1,42,53.06,29732.75,0,1,25,0,'HIGH','JANNET',1,1,'LEDBETTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NV',0,3,'CU5854',1500,1621,3,0,69743,'M','Software Engineer',1500,'Southwest',1,371,'No',2,0,26,54.44,25535.75,3883,3,3375,5,'HIGH','FRANK',1,1,'MAGEE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU12168',375,500,3,0,57992,'M','Professor',1000,'West',1,375,'No',4,4,19,53.58,21898,297,2,25,4,'MEDIUM','DESMOND',1,1,'FERRELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU12517',800,450,3,1,58366,'M','Fireman',1000,'NorthEast',1,800,'No',14,1,29,53.33,18491.5,633,2,620,3,'MEDIUM','JERMAINE',1,1,'ZAPATA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','UT',0,3,'CU15599',0,750,3,1,70112,'M','Programmer/Developer',1500,'Southwest',0,0,'No',5,3,25,53.08,10528,793,3,283,1,'LOW','CARMINE',0,1,'HINDS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',16579,3,'CU14537',600,450,3,1,69908,'M','Programmer/Developer',1000,'Midwest',1,600,'No',3,1,24,53.24,20377,16861,2,74,3,'MEDIUM','JEFF',1,1,'KIMBLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU10566',0,0,0,1,69578,'M','Nurse',1500,'NorthEast',0,0,'No',0,1,22,53.06,15594.5,0,0,25,0,'MEDIUM','STEVE',0,0,'UNGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU4321',1500,0,1,0,73697,'F','Lab Technician',1500,'West',1,1500,'No',0,3,43,53.06,31224.25,507,1,25,0,'VERY HIGH','WILLETTE',1,1,'IRWIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,1,'CU15471',400,0,1,0,62911,'M','PROF-5',600,'West',1,400,'No',0,4,36,53.07,27827.75,0,0,25,1,'HIGH','WINSTON',1,1,'CORDOVA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU2669',1050,700,3,1,70046,'M','PROF-26',1000,'NorthEast',1,1050,'No',14,2,24,53.01,20411.5,687,3,176,2,'MEDIUM','CHI',1,1,'FRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU15671',1000,3000,4,1,62530,'M','Clerical',1000,'NorthEast',1,1000,'No',2,4,42,53.83,18832.5,4095,1,4080,4,'MEDIUM','MIQUEL',1,1,'FUGATE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,1,'CU3918',0,0,1,0,63281,'M','Waiter/Waitress',500,'West',0,0,'No',0,3,34,53.06,17720.25,506,0,25,0,'MEDIUM','MATHEW',0,1,'DENT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU4215',0,0,0,0,67356,'M','Administrative Assistant',700,'NorthEast',0,0,'No',1,3,50,53.07,22839,508,0,25,1,'HIGH','BRADY',0,1,'WASHINGTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU2108',3000,2400,1,1,64766,'F','PROF-35',500,'NorthEast',1,500,'No',6,4,30,53.83,22691.5,878,1,188,4,'HIGH','LISBETH',1,1,'HOLT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','UT',0,1,'CU15800',1406,500,1,0,54879,'M','Programmer/Developer',2500,'Southwest',1,1406,'No',4,5,26,52.97,24819.75,184,2,25,2,'HIGH','GRANT',1,1,'SWAIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU5662',4500,4726,1,1,65305,'F','Clerical',900,'Midwest',2,501,'No',17,3,56,54.07,35426.25,2293,3,1097,5,'VERY HIGH','VIRGINIA',2,1,'ODOM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU4884',0,0,0,0,58991,'M','Truck Driver',700,'NorthEast',0,0,'No',0,3,47,53.06,20447.75,502,1,25,0,'MEDIUM','JARRED',0,1,'DOWLING')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',14392,1,'CU3526',4000,4200,1,0,65364,'F','Homemaker',900,'NorthEast',1,1600,'No',16,1,51,53.38,29941,15773,6,25,3,'HIGH','BENNIE',1,1,'NIELSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU391',6000,9800,1,0,61774,'F','Truck Driver',900,'NorthEast',1,2000,'No',8,0,38,55.99,27743.5,2019,4,287,6,'HIGH','AMAL',1,1,'MINOR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU15853',0,500,3,0,56552,'M','Programmer/Developer',1500,'West',0,0,'No',6,4,19,53.03,11538,1114,2,723,2,'LOW','ELIJAH',0,1,'OUELLETTE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU497',1000,1600,1,0,63021,'F','PROF-46',800,'West',1,300,'No',5,0,70,53.96,31255.25,793,3,230,5,'VERY HIGH','DALE',1,1,'FARR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','UT',0,2,'CU1815',0,0,0,0,68755,'M','Nurse',1500,'Southwest',0,0,'No',0,2,0,53.06,0,510,0,25,0,'LOW','NEIL',0,1,'LOGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU13980',8000,3650,1,1,83263,'F','IT Staff',5000,'Midwest',1,1000,'No',9,1,31,53.23,27415.75,809,1,25,3,'HIGH','ETHELYN',1,1,'WHITMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','IL',0,2,'CU3969',2900,0,0,1,68668,'M','Veterinarian',1700,'Midwest',1,2900,'No',1,3,40,49.86,27167,521,1,25,2,'HIGH','TRINIDAD',1,1,'GAGE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',0,4,'CU15927',2350,0,4,0,80551,'F','Construction Laborer',2500,'Southwest',1,2350,'No',9,5,33,53.2,27437.75,0,0,25,3,'HIGH','ARLA',1,1,'COREY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',76470,4,'CU3167',3500,10525,1,1,57501,'F','Cashier',1300,'NorthEast',1,2275,'No',1,3,54,56.85,24775.25,98684,4,21069,6,'HIGH','KELI',1,1,'PETERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU9766',4850,0,1,0,69518,'M','Not specified',800,'Midwest',1,4850,'No',0,1,44,53.06,30279.5,0,1,25,0,'VERY HIGH','WES',1,1,'MEJIA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,2,'CU7040',781,0,0,0,62088,'M','Nurse',900,'South',1,781,'No',0,1,42,53.06,30722,504,0,25,0,'VERY HIGH','ISAIAS',1,1,'GILMORE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WI',0,3,'CU14975',300,0,3,0,62427,'M','PROF-11',600,'Midwest',1,300,'No',0,1,35,53.06,24606.75,0,0,25,0,'HIGH','CHRISTOPER',1,1,'BAEZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14235',0,0,3,1,59296,'M','Fireman',600,'West',0,0,'No',13,1,31,53.48,8424,4682,0,4672,4,'LOW','MERRILL',0,1,'MALONEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','IL',0,1,'CU9217',4200,0,1,1,71191,'F','IT Staff',3500,'Midwest',1,4200,'No',0,1,54,53.06,26697.75,0,1,25,0,'HIGH','MARIANELA',1,1,'EWING')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU12528',1750,1200,1,0,62763,'F','Construction Laborer',1000,'NorthEast',1,350,'No',4,2,38,53.21,27990.75,301,3,294,3,'HIGH','AKILAH',1,1,'KOENIG')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NC',0,1,'CU14308',810,0,1,0,62349,'M','PROF-23',1500,'South',1,810,'No',3,1,26,53.05,26687.25,1423,1,1364,2,'HIGH','ALVA',1,1,'NORMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2533',0,0,0,0,60037,'M','Sales Representative',1000,'NorthEast',0,0,'No',0,2,0,53.06,0,504,0,25,0,'LOW','AUGUSTUS',0,1,'MOSELEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,2,'CU2798',2500,4525,2,0,75513,'F','Fireman',1500,'Midwest',1,975,'No',15,2,41,53.15,29978.25,5815,4,5306,2,'HIGH','PING',1,1,'HARRIS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MS',0,1,'CU14941',2500,0,1,0,66175,'F','IT Staff',1000,'South',1,2500,'No',0,1,29,53.06,27943.75,0,1,25,0,'HIGH','SALLEY',1,1,'STAMPER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',1241,3,'CU5704',3367,3250,3,1,69340,'M','Publisher',900,'Midwest',2,450,'No',4,0,26,53.13,30435,2293,1,959,2,'VERY HIGH','LEONARDO',2,1,'CALVERT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU6691',3000,4500,1,0,63103,'F','Publisher',1200,'Midwest',1,900,'No',2,10,49,53.44,29175.75,4619,2,25,4,'HIGH','MAIA',1,1,'SOSA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU11574',885,450,1,0,61491,'M','Fireman',700,'NorthEast',1,885,'No',2,1,42,53.25,28072.75,141,2,131,3,'HIGH','JERALD',1,1,'MELVIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2129',0,6680,0,0,63785,'M','Author',900,'NorthEast',0,1430,'No',1,2,61,53.08,23046.25,1293,4,786,1,'HIGH','HENRY',0,1,'MCGHEE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU7846',1000,0,1,1,64353,'F','IT Staff',1500,'NorthEast',1,1000,'No',0,1,24,53.06,21988.25,0,1,25,0,'MEDIUM','MARYLOU',1,1,'WEIR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',49216,2,'CU1840',0,0,0,1,68128,'M','Author',1500,'NorthEast',0,0,'No',12,2,66,55.45,19632,49721,1,25,5,'MEDIUM','MORGAN',0,1,'BRASWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','IL',0,3,'CU15559',437,0,3,0,64053,'M','PROF-41',1000,'Midwest',1,437,'No',0,4,28,53.06,24313.25,0,0,25,0,'HIGH','CLAUDIO',1,1,'VARGAS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NV',0,3,'CU14733',1500,2500,3,0,57045,'M','Not specified',1500,'Southwest',1,1500,'No',14,1,27,53.94,22461.25,6840,1,3811,4,'HIGH','LAWRENCE',1,1,'CAMERON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU4598',800,0,1,0,60388,'M','PROF-47',1200,'West',1,800,'No',0,3,43,54,27897,506,1,25,5,'HIGH','BENNETT',1,1,'MYERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,5,'CU11006',2500,2000,5,0,62334,'F','Construction Laborer',1500,'Midwest',1,2500,'No',16,1,33,53.38,21383.5,1791,1,1774,3,'MEDIUM','MAYRA',1,1,'PLUMMER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU845',1500,1500,1,1,66764,'F','Waiter/Waitress',500,'NorthEast',1,1500,'No',3,0,37,53.57,23891,14141,3,13545,4,'HIGH','GIGI',1,1,'BEAULIEU')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU7296',2000,1700,1,1,83961,'F','PROF-25',2300,'Midwest',1,500,'No',4,1,63,53.4,30790.25,1068,3,25,4,'VERY HIGH','MECHELLE',1,1,'WHITLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU6476',700,0,5,1,67710,'F','PROF-44',1000,'NorthEast',1,700,'No',0,1,21,54.19,16527.5,0,1,25,5,'MEDIUM','LANELLE',1,1,'HENRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NM',0,1,'CU11917',0,0,1,1,59013,'M','Programmer/Developer',700,'Southwest',0,0,'No',0,4,32,53.13,11453.25,0,1,25,2,'LOW','QUINTIN',0,0,'MCMAHAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14334',0,0,3,0,70489,'M','Programmer/Developer',1500,'West',0,0,'No',0,1,24,53.06,15522.25,0,0,25,0,'MEDIUM','RONALD',0,0,'BLACKWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU7472',7000,0,1,0,46360,'F','IT Staff',3500,'NorthEast',1,7000,'No',0,1,40,53.06,26090,0,1,25,0,'HIGH','CRYSTAL',1,1,'RANDLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,3,'CU13028',700,450,3,0,68753,'M','PROF-40',1000,'NorthEast',1,700,'No',13,3,26,53.41,25288.25,3648,2,3181,4,'HIGH','BENEDICT',1,1,'OCONNOR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',0,5,'CU1547',2200,1445,5,1,70853,'F','Childcare Worker',900,'Southwest',1,700,'No',2,0,30,53.26,18213.25,1328,2,25,3,'MEDIUM','FAYE',1,1,'KRUSE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU1722',1200,750,1,0,62155,'F','Waiter/Waitress',500,'West',1,1200,'No',1,2,63,53.07,30338.75,502,3,25,1,'VERY HIGH','SABINE',1,1,'PENA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MS',0,1,'CU129',1500,0,1,0,63107,'M','PROF-8',900,'South',2,1500,'No',1,0,30,53.08,37276.75,713,1,25,1,'VERY HIGH','GREG',2,1,'LEMON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',0,1,'CU15240',2500,0,1,0,73116,'M','Software Engineer',2500,'Southwest',1,2500,'No',0,5,41,53.06,30879,0,0,25,0,'VERY HIGH','CHANCE',1,1,'DUNCAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','IL',0,1,'CU13184',3737,2950,1,1,66473,'M','Cashier',2000,'Midwest',1,550,'No',4,1,42,53.45,24318.25,1364,1,25,4,'HIGH','ELDRIDGE',1,1,'BOLTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MS',0,2,'CU3113',0,0,0,1,64138,'M','IT Staff',500,'South',0,0,'No',1,2,38,53.08,15834.5,602,1,25,1,'MEDIUM','HUMBERTO',0,1,'CORBIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU11108',1800,500,1,1,58981,'M','Technical Writer',1000,'NorthEast',1,1800,'No',3,1,26,53.57,20845.25,329,2,302,4,'MEDIUM','FRANCIS',1,1,'ROSEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU5201',0,0,0,0,61980,'M','PROF-23',600,'NorthEast',0,0,'No',1,3,44,53.08,20895,503,0,25,1,'MEDIUM','MARCO',0,1,'BLANCO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14670',350,0,3,0,69983,'M','Sales Representative',1500,'NorthEast',1,350,'No',2,1,21,53.07,25095.75,0,0,25,1,'HIGH','BOYD',1,1,'HARTMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,1,'CU10375',485,0,1,1,62791,'M','Nurse',800,'NorthEast',1,485,'No',5,1,77,55.81,26897.75,55548,0,25,6,'HIGH','LYLE',1,1,'METZGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU13664',10000,301,3,0,37572,'F','PROF-65',5000,'NorthEast',1,300,'No',0,1,46,68.2,19993,0,2,25,7,'MEDIUM','ASHLEY',1,1,'LOZANO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU7426',1500,0,3,0,71821,'M','PROF-13',1000,'NorthEast',1,1500,'No',0,1,39,53.06,27355.25,0,0,25,0,'HIGH','LESLEY',1,1,'BRANCH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,2,'CU8916',4000,0,2,1,64367,'M','Nurse',1000,'NorthEast',1,4000,'No',1,1,42,53.07,22291.75,0,0,25,1,'HIGH','FRANCIS',1,1,'GAGNE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,4,'CU14750',2184,1700,6,1,67163,'M','Author',1500,'Midwest',1,2184,'No',15,1,48,54.17,16590.75,829,3,25,5,'MEDIUM','ANTONIO',1,1,'AUSTIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','IL',0,3,'CU7922',0,550,3,0,60550,'M','Programmer/Developer',1000,'Midwest',0,0,'No',16,2,29,53.01,13537.5,109,2,99,2,'LOW','DONNELL',0,1,'HANCOCK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU11324',731,500,3,0,81832,'M','PROF-43',2500,'NorthEast',1,731,'No',2,1,42,53.39,30158,262,2,253,4,'VERY HIGH','GILBERT',1,1,'LIU')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU7481',0,250,3,0,58079,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',14,1,23,53.4,12319.75,8082,2,7544,4,'LOW','ERIN',0,1,'BLACKMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14507',0,0,3,1,71886,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',6,1,24,53.09,10871.5,370,1,362,1,'LOW','STEVEN',0,1,'CRAVEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU1704',2500,4000,1,1,70982,'F','IT Staff',1500,'Midwest',1,600,'No',4,3,57,53.55,26945.5,917,1,276,4,'HIGH','ILLA',1,1,'MCCORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU8915',0,0,0,0,70401,'M','PROF-5',1000,'NorthEast',0,0,'No',0,1,22,53.06,20800.25,0,0,25,0,'MEDIUM','JEROMY',0,0,'HINDS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU15828',0,0,0,0,66119,'M','Medical Doctor',1500,'Midwest',0,0,'No',0,4,0,53.06,0,505,0,25,0,'LOW','ALBERTO',0,1,'MATLOCK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU135',3000,0,1,1,60195,'F','IT Staff',1300,'NorthEast',1,3000,'No',4,0,38,53.22,22348.75,748,1,236,3,'HIGH','ROSAMOND',1,1,'HOGUE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,5,'CU876',2500,2550,5,1,55726,'F','Author',1300,'West',2,750,'No',2,0,55,53.52,26931.5,10426,1,9195,4,'HIGH','BERNEICE',2,1,'CURRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,4,'CU3852',1200,0,0,1,70347,'M','Veterinarian',1000,'NorthEast',2,1200,'No',0,3,28,53.06,37386.75,502,0,25,0,'VERY HIGH','MERVIN',2,1,'BAUM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','IL',0,2,'CU72',7000,26300,2,1,63581,'F','School Teacher',800,'Midwest',1,4300,'No',16,0,67,53.83,24595.25,7794,5,6028,4,'HIGH','KENNA',1,1,'JARRETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU10011',7250,6500,1,0,92802,'F','PROF-16',4000,'Midwest',1,7250,'No',3,1,39,53.8,35600.5,1672,6,168,4,'VERY HIGH','MOZELLA',1,1,'CAREY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU13908',0,0,0,0,65940,'M','Construction Laborer',600,'West',0,0,'No',6,1,44,53.08,21885,301,0,25,1,'MEDIUM','EDWARDO',0,1,'DEMPSEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU7244',0,0,0,0,56255,'M','Nurse',1500,'West',0,0,'No',0,1,23,53.06,17363.75,507,0,25,0,'MEDIUM','MARLIN',0,1,'HIGHTOWER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU2943',0,1956,0,1,59348,'M','Bank Teller',700,'NorthEast',0,506,'No',10,2,51,53.48,15937,2648,1,1984,4,'MEDIUM','LOWELL',0,1,'BLANCO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU9663',400,0,3,1,61616,'M','Nurse',1000,'West',1,400,'No',2,1,23,53.09,18204,0,0,25,1,'MEDIUM','ORVILLE',1,1,'ISAAC')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU13887',883,0,1,1,59067,'F','Dentist',1000,'NorthEast',2,883,'No',1,1,30,53.05,31266.75,0,1,25,2,'VERY HIGH','DARLINE',2,1,'HUDSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU12409',0,600,3,0,57282,'M','Programmer/Developer',1000,'West',0,0,'No',3,1,21,53.26,11920.5,655,2,25,3,'LOW','BRICE',0,1,'DUNCAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU5795',0,0,0,1,69639,'M','PROF-48',900,'Midwest',0,0,'No',0,0,79,53.06,21309.75,506,0,25,0,'MEDIUM','BILLY',0,1,'BROWNE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU10855',2500,0,3,1,70978,'M','Lab Technician',1000,'NorthEast',1,2500,'No',17,1,26,53.05,20844.5,745,1,270,2,'MEDIUM','NELSON',1,1,'CORONA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU14560',2000,2300,1,1,61126,'M','IT Staff',1000,'NorthEast',1,400,'No',2,1,51,53.37,23881.5,944,1,154,3,'HIGH','COLTON',1,1,'DUNN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU6556',1000,0,3,0,68006,'M','Software Engineer',700,'West',1,1000,'No',1,1,45,53.16,27001.5,2324,0,1786,2,'HIGH','DOMINICK',1,1,'DIAMOND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU1065',0,0,0,0,68468,'M','Author',1400,'Midwest',0,0,'No',0,0,0,53.06,0,504,0,25,0,'LOW','ULYSSES',0,1,'MAYNARD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','UT',0,3,'CU15231',0,0,3,0,64993,'M','PROF-5',900,'Southwest',0,0,'No',14,5,0,53.24,0,3138,0,3131,3,'LOW','JACKIE',0,1,'HEATH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU6993',0,0,0,0,82343,'M','Nurse',2500,'Midwest',0,0,'No',1,1,68,53.1,28385.75,590,0,85,2,'HIGH','RUBEN',0,1,'STAHL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU259',700,500,3,0,64971,'M','Construction Laborer',1000,'West',1,700,'No',14,0,30,53.65,24742.75,793,2,236,4,'HIGH','ORLANDO',1,1,'GILL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',0,1,'CU27',0,0,1,1,65390,'M','Homemaker',600,'Southwest',0,0,'No',0,0,39,53.06,13747.5,506,1,25,0,'LOW','HAL',0,1,'DEVINE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','FL',0,1,'CU12567',2300,0,1,0,69980,'M','Truck Driver',1000,'South',1,2300,'No',0,1,25,53.06,28495,0,1,25,0,'HIGH','SIMON',1,1,'HOLLOWAY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU10707',1000,500,1,0,63993,'F','PROF-5',1000,'West',1,1000,'No',3,1,35,53.62,27998.25,238,2,216,4,'HIGH','TREENA',1,1,'MERRITT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','OR',5495,2,'CU5262',3000,10150,0,0,65506,'M','Not specified',500,'West',1,2100,'No',6,3,36,55.06,30976.5,10846,3,2442,5,'VERY HIGH','JOHNNIE',1,1,'KOHLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14153',450,0,3,0,64183,'M','Construction Laborer',600,'NorthEast',1,450,'No',0,1,32,53.05,24745.75,0,0,25,2,'HIGH','WALLACE',1,1,'MCMILLAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,2,'CU4663',2200,3858,2,1,64902,'F','Cashier',1600,'NorthEast',1,858,'No',9,3,49,53.22,23125.5,5859,2,5186,3,'HIGH','BRITTANIE',1,1,'COLVIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','UT',0,4,'CU7200',0,0,6,0,66318,'M','First-line Manager',500,'Southwest',0,0,'No',2,1,79,53.07,14479.5,713,0,25,1,'MEDIUM','MARCUS',0,1,'BOWIE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU10410',380,0,3,0,64415,'M','Nurse',1000,'NorthEast',1,380,'No',0,1,24,53.06,24003.75,0,0,25,0,'HIGH','AUGUSTINE',1,1,'KNIGHT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','DC',0,2,'CU339',0,17001,0,1,62477,'M','Nurse',1000,'NorthEast',0,0,'No',14,0,48,54.98,16419.25,21264,5,25,5,'MEDIUM','JAIME',0,1,'HOOD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU13739',310,0,3,0,58128,'M','Construction Laborer',1000,'Midwest',2,310,'No',0,1,30,53.06,33032,0,0,25,0,'VERY HIGH','WILLIE',2,1,'BROCK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,2,'CU6291',2000,2850,3,0,59755,'F','Medical Doctor',1300,'West',2,700,'No',16,0,45,54.61,34438.75,16743,1,16224,5,'VERY HIGH','LUE',2,1,'GILCHRIST')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,2,'CU14851',0,0,0,0,61162,'M','School Teacher',600,'West',0,0,'No',0,1,37,53.06,19990.5,0,0,25,0,'MEDIUM','ROSARIO',0,0,'CLINE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU3323',5000,0,1,0,73571,'M','Clerical',3500,'NorthEast',1,5000,'No',0,2,47,53.06,31592.75,506,1,25,0,'VERY HIGH','EDGARDO',1,1,'VILLALOBOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU9347',773,501,1,0,69457,'F','Author',800,'West',1,773,'No',1,1,72,53.46,33064.25,8946,2,25,4,'VERY HIGH','TAYNA',1,1,'HENLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,2,'CU3376',3500,0,1,1,63840,'F','Plumber',900,'Midwest',1,3500,'No',2,2,40,53.09,23960,578,1,59,1,'HIGH','PHYLLIS',1,1,'DAWKINS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','IL',0,5,'CU9374',4500,6300,5,1,68785,'M','Publisher',1500,'Midwest',1,1500,'No',3,8,30,52.88,17696.25,743,4,25,2,'MEDIUM','MARCOS',1,1,'JAMISON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,1,'CU7767',6600,0,1,1,76739,'F','Software Engineer',5000,'West',1,6600,'No',1,1,59,52.69,28584.75,0,1,25,2,'HIGH','LETTIE',1,1,'BECERRA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MN',0,2,'CU2769',1454,0,0,1,65101,'M','Fireman',900,'West',1,1454,'No',1,2,45,53.22,26775.25,619,1,25,3,'HIGH','LEOPOLDO',1,1,'MCKAY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU8536',0,0,0,1,69267,'M','Plumber',800,'Midwest',0,0,'No',0,1,53,53.06,18616.75,507,1,25,0,'MEDIUM','DARRYL',0,1,'PALMER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MN',0,4,'CU12702',2700,0,4,0,76169,'F','PROF-39',1500,'West',1,2700,'No',0,1,46,53.1,27642.25,0,1,25,2,'HIGH','MARCELINE',1,1,'BROUSSARD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WI',0,3,'CU11325',250,250,3,0,54882,'M','Programmer/Developer',1500,'Midwest',1,250,'No',1,1,27,53.08,21920.5,0,2,25,1,'MEDIUM','EVERETT',1,1,'WALSH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,1,'CU1653',7000,9850,1,1,75250,'F','IT Staff',5000,'West',2,1500,'No',18,0,70,53.57,39312.5,1075,4,25,4,'VERY HIGH','KRISTAN',2,1,'COREY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',44258,3,'CU15780',0,1900,3,1,58279,'M','Programmer/Developer',1500,'West',0,0,'No',4,5,28,53.65,7869.75,44737,1,25,4,'LOW','DONNELL',0,1,'CARVER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU2799',3600,0,1,1,64759,'F','IT Staff',500,'Midwest',1,3600,'No',2,2,46,53.04,24289.75,506,1,25,2,'HIGH','EDDIE',1,1,'CASTANEDA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',356,1,'CU6859',3900,11635,1,1,71933,'F','IT Staff',1000,'Midwest',1,3535,'No',12,1,53,53.27,26783.25,4131,2,3161,3,'HIGH','JANETH',1,1,'HOSKINS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU3537',2654,1350,1,1,61958,'M','PROF-3',900,'West',1,350,'No',3,6,48,53.18,23789.5,1543,3,25,3,'HIGH','LAWRENCE',1,1,'BOGGS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',36843,4,'CU5726',5000,25000,3,1,60912,'F','Waiter/Waitress',500,'West',2,5000,'No',3,3,56,55.35,31828,54082,3,5394,5,'VERY HIGH','HWA',2,1,'DYSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,2,'CU3892',3000,0,0,1,58676,'M','PROF-47',1000,'NorthEast',1,3000,'No',0,3,45,53.06,25169,507,0,25,0,'HIGH','JAMAAL',1,1,'ROBERSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU7791',3000,0,1,1,72144,'M','Lab Technician',1500,'West',1,3000,'No',6,1,31,53.96,24636,607,1,25,5,'HIGH','MORTON',1,1,'POPE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU73',1500,1600,3,1,66857,'F','PROF-63',1300,'NorthEast',1,300,'No',5,0,0,53.66,0,2022,2,1070,4,'LOW','DAVINA',1,1,'VOGEL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU8218',1000,0,3,1,65304,'M','Sales Representative',1000,'NorthEast',1,1000,'No',0,1,30,53.05,19826,0,1,25,2,'MEDIUM','LEN',1,1,'GRIFFITH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','CA',0,4,'CU5460',45000,0,1,1,101688,'F','Law Enforcement Officer',5000,'West',1,45000,'No',1,0,34,53.08,33822,547,1,25,1,'VERY HIGH','DAYLE',1,1,'WEATHERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU8921',1000,800,4,1,63826,'F','Veterinarian',700,'NorthEast',1,1000,'No',3,1,48,53.33,19756.5,0,3,25,3,'MEDIUM','KATHY',1,1,'SHERIDAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU10655',700,250,3,1,67863,'M','PROF-3',1000,'NorthEast',1,700,'No',2,1,25,53.29,19965.75,245,2,25,3,'MEDIUM','LOGAN',1,1,'CHILDS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14743',0,0,3,0,59720,'M','PROF-30',1000,'West',0,0,'No',1,1,22,53.06,12630,0,0,25,0,'LOW','DEWEY',0,0,'CONNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU15069',2000,0,3,0,68137,'M','PROF-42',1500,'NorthEast',1,2000,'No',1,1,36,53.08,26134.25,0,0,25,1,'HIGH','GARY',1,1,'GATES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',44039,2,'CU9515',0,0,0,1,61870,'M','Nurse',900,'NorthEast',0,0,'No',0,1,32,55.4,14667.5,44544,0,25,5,'MEDIUM','DANA',0,1,'PADGETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU2',0,0,0,0,64928,'M','Administrative Assistant',500,'Midwest',0,0,'No',0,0,32,53.04,20432,542,0,25,2,'MEDIUM','MILLARD',0,1,'BENSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU8064',5100,4900,1,1,46057,'F','Not specified',3500,'NorthEast',1,1000,'No',4,3,31,53.48,18114.25,677,1,25,4,'MEDIUM','TEMEKA',1,1,'MCMILLIAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,4,'CU7394',1500,950,1,0,63009,'F','PROF-29',1000,'Midwest',1,250,'No',2,1,35,53.16,29252.25,2206,3,25,2,'HIGH','JENEE',1,1,'MCCLELLAND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','NV',812,4,'CU6250',15000,26600,3,1,98263,'F','Clerical',4000,'Southwest',2,5000,'No',12,0,44,54.04,39965.75,7866,2,25,5,'VERY HIGH','RENATA',2,1,'WELCH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU4176',10000,17750,1,1,48718,'M','Clerical',4000,'NorthEast',2,3200,'No',4,8,40,54.04,29679.5,11922,5,8135,5,'HIGH','MAN',2,1,'MUNIZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',29714,1,'CU3095',8000,17700,1,1,59870,'F','Administrator',500,'NorthEast',1,4500,'No',3,2,49,54.44,23367.5,31444,2,25,5,'HIGH','KITTY',1,1,'CROW')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU12821',827,0,3,0,65758,'M','PROF-4',700,'West',1,827,'No',3,9,34,54.26,25339.5,0,0,25,5,'HIGH','WILLY',1,1,'CASH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','UT',0,1,'CU7070',5000,0,1,1,62517,'M','Software Engineer',900,'Southwest',1,5000,'No',1,1,57,53.08,24829.25,377,1,25,1,'HIGH','VAN',1,1,'WARREN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU2611',1000,750,3,1,62236,'M','School Teacher',500,'NorthEast',1,1000,'No',9,3,32,53.51,19259,657,3,133,4,'MEDIUM','EDWIN',1,1,'SALGADO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NV',0,1,'CU4309',2000,0,1,1,62719,'F','IT Staff',500,'Southwest',1,2000,'No',3,3,35,53.75,22679.75,528,0,25,4,'HIGH','PEGGIE',1,1,'BLAKE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU9839',700,900,6,0,66180,'M','PROF-5',800,'West',1,700,'No',1,1,54,53.69,21945,4694,3,4687,4,'MEDIUM','LANE',1,1,'TRIPP')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU13678',750,500,1,1,60188,'M','Plumber',600,'Midwest',1,750,'No',15,1,48,53.35,23347,895,2,884,3,'HIGH','SAM',1,1,'KEYS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU15455',500,500,3,1,66877,'M','Truck Driver',600,'Midwest',2,500,'No',6,4,33,53.11,30519.25,158,2,25,2,'VERY HIGH','JAVIER',2,1,'REESE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU13442',0,250,3,0,64746,'M','Programmer/Developer',1000,'South',0,0,'No',3,1,23,53.07,13986.5,0,2,29,1,'LOW','WILBURN',0,0,'VENTURA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,4,'CU6543',0,0,0,1,59582,'M','Veterinarian',500,'South',0,0,'No',4,1,50,53.11,16895.5,806,1,25,2,'MEDIUM','STAN',0,1,'HARRIS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU14250',2000,0,1,1,73464,'F','Law Enforcement Officer',1500,'Midwest',1,2000,'No',4,1,43,54.41,26166,0,1,25,5,'HIGH','STEVEN',1,1,'SWEET')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',2790,5,'CU4808',3447,3301,5,0,67482,'F','Not specified',900,'West',1,1,'No',1,3,40,55.78,23370.5,12470,1,9161,6,'HIGH','DINORAH',1,1,'FELIX')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU11958',3500,0,4,1,80454,'F','IT Staff',2000,'West',1,3500,'No',1,4,36,58.77,22713.5,175,1,25,6,'HIGH','ALEIDA',1,1,'RAMSEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CO',0,2,'CU1954',0,0,0,0,65044,'M','PROF-24',900,'West',0,0,'No',0,2,41,53.06,21361,919,0,25,0,'MEDIUM','CLEO',0,1,'SHOOK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WI',11167,1,'CU2855',4000,9000,1,1,60271,'F','IT Staff',500,'Midwest',1,1600,'No',1,2,44,54.26,22967.75,21802,4,25,5,'HIGH','WYNONA',1,1,'CASH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,3,'CU4775',3000,2800,3,0,68419,'M','PROF-18',900,'Midwest',1,3000,'No',3,0,28,53.27,25404.75,3382,1,25,3,'HIGH','ANTIONE',1,1,'VALENCIA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,2,'CU1915',1500,0,2,1,63109,'F','Bank Teller',500,'NorthEast',1,1500,'No',3,1,53,53.11,23077.25,890,2,25,2,'HIGH','MELANY',1,1,'HAMILTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU14254',4000,3200,1,1,61585,'M','IT Staff',2000,'NorthEast',1,600,'No',2,3,34,53.83,22296.25,3793,1,3714,4,'HIGH','MERVIN',1,1,'THARP')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU2866',4000,0,1,1,65534,'F','IT Staff',500,'Midwest',1,4000,'No',1,2,39,53.07,23783.5,506,1,25,1,'HIGH','MARJORY',1,1,'SHELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU1612',1900,0,1,0,75110,'F','PROF-19',2200,'Midwest',1,1900,'No',3,0,54,53.03,32677.5,653,1,25,2,'VERY HIGH','VALERIE',1,1,'VILLARREAL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU3835',800,0,3,0,58404,'M','Childcare Worker',900,'West',1,800,'No',0,3,43,53.06,24401,506,0,25,0,'HIGH','ARMANDO',1,1,'GANT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',4752,5,'CU385',2500,4350,5,1,71057,'F','School Teacher',1500,'NorthEast',1,750,'No',4,4,79,53.51,23164.25,15114,6,9827,4,'HIGH','ARIELLE',1,1,'DYE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',52355,2,'CU6461',0,2733,0,1,68116,'M','Nurse',700,'NorthEast',0,1333,'No',9,1,62,55,19229,54100,1,25,5,'MEDIUM','CARLOS',0,1,'NEAL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU15821',1000,0,3,0,75552,'M','Sales Representative',1500,'NorthEast',1,1000,'No',8,4,22,53.08,26588,172,1,159,1,'HIGH','RASHAD',1,1,'JEFFERSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,5,'CU8826',4000,3750,5,1,67315,'M','Clerical',1500,'Midwest',1,4000,'No',9,1,28,53.56,17128.75,1793,1,25,4,'MEDIUM','DANIEL',1,1,'DICKENS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU4113',700,0,3,0,61933,'M','PROF-18',700,'Midwest',1,700,'No',0,3,35,53.06,24483.25,506,0,25,0,'HIGH','JUDE',1,1,'HATCH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU10236',0,450,3,1,62275,'M','Programmer/Developer',1000,'South',0,0,'No',2,1,26,53.09,8668.75,0,2,25,1,'LOW','ALFRED',0,0,'DELACRUZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU5144',4500,13900,1,1,69836,'F','Law Enforcement Officer',900,'Midwest',1,900,'No',4,7,64,53.59,27359,1790,5,25,4,'HIGH','PORSHA',1,1,'CARRASCO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',25915,1,'CU8530',0,10140,1,1,63074,'M','PROF-29',800,'Midwest',0,2090,'No',13,2,47,54.37,13968.5,26431,1,25,5,'LOW','SID',0,1,'CLIFFORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','WI',0,3,'CU1015',826,501,3,1,60556,'M','Waiter/Waitress',900,'Midwest',1,826,'No',0,0,48,53.13,20439,0,2,25,2,'MEDIUM','RALEIGH',1,1,'HYDE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OR',0,3,'CU14991',300,0,3,0,66442,'M','Waiter/Waitress',1000,'West',1,300,'No',5,1,19,53.05,24010.5,0,0,25,2,'HIGH','ROBIN',1,1,'ZEIGLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU13624',1483,3200,1,0,62494,'M','Clerical',1000,'NorthEast',1,1000,'No',2,3,29,55.75,27023.5,12344,1,25,6,'HIGH','DARIO',1,1,'MARINO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU7744',780,550,1,1,67566,'M','Construction Laborer',700,'NorthEast',1,780,'No',5,1,48,53.24,25191.5,334,2,25,3,'HIGH','GREG',1,1,'UPTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,1,'CU5698',12000,1801,1,1,59039,'F','IT Staff',900,'NorthEast',1,12000,'No',1,0,74,53.77,25659.75,536,3,25,4,'HIGH','NOELIA',1,1,'OROURKE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MN',0,4,'CU12367',5000,0,3,1,92255,'F','Clerical',3500,'West',1,5000,'No',2,4,41,52.78,28163.75,1879,1,59,2,'HIGH','JOY',1,1,'MATTHEWS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU11694',1021,800,3,0,84160,'M','PROF-51',2500,'West',1,1021,'No',2,4,32,53.32,29740,212,3,25,3,'HIGH','JAN',1,1,'CRAWFORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MS',0,2,'CU2185',0,0,0,1,61681,'M','First-line Manager',1300,'South',0,0,'No',1,2,47,53.1,16120.25,645,1,141,2,'MEDIUM','ALFONSO',0,1,'SANTIAGO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU12663',512,0,3,1,68113,'M','Waiter/Waitress',1000,'West',1,512,'No',2,1,23,53.12,19828.25,0,1,40,2,'MEDIUM','HERSHEL',1,1,'PARSONS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OH',0,2,'CU2555',1300,0,0,0,63722,'M','Professor',900,'Midwest',1,1300,'No',0,2,41,53.06,31030.5,506,1,25,0,'VERY HIGH','REGINALD',1,1,'MEJIA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',1445,1,'CU5351',6144,8100,1,1,61194,'F','Cashier',500,'Midwest',1,6144,'No',3,0,28,53.28,21598.5,11106,4,8328,3,'MEDIUM','CRYSTAL',1,1,'BARBER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,1,'CU15809',951,0,1,0,68371,'M','Waiter/Waitress',2500,'NorthEast',1,951,'No',0,4,39,53.06,29492.75,0,0,25,0,'HIGH','HARLAND',1,1,'CARVER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU10745',0,0,3,0,63925,'M','Programmer/Developer',1000,'Midwest',0,0,'No',0,1,30,53.06,14481.25,0,1,25,0,'MEDIUM','TRENTON',0,0,'MORENO')
SELECT * FROM DUAL;
INSERT ALL
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU5151',0,0,0,0,60500,'M','Technical Writer',900,'NorthEast',0,0,'No',2,0,43,53.07,20425,507,0,25,1,'MEDIUM','RUBIN',0,1,'HEALY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU11246',1400,1900,3,0,60979,'M','Secretary',1500,'West',1,1400,'No',2,1,31,54.95,23844.75,13939,1,13931,5,'HIGH','DONNY',1,1,'FAULKNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',43787,1,'CU216',500,2201,1,0,65218,'M','Author',900,'NorthEast',1,1,'No',4,0,83,56.39,33104.5,55686,4,25,6,'VERY HIGH','FREDRIC',1,1,'LEVIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU5056',1716,0,2,0,61776,'M','Professor',900,'West',1,1716,'No',0,0,32,53.71,25644,500,1,25,4,'HIGH','CORY',1,1,'BABCOCK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU15116',3723,2601,6,0,61399,'M','Cashier',2000,'West',1,1,'No',4,8,45,53.4,19849.75,6226,1,4226,4,'MEDIUM','RODOLFO',1,1,'BARON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU14993',900,0,3,1,59721,'M','PROF-31',600,'NorthEast',1,900,'No',4,1,34,53.05,18830.25,0,0,25,2,'MEDIUM','RODNEY',1,1,'SCRUGGS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',4856,4,'CU6501',2000,2300,6,1,70907,'F','PROF-2',1000,'West',1,200,'No',2,1,66,53.81,19326.75,15397,2,10527,4,'MEDIUM','ELIZABETH',1,1,'BARGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU4871',1729,4100,1,0,55475,'F','Homemaker',1500,'West',1,650,'No',15,3,38,54.19,26168.75,22716,1,21998,5,'HIGH','CORDELIA',1,1,'BRANHAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU13515',0,0,3,0,64462,'M','Programmer/Developer',1000,'Midwest',0,0,'No',0,1,28,53.06,14415.5,0,1,25,0,'MEDIUM','WYATT',0,0,'BLAIR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU938',0,0,0,0,59368,'M','Fireman',1300,'West',0,0,'No',0,0,60,53.06,21842,507,1,25,0,'MEDIUM','RASHAD',0,1,'GOFF')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU5310',4200,0,1,1,62354,'F','Veterinarian',500,'Midwest',2,4200,'No',18,8,28,56.22,31888.5,1756,1,25,6,'VERY HIGH','CAROLEE',2,1,'ONEIL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU4914',1000,0,0,0,62427,'M','Administrator',500,'West',1,1000,'No',0,3,42,53.06,30806.75,512,3,25,0,'VERY HIGH','DEVIN',1,1,'TYSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU8955',5000,9850,1,1,50758,'F','Clerical',3500,'Midwest',2,1500,'No',11,1,32,53.08,29389.5,1601,1,1053,1,'HIGH','RICARDA',2,1,'MAGEE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',28829,1,'CU14800',12000,11100,1,0,74803,'F','Not specified',4000,'NorthEast',1,12000,'No',2,1,43,53.77,31500.75,38963,4,10084,4,'VERY HIGH','CORDELIA',1,1,'STARR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',38186,4,'CU15766',0,12500,4,1,59261,'M','Clerical',800,'NorthEast',0,3100,'No',4,5,41,54.87,7915.25,38208,4,25,5,'LOW','LEONARD',0,1,'BERGERON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','MI',6602,4,'CU5759',5000,18300,3,1,61580,'F','Publisher',900,'Midwest',2,3100,'No',2,0,55,52.97,31895,10054,5,2629,2,'VERY HIGH','SYLVIE',2,1,'BEATTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',11645,2,'CU692',5000,14800,2,1,61270,'M','Clerical',1400,'NorthEast',1,5000,'No',3,0,59,53.94,23217.5,24484,2,1436,4,'HIGH','DANNIE',1,1,'KEATING')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',25919,4,'CU4105',700,11500,4,1,65668,'M','PROF-49',500,'Midwest',1,700,'No',7,3,29,53.96,18317,30686,4,3756,5,'MEDIUM','ANTONY',1,1,'GUIDRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,1,'CU13265',0,0,1,0,70582,'M','Programmer/Developer',1000,'South',0,0,'No',0,1,27,53.06,18845.5,0,1,25,0,'MEDIUM','FOREST',0,0,'HAGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU6227',4528,14900,1,1,69268,'M','Not specified',800,'NorthEast',1,5000,'No',17,0,43,53.28,26617,4265,1,3677,3,'HIGH','GRAHAM',1,1,'RILEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,4,'CU4292',12000,0,1,1,64180,'M','IT Staff',500,'Midwest',1,12000,'No',7,3,34,49.94,24445,506,1,25,2,'HIGH','NEAL',1,1,'MATTINGLY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU7681',352,0,3,0,58981,'M','Sales Representative',1500,'NorthEast',1,352,'No',1,1,24,53.07,22645.25,0,0,25,1,'HIGH','JUDE',1,1,'POST')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU14310',11657,250,3,0,78125,'M','Veterinarian',2500,'West',1,1400,'No',0,1,50,53.43,30031.25,20856,2,7715,4,'VERY HIGH','CECIL',1,1,'EGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',2558,3,'CU11113',760,550,3,1,58567,'M','Childcare Worker',700,'NorthEast',1,760,'No',10,1,35,53.15,18641.75,3203,2,633,2,'MEDIUM','VAL',1,1,'HUGGINS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14302',0,0,3,0,66488,'M','Nurse',1500,'West',0,0,'No',1,1,23,53.06,14422,0,0,25,0,'MEDIUM','TRINIDAD',0,0,'WOODY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU7839',0,0,0,0,59621,'M','Nurse',700,'Midwest',0,0,'No',4,1,34,53.08,19305.25,0,0,25,1,'MEDIUM','KIM',0,0,'SHIRLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','UT',0,1,'CU15289',1400,0,1,0,73987,'M','Professor',2500,'Southwest',1,1400,'No',0,5,46,53.06,31596.75,0,0,25,0,'VERY HIGH','FRANKLIN',1,1,'KNOX')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,2,'CU4101',8550,0,0,0,71417,'M','IT Staff',4000,'Midwest',1,8550,'No',0,3,33,53.06,32154.25,506,1,25,0,'VERY HIGH','ARTHUR',1,1,'PULLIAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',446,1,'CU2570',5000,17100,1,1,57124,'F','IT Staff',1500,'NorthEast',1,3100,'No',4,10,68,53.42,24581,6281,5,1076,4,'HIGH','TYNISHA',1,1,'HUTSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',68682,5,'CU11231',3503,6800,5,1,62482,'F','Veterinarian',900,'Southwest',1,1500,'No',1,1,33,55.88,16420.5,76910,4,25,6,'MEDIUM','AKILAH',1,1,'MULLEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',111,3,'CU5289',800,1300,3,1,68947,'M','Veterinarian',900,'Midwest',1,800,'No',4,0,28,52.93,20536.75,1129,3,385,2,'MEDIUM','WILEY',1,1,'BORDEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU3084',0,0,0,0,57964,'M','PROF-44',900,'NorthEast',0,0,'No',0,2,24,53.06,17891,504,0,25,0,'MEDIUM','SHON',0,1,'COHEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU7866',1123,901,1,0,69444,'F','Waiter/Waitress',800,'West',1,1123,'No',8,1,46,53.26,30461,121,3,25,3,'VERY HIGH','PEARLIE',1,1,'PERALTA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NC',0,1,'CU13120',400,0,1,0,60554,'M','Construction Laborer',1000,'South',1,400,'No',1,1,30,53.07,26638.5,331,0,25,1,'HIGH','DARWIN',1,1,'MACK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU6243',0,5735,3,0,64799,'M','PROF-33',900,'West',0,2585,'No',16,0,45,53.55,16199.75,13433,4,12387,4,'MEDIUM','DWAYNE',0,1,'LITTLEJOHN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU6466',3250,4400,1,1,56361,'F','Fireman',1500,'West',2,200,'No',3,1,54,53.58,32990.25,5037,6,2602,4,'VERY HIGH','GWYN',2,1,'KOENIG')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,2,'CU9798',0,0,0,0,66711,'M','Nurse',800,'South',0,0,'No',0,1,48,53.04,22477.75,0,0,25,2,'HIGH','PEDRO',0,0,'GRACE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NV',0,1,'CU12208',3000,0,1,1,66479,'M','IT Staff',1500,'Southwest',1,3000,'No',4,4,32,53.01,23319.75,0,1,25,2,'HIGH','FIDEL',1,1,'WEATHERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU13133',0,500,3,1,68679,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',1,3,22,53.34,9869.75,0,2,25,3,'LOW','DALLAS',0,0,'WILHELM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14553',170,0,3,0,67224,'M','Technical Writer',1000,'NorthEast',1,170,'No',0,1,19,53.06,24206,0,0,25,0,'HIGH','RANDALL',1,1,'JENNINGS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11341',0,0,3,0,58086,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',0,1,29,56.63,12921.5,0,1,25,6,'LOW','ARLEN',0,0,'LY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU9102',288,0,3,0,65843,'M','PROF-5',700,'West',1,288,'No',0,1,31,53.06,25060.75,0,0,25,0,'HIGH','ALONZO',1,1,'PUGH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU11209',747,600,3,0,62475,'M','Sales Representative',600,'West',1,747,'No',6,1,33,53.53,24418.75,826,2,118,4,'HIGH','WILL',1,1,'ABRAHAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU14291',0,0,0,0,57542,'M','Administrative Assistant',1500,'NorthEast',0,0,'No',0,1,0,53.06,0,651,0,25,0,'LOW','ANIBAL',0,1,'BALL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NV',44,1,'CU11516',3000,0,1,0,70044,'F','Clerical',2500,'Southwest',1,3000,'No',1,1,51,53.17,31111,413,0,342,2,'VERY HIGH','CHARLESETTA',1,1,'FORTUNE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',37066,1,'CU534',10000,21100,1,1,66848,'F','Clerical',4000,'NorthEast',2,5000,'No',3,0,74,53.68,37612,45750,5,6612,4,'VERY HIGH','THEODORA',2,1,'HACKETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,4,'CU2956',1487,0,4,0,64101,'M','Cashier',500,'NorthEast',1,1487,'No',11,1,34,53.3,23425.25,345,1,25,3,'HIGH','LINDSAY',1,1,'CARMONA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WA',0,4,'CU8630',600,500,3,0,62456,'M','Waiter/Waitress',1500,'West',1,600,'No',16,1,28,53.11,24414,120,2,93,2,'HIGH','CARMINE',1,1,'LACKEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','FL',0,1,'CU6674',3500,0,1,1,57213,'F','IT Staff',1500,'South',1,3500,'No',5,1,35,53.08,21303.25,596,1,94,1,'MEDIUM','GILMA',1,1,'FIELDS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NC',0,3,'CU7733',1000,0,3,1,71397,'M','Programmer/Developer',1000,'South',1,1000,'No',1,1,22,54.46,20549.25,0,1,25,5,'MEDIUM','REINALDO',1,1,'WALKER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OK',0,3,'CU9746',1000,750,3,0,65606,'M','Programmer/Developer',1000,'Midwest',1,1000,'No',2,1,21,53.26,24001.5,1309,3,1126,3,'HIGH','EUSEBIO',1,1,'PROCTOR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,3,'CU4544',2645,3200,3,1,59670,'M','Cashier',500,'West',1,400,'No',4,0,29,54.41,18317.5,2906,1,2847,5,'MEDIUM','DEON',1,1,'ROCKWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU153',1800,0,3,0,60958,'M','Author',1000,'Midwest',1,1800,'No',0,0,77,53.06,27439.5,504,1,25,0,'HIGH','FLORENTINO',1,1,'DUGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU577',700,0,1,1,65108,'M','Veterinarian',900,'West',1,700,'No',3,0,26,52.94,22377,685,1,156,2,'HIGH','KENDALL',1,1,'ESCOBAR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU4116',0,301,3,1,64173,'M','PROF-5',1300,'Midwest',0,0,'No',3,3,52,53.12,11743.25,759,1,184,2,'LOW','NORMAND',0,1,'HO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU8583',500,0,3,1,62117,'M','Dentist',1500,'West',1,500,'No',1,1,26,53.07,18629.25,125,0,25,1,'MEDIUM','PABLO',1,1,'WHITMORE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU13235',620,0,3,0,61908,'M','Programmer/Developer',1000,'NorthEast',1,620,'No',0,1,23,53.17,23277,0,1,25,2,'HIGH','RODNEY',1,1,'KEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU13847',670,350,1,0,58703,'F','Programmer/Developer',700,'Midwest',1,670,'No',3,3,37,53.16,26875.75,688,2,673,2,'HIGH','MARYROSE',1,1,'BELTRAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU9125',0,0,0,0,70227,'M','Construction Laborer',1500,'West',0,0,'No',0,1,0,53.06,0,0,0,25,0,'LOW','OTTO',0,0,'WILLETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NV',0,2,'CU7837',0,0,0,0,60528,'M','First-line Manager',1500,'Southwest',0,0,'No',1,1,28,53.07,18932,0,0,25,1,'MEDIUM','JULIUS',0,0,'BRAVO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU6791',0,0,0,0,60501,'M','Nurse',500,'NorthEast',0,0,'No',7,1,49,53.32,21025.25,4401,1,1209,3,'MEDIUM','TY',0,1,'MCINTYRE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,1,'CU4245',0,0,1,1,68959,'M','Not specified',800,'West',0,0,'No',1,3,48,53.16,15539.75,1288,1,757,2,'MEDIUM','LINWOOD',0,1,'WEIR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU8506',2513,1150,1,0,70749,'M','Plumber',1000,'Midwest',1,2513,'No',11,1,48,54.13,30987.25,6248,3,466,5,'VERY HIGH','JON',1,1,'DUTTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU10680',1500,0,2,1,68987,'M','Bank Teller',1000,'West',1,1500,'No',5,1,39,53.08,23146.75,0,1,25,1,'HIGH','DOMINIQUE',1,1,'PUGH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CO',0,2,'CU2366',0,0,0,1,61075,'M','Administrative Assistant',500,'West',0,0,'No',1,2,46,53.09,15868.75,2400,0,25,1,'MEDIUM','VIRGILIO',0,1,'LEVY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU7014',0,0,0,0,60998,'M','Nurse',2500,'Midwest',0,0,'No',18,1,67,53.07,22949.5,762,0,257,1,'HIGH','SON',0,1,'WALSH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU10518',0,0,0,1,66533,'M','Nurse',800,'West',0,0,'No',1,1,41,53.06,16733.25,0,1,25,0,'MEDIUM','ZACHERY',0,0,'RUDOLPH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU860',0,0,0,0,74494,'M','Administrative Assistant',1500,'NorthEast',0,0,'No',0,0,0,53.06,0,503,0,25,0,'LOW','JIM',0,1,'HOPPER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU13297',1900,0,3,1,68988,'M','Truck Driver',1500,'NorthEast',1,1900,'No',9,1,25,53.67,20247,241,1,25,4,'MEDIUM','MARQUIS',1,1,'MALLOY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU8716',450,0,3,0,62848,'M','Nurse',700,'NorthEast',2,450,'No',1,1,44,53.06,35612,0,0,25,0,'VERY HIGH','FRANK',2,1,'SHEPPARD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU4845',2000,0,1,1,59934,'F','DBA',1500,'NorthEast',1,2000,'No',1,3,47,55.45,23183.5,506,1,25,5,'HIGH','MARGRET',1,1,'GARVIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU15400',120,0,3,0,63498,'M','Nurse',1000,'NorthEast',1,120,'No',0,4,27,53.06,24074.5,0,0,25,0,'HIGH','WILLIAMS',1,1,'MYERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',27450,1,'CU5114',3600,6500,1,1,57693,'F','IT Staff',900,'NorthEast',1,3600,'No',3,6,64,54.4,24323.25,28900,4,25,5,'HIGH','MARIAM',1,1,'COTTRELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU11130',750,0,1,1,61493,'F','PROF-22',700,'Midwest',1,750,'No',12,1,50,53.17,23873.25,865,1,25,2,'HIGH','JANYCE',1,1,'LIM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,4,'CU3265',1500,1400,4,1,59851,'M','PROF-23',500,'South',1,1500,'No',3,3,35,53.04,17462.75,3316,2,25,2,'MEDIUM','JERRELL',1,1,'KIM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU10411',1200,0,3,0,59975,'M','Truck Driver',700,'NorthEast',1,1200,'No',0,1,34,53.06,23893.75,0,0,25,0,'HIGH','STEWART',1,1,'PAYTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WA',0,3,'CU8180',3000,0,3,0,56582,'M','PROF-25',1500,'West',1,3000,'No',2,1,37,53.04,23345.5,0,1,25,2,'HIGH','SETH',1,1,'HUMPHREYS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU13653',550,0,3,0,60108,'M','Administrative Assistant',600,'NorthEast',1,550,'No',0,1,53,53.06,25827,0,0,25,0,'HIGH','MIQUEL',1,1,'CHERRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU7701',0,750,3,0,67076,'M','Programmer/Developer',1000,'NorthEast',0,0,'No',15,1,22,53.03,14469,159,3,96,2,'MEDIUM','HUNTER',0,1,'HURLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MS',0,2,'CU4371',6000,9200,1,1,63268,'F','IT Staff',500,'South',1,3000,'No',4,8,46,54.43,24417,8284,2,25,5,'HIGH','LILLY',1,1,'GRADY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU13390',360,0,3,0,65955,'M','PROF-27',2500,'Midwest',1,360,'No',1,1,47,53.07,26688.75,0,0,25,1,'HIGH','RODERICK',1,1,'WAGONER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU9594',3341,4052,1,0,64428,'F','Homemaker',800,'West',1,1302,'No',18,1,53,53.63,29907,227,1,25,4,'HIGH','JERRICA',1,1,'KHAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU12638',700,201,3,1,59127,'M','PROF-4',1000,'West',1,700,'No',11,2,27,53.21,17981.75,0,1,25,3,'MEDIUM','OTTO',1,1,'HARMON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU11877',1500,301,3,0,63363,'M','Professor',1000,'NorthEast',1,1500,'No',2,4,30,53.04,24340.75,377,2,25,2,'HIGH','SANFORD',1,1,'JOSEPH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OR',0,1,'CU8238',1117,0,1,0,60740,'F','Author',1000,'West',1,1117,'No',0,1,58,53.06,29485,0,1,25,0,'HIGH','ARGENTINA',1,1,'FLAHERTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU8734',1400,0,5,0,63251,'F','Programmer/Developer',700,'NorthEast',2,1400,'No',0,1,31,53.06,31412.75,0,1,25,0,'VERY HIGH','SCARLET',2,1,'MERRILL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',50375,1,'CU6061',2235,5400,1,1,61083,'M','Secretary',1000,'NorthEast',1,1200,'No',16,1,50,55.06,23770.75,57652,4,25,5,'HIGH','LAURENCE',1,1,'MCCABE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,2,'CU9038',1000,0,0,0,58918,'M','Waiter/Waitress',800,'NorthEast',1,1000,'No',3,1,68,53.07,32529.5,523,0,25,1,'VERY HIGH','KURTIS',1,1,'BUNDY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU8196',1980,0,1,0,73019,'F','Programmer/Developer',1500,'Midwest',1,1980,'No',1,1,36,53.07,30354.75,212,1,116,1,'VERY HIGH','RUBIE',1,1,'CARON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU10447',2750,0,3,1,66575,'M','Sales Representative',1000,'NorthEast',1,2750,'No',4,3,26,53.18,19743.75,1926,0,508,3,'MEDIUM','JIMMIE',1,1,'CHRISTIE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',47429,4,'CU6315',0,22900,1,1,73881,'F','Waiter/Waitress',1300,'West',0,3700,'No',4,3,53,55.27,18770.25,50724,5,25,5,'MEDIUM','MELLISSA',0,1,'CAMPBELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',5044,4,'CU5177',3000,8700,2,1,64610,'F','Veterinarian',1800,'NorthEast',2,1400,'No',2,0,45,53.49,33652.5,6200,4,222,4,'VERY HIGH','ELOIS',2,1,'WATSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU9385',945,500,1,0,54947,'F','Construction Laborer',1500,'Midwest',1,945,'No',3,1,30,53.58,25236.75,0,2,25,4,'HIGH','DAVINA',1,1,'MULLEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,3,'CU12228',2100,2500,3,1,64244,'M','IT Staff',1500,'Midwest',1,500,'No',6,4,41,53.49,20661,645,1,25,4,'MEDIUM','MARVIN',1,1,'PEOPLES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',75693,1,'CU895',4000,9500,1,0,60028,'F','Not specified',800,'NorthEast',2,1600,'No',3,0,41,55.46,37607,76330,2,25,5,'VERY HIGH','KIT',2,1,'MOFFETT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,1,'CU10473',1000,250,1,1,60249,'M','IT Staff',1000,'NorthEast',1,1000,'No',2,3,24,53.54,20962.25,409,2,25,4,'MEDIUM','FLORENCIO',1,1,'HAINES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',6919,3,'CU3742',2500,1801,3,1,69057,'M','Plumber',1400,'NorthEast',1,2500,'No',5,3,58,54.58,23564.25,21260,5,6021,5,'HIGH','NOE',1,1,'HARMON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,2,'CU4470',0,2850,0,1,65217,'M','Construction Laborer',900,'Midwest',0,750,'No',4,3,33,53.01,15604.25,1213,1,637,2,'MEDIUM','DARYL',0,1,'NORWOOD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU8478',0,0,0,0,64627,'M','PROF-1',700,'West',0,0,'No',0,1,44,53.06,21556.75,0,0,25,0,'MEDIUM','SHERWOOD',0,0,'VALENTINE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU14974',1147,251,3,0,63837,'M','PROF-51',1000,'Midwest',1,1147,'No',12,3,24,53.09,23859.25,152,2,141,1,'HIGH','JERAMY',1,1,'STJOHN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU2100',3000,0,1,1,58309,'F','PROF-5',900,'NorthEast',1,3000,'No',0,2,27,53.06,20777.25,563,1,56,0,'MEDIUM','TERINA',1,1,'MATTHEWS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU10653',914,201,3,1,65464,'M','Sales Representative',1000,'Midwest',1,914,'No',7,1,23,53.48,19166,456,1,25,4,'MEDIUM','WARNER',1,1,'GALLEGOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU945',4000,9200,1,1,73662,'F','PROF-9',1200,'NorthEast',1,1600,'No',3,5,65,54.41,28415.5,10144,2,9367,5,'HIGH','WENDI',1,1,'HO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU4641',0,0,0,0,61071,'M','Nurse',900,'NorthEast',0,0,'No',1,3,73,53.2,23567.75,3267,0,2750,3,'HIGH','MITCHELL',0,1,'CORCORAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MN',0,3,'CU11429',1000,0,3,0,58585,'M','Waiter/Waitress',1000,'West',1,1000,'No',15,4,29,54.86,23046.25,495,1,25,5,'HIGH','ERIC',1,1,'RAMIREZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU13737',754,0,1,0,65511,'M','Cashier',700,'West',1,754,'No',2,1,31,53.07,27977.75,0,0,25,1,'HIGH','LEONARDO',1,1,'MCGRATH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU7218',2500,0,3,1,61348,'F','Truck Driver',1000,'NorthEast',1,2500,'No',9,1,49,53.24,21237,590,1,25,3,'MEDIUM','JOANIE',1,1,'PERKINS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU3243',2000,0,3,1,62845,'M','PROF-7',500,'NorthEast',1,2000,'No',1,3,39,53.07,20111.25,543,1,25,1,'MEDIUM','CAMERON',1,1,'MOTT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,2,'CU1600',2650,1800,0,0,66711,'M','Fireman',1000,'NorthEast',1,2650,'No',0,0,51,53.06,32777.75,505,3,25,0,'VERY HIGH','RUBEN',1,1,'ALFORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU4983',1600,1000,3,1,64047,'M','PROF-20',900,'West',1,200,'No',13,0,33,53.53,19811.75,1125,4,482,4,'MEDIUM','JACKIE',1,1,'GILCHRIST')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',92734,4,'CU12603',3000,7648,1,1,55957,'F','IT Staff',1500,'Midwest',1,3824,'No',17,1,78,54.55,26789.25,100578,4,7170,5,'HIGH','RACHELL',1,1,'COBURN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,2,'CU2320',2214,5200,0,1,68477,'M','Nurse',800,'West',1,1900,'No',10,2,48,54.11,27919.25,20719,2,20055,5,'HIGH','JUDE',1,1,'OTTO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,3,'CU7522',0,500,3,0,60786,'M','Programmer/Developer',1000,'West',0,0,'No',18,1,21,53.08,12796.5,127,2,25,1,'LOW','ANTOINE',0,1,'HUDDLESTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU7949',0,0,0,0,60849,'M','Nurse',700,'NorthEast',0,0,'No',3,1,45,53.06,20712.25,0,0,25,0,'MEDIUM','DAREN',0,0,'GIBBS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','DC',0,2,'CU10044',15000,14000,2,1,64744,'F','IT Staff',800,'NorthEast',1,5000,'No',2,1,56,54.33,23786,4988,1,25,5,'HIGH','LEONIE',1,1,'TRAYLOR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,5,'CU4395',1000,0,5,1,66038,'F','PROF-33',500,'Midwest',1,1000,'No',0,3,35,53.06,17509.5,507,0,25,0,'MEDIUM','KANDIS',1,1,'HOLMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU5739',0,4306,0,1,67016,'M','Construction Laborer',900,'West',0,956,'No',2,0,64,53.21,19154,9354,1,88,3,'MEDIUM','ALVA',0,1,'ROBINSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU10856',3000,0,3,1,70195,'F','Bank Teller',1000,'NorthEast',1,3000,'No',3,1,42,53.12,22748.75,488,1,25,2,'HIGH','SUNNI',1,1,'CONNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,4,'CU4171',6800,11800,3,1,59628,'F','IT Staff',900,'West',1,3000,'No',2,3,55,54.78,21407,9923,4,25,5,'MEDIUM','DONNIE',1,1,'MYLES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU6965',0,0,0,0,69728,'M','Nurse',800,'NorthEast',0,0,'No',2,1,47,53.06,23132,503,0,25,0,'HIGH','PRINCE',0,1,'MCCLELLAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,1,'CU10831',5000,0,1,1,96667,'F','PROF-54',3500,'South',1,5000,'No',0,1,26,53.06,30266.75,0,1,25,0,'VERY HIGH','ALBERTA',1,1,'DIAZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MS',0,3,'CU12641',1369,1050,3,0,55367,'M','PROF-3',1500,'South',1,1369,'No',2,1,55,54.26,24841.75,343,2,149,5,'HIGH','RUSSELL',1,1,'HUYNH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','IL',0,3,'CU9461',0,251,3,1,70077,'M','Programmer/Developer',1000,'Midwest',0,0,'No',1,1,26,53.09,10619.25,0,2,25,1,'LOW','DOUGLAS',0,0,'VELAZQUEZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,5,'CU8831',4800,0,5,0,63127,'M','Cashier',800,'Midwest',1,4800,'No',0,1,42,53.06,22481.75,0,0,25,0,'HIGH','JAY',1,1,'HATTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,2,'CU13263',400,750,2,0,62116,'M','Programmer/Developer',700,'West',1,400,'No',13,1,53,53.13,27829,2650,3,2489,2,'HIGH','ETHAN',1,1,'DOYLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU8452',0,0,3,0,69905,'M','PROF-6',1500,'Midwest',0,0,'No',0,1,26,53.06,15576.25,0,0,25,0,'MEDIUM','TREY',0,0,'DICKENS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU1851',6500,0,1,1,64912,'F','Not specified',500,'NorthEast',1,6500,'No',9,2,36,54.17,23328,1227,1,25,5,'HIGH','FELIPA',1,1,'BASS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU12325',228,0,3,0,73067,'M','Nurse',1500,'West',1,228,'No',2,4,27,53.05,26466.75,0,0,25,2,'HIGH','PAUL',1,1,'FLINT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,2,'CU3193',1000,0,0,1,68717,'M','PROF-10',700,'Midwest',1,1000,'No',10,3,40,53.11,27179.25,718,0,209,2,'HIGH','RUDY',1,1,'GALINDO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','NY',170498,4,'CU55',30000,36000,1,1,98449,'F','Clerical',4000,'NorthEast',1,30000,'No',6,0,70,63.04,36612.25,499362,9,592,7,'VERY HIGH','NYLA',1,1,'CHO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','OH',0,2,'CU7381',3000,0,0,1,64586,'M','PROF-7',1500,'Midwest',1,3000,'No',0,1,35,53.06,25646.5,0,1,25,0,'HIGH','RICHARD',1,1,'NOVAK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',1437,3,'CU9290',0,650,3,0,60686,'M','Programmer/Developer',1500,'West',0,0,'No',9,2,24,53.43,13071.5,4959,2,3006,4,'LOW','BOYCE',0,1,'DOWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,3,'CU5090',1500,250,3,1,72463,'M','PROF-5',1500,'South',1,1500,'No',9,0,26,53.17,21215.75,2765,2,2202,2,'MEDIUM','RODOLFO',1,1,'DOWNEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','WI',0,4,'CU4195',700,950,6,1,68469,'M','PROF-2',700,'Midwest',1,700,'No',10,3,32,53.49,15317.25,853,3,318,4,'MEDIUM','LOGAN',1,1,'NEWBY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU557',3500,0,1,1,64805,'F','Publisher',800,'Midwest',1,3500,'No',6,0,65,53.51,26201.25,699,1,134,4,'HIGH','LINDY',1,1,'MCHUGH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU10218',0,0,3,0,66009,'M','Nurse',1000,'West',0,0,'No',0,1,28,53.06,14802.25,0,0,25,0,'MEDIUM','JEROME',0,0,'MOYER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','UT',0,3,'CU15942',0,250,3,0,56486,'M','Programmer/Developer',1500,'Southwest',0,0,'No',0,5,22,53.06,11821.5,0,2,25,0,'LOW','MOISES',0,0,'GRIGGS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU9964',1100,1100,1,0,66866,'F','PROF-16',700,'Midwest',1,1100,'No',4,1,35,53.83,28716.5,156,3,81,4,'HIGH','ALLIE',1,1,'MCCARTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU13322',3500,0,1,1,71237,'F','IT Staff',2000,'Midwest',1,3500,'No',1,1,58,32.16,27109.25,1052,1,25,2,'HIGH','VIKKI',1,1,'RADFORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU13087',1000,201,1,1,62383,'M','Author',1000,'Midwest',1,1000,'No',2,1,53,53.12,24395.75,467,1,456,2,'HIGH','ROBT',1,1,'MCLAIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CO',0,1,'CU4252',750,0,1,1,59511,'M','PROF-60',700,'West',1,750,'No',1,3,33,53.13,21677.75,507,1,25,2,'MEDIUM','EDMUND',1,1,'EDMONDS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU4932',0,0,0,0,64473,'M','Nurse',500,'NorthEast',0,0,'No',6,3,51,53.07,22218.25,744,0,239,1,'HIGH','HUEY',0,1,'ACOSTA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WA',0,2,'CU1527',0,0,0,1,62380,'M','Administrative Assistant',600,'West',0,0,'No',0,0,49,53.1,16495,505,0,25,2,'MEDIUM','OTHA',0,1,'STOKES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU4087',1500,400,1,0,68514,'M','First-line Manager',900,'NorthEast',1,1500,'No',2,3,49,53.29,30528.5,727,2,220,3,'VERY HIGH','MARY',1,1,'JAMESON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU1691',3330,4700,3,1,65568,'M','Veterinarian',2000,'NorthEast',1,500,'Yes',4,4,30,54.6,19892,5124,1,25,5,'MEDIUM','TORY',1,1,'CONRAD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU3214',3100,4400,1,1,74442,'F','Homemaker',2000,'NorthEast',1,1200,'Yes',2,3,62,54.29,28310.5,2143,1,25,5,'HIGH','KISHA',1,1,'RIDER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU8318',2919,1400,1,0,59957,'M','Medical Doctor',1500,'NorthEast',1,450,'Yes',3,1,43,53.5,27789.25,438,3,25,4,'HIGH','DEANGELO',1,1,'BUTCHER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14921',250,340,3,0,61651,'M','Programmer/Developer',700,'NorthEast',1,250,'Yes',1,2,35,53.61,24412.75,342,2,25,4,'HIGH','ARMAND',1,1,'CASH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',16009,1,'CU5675',0,11289,1,1,59255,'M','Mason',800,'NorthEast',0,2300,'Yes',2,0,44,54.29,12713.75,26711,4,924,5,'LOW','RAFAEL',0,1,'PINA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU2399',7000,20800,1,0,63876,'F','Law Enforcement Officer',1400,'Midwest',1,4300,'Yes',1,1,45,62.72,28969,8657,1,25,7,'HIGH','YON',1,1,'CONRAD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,1,'CU12658',0,500,1,0,61482,'M','Programmer/Developer',1000,'West',0,0,'Yes',15,2,23,53.28,16170.5,135,2,25,3,'MEDIUM','RALEIGH',0,1,'CASTELLANOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','WI',0,1,'CU9004',5000,17100,1,1,45796,'F','Clerical',3500,'Midwest',1,3100,'Yes',4,6,45,55.98,19449,2126,5,25,6,'MEDIUM','JENE',1,1,'CRUZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU13803',1643,3200,1,0,70612,'F','Truck Driver',1500,'NorthEast',2,1000,'Yes',1,1,54,54.26,41553,2884,1,25,5,'VERY HIGH','CAMERON',2,1,'HARPER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU8649',1800,1350,5,1,63371,'F','Dentist',1000,'NorthEast',1,1800,'Yes',2,1,27,54.42,16042.75,477,3,130,5,'MEDIUM','LEEANNE',1,1,'BRYAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NC',0,1,'CU3856',650,1403,1,1,66496,'F','Sales Representative',600,'South',1,453,'Yes',3,1,37,53.34,23824,1293,3,25,3,'HIGH','ALBERTA',1,1,'DEMPSEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NC',0,2,'CU6215',0,3850,1,0,68155,'F','Author',900,'South',0,350,'Yes',3,2,49,53.48,20938.75,973,1,49,4,'MEDIUM','DARLEEN',0,1,'BRYANT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU11959',2500,3700,1,1,70289,'M','Publisher',1500,'NorthEast',1,2500,'Yes',12,4,31,55.54,24172.25,509,1,25,6,'HIGH','EDMUND',1,1,'ALONZO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','IL',0,2,'CU7214',0,0,0,0,66267,'M','Clerical',600,'Midwest',0,0,'Yes',3,1,32,53.17,20766.75,567,0,25,2,'MEDIUM','LYNWOOD',0,1,'CHILDERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU15136',700,450,3,1,62065,'M','IT Staff',600,'Midwest',1,700,'Yes',13,2,31,53.4,19116.25,154,2,25,4,'MEDIUM','BOYCE',1,1,'HEARN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WI',0,4,'CU8687',2000,2000,3,0,63263,'F','Programmer/Developer',1000,'Midwest',1,400,'Yes',1,1,37,53.74,25515.75,361,1,89,4,'HIGH','HUI',1,1,'HOLLIS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CO',0,1,'CU8091',2520,2000,1,0,61670,'M','School Teacher',1500,'West',1,800,'Yes',18,1,35,54.9,27417.5,1162,1,25,5,'HIGH','RUPERT',1,1,'CARLTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,5,'CU9232',4821,5900,5,1,57844,'F','Law Enforcement Officer',3500,'NorthEast',2,1400,'Yes',3,1,35,54.34,25461,2127,4,228,5,'HIGH','MYRL',2,1,'HORNER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU11361',2600,1100,5,0,62571,'F','Technical Writer',1500,'NorthEast',1,2600,'Yes',14,1,31,53.38,21242.75,184,3,25,3,'MEDIUM','SONG',1,1,'DYE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,1,'CU3940',2000,2430,1,1,63965,'M','IT Staff',500,'NorthEast',1,400,'Yes',3,3,32,54.24,22691.25,1284,1,25,5,'HIGH','PASQUALE',1,1,'ORTEGA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,4,'CU1241',5000,32000,1,1,68909,'F','PROF-9',800,'West',1,5000,'Yes',3,0,51,56.43,27327.25,17340,4,13994,6,'HIGH','DEIDRE',1,1,'GUEVARA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',1127,1,'CU928',1200,2068,1,1,61959,'F','PROF-1',1100,'Midwest',1,468,'Yes',2,0,70,53.51,25989.75,5443,1,3774,4,'HIGH','CIRA',1,1,'PULLIAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU12586',250,540,3,0,63290,'M','Programmer/Developer',1000,'NorthEast',1,250,'Yes',14,1,23,54.5,23622.5,273,2,154,5,'HIGH','CALVIN',1,1,'NAPIER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,5,'CU8290',4000,3200,5,1,54151,'M','IT Staff',2000,'Midwest',1,600,'Yes',2,1,26,54.72,13637.75,329,1,25,5,'LOW','RIGOBERTO',1,1,'JANSEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU13196',0,500,3,1,65843,'M','Programmer/Developer',1000,'NorthEast',0,0,'Yes',2,3,21,53.19,9060.75,136,2,25,3,'LOW','TREVOR',0,1,'MCGUIRE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NC',0,2,'CU11100',1700,1860,2,0,65311,'F','DBA',1000,'South',1,300,'Yes',12,2,42,54.84,27527.75,1229,1,25,5,'HIGH','MARI',1,1,'ADKINS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',11518,4,'CU3269',4000,5503,4,1,63979,'M','Not specified',800,'West',1,1803,'Yes',4,3,47,54.6,19694.75,27386,4,15060,5,'MEDIUM','DEMETRIUS',1,1,'ROONEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,1,'CU5655',8000,15100,1,1,47900,'F','Bank Teller',5000,'NorthEast',1,8000,'Yes',4,8,50,54.54,20475,36920,3,1148,5,'MEDIUM','DEBBRA',1,1,'FOSS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU1229',4388,16100,1,1,75264,'M','Secretary',3000,'West',1,3200,'Yes',13,4,60,59.99,28316,7999,5,25,7,'HIGH','DEANDRE',1,1,'FRANCO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,3,'CU9726',1834,640,3,0,57728,'M','Programmer/Developer',1000,'West',1,1834,'Yes',9,1,26,53.89,22532,158,2,29,4,'HIGH','SANG',1,1,'HAIRSTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU8976',1000,250,3,1,69707,'M','Programmer/Developer',1000,'West',1,1000,'Yes',8,3,23,53.72,20226.75,916,2,840,4,'MEDIUM','EDWARD',1,1,'ROSENTHAL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU15372',418,750,3,0,63734,'M','Programmer/Developer',1000,'NorthEast',1,418,'Yes',2,4,23,53.68,23733.5,435,3,25,4,'HIGH','IVAN',1,1,'CANTRELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','FL',0,1,'CU276',6000,16000,1,0,64053,'F','Not specified',1000,'South',2,4600,'Yes',2,0,57,56.97,40213.25,7574,1,26,6,'VERY HIGH','DEANNA',2,1,'BYERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','WA',56297,1,'CU868',15000,12500,1,1,65071,'F','IT Staff',500,'West',1,3000,'Yes',17,3,47,57.7,24467.75,59437,7,25,6,'HIGH','ANALISA',1,1,'BATEMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,3,'CU5976',1942,3300,3,1,66860,'M','Clerical',500,'West',2,1000,'Yes',2,0,34,53.35,30615,1200,3,64,3,'VERY HIGH','LEE',2,1,'HAYNES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','MI',0,1,'CU13417',10000,7300,1,0,67570,'F','Not specified',5000,'Midwest',1,10000,'Yes',4,1,68,56.41,32192.5,3327,4,25,6,'VERY HIGH','SHARI',1,1,'PARSONS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,2,'CU67',1500,5245,0,1,60455,'M','Administrative Assistant',900,'NorthEast',1,1545,'Yes',12,5,63,54.18,27413.75,2835,5,48,5,'HIGH','GRANT',1,1,'DURHAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','FL',0,4,'CU293',4000,3200,3,1,66389,'F','IT Staff',800,'South',1,400,'Yes',2,8,65,55.41,24097.25,2826,2,25,5,'HIGH','SHEMIKA',1,1,'LARA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',1570,2,'CU6366',0,24000,0,1,65182,'M','PROF-63',1100,'NorthEast',0,5000,'Yes',3,0,47,61.54,16995.5,22537,6,15469,7,'MEDIUM','GERALDO',0,1,'HALL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NC',0,1,'CU1872',2055,3850,1,1,63402,'F','Publisher',900,'South',1,1000,'Yes',12,2,58,54.7,25150.5,2044,1,25,5,'HIGH','ADA',1,1,'HIGGINBOTHAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU161',3000,6500,1,1,63071,'F','PROF-56',1100,'West',1,2200,'Yes',4,0,74,55.55,26667.75,2220,1,25,6,'HIGH','KESHIA',1,1,'BURKS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU10168',250,550,3,1,63911,'M','Programmer/Developer',1000,'West',1,250,'Yes',1,1,25,53.42,18977.75,270,2,25,4,'MEDIUM','CLIFF',1,1,'CORONA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,3,'CU15854',800,650,3,0,81909,'F','Lab Technician',2500,'South',1,800,'Yes',15,4,32,53.07,29177.25,188,2,25,1,'HIGH','FLORRIE',1,1,'CHENEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',344,1,'CU2098',3700,4200,1,1,58808,'M','Veterinarian',900,'NorthEast',1,3700,'Yes',2,0,33,54.39,21502,1648,3,98,5,'MEDIUM','AURELIO',1,1,'MAGUIRE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU13052',1100,850,3,1,69737,'M','Lab Technician',1000,'NorthEast',1,1100,'Yes',11,1,34,54.53,21334.25,442,3,25,5,'MEDIUM','JARVIS',1,1,'EDMONDSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OK',0,1,'CU3636',1000,2400,1,1,66941,'F','Not specified',500,'Midwest',1,400,'Yes',16,3,35,53.36,23735.25,770,1,55,3,'HIGH','ROWENA',1,1,'ESCOBEDO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','WA',0,1,'CU2377',5000,17700,1,1,61602,'F','PROF-59',1000,'West',1,4000,'Yes',2,1,51,58.59,24000.5,5765,5,25,6,'HIGH','UNA',1,1,'AKERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU7169',2794,3900,1,0,69144,'F','IT Staff',800,'NorthEast',1,300,'Yes',4,3,50,53.94,32286,622,1,25,4,'VERY HIGH','JOEANN',1,1,'COYLE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU7943',250,600,3,0,66785,'M','Programmer/Developer',1000,'NorthEast',1,250,'Yes',0,1,26,53.83,24796.25,357,2,25,4,'HIGH','JARRETT',1,1,'HUNT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU13568',4500,7000,1,1,56649,'F','PROF-1',3000,'West',1,1500,'Yes',7,1,39,55.11,21562.25,1821,4,25,5,'MEDIUM','CHRYSTAL',1,1,'GOLDSMITH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU5330',3650,4150,1,0,78240,'M','IT Staff',2000,'West',1,800,'Yes',2,2,36,54.04,31660,2015,1,25,5,'VERY HIGH','SHELBY',1,1,'BRYANT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11422',543,500,3,0,57911,'M','Programmer/Developer',1000,'NorthEast',1,543,'Yes',6,2,20,53.56,21977.75,242,2,25,4,'MEDIUM','COLLIN',1,1,'LADD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU15343',688,290,1,0,66397,'M','Cashier',700,'West',1,688,'Yes',16,4,31,53.26,28199.25,210,2,25,3,'HIGH','STACEY',1,1,'BOLTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,5,'CU10550',3000,1500,5,1,61624,'F','PROF-65',1500,'Midwest',1,500,'Yes',3,2,35,54.74,16406,301,3,59,5,'MEDIUM','SHERRIE',1,1,'IRVIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU9790',3000,5060,1,1,69445,'F','Not specified',800,'Midwest',1,1000,'Yes',3,6,45,55.9,25361.25,2974,4,126,6,'HIGH','KATTIE',1,1,'ROBERTSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MN',0,1,'CU13565',2680,1200,1,0,66789,'M','Childcare Worker',1500,'West',1,2680,'Yes',3,1,38,54.41,28997.25,993,3,25,5,'HIGH','JOHNNY',1,1,'FELICIANO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU9820',1200,500,3,0,67528,'M','PROF-37',800,'West',1,1200,'Yes',3,1,42,53.94,26582,724,2,25,4,'HIGH','RICARDO',1,1,'SALTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU8076',4000,1600,5,1,62171,'M','PROF-3',2000,'NorthEast',1,600,'Yes',3,10,23,55.14,15342.75,1558,1,25,5,'MEDIUM','VANCE',1,1,'DODD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,5,'CU8368',6000,4750,5,0,61960,'M','PROF-32',5000,'West',1,950,'Yes',5,1,25,54.96,20490,0,1,25,5,'MEDIUM','CLINTON',1,1,'SOUSA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU6103',0,450,3,0,64367,'M','Programmer/Developer',500,'West',0,0,'Yes',13,0,21,53.04,13691.75,737,2,25,2,'LOW','PHILLIP',0,1,'STRATTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU8122',3000,2710,3,0,65256,'F','Software Engineer',1500,'West',1,450,'Yes',12,1,63,54.46,28614,648,1,25,5,'HIGH','YELENA',1,1,'LANGE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU7417',1000,450,3,1,65797,'M','Programmer/Developer',1000,'NorthEast',1,1000,'Yes',18,1,24,53.11,19349.25,2720,2,2535,2,'MEDIUM','CLAUD',1,1,'MORRIS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU8952',240,290,3,1,59770,'M','Programmer/Developer',1000,'Midwest',1,240,'Yes',1,8,23,53.62,17742.5,280,2,25,4,'MEDIUM','LOU',1,1,'LANE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OR',0,2,'CU14798',0,650,2,0,60622,'M','Programmer/Developer',1000,'West',0,0,'Yes',14,2,25,53.29,14655.5,278,2,59,3,'MEDIUM','CARMEN',0,1,'GUEVARA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,3,'CU10835',1214,1650,3,1,59303,'M','Dentist',1000,'South',1,300,'Yes',4,1,26,54.22,17925.75,1086,3,25,5,'MEDIUM','SHIRLEY',1,1,'UNGER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU1947',3000,4800,1,1,66911,'M','IT Staff',500,'NorthEast',1,1000,'Yes',14,8,29,54.6,23127.75,2693,3,25,5,'HIGH','ABE',1,1,'WADE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','TX',0,1,'CU9731',2721,1500,1,0,68376,'F','Cashier',1000,'Southwest',1,400,'Yes',10,2,33,53.44,28894,218,3,25,4,'HIGH','VIKKI',1,1,'FOURNIER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU11970',0,750,3,1,60822,'M','Programmer/Developer',1000,'West',0,0,'Yes',2,4,22,53.04,7905.5,228,3,25,2,'LOW','JAMEL',0,1,'SINGH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,3,'CU10922',760,750,3,1,71767,'M','Programmer/Developer',1000,'NorthEast',1,760,'Yes',3,1,27,53.32,21141.75,262,3,25,3,'MEDIUM','COLE',1,1,'LYON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU6954',9500,7200,2,1,67461,'F','IT Staff',1500,'Midwest',1,1000,'Yes',5,1,32,64.02,21565.25,7679,4,25,7,'MEDIUM','AVIS',1,1,'MCMAHON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU6635',3200,3351,1,1,57459,'M','Medical Doctor',1000,'NorthEast',1,1,'Yes',4,2,33,54.32,22664.75,1895,2,25,5,'HIGH','MARY',1,1,'SADLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU13172',700,500,1,1,64092,'F','First-line Manager',600,'Midwest',1,700,'Yes',3,1,43,53.5,23823,215,2,25,4,'HIGH','TANEKA',1,1,'RUFF')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU3244',3000,16950,1,1,64557,'F','PROF-59',1000,'West',1,2800,'Yes',4,3,48,54.56,24439.25,2143,5,25,5,'HIGH','TA',1,1,'AMBROSE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MS',0,2,'CU141',3500,3500,2,1,66173,'F','IT Staff',900,'South',1,3500,'Yes',12,0,61,59.58,24643.25,2975,1,25,6,'HIGH','VASILIKI',1,1,'DAUGHERTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OH',0,3,'CU4476',900,600,3,1,68097,'M','Programmer/Developer',900,'Midwest',1,900,'Yes',10,2,23,53.52,19824.25,743,1,43,4,'MEDIUM','LENNY',1,1,'BENOIT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU8402',1000,700,1,1,61883,'F','PROF-52',1000,'West',1,1000,'Yes',10,1,34,53.94,22370.75,345,3,25,4,'HIGH','CAMERON',1,1,'CHRISTY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',0,5,'CU15988',2500,1200,5,0,81090,'F','Programmer/Developer',2500,'Southwest',1,400,'Yes',3,5,35,53.84,26272.5,135,3,25,4,'HIGH','VIVIEN',1,1,'WEAVER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,5,'CU14500',2000,5390,5,1,73082,'F','Clerical',1500,'West',1,2000,'Yes',2,1,30,59.09,18770.5,5311,4,25,6,'MEDIUM','JINNY',1,1,'DUARTE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WA',0,1,'CU6812',2500,3750,1,1,60705,'F','Sales Representative',1500,'West',1,750,'Yes',15,2,26,55.36,21276.25,2088,1,25,5,'MEDIUM','EASTER',1,1,'MARTIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,5,'CU13712',0,450,5,0,60275,'F','Programmer/Developer',1000,'NorthEast',0,0,'Yes',0,1,28,53.04,10368.75,369,2,25,2,'LOW','DAVID',0,1,'LAMBERT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU1304',2100,1900,3,1,55657,'M','Bank Teller',1500,'NorthEast',1,300,'Yes',2,2,32,53.41,17614.25,1539,1,111,4,'MEDIUM','JOSPEH',1,1,'FORBES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU9383',5162,13850,1,1,62502,'F','Publisher',800,'NorthEast',1,3000,'Yes',0,1,47,52.74,25325.5,151,5,25,2,'HIGH','KARINA',1,1,'NORWOOD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU4701',2332,3450,1,1,56599,'M','Publisher',1500,'West',1,950,'Yes',2,3,35,55.86,21149.75,2401,2,773,6,'MEDIUM','TORY',1,1,'REAGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NV',0,1,'CU2607',2500,4050,1,1,61781,'F','IT Staff',500,'Southwest',1,750,'Yes',7,2,53,53.73,24245.25,1538,1,131,4,'HIGH','CHRISTAL',1,1,'BLANTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU12743',700,250,1,0,67881,'F','Administrative Assistant',600,'West',1,700,'Yes',7,3,42,53.2,29670.25,137,2,25,3,'HIGH','GITA',1,1,'BURR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU14714',2000,8000,3,1,64335,'M','Administrator',1500,'NorthEast',1,2000,'Yes',2,6,30,54.35,19583.75,2040,4,1281,5,'MEDIUM','OSWALDO',1,1,'FISHER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU10110',1450,1450,5,0,63114,'F','Bank Teller',1500,'NorthEast',1,1450,'Yes',3,1,27,54.49,20978.5,2409,3,1540,5,'MEDIUM','LUELLA',1,1,'REEVES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU6668',2200,1550,1,1,59277,'F','First-line Manager',900,'NorthEast',1,500,'Yes',3,6,33,53.92,21619.25,1347,2,118,4,'MEDIUM','LOUETTA',1,1,'LEACH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,5,'CU14784',5000,4500,5,1,87936,'F','IT Staff',3500,'West',1,1500,'Yes',3,6,26,54.94,22084,1172,1,25,5,'HIGH','MARIEL',1,1,'CLEMONS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MO',0,3,'CU15177',0,750,3,0,60660,'M','Programmer/Developer',1000,'Midwest',0,0,'Yes',5,1,22,53.12,12865,0,3,30,2,'LOW','RORY',0,0,'COCHRAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU4152',2950,3750,1,1,65980,'M','PROF-8',900,'Midwest',1,650,'Yes',3,1,34,54.86,23395,2233,2,25,5,'HIGH','STANLEY',1,1,'FORREST')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NC',0,4,'CU9108',4000,8800,6,1,61332,'F','PROF-15',800,'South',1,1600,'Yes',1,1,66,54.97,16933,1923,4,25,5,'MEDIUM','MARGART',1,1,'CALDWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU12794',0,500,3,0,71812,'M','Programmer/Developer',1000,'NorthEast',0,0,'Yes',4,6,20,53.23,15453,130,2,30,3,'MEDIUM','LYLE',0,1,'TREVINO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU5596',0,19200,1,1,67232,'F','Software Engineer',1000,'West',0,4300,'Yes',4,0,70,60.07,17308,10075,2,65,7,'MEDIUM','TENESHA',0,1,'LITTLEJOHN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU12573',2500,2250,5,0,69807,'F','PROF-45',1000,'NorthEast',1,450,'Yes',2,1,65,53.17,26451.75,1029,1,42,2,'HIGH','THERSA',1,1,'LILLY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU2885',4000,7000,1,0,58116,'F','IT Staff',1000,'West',1,3000,'Yes',4,10,47,62.12,29229,10943,1,25,7,'HIGH','MARGART',1,1,'BOSTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WI',0,3,'CU8600',3500,3000,3,1,73727,'M','IT Staff',1500,'Midwest',1,550,'Yes',16,1,23,54.52,21231.75,1216,2,25,5,'MEDIUM','CALEB',1,1,'WITHERSPOON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU3850',1054,1250,1,1,66195,'F','Childcare Worker',500,'Midwest',1,1054,'Yes',3,3,35,53.45,23548.75,707,3,25,4,'HIGH','BERYL',1,1,'KEEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NV',0,1,'CU5599',4500,9204,1,1,66053,'F','Not specified',800,'Southwest',1,2004,'Yes',4,0,55,54.97,25513.25,7833,3,491,5,'HIGH','CANDYCE',1,1,'BRITTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU7962',1800,850,3,1,67329,'M','Lab Technician',1000,'West',2,250,'Yes',3,1,37,54.34,31532.25,687,1,337,5,'VERY HIGH','GREGORY',2,1,'STEVENSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU3942',3800,12500,1,0,58108,'F','Not specified',2000,'West',1,3800,'Yes',9,1,50,56.54,28027,2209,4,268,6,'HIGH','KAYLEE',1,1,'AGUILERA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MN',0,1,'CU4299',1200,3250,1,1,66803,'F','PROF-62',500,'West',1,600,'Yes',4,1,48,54.29,25000.75,1256,1,137,5,'HIGH','JACINTA',1,1,'SEWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU4155',4000,3061,1,1,66682,'F','IT Staff',1000,'West',1,1,'Yes',1,3,39,55.62,24070.5,2724,1,25,6,'HIGH','BONITA',1,1,'KANG')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,3,'CU1005',1200,3000,3,1,80121,'M','Clerical',2500,'South',1,1200,'Yes',1,0,50,54.21,25530.25,787,1,25,5,'HIGH','SHERMAN',1,1,'HEMPHILL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU5403',1536,2749,1,1,61979,'M','DBA',1500,'Midwest',1,599,'Yes',4,0,28,53.39,21794.75,1290,1,185,4,'MEDIUM','MAXIMO',1,1,'JUDD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','TX',0,1,'CU15326',3000,3850,1,0,63793,'F','Medical Doctor',1000,'Southwest',1,750,'Yes',10,2,39,54.25,28348.25,853,1,25,5,'HIGH','ELEONOR',1,1,'SEWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU10154',1500,1300,3,1,66583,'M','Lab Technician',1000,'NorthEast',1,300,'Yes',6,1,27,53.41,19845.75,1614,1,1262,4,'MEDIUM','WAYLON',1,1,'DOWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14434',0,600,3,0,61564,'M','Programmer/Developer',1000,'West',0,0,'Yes',4,1,24,53.43,13291,0,2,25,4,'LOW','LANCE',0,0,'ESPINOSA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU6560',1100,1100,4,1,65853,'M','Programmer/Developer',700,'West',1,200,'Yes',17,1,44,53.68,19863.25,476,3,25,4,'MEDIUM','AHMED',1,1,'MANUEL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU12842',2144,4600,1,1,70198,'F','PROF-32',1500,'NorthEast',1,600,'Yes',2,1,39,53.41,24949.5,2538,1,25,4,'HIGH','MAGAN',1,1,'SMALL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU6165',3500,3000,5,1,76204,'F','Truck Driver',1500,'NorthEast',1,1000,'Yes',2,2,25,53.08,19051,576,3,25,1,'MEDIUM','MICHAL',1,1,'MINER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU11570',0,500,3,0,67190,'M','Programmer/Developer',1000,'South',0,0,'Yes',2,1,24,53.5,14697.5,186,2,25,4,'MEDIUM','AGUSTIN',0,1,'LOVE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU12738',2200,1500,1,0,60526,'F','PROF-1',1500,'NorthEast',1,300,'Yes',17,1,35,53.96,27131.5,293,3,25,5,'HIGH','PIPER',1,1,'DUBE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU8340',4600,4100,1,1,72361,'F','Truck Driver',3000,'NorthEast',1,1300,'Yes',2,2,29,58.73,24490.25,2856,1,25,6,'HIGH','BERENICE',1,1,'STERLING')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,1,'CU3654',5000,11001,1,1,66118,'F','Publisher',3500,'NorthEast',1,1,'Yes',3,3,50,58.44,25029.5,6894,4,25,6,'HIGH','KARLYN',1,1,'ARNOLD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU14052',1254,750,6,0,68357,'M','Author',1500,'West',1,250,'Yes',2,1,58,53.22,22889.25,166,3,25,3,'HIGH','LEONARDO',1,1,'CROWE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU7502',0,750,3,0,59865,'M','Programmer/Developer',1000,'Midwest',0,0,'Yes',1,8,24,53.11,12866.25,0,3,25,2,'LOW','ZACHARIAH',0,0,'SNOW')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU4285',6000,12001,1,1,48811,'F','IT Staff',5000,'NorthEast',1,1,'Yes',1,1,48,61.44,20502.75,7283,4,25,7,'MEDIUM','MARYROSE',1,1,'MULLINS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU4679',3063,2900,1,1,60271,'M','PROF-9',900,'West',1,3063,'Yes',3,0,36,54.51,22167.75,1311,1,25,5,'HIGH','RUDY',1,1,'HERMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,2,'CU5082',885,2820,0,1,61440,'M','Accountant',700,'West',1,720,'Yes',4,0,32,53.09,24560,669,1,25,1,'HIGH','NATHAN',1,1,'HAGEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU14911',713,750,3,0,63581,'M','PROF-20',1000,'West',1,713,'Yes',17,1,20,53.21,23395.25,261,3,105,3,'HIGH','LOYD',1,1,'BIRD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU2394',2000,4600,1,1,75811,'F','Author',1500,'NorthEast',1,800,'Yes',3,2,52,56.33,27652.75,3706,1,147,6,'HIGH','HOLLEY',1,1,'CRAMER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WI',0,3,'CU15786',550,750,3,0,70954,'M','Secretary',1000,'Midwest',1,550,'Yes',5,5,22,53.35,25438.5,237,3,25,3,'HIGH','DUNCAN',1,1,'COSTA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,4,'CU10861',1500,591,6,1,69237,'F','PROF-2',1000,'West',1,1,'Yes',4,1,70,53.78,19309.25,159,2,25,4,'MEDIUM','ANNITA',1,1,'HAGEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU9868',700,460,3,0,57796,'M','PROF-12',1500,'NorthEast',1,700,'Yes',2,1,29,53.85,22849,378,2,25,4,'HIGH','KING',1,1,'REEDER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',0,1,'CU8647',5000,4900,1,0,66166,'F','Law Enforcement Officer',3500,'South',1,850,'Yes',3,1,31,56.69,28141.5,1312,1,27,6,'HIGH','LOUIE',1,1,'LINN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU5473',2500,3601,3,1,64812,'M','Cashier',800,'NorthEast',1,1,'Yes',1,0,42,53.3,20903,550,1,25,3,'MEDIUM','EVERETT',1,1,'ALVARADO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,3,'CU10161',400,700,3,1,69202,'M','Programmer/Developer',1000,'West',1,400,'Yes',11,1,26,53.17,20400.5,242,3,25,2,'MEDIUM','PATRICK',1,1,'HOGUE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','MI',0,4,'CU6234',5000,9850,6,0,71028,'F','IT Staff',1300,'Midwest',2,1500,'Yes',4,0,71,52.83,34857,3005,4,632,2,'VERY HIGH','LINDSAY',2,1,'WESLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU12312',0,500,3,0,55286,'M','Programmer/Developer',1500,'Midwest',0,0,'Yes',7,4,22,53.19,11521.5,125,2,25,3,'LOW','IRA',0,1,'QUARLES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,4,'CU975',4500,6600,6,1,75630,'F','PROF-8',1800,'Midwest',1,2000,'Yes',2,6,51,56.99,19007.5,2321,5,736,6,'MEDIUM','KAYLA',1,1,'GILL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU7799',0,500,3,0,60948,'M','Programmer/Developer',600,'West',0,0,'Yes',15,1,32,53.56,13937,196,2,25,4,'LOW','MARQUIS',0,1,'MORGAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','IL',0,1,'CU2753',3500,1800,1,1,60411,'F','Truck Driver',1000,'Midwest',1,600,'Yes',2,2,41,54.27,22702.75,2086,3,25,5,'HIGH','WAI',1,1,'RANDOLPH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU11667',1350,1050,4,0,54344,'F','Construction Laborer',2500,'NorthEast',1,1350,'Yes',3,4,31,53.46,20686,211,3,25,4,'MEDIUM','CAMILLA',1,1,'OCHOA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MS',0,2,'CU12797',2500,3500,1,1,64494,'M','Waiter/Waitress',1000,'South',1,2500,'Yes',2,1,22,56.98,22323.5,1156,1,25,6,'HIGH','JAIME',1,1,'CRISP')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU12915',850,870,3,1,66930,'M','PROF-11',600,'NorthEast',2,850,'Yes',6,1,34,53.81,30632.5,593,3,25,4,'VERY HIGH','DARIO',2,1,'MANNING')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','FL',0,1,'CU3134',4600,4710,1,1,64347,'F','IT Staff',500,'South',1,1300,'Yes',4,2,46,55.5,24186.75,3508,1,25,6,'HIGH','DELPHA',1,1,'ELMORE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','MN',0,5,'CU3619',20000,17550,5,0,78250,'F','Homemaker',4000,'West',1,1700,'Yes',13,3,38,53.62,25862.5,2151,1,886,4,'HIGH','SHELA',1,1,'HANNAH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,3,'CU11176',0,750,3,0,63221,'M','Programmer/Developer',1000,'Midwest',0,0,'Yes',2,2,27,53.02,14005.25,101,3,25,2,'MEDIUM','JAIME',0,1,'BEGAY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','OR',0,3,'CU7973',724,650,3,0,61495,'M','Programmer/Developer',1000,'West',1,724,'Yes',3,1,29,54,23773.75,318,2,25,5,'HIGH','HUEY',1,1,'CHILDRESS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,2,'CU5376',5000,11350,0,1,49516,'M','PROF-24',3500,'NorthEast',1,2650,'Yes',7,0,44,54.17,22779,871,4,25,5,'HIGH','LUCAS',1,1,'MEDRANO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','FL',0,1,'CU13601',2000,2330,1,1,71083,'F','IT Staff',1000,'South',1,400,'Yes',4,1,33,54.42,24570.75,1247,1,25,5,'HIGH','REBEKAH',1,1,'STARNES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,2,'CU7015',1233,600,1,0,57079,'F','Sales Representative',1300,'Midwest',1,1233,'Yes',4,1,37,53.68,26969.75,838,2,25,4,'HIGH','MARGRET',1,1,'BUNDY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','FL',0,4,'CU985',4000,8350,3,1,64533,'F','Homemaker',500,'South',1,4000,'Yes',1,0,50,53.17,22133.25,567,4,25,2,'HIGH','STEPHANY',1,1,'RUDOLPH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU7294',2000,9800,1,1,67738,'F','Publisher',1500,'NorthEast',1,2600,'Yes',3,1,36,52.41,24034.5,2185,4,25,2,'HIGH','KERRIE',1,1,'TOMPKINS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,4,'CU8598',2000,1200,3,1,69293,'M','PROF-49',1500,'West',1,2000,'Yes',4,2,39,53.33,22223.25,251,3,25,3,'HIGH','JOHNATHAN',1,1,'STEELE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,2,'CU3237',0,2318,0,0,74392,'M','Nurse',1300,'West',0,768,'Yes',2,3,37,54.21,23298,1558,1,25,5,'HIGH','SETH',0,1,'ACEVEDO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU11608',2450,2050,1,0,73126,'F','Lab Technician',1500,'NorthEast',1,450,'Yes',18,1,33,54.76,30081.5,1314,1,25,5,'VERY HIGH','GENE',1,1,'NORRIS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU12512',0,500,3,0,67190,'M','Programmer/Developer',1000,'NorthEast',0,0,'Yes',8,1,20,53.05,14297.5,11602,2,11581,2,'MEDIUM','ISAIAS',0,1,'MONTANO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',83282,1,'CU5807',8000,10049,1,1,58210,'M','PROF-9',900,'NorthEast',1,8000,'Yes',2,0,42,53.6,22252.5,87304,4,2129,4,'HIGH','MICAH',1,1,'GARZA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','OH',0,4,'CU1965',3500,1950,4,1,63241,'M','Truck Driver',500,'Midwest',1,550,'Yes',3,2,36,54.67,18410.25,1787,1,25,5,'MEDIUM','WALDO',1,1,'DOLAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',12034,5,'CU8296',11000,22000,5,1,89385,'F','Veterinarian',5000,'West',1,5000,'Yes',3,2,42,53.82,24046.25,12933,5,419,4,'HIGH','ANTONETTE',1,1,'GATLIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU15411',0,500,3,0,65300,'M','Programmer/Developer',1000,'West',0,0,'Yes',5,2,23,53.19,14125,0,2,41,3,'MEDIUM','EDWIN',0,0,'BLEVINS')
SELECT * FROM DUAL;
INSERT ALL
    INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,3,'CU1732',3000,3800,3,1,65571,'M','PROF-16',900,'NorthEast',1,3000,'Yes',4,9,36,54.36,20492.75,9120,4,7348,5,'MEDIUM','SCOT',1,1,'MCNAMARA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU7828',1000,500,3,0,75218,'M','Administrative Assistant',1500,'NorthEast',1,1000,'Yes',15,1,18,53.04,26104.5,113,2,25,2,'HIGH','MCKINLEY',1,1,'BUNCH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU3434',5000,3000,1,1,53702,'F','IT Staff',3000,'NorthEast',2,800,'Yes',4,9,45,56.06,31425.5,2702,1,866,6,'VERY HIGH','EMMALINE',2,1,'SAYLOR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU2110',5000,7500,1,1,67543,'F','IT Staff',3000,'NorthEast',1,1500,'Yes',2,2,41,57.32,24485.75,5126,4,287,6,'HIGH','ERNESTINE',1,1,'HORTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU10119',0,600,3,1,66012,'M','Programmer/Developer',1500,'NorthEast',0,0,'Yes',4,1,26,53.23,9603,173,2,89,3,'LOW','ALEC',0,1,'GAGNE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,3,'CU13588',350,500,3,0,54915,'M','Programmer/Developer',1500,'West',1,350,'Yes',4,1,27,53.34,21928.75,0,2,25,3,'MEDIUM','BURTON',1,1,'PARSONS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WI',0,5,'CU11688',2215,2100,5,0,58593,'F','PROF-1',2500,'Midwest',1,400,'Yes',3,4,36,54.12,20748.25,662,1,25,5,'MEDIUM','JANNA',1,1,'FLETCHER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NC',0,4,'CU5758',356,904,3,0,63917,'M','Author',600,'South',1,404,'Yes',17,0,72,53.12,29179.25,898,3,224,2,'HIGH','ALFRED',1,1,'COVINGTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MN',0,5,'CU8144',1200,850,5,0,63700,'F','Waiter/Waitress',1500,'West',1,1200,'Yes',0,1,37,53.08,22125,0,3,25,1,'HIGH','STEPHINE',1,1,'MCCARTHY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,3,'CU12577',300,750,3,0,63567,'M','Programmer/Developer',1000,'West',1,300,'Yes',16,2,25,53.12,23891.75,195,3,46,2,'HIGH','NIGEL',1,1,'REAVES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,1,'CU840',5000,16800,1,1,47113,'F','Clerical',3500,'NorthEast',1,3100,'Yes',3,0,64,53.1,21678.25,670,4,25,2,'MEDIUM','CRISELDA',1,1,'LAMBERT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14912',250,750,3,0,62293,'M','Programmer/Developer',1000,'West',1,250,'Yes',3,1,22,53.26,23273.25,213,3,25,3,'HIGH','JAMAAL',1,1,'GANN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,5,'CU12021',4500,2400,5,0,65707,'M','PROF-8',3000,'West',1,4500,'Yes',4,3,31,53.53,22026.75,269,1,25,4,'HIGH','ERICK',1,1,'MOBLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,5,'CU10386',4000,2200,5,1,70951,'F','School Teacher',1500,'Midwest',1,4000,'Yes',3,1,35,54.58,18737.75,1044,2,25,5,'MEDIUM','CECILE',1,1,'FONTENOT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','MI',0,1,'CU793',6705,24600,1,1,61057,'F','Software Engineer',800,'Midwest',1,4600,'Yes',4,0,60,73.61,24764.25,14975,5,25,8,'HIGH','NERISSA',1,1,'BRUNO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU10041',700,250,3,0,74170,'M','Programmer/Developer',1500,'West',1,700,'Yes',3,8,33,53.07,27342.5,702,2,25,1,'HIGH','ROBERTO',1,1,'HARDEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU8038',1350,1050,1,1,64751,'M','Dentist',1000,'NorthEast',1,1350,'Yes',15,1,29,54.75,22587.75,723,3,25,5,'HIGH','GAYLORD',1,1,'RASMUSSEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU13259',1000,700,3,0,67126,'M','Programmer/Developer',700,'NorthEast',1,1000,'Yes',12,1,36,53.24,25881.5,211,3,25,3,'HIGH','GRADY',1,1,'STARK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,3,'CU15002',1000,250,3,0,64418,'M','First-line Manager',1000,'NorthEast',1,1000,'Yes',16,6,26,53.63,24204.5,206,2,25,4,'HIGH','SALVADOR',1,1,'LEARY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU6614',1265,1400,1,1,68179,'M','DBA',900,'West',1,1265,'Yes',16,1,33,53.95,23844.75,1190,1,25,4,'HIGH','RICKY',1,1,'HURT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11541',480,750,3,0,61988,'M','Programmer/Developer',1000,'NorthEast',1,480,'Yes',15,1,24,53.69,23397,134,3,25,4,'HIGH','LINCOLN',1,1,'ROMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NC',0,1,'CU3801',10000,21600,1,1,63663,'F','IT Staff',500,'South',1,4000,'Yes',2,6,37,63.33,23115.75,8613,5,136,7,'HIGH','BELLE',1,1,'HARDIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU14339',1000,400,3,0,61478,'M','Sales Representative',1000,'Midwest',1,1000,'Yes',2,2,21,53.42,22969.5,135,2,113,4,'HIGH','LUCAS',1,1,'DORAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU11632',250,250,3,0,71929,'M','Programmer/Developer',1000,'West',1,250,'Yes',9,1,21,53.04,25582.25,197,2,25,2,'HIGH','GRANVILLE',1,1,'SHEFFIELD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',469,4,'CU3373',5500,15000,6,1,64786,'F','IT Staff',5000,'NorthEast',1,3500,'Yes',4,2,51,53.79,16296.5,3110,5,44,4,'MEDIUM','VADA',1,1,'CRENSHAW')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,1,'CU3592',5000,7800,1,0,74625,'F','IT Staff',1400,'West',1,5000,'Yes',4,3,45,53.33,31656.25,668,4,25,3,'VERY HIGH','SHERRON',1,1,'DRAKE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,2,'CU1590',868,3007,0,1,59409,'M','Cashier',900,'NorthEast',1,607,'Yes',3,0,53,53.26,26152.25,1032,1,25,3,'HIGH','SANTO',1,1,'FRY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','OR',75491,1,'CU5992',4000,9100,1,0,66000,'M','Not specified',900,'West',2,3300,'Yes',2,0,43,54.43,39300,77470,4,1428,5,'VERY HIGH','CHRISTOPER',2,1,'HAMMOND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU5870',2000,1050,5,1,70482,'F','Sales Representative',1500,'NorthEast',1,300,'Yes',3,0,40,53.55,19120.5,998,1,25,4,'MEDIUM','JOLIE',1,1,'DARDEN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU2134',10000,16201,5,1,71060,'M','Clerical',1000,'NorthEast',1,1,'Yes',3,2,32,56.21,18465,8268,3,997,6,'MEDIUM','DARRELL',1,1,'CARLTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,2,'CU5091',0,5166,0,0,62222,'M','PROF-45',900,'NorthEast',0,2166,'Yes',2,0,39,53.58,20455.5,4983,4,25,4,'MEDIUM','DONOVAN',0,1,'DUNHAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU5282',200,650,3,0,60268,'M','Programmer/Developer',900,'West',1,200,'Yes',6,6,35,53.34,24067,348,2,25,3,'HIGH','DARRON',1,1,'PARRISH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU6578',700,500,3,1,65270,'F','IT Staff',900,'Midwest',1,700,'Yes',2,1,38,53.37,20617.5,0,2,25,3,'MEDIUM','ALIZA',1,1,'BILLINGS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,5,'CU14632',550,300,5,0,61167,'F','Dentist',1000,'NorthEast',1,550,'Yes',3,1,25,53.48,20291.75,311,2,25,4,'MEDIUM','ELOUISE',1,1,'ZUNIGA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',5079,1,'CU6503',12000,27000,1,1,76669,'F','Publisher',4000,'Midwest',1,5000,'Yes',2,1,47,54.45,27367.25,29601,5,23093,5,'HIGH','REMEDIOS',1,1,'STATON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU12010',1600,8000,1,1,54792,'M','Clerical',1500,'Midwest',1,2000,'Yes',12,4,43,55.03,21498,2176,4,25,5,'MEDIUM','JASON',1,1,'CORCORAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU5120',2000,2000,1,1,70092,'F','PROF-26',900,'NorthEast',1,400,'Yes',2,6,39,55.15,24923,1418,3,25,5,'HIGH','LEILA',1,1,'MATOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,1,'CU15325',800,1100,1,1,60781,'M','Waiter/Waitress',700,'NorthEast',1,800,'Yes',3,4,39,53.35,22595.25,323,3,25,3,'HIGH','CARMINE',1,1,'BREWSTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,3,'CU8599',2000,1850,3,1,67054,'M','Cashier',1500,'NorthEast',1,2000,'Yes',4,1,35,55.13,20763.5,914,3,25,5,'MEDIUM','STERLING',1,1,'SCHULTZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU2194',1000,1972,3,0,68515,'M','Waiter/Waitress',1000,'West',1,522,'Yes',2,2,39,53.48,26528.75,807,1,25,4,'HIGH','DIRK',1,1,'WEBSTER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WI',0,1,'CU15061',3570,5100,1,1,59371,'F','DBA',1000,'Midwest',1,1500,'Yes',5,3,48,55.05,23142.75,1967,2,1149,5,'HIGH','LEOLA',1,1,'STRANGE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU4913',1800,2050,3,0,62921,'M','Programmer/Developer',500,'Midwest',1,350,'Yes',3,3,31,54.56,24330.25,1250,3,25,5,'HIGH','ARTHUR',1,1,'WOODY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14853',0,500,3,0,63784,'M','Programmer/Developer',1000,'NorthEast',0,0,'Yes',3,6,21,53.3,13546,201,2,25,3,'LOW','TONY',0,1,'CHILDS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU13817',1050,500,3,0,71650,'M','PROF-18',1000,'West',1,1050,'Yes',9,1,28,53.15,26212.5,0,2,25,2,'HIGH','SANTOS',1,1,'BERNSTEIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','WI',0,4,'CU4126',4000,3400,4,1,69586,'F','Programmer/Developer',900,'Midwest',1,4000,'Yes',4,1,22,53.74,18596.5,1775,1,26,4,'MEDIUM','KATRINA',1,1,'MARTINEZ')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OH',0,3,'CU13373',0,500,3,1,74119,'M','Programmer/Developer',1500,'Midwest',0,0,'Yes',4,1,27,53.03,11729.75,145,2,25,2,'LOW','RAYMOND',0,1,'MCCRAY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU6380',2500,2550,1,1,66526,'F','PROF-16',500,'Midwest',2,750,'Yes',3,0,32,54.6,33331.5,1401,1,25,5,'VERY HIGH','CORTNEY',2,1,'SADLER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MN',0,4,'CU267',3200,2968,3,1,64632,'M','PROF-8',1000,'West',1,1087,'Yes',2,0,73,54.93,24458,2276,1,542,5,'HIGH','ADOLPH',1,1,'CORREA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU2361',500,500,3,0,60651,'M','Programmer/Developer',500,'NorthEast',1,500,'Yes',12,3,25,53.37,23162.75,180,2,25,3,'HIGH','NICKY',1,1,'OVERTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,1,'CU11797',3100,5200,1,0,64951,'F','Not specified',1000,'NorthEast',1,2400,'Yes',2,4,57,55.04,30437.75,2618,4,25,5,'VERY HIGH','RENETTA',1,1,'JEFFERSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,5,'CU225',3500,3100,5,0,63299,'F','Veterinarian',2000,'West',1,1000,'Yes',2,0,29,54.99,21224.75,1046,1,25,5,'MEDIUM','BARBAR',1,1,'DRISCOLL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','DC',0,4,'CU11596',1600,1250,3,1,65689,'M','PROF-8',1500,'NorthEast',1,1600,'Yes',12,1,39,54.64,21322.25,441,3,25,5,'MEDIUM','LES',1,1,'FINLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU11214',1300,750,1,0,71733,'F','DBA',1500,'Midwest',1,1300,'Yes',8,1,31,53.57,29533.25,333,3,25,4,'HIGH','CARIE',1,1,'ASHBY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU967',1800,4750,1,1,68848,'F','PROF-15',1500,'NorthEast',1,850,'Yes',5,0,69,54.27,27612,1392,1,95,5,'HIGH','BUFFY',1,1,'WANG')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,5,'CU685',5000,2401,5,0,72236,'F','Software Engineer',3000,'NorthEast',1,1,'Yes',4,0,37,56.61,24259,3702,1,25,6,'HIGH','MARYLOUISE',1,1,'MYERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NV',0,1,'CU15165',1000,500,1,1,60676,'M','IT Staff',1000,'Southwest',1,1000,'Yes',2,1,20,54.39,20669,444,2,333,5,'MEDIUM','LYNDON',1,1,'ARELLANO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','OH',0,3,'CU9932',0,700,3,1,58796,'M','Programmer/Developer',1000,'Midwest',0,0,'Yes',5,1,25,53.38,7699,250,3,25,3,'LOW','ARNOLD',0,1,'HALL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU12479',1107,650,3,0,64674,'M','Fireman',1000,'NorthEast',1,1107,'Yes',1,1,21,53.21,23768.5,0,2,25,3,'HIGH','BENITO',1,1,'CRANDALL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU8259',0,540,3,0,68654,'M','Programmer/Developer',1000,'West',0,0,'Yes',17,1,21,53.39,14763.5,246,2,25,4,'MEDIUM','CHET',0,1,'MCRAE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU13121',0,250,3,0,65822,'M','Programmer/Developer',600,'West',0,0,'Yes',6,1,42,53.02,16155.5,0,1,25,2,'MEDIUM','DUSTIN',0,0,'BEST')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MS',0,1,'CU14887',10000,9000,1,1,62345,'F','IT Staff',5000,'South',1,3000,'Yes',1,1,48,58.5,23886.25,4993,4,25,6,'HIGH','BRONWYN',1,1,'HINOJOSA')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,3,'CU13802',2229,1850,3,1,69357,'M','Dentist',1500,'West',1,600,'Yes',18,3,32,54.29,21039.25,483,1,300,5,'MEDIUM','WARD',1,1,'SHIPLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','FL',0,5,'CU15049',4000,2000,5,1,64514,'M','PROF-8',1000,'South',1,600,'Yes',2,1,53,53.96,18928.5,1193,1,25,5,'MEDIUM','ALFONSO',1,1,'LANKFORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU15087',300,500,3,1,61242,'M','Veterinarian',1000,'NorthEast',1,300,'Yes',11,1,21,53.07,17910.5,234,2,25,1,'MEDIUM','RUSSELL',1,1,'ELDER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU10303',2200,2100,1,1,63131,'M','Lab Technician',1500,'West',2,2200,'Yes',4,2,33,53.2,32582.75,776,1,456,3,'VERY HIGH','DONG',2,1,'HOYT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,1,'CU6950',4000,3500,1,1,56504,'F','IT Staff',1500,'NorthEast',1,600,'Yes',3,1,27,53.56,20326,2594,1,25,4,'MEDIUM','DEANNA',1,1,'MARIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU8084',5000,8800,1,1,66604,'F','IT Staff',1600,'Midwest',1,2000,'Yes',7,1,38,61.99,23951,6209,4,25,7,'HIGH','LEEANNA',1,1,'GUINN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NC',0,3,'CU12786',300,700,3,0,64804,'M','Programmer/Developer',1000,'South',1,300,'Yes',17,1,24,53.5,24101,292,1,25,4,'HIGH','EMORY',1,1,'PARRISH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU11391',400,500,3,0,62070,'M','Programmer/Developer',1000,'NorthEast',1,400,'Yes',14,4,24,53.13,23417.5,111,2,67,2,'HIGH','JEREMIAH',1,1,'MCCLOUD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,1,'CU14874',3000,950,1,1,64432,'F','First-line Manager',1500,'Midwest',1,450,'Yes',4,9,54,57.21,25008,989,3,25,6,'HIGH','REGINE',1,1,'VALENTIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,4,'CU4441',2000,1100,3,1,58000,'F','PROF-6',900,'Midwest',1,2000,'Yes',3,3,35,54.57,19000,842,3,25,5,'MEDIUM','CATALINA',1,1,'RIOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU1750',2500,3862,1,0,62640,'F','PROF-15',500,'West',1,975,'Yes',14,2,58,54.23,29960,1261,1,36,5,'HIGH','MARILEE',1,1,'MAYS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU13533',0,500,3,0,59867,'M','Programmer/Developer',1000,'NorthEast',0,0,'Yes',4,1,21,53.69,12566.75,202,2,25,4,'LOW','FREDDY',0,1,'PAYNE')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,3,'CU5318',1200,1668,3,0,58393,'M','Plumber',800,'Midwest',1,468,'Yes',4,0,43,53.82,24398.25,1071,1,25,4,'HIGH','TYREE',1,1,'DIEHL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU1494',2277,3550,1,1,58012,'M','Not specified',1500,'NorthEast',1,350,'Yes',4,0,34,53.7,22903,1210,1,25,4,'HIGH','WARNER',1,1,'MARINO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','FL',0,3,'CU11412',0,500,3,0,64738,'M','Programmer/Developer',1000,'South',0,0,'Yes',4,4,21,53.02,13784.5,539,2,25,2,'LOW','JEWELL',0,1,'FONTENOT')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,4,'CU2977',2000,1000,3,1,59893,'F','Truck Driver',900,'NorthEast',1,2000,'Yes',11,3,36,56.73,19573.25,1399,3,25,6,'MEDIUM','GOLDIE',1,1,'MORAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU10728',700,600,1,0,64581,'M','Childcare Worker',600,'NorthEast',1,700,'Yes',6,1,32,53.22,27845.25,0,1,66,3,'HIGH','REID',1,1,'PRADO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NC',0,3,'CU8369',0,500,3,0,64589,'M','Programmer/Developer',1000,'South',0,0,'Yes',3,2,20,53.46,13647.25,213,2,25,4,'LOW','ELLIS',0,1,'CHOI')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU1937',1000,850,3,0,64000,'M','PROF-20',900,'NorthEast',1,1000,'Yes',4,2,26,53.64,24100,772,3,25,4,'HIGH','JAMAL',1,1,'ATWOOD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU13368',1000,450,3,0,73216,'M','Sales Representative',1500,'NorthEast',1,1000,'Yes',15,2,22,53.28,26004,168,2,25,3,'HIGH','BOYCE',1,1,'LEMONS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,1,'CU2685',3000,4500,1,1,67355,'F','IT Staff',1200,'West',1,900,'Yes',4,7,55,53.74,25838.75,2502,1,601,4,'HIGH','TOBI',1,1,'STEPHENSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',0,3,'CU10536',2500,5801,3,0,68374,'M','PROF-46',1500,'Southwest',1,1,'Yes',14,7,34,54.78,25993.5,2871,4,25,5,'HIGH','CLINT',1,1,'GALLEGOS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',28273,1,'CU5303',6767,16900,1,1,80967,'F','Clerical',5000,'NorthEast',1,4200,'Yes',2,2,50,54.89,28741.75,31483,5,25,5,'HIGH','NUBIA',1,1,'HAMBY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,1,'CU8235',700,400,1,0,59334,'M','PROF-16',600,'NorthEast',1,700,'Yes',9,1,42,53.37,27533.5,265,2,25,3,'HIGH','SPENCER',1,1,'FARRIS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NV',0,1,'CU1941',1500,3070,1,1,72642,'F','Waiter/Waitress',1500,'Southwest',1,1000,'Yes',3,1,55,55.08,27160.5,2312,1,25,5,'HIGH','REBA',1,1,'HAND')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,1,'CU3379',5000,7390,1,1,69094,'M','PROF-8',900,'NorthEast',1,3000,'Yes',3,2,51,56.85,25873.5,6489,4,25,6,'HIGH','DEANDRE',1,1,'WINN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','UT',0,4,'CU6953',3700,8500,1,1,64769,'F','Veterinarian',1400,'Southwest',1,1400,'Yes',3,1,33,56.65,24492.25,2936,3,229,6,'HIGH','MADALYN',1,1,'MAJOR')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU3818',2700,1550,1,1,68197,'F','PROF-31',1500,'NorthEast',1,400,'Yes',3,2,47,53.12,25249.25,769,1,25,2,'HIGH','MARIELA',1,1,'BRYSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,5,'CU7700',2000,1900,5,1,57185,'F','Lab Technician',1000,'NorthEast',1,2000,'Yes',2,1,39,53.94,15696.25,869,1,25,4,'MEDIUM','GWENDOLYN',1,1,'MELVIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','IL',0,3,'CU15509',0,500,3,0,67791,'M','Programmer/Developer',1000,'Midwest',0,0,'Yes',3,3,21,53.15,14547.75,134,2,25,2,'MEDIUM','DION',0,1,'HELMS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','NY',0,1,'CU3894',5000,17500,1,1,90725,'M','PROF-16',3000,'NorthEast',1,3500,'Yes',2,3,51,57.55,31281.25,8091,4,25,6,'VERY HIGH','HERMAN',1,1,'MCNALLY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','IL',0,3,'CU8867',500,300,3,1,63597,'M','Programmer/Developer',1500,'Midwest',1,500,'Yes',13,3,22,53.17,18599.25,322,2,67,2,'MEDIUM','ENOCH',1,1,'HIGH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU14704',0,700,3,0,59710,'M','Programmer/Developer',1000,'West',0,0,'Yes',9,1,27,53.22,13127.5,268,3,25,3,'LOW','LIONEL',0,1,'WILCOX')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,2,'CU4955',2000,1600,2,1,58892,'F','PROF-55',900,'NorthEast',1,2000,'Yes',2,0,49,53.3,21623,1308,1,25,3,'MEDIUM','SILVA',1,1,'DODSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',24,3,'CU12535',0,650,3,0,59086,'M','Programmer/Developer',1000,'NorthEast',0,0,'Yes',2,1,22,53.15,12471.5,860,2,735,2,'LOW','RALEIGH',0,1,'NIXON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NC',0,4,'CU13302',845,500,3,0,65950,'M','Sales Representative',600,'South',1,845,'Yes',8,2,37,54.08,26187.5,480,2,25,5,'HIGH','FREEMAN',1,1,'LYNCH')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,4,'CU4645',3230,5500,1,1,61064,'F','PROF-21',800,'NorthEast',1,2000,'Yes',3,0,49,55.51,25166,2644,2,25,6,'HIGH','TAWNYA',1,1,'RIDLEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','WI',0,3,'CU14951',0,550,3,1,61217,'M','Programmer/Developer',1000,'Midwest',0,0,'Yes',18,8,25,53.34,8304.25,155,2,25,3,'LOW','DICK',0,1,'CLIFTON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('WIDOWED','CA',0,2,'CU1591',6000,10200,2,1,62229,'F','IT Staff',500,'West',1,3000,'Yes',5,0,69,53.75,24457.25,2568,4,860,4,'HIGH','MARYBELLE',1,1,'DELGADO')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('OTHER','CA',0,1,'CU396',15000,9000,1,0,68194,'F','IT Staff',5000,'West',1,3000,'Yes',3,0,53,54.49,30848.5,2680,4,25,5,'VERY HIGH','MARIO',1,1,'HICKEY')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,1,'CU2107',1000,800,1,0,69487,'F','Lab Technician',800,'Midwest',1,1000,'Yes',3,2,53,53.02,31171.75,679,1,96,2,'VERY HIGH','MAISHA',1,1,'HULL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','FL',18166,5,'CU6327',10000,15000,5,1,61738,'F','Not specified',500,'South',2,5000,'Yes',18,0,34,55.76,26334.5,23765,5,25,6,'HIGH','MARYETTA',2,1,'NOVAK')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','DC',0,4,'CU3066',3500,5001,1,1,81173,'M','IT Staff',2000,'NorthEast',2,1,'Yes',3,2,42,53.89,39493.25,606,4,156,4,'VERY HIGH','FRED',2,1,'ERNST')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MI',0,1,'CU11539',0,500,1,0,66494,'M','Childcare Worker',1000,'Midwest',0,0,'Yes',2,1,30,53.19,18123.5,212,2,25,3,'MEDIUM','FLOYD',0,1,'BRYSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',973,1,'CU8723',2500,800,1,1,60832,'M','DBA',1000,'NorthEast',1,2500,'Yes',2,3,31,53.44,21808,12819,2,25,4,'MEDIUM','MICHAEL',1,1,'MANN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','CA',0,3,'CU13831',972,750,3,0,62637,'M','Medical Doctor',600,'West',1,972,'Yes',2,1,45,53.2,25659.25,702,3,281,3,'HIGH','HORACIO',1,1,'GROVES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,4,'CU9453',4500,4200,4,0,75869,'M','Administrator',3500,'Midwest',1,4500,'Yes',4,1,28,53.78,25767.25,9716,1,9559,4,'HIGH','FELTON',1,1,'COMER')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','MI',0,4,'CU6242',5000,6000,0,1,61948,'M','IT Staff',1500,'Midwest',1,1000,'Yes',1,0,47,53.64,27187,1109,4,585,4,'HIGH','CRAIG',1,1,'SEWELL')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU15131',0,540,3,0,61369,'M','Programmer/Developer',1000,'NorthEast',0,0,'Yes',3,4,22,53.54,13042.25,230,2,25,4,'LOW','VIRGILIO',0,1,'RIVERS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU8395',3000,8100,1,1,64206,'F','PROF-10',1500,'NorthEast',1,2700,'Yes',4,2,25,55.08,22051.5,3040,4,130,5,'HIGH','LAI',1,1,'STEVENSON')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,3,'CU14554',1100,700,3,1,60398,'M','Programmer/Developer',1000,'NorthEast',2,1100,'Yes',4,1,28,53.39,28399.5,646,3,167,4,'HIGH','HECTOR',2,1,'PULLIAM')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('MARRIED','NY',0,4,'CU5630',0,33500,1,1,65130,'F','PROF-17',1300,'NorthEast',0,5000,'Yes',4,0,29,58.66,14182.5,165815,5,25,6,'MEDIUM','CASSANDRA',0,1,'LORD')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','MI',0,5,'CU2473',4000,5250,5,1,64998,'F','PROF-14',900,'Midwest',1,850,'Yes',16,2,44,55.02,18149.5,2077,4,25,5,'MEDIUM','LORELEI',1,1,'OAKES')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','CA',0,3,'CU878',350,550,3,1,64032,'M','Programmer/Developer',900,'West',1,350,'Yes',2,0,24,53.22,18908,607,2,25,3,'MEDIUM','GORDON',1,1,'TOBIN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NC',0,3,'CU10148',450,700,3,1,63947,'M','Veterinarian',1000,'South',1,450,'Yes',4,1,21,53.47,18586.75,543,1,251,4,'MEDIUM','LYNWOOD',1,1,'HARTMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','NY',0,3,'CU14606',650,540,3,1,66382,'M','Programmer/Developer',600,'NorthEast',1,650,'Yes',1,1,34,53.41,20495.5,280,2,47,4,'MEDIUM','CLYDE',1,1,'WALLS')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','NY',0,1,'CU4224',4000,7500,1,1,56480,'F','IT Staff',1200,'NorthEast',1,1500,'Yes',3,3,53,53.56,22920,3386,1,2280,4,'HIGH','GEORGIANNA',1,1,'GUZMAN')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('SINGLE','MN',0,2,'CU3006',0,6372,0,1,64209,'M','Administrator',600,'West',0,936,'Yes',2,1,44,53.8,16452.25,2001,4,288,4,'MEDIUM','GARFIELD',0,1,'JACOB')
     INTO INSUR_CUST_LTV_SAMPLE (MARITAL_STATUS,STATE,CREDIT_BALANCE,TIME_AS_CUSTOMER,CUSTOMER_ID,MORTGAGE_AMOUNT,BANK_FUNDS,N_OF_DEPENDENTS,HAS_CHILDREN,SALARY,SEX,PROFESSION,CREDIT_CARD_LIMITS,REGION,HOUSE_OWNERSHIP,N_TRANS_WEB_BANK,BUY_INSURANCE,MONTHLY_CHECKS_WRITTEN,N_TRANS_KIOSK,AGE,MONEY_MONTLY_OVERDRAWN,LTV,T_AMOUNT_AUTOM_PAYMENTS,N_TRANS_TELLER,CHECKING_AMOUNT,N_TRANS_ATM,LTV_BIN,LAST,N_MORTGAGES,CAR_OWNERSHIP,FIRST) values ('DIVORCED','CA',0,2,'CU4643',2705,2550,0,0,64019,'M','PROF-2',900,'West',1,2705,'Yes',3,2,40,54.49,31004.75,1438,3,254,5,'VERY HIGH','DUSTY',1,1,'WILLEY')
SELECT * FROM DUAL;
commit;