 CREATE OR REPLACE PACKAGE "ODMRSYS"."ODMR_ENGINE_TEXT" 
AUTHID CURRENT_USER AS

  /**
   * Return an array of tokens generated by the Oracle Text
   -- @param policy_name  Specify the Oracle Text policy name
   -- @param text         Specify the document for which to generate tokens
   */
  FUNCTION dm_policy_tokens(policy_name VARCHAR2,
                            text VARCHAR2) RETURN ODMR_OBJECT_VALUES PIPELINED;

  /**
   * Return an array of themes generated by the Oracle Text
   -- @param policy_name  Specify the Oracle Text policy name
   -- @param text         Specify the document for which to generate themes
   -- @param full_themes  Specify whether this procedure generates a single theme or a hierarchical list of parent themes (full themes) for each document theme
   *                      full_themes = 0, generate single theme
   *                      full_themes = 1, generate full themes
   */
  FUNCTION dm_policy_themes(policy_name VARCHAR2,
                            text VARCHAR2,
                            full_themes NUMBER) RETURN ODMR_OBJECT_VALUES PIPELINED;

  /**
   * Return an array of tokens generated by the Oracle Text
   -- @param policy_name  Specify the Oracle Text policy name
   -- @param text         Specify the document for which to generate tokens
   */
  FUNCTION dm_policy_tokens(policy_name VARCHAR2,
                            text CLOB) RETURN ODMR_OBJECT_VALUES PIPELINED;

  /**
   * Return an array of themes generated by the Oracle Text
   -- @param policy_name  Specify the Oracle Text policy name
   -- @param text         Specify the document for which to generate themes
   -- @param full_themes  Specify whether this procedure generates a single theme or a hierarchical list of parent themes (full themes) for each document theme
   *                      full_themes = 0, generate single theme
   *                      full_themes = 1, generate full themes
   */
  FUNCTION dm_policy_themes(policy_name VARCHAR2,
                            text CLOB,
                            full_themes NUMBER) RETURN ODMR_OBJECT_VALUES PIPELINED;

  /**
   * Return an array of tokens generated by the Oracle Text
   -- @param policy_name  Specify the Oracle Text policy name
   -- @param text         Specify the document for which to generate tokens. The document can be any Oracle Text supported document format (e.g. MS Word, PDF, etc)
   */
  FUNCTION dm_policy_tokens(policy_name VARCHAR2,
                            text BLOB) RETURN ODMR_OBJECT_VALUES PIPELINED;

  /**
   * Return an array of themes generated by the Oracle Text
   -- @param policy_name  Specify the Oracle Text policy name
   -- @param text         Specify the document for which to generate themes. The document can be any Oracle Text supported document format (e.g. MS Word, PDF, etc)
   -- @param full_themes  Specify whether this procedure generates a single theme or a hierarchical list of parent themes (full themes) for each document theme
   *                      full_themes = 0, generate single theme
   *                      full_themes = 1, generate full themes
   */
  FUNCTION dm_policy_themes(policy_name VARCHAR2,
                            text BLOB,
                            full_themes NUMBER) RETURN ODMR_OBJECT_VALUES PIPELINED;

  /**
   * Return an array of tokens generated by the Oracle Text
   -- @param policy_name  Specify the Oracle Text policy name
   -- @param text         Specify the document location for which to generate tokens. The document can be any Oracle Text supported document format (e.g. MS Word, PDF, etc)
   */
  FUNCTION dm_policy_tokens(policy_name VARCHAR2,
                            text BFILE) RETURN ODMR_OBJECT_VALUES PIPELINED;

  /**
   * Return an array of themes generated by the Oracle Text
   -- @param policy_name  Specify the Oracle Text policy name
   -- @param text         Specify the document location for which to generate themes. The document can be any Oracle Text supported document format (e.g. MS Word, PDF, etc)
   -- @param full_themes  Specify whether this procedure generates a single theme or a hierarchical list of parent themes (full themes) for each document theme
   *                      full_themes = 0, generate single theme
   *                      full_themes = 1, generate full themes
   */
  FUNCTION dm_policy_themes(policy_name VARCHAR2,
                            text BFILE,
                            full_themes NUMBER) RETURN ODMR_OBJECT_VALUES PIPELINED;

  /**
   -- @param policy_name   VARCHAR2
   -- @param text          VARCHAR2
   -- @param stoplist_name VARCHAR2 (deprecated)
   */
  FUNCTION dm_policy_tokens2(policy_name VARCHAR2,
                             text VARCHAR2,
                             stoplist_name VARCHAR2) RETURN DM_NESTED_NUMERICALS PIPELINED;

  /**
   -- @param policy_name   VARCHAR2,
   -- @param text          VARCHAR2,
   -- @param full_themes   NUMBER,
   -- @param stoplist_name VARCHAR2 (deprecated)
   */
  FUNCTION dm_policy_themes2(policy_name VARCHAR2,
                             text VARCHAR2,
                             full_themes NUMBER,
                             stoplist_name VARCHAR2) RETURN DM_NESTED_NUMERICALS PIPELINED;

  /**
   -- @param policy_name   VARCHAR2
   -- @param text          CLOB
   -- @param stoplist_name VARCHAR2 (deprecated)
   */
  FUNCTION dm_policy_tokens2(policy_name VARCHAR2,
                             text CLOB,
                             stoplist_name VARCHAR2) RETURN DM_NESTED_NUMERICALS PIPELINED;

  /**
   -- @param policy_name   VARCHAR2,
   -- @param text          CLOB,
   -- @param full_themes   NUMBER,
   -- @param stoplist_name VARCHAR2 (deprecated)
   */
  FUNCTION dm_policy_themes2(policy_name VARCHAR2,
                             text CLOB,
                             full_themes NUMBER,
                             stoplist_name VARCHAR2) RETURN DM_NESTED_NUMERICALS PIPELINED;

  /**
   -- @param policy_name   VARCHAR2
   -- @param text          BLOB
   -- @param stoplist_name VARCHAR2 (deprecated)
   */
  FUNCTION dm_policy_tokens2(policy_name VARCHAR2,
                             text BLOB,
                             stoplist_name VARCHAR2) RETURN DM_NESTED_NUMERICALS PIPELINED;

  /**
   -- @param policy_name   VARCHAR2,
   -- @param text          BLOB,
   -- @param full_themes   NUMBER,
   -- @param stoplist_name VARCHAR2 (deprecated)
   */
  FUNCTION dm_policy_themes2(policy_name VARCHAR2,
                             text BLOB,
                             full_themes NUMBER,
                             stoplist_name VARCHAR2) RETURN DM_NESTED_NUMERICALS PIPELINED;

  /**
   -- @param policy_name   VARCHAR2
   -- @param text          BFILE
   -- @param stoplist_name VARCHAR2 (deprecated)
   */
  FUNCTION dm_policy_tokens2(policy_name VARCHAR2,
                             text BFILE,
                             stoplist_name VARCHAR2) RETURN DM_NESTED_NUMERICALS PIPELINED;

  /**
   -- @param policy_name   VARCHAR2,
   -- @param text          BFILE,
   -- @param full_themes   NUMBER,
   -- @param stoplist_name VARCHAR2 (deprecated)
   */
  FUNCTION dm_policy_themes2(policy_name VARCHAR2,
                             text BFILE,
                             full_themes NUMBER,
                             stoplist_name VARCHAR2) RETURN DM_NESTED_NUMERICALS PIPELINED;

  /**
   * Return an array of tokens and computed frequency values. The frequency values can be either term frequency (tf) or term frequencyinverse document frequency (tf-idf)
   -- @param policy_name        Specify the Oracle Text policy name
   -- @param text               Specify the document for which to generate tokens and frequency values
   -- @param model_table_name   Specify the table that contains all document tokens and their inverse document frequency (idf) values
   -- @param attr_name          Specify the column in the input data that contains documents (deprecated)
   -- @param maxNumberPerDoc    Specify the max number of generated tokens per document
   -- @param frequency          Specify the output frequency values
   --                           frequency = Terms, generate term frequency (tf)
   --                           frequency = IDF, generate term frequencyinverse document frequency (tf-idf)
   */
  FUNCTION dm_text_token_features(policy_name VARCHAR2,
                            text VARCHAR2,
                            model_table_name VARCHAR2,
                            attr_name VARCHAR2,
                            maxNumberPerDoc NUMBER,
                            frequency VARCHAR2) RETURN DM_NESTED_NUMERICALS;

  /**
   * Return an array of themes and computed frequency values. The frequency values can be either term frequency (tf) or term frequencyinverse document frequency (tf-idf)
   -- @param policy_name        Specify the Oracle Text policy name
   -- @param text               Specify the document for which to generate themes and frequency values
   -- @param model_table_name   Specify the table that contains all document themes and their inverse document frequency (idf) values
   -- @param attr_name          Specify the column in the input data that contains documents (deprecated)
   -- @param full_themes        Specify whether this procedure generates a single theme or a hierarchical list of parent themes (full themes) for each document theme
   --                           full_themes = 0, generate single theme
   --                           full_themes = 1, generate full themes
   -- @param maxNumberPerDoc    Specify the max number of generated themes per document
   -- @param frequency          Specify the output frequency values
   --                           frequency = Terms, generate term frequency (tf)
   --                           frequency = IDF, generate term frequencyinverse document frequency (tf-idf)
   */
  FUNCTION dm_text_theme_features(policy_name VARCHAR2,
                            text VARCHAR2,
                            model_table_name VARCHAR2,
                            attr_name VARCHAR2,
                            full_themes NUMBER,
                            maxNumberPerDoc NUMBER,
                            frequency VARCHAR2) RETURN DM_NESTED_NUMERICALS;

  /**
   * Return an array of tokens and computed frequency values. The frequency values can be either term frequency (tf) or term frequencyinverse document frequency (tf-idf)
   -- @param policy_name        Specify the Oracle Text policy name
   -- @param text               Specify the document for which to generate tokens and frequency values
   -- @param model_table_name   Specify the table that contains all document tokens and their inverse document frequency (idf) values
   -- @param attr_name          Specify the column in the input data that contains documents (deprecated)
   -- @param maxNumberPerDoc    Specify the max number of generated tokens per document
   -- @param frequency          Specify the output frequency values
   --                           frequency = Terms, generate term frequency (tf)
   --                           frequency = IDF, generate term frequencyinverse document frequency (tf-idf)
   */
  FUNCTION dm_text_token_features(policy_name VARCHAR2,
                            text CLOB,
                            model_table_name VARCHAR2,
                            attr_name VARCHAR2,
                            maxNumberPerDoc NUMBER,
                            frequency VARCHAR2) RETURN DM_NESTED_NUMERICALS;

  /**
   * Return an array of themes and computed frequency values. The frequency values can be either term frequency (tf) or term frequencyinverse document frequency (tf-idf)
   -- @param policy_name        Specify the Oracle Text policy name
   -- @param text               Specify the document for which to generate themes and frequency values
   -- @param model_table_name   Specify the table that contains all document themes and their inverse document frequency (idf) values
   -- @param attr_name          Specify the column in the input data that contains documents (deprecated)
   -- @param full_themes        Specify whether this procedure generates a single theme or a hierarchical list of parent themes (full themes) for each document theme
   --                           full_themes = 0, generate single theme
   --                           full_themes = 1, generate full themes
   -- @param maxNumberPerDoc    Specify the max number of generated themes per document
   -- @param frequency          Specify the output frequency values
   --                           frequency = Terms, generate term frequency (tf)
   --                           frequency = IDF, generate term frequencyinverse document frequency (tf-idf)
   */
  FUNCTION dm_text_theme_features(policy_name VARCHAR2,
                            text CLOB,
                            model_table_name VARCHAR2,
                            attr_name VARCHAR2,
                            full_themes NUMBER,
                            maxNumberPerDoc NUMBER,
                            frequency VARCHAR2) RETURN DM_NESTED_NUMERICALS;

  /**
   * Return an array of tokens and computed frequency values. The frequency values can be either term frequency (tf) or term frequencyinverse document frequency (tf-idf)
   -- @param policy_name        Specify the Oracle Text policy name
   -- @param text               Specify the document for which to generate tokens and frequency values. The document can be any Oracle Text supported document format (e.g. MS Word, PDF, etc)
   -- @param model_table_name   Specify the table that contains all document tokens and their inverse document frequency (idf) values
   -- @param attr_name          Specify the column in the input data that contains documents (deprecated)
   -- @param maxNumberPerDoc    Specify the max number of generated tokens per document
   -- @param frequency          Specify the output frequency values
   --                           frequency = Terms, generate term frequency (tf)
   --                           frequency = IDF, generate term frequencyinverse document frequency (tf-idf)
   */
  FUNCTION dm_text_token_features(policy_name VARCHAR2,
                            text BLOB,
                            model_table_name VARCHAR2,
                            attr_name VARCHAR2,
                            maxNumberPerDoc NUMBER,
                            frequency VARCHAR2) RETURN DM_NESTED_NUMERICALS;

  /**
   * Return an array of themes and computed frequency values. The frequency values can be either term frequency (tf) or term frequencyinverse document frequency (tf-idf)
   -- @param policy_name        Specify the Oracle Text policy name
   -- @param text               Specify the document for which to generate themes and frequency values. The document can be any Oracle Text supported document format (e.g. MS Word, PDF, etc)
   -- @param model_table_name   Specify the table that contains all document themes and their inverse document frequency (idf) values
   -- @param attr_name          Specify the column in the input data that contains documents (deprecated)
   -- @param full_themes        Specify whether this procedure generates a single theme or a hierarchical list of parent themes (full themes) for each document theme
   --                           full_themes = 0, generate single theme
   --                           full_themes = 1, generate full themes
   -- @param maxNumberPerDoc    Specify the max number of generated themes per document
   -- @param frequency          Specify the output frequency values
   --                           frequency = Terms, generate term frequency (tf)
   --                           frequency = IDF, generate term frequencyinverse document frequency (tf-idf)
   */
  FUNCTION dm_text_theme_features(policy_name VARCHAR2,
                            text BLOB,
                            model_table_name VARCHAR2,
                            attr_name VARCHAR2,
                            full_themes NUMBER,
                            maxNumberPerDoc NUMBER,
                            frequency VARCHAR2) RETURN DM_NESTED_NUMERICALS;

  /**
   * Return an array of tokens and computed frequency values. The frequency values can be either term frequency (tf) or term frequencyinverse document frequency (tf-idf)
   -- @param policy_name        Specify the Oracle Text policy name
   -- @param text               Specify the document location for which to generate tokens and frequency values. The document can be any Oracle Text supported document format (e.g. MS Word, PDF, etc)
   -- @param model_table_name   Specify the table that contains all document tokens and their inverse document frequency (idf) values
   -- @param attr_name          Specify the column in the input data that contains documents (deprecated)
   -- @param maxNumberPerDoc    Specify the max number of generated tokens per document
   -- @param frequency          Specify the output frequency values
   --                           frequency = Terms, generate term frequency (tf)
   --                           frequency = IDF, generate term frequencyinverse document frequency (tf-idf)
   */
  FUNCTION dm_text_token_features(policy_name VARCHAR2,
                            text BFILE,
                            model_table_name VARCHAR2,
                            attr_name VARCHAR2,
                            maxNumberPerDoc NUMBER,
                            frequency VARCHAR2) RETURN DM_NESTED_NUMERICALS;

  /**
   * Return an array of themes and computed frequency values. The frequency values can be either term frequency (tf) or term frequencyinverse document frequency (tf-idf)
   -- @param policy_name        Specify the Oracle Text policy name
   -- @param text               Specify the document location for which to generate themes and frequency values. The document can be any Oracle Text supported document format (e.g. MS Word, PDF, etc)
   -- @param model_table_name   Specify the table that contains all document themes and their inverse document frequency (idf) values
   -- @param attr_name          Specify the column in the input data that contains documents (deprecated)
   -- @param full_themes        Specify whether this procedure generates a single theme or a hierarchical list of parent themes (full themes) for each document theme
   --                           full_themes = 0, generate single theme
   --                           full_themes = 1, generate full themes
   -- @param maxNumberPerDoc    Specify the max number of generated themes per document
   -- @param frequency          Specify the output frequency values
   --                           frequency = Terms, generate term frequency (tf)
   --                           frequency = IDF, generate term frequencyinverse document frequency (tf-idf)
   */
  FUNCTION dm_text_theme_features(policy_name VARCHAR2,
                            text BFILE,
                            model_table_name VARCHAR2,
                            attr_name VARCHAR2,
                            full_themes NUMBER,
                            maxNumberPerDoc NUMBER,
                            frequency VARCHAR2) RETURN DM_NESTED_NUMERICALS;

  /**
   -- @param p_transform_type              IN NUMBER,
   -- @param p_use_auto_filter             IN BOOLEAN,
   -- @param p_policy_name                 IN VARCHAR2,
   -- @param p_multi_lexer_name            IN VARCHAR2,
   -- @param p_multi_lexer_languages       IN OUT NOCOPY ODMR_OBJECT_NAMES,
   -- @param p_multi_stoplist_name         IN VARCHAR2,
   -- @param p_multi_stopword_types        IN OUT NOCOPY ODMR_OBJECT_NAMES,    -- WORD or THEME
   -- @param p_multi_stopword_languages    IN OUT NOCOPY ODMR_OBJECT_NAMES,
   -- @param p_multi_stopwords             IN OUT NOCOPY ODMR_OBJECT_VALUES,
   -- @param p_lexer_attr_names            IN OUT NOCOPY ODMR_OBJECT_NAMES,  -- only basic lexer has settings
   -- @param p_lexer_attr_strings          IN OUT NOCOPY ODMR_OBJECT_VALUES,
   -- @param p_lexer_attr_numbers          IN OUT NOCOPY ODMR_OBJECT_IDS,
   -- @param p_lexer_attr_types            IN OUT NOCOPY ODMR_OBJECT_NAMES
   */
  PROCEDURE create_auto_policy(p_transform_type              IN NUMBER,
                               p_use_auto_filter             IN BOOLEAN,
                               p_policy_name                 IN VARCHAR2,
                               p_multi_lexer_name            IN VARCHAR2,
                               p_multi_lexer_languages       IN OUT NOCOPY ODMR_OBJECT_NAMES,
                               p_multi_stoplist_name         IN VARCHAR2,
                               p_multi_stopword_types        IN OUT NOCOPY ODMR_OBJECT_NAMES,    -- WORD or THEME
                               p_multi_stopword_languages    IN OUT NOCOPY ODMR_OBJECT_NAMES,
                               p_multi_stopwords             IN OUT NOCOPY ODMR_OBJECT_VALUES,
                               p_lexer_attr_names            IN OUT NOCOPY ODMR_OBJECT_NAMES,  -- only basic lexer has settings
                               p_lexer_attr_strings          IN OUT NOCOPY ODMR_OBJECT_VALUES,
                               p_lexer_attr_numbers          IN OUT NOCOPY ODMR_OBJECT_IDS,
                               p_lexer_attr_types            IN OUT NOCOPY ODMR_OBJECT_NAMES);

  /**
   -- @param p_transform_type            IN NUMBER,
   -- @param p_use_auto_filter           IN BOOLEAN,
   -- @param p_policy_name               IN VARCHAR2,
   -- @param p_basic_lexer_name          IN VARCHAR2,
   -- @param p_basic_lexer_lang          IN VARCHAR2,
   -- @param p_basic_stoplist_name       IN VARCHAR2,
   -- @param p_basic_types               IN OUT NOCOPY ODMR_OBJECT_NAMES,  -- WORD or THEME
   -- @param p_basic_stopword_languages  IN OUT NOCOPY ODMR_OBJECT_NAMES,
   -- @param p_basic_stopwords           IN OUT NOCOPY ODMR_OBJECT_VALUES,
   -- @param p_lexer_attr_names          IN OUT NOCOPY ODMR_OBJECT_NAMES,
   -- @param p_lexer_attr_strings        IN OUT NOCOPY ODMR_OBJECT_VALUES,
   -- @param p_lexer_attr_numbers        IN OUT NOCOPY ODMR_OBJECT_IDS,
   -- @param p_lexer_attr_types          IN OUT NOCOPY ODMR_OBJECT_NAMES
   */
  PROCEDURE create_basic_policy(p_transform_type            IN NUMBER,
                                p_use_auto_filter           IN BOOLEAN,
                                p_policy_name               IN VARCHAR2,
                                p_basic_lexer_name          IN VARCHAR2,
                                p_basic_lexer_lang          IN VARCHAR2,
                                p_basic_stoplist_name       IN VARCHAR2,
                                p_basic_types               IN OUT NOCOPY ODMR_OBJECT_NAMES,  -- WORD or THEME
                                p_basic_stopword_languages  IN OUT NOCOPY ODMR_OBJECT_NAMES,
                                p_basic_stopwords           IN OUT NOCOPY ODMR_OBJECT_VALUES,
                                p_lexer_attr_names          IN OUT NOCOPY ODMR_OBJECT_NAMES,
                                p_lexer_attr_strings        IN OUT NOCOPY ODMR_OBJECT_VALUES,
                                p_lexer_attr_numbers        IN OUT NOCOPY ODMR_OBJECT_IDS,
                                p_lexer_attr_types          IN OUT NOCOPY ODMR_OBJECT_NAMES);

  /**
   -- @param p_job_name   IN VARCHAR2
   -- @param p_chain_step IN VARCHAR2
   */
  PROCEDURE BUILDTEXT_PROG(p_job_name IN VARCHAR2, p_chain_step IN VARCHAR2);

  /**
   -- @param p_job_name   IN VARCHAR2
   -- @param p_chain_step IN VARCHAR2
   */
  PROCEDURE APPLYTEXT_PROG(p_job_name IN VARCHAR2, p_chain_step IN VARCHAR2);

  /**
   -- @param p_job_name   IN VARCHAR2
   -- @param p_chain_step IN VARCHAR2
   */
  PROCEDURE BUILDTEXT_REF_PROG(p_job_name IN VARCHAR2, p_chain_step IN VARCHAR2);

END ODMR_ENGINE_TEXT;
/
