#include <iostream>
#include <string>
using namespace std;

class BTree { };

class SearchEngineImp {
  public :
    virtual bool Search(string s, string idxFn) = 0;
    virtual bool Search(string s, BTree& bTree) = 0;
};

class UnixSearchEngineImp : public SearchEngineImp {
  public :
    bool Search(string s, string idxFn) {
      // -- Unix ȯ濡 ߾ idxFn  ڿ ˻
      return true;
    }
    bool Search(string s, BTree& bTree) {
      // -- Unix ȯ濡 ߾ BTree  ڿ ˻
      return true;
    }
};

class WindowsSearchEngineImp : public SearchEngineImp {
  public :
    bool Search(string s, string idxFn) {
      // -- MS Windows ȯ濡 ߾ idxFn  ڿ ˻
      return true;
    }
    bool Search(string s, BTree& bTree) {
      // -- MS Windows ȯ濡 ߾ BTree  ڿ ˻
      return true;
    }
};

class SearchEngine {
  public :
    SearchEngine() { pImp_ = 0; }
    virtual bool Search(string s) = 0;

  protected :
    SearchEngineImp* GetSearchEngineImp() {
      if (pImp_ == 0) {
#ifdef  __WIN32__
        pImp_ = new WindowsSearchEngineImp;
#else
        pImp_ = new UnixSearchEngineImp;
#endif
      }
      return pImp_;
    }

  private :
    SearchEngineImp* pImp_;
};

class WebSearchEngine : public SearchEngine {
  public :
    WebSearchEngine(string idxFn) { indexFn_ = idxFn; }
    bool Search(string s) {
      return GetSearchEngineImp()->Search(s, indexFn_);
    }

  private :
    string indexFn_;
};

class DBSearchEngine : public SearchEngine {
  public : 
    bool Search(string s) {
      return GetSearchEngineImp()->Search(s, bTree_);
    }

  private :
    BTree bTree_;
};

int 
main() 
{
  WebSearchEngine finder("inverted_file4web.idx");
  finder.Search(" ");
}
