#include <iostream>
using namespace std;

#define DEFAULT_REQUEST   0
#define HELP_REQUEST      1
#define PRINT_REQUEST     2
#define PREVIEW_REQUEST   3

class Request {
  public :
    virtual int GetKind() { return DEFAULT_REQUEST; }
};
class HelpRequest : public Request {
  public :
    virtual int GetKind() { return HELP_REQUEST; }
};
class PrintRequest : public Request {
  public :
    virtual int GetKind() { return PRINT_REQUEST; }
};
class PreviewRequest : public Request {
  public :
    virtual int GetKind() { return PREVIEW_REQUEST; }
};

class Handler {
  public : 
    Handler(Handler* pObj) : pSuccessor_(pObj) {}
    virtual void HandleRequest(Request *pReq) {
      switch (pReq->GetKind()) {
        case HELP_REQUEST : 
          // -- HelpRequest  ó
          cout << "HelpRequest Processing" << endl;
          break;
        case PRINT_REQUEST :
          // -- PrintRequest  ó
          cout << "PrintRequest Processing" << endl;
          break;
        default :
          // -- ⺻ ó
          cout << "Default Processing" << endl;
      }
    }

  private :
    Handler* pSuccessor_;
};

class ExtendedHandler : public Handler {
  public : 
    ExtendedHandler(Handler *pObj) : Handler(pObj) {}

    virtual void HandleRequest(Request *pReq) 
    {
      switch (pReq->GetKind()) {
        case PREVIEW_REQUEST :
          // -- PreviewRequest  ó
          cout << "PreviewRequest Processing" << endl;
          break;
        default :
          Handler::HandleRequest(pReq);
      }
    }
};

int 
main()
{
  ExtendedHandler hdlr(0);
  Request *pReq = new PreviewRequest;

  hdlr.HandleRequest(pReq);
}
