#include <iostream>
#include <strings.h>
#include <sys/utsname.h>
using namespace std;

#define HPUX "HPUX"
#define SUNOS "SunOS"

class Scanner {
  public : 
    virtual ~Scanner()=0;
};

class Parser {
  public : 
    virtual ~Parser()=0;
};

class CodeGenerator {
  public : 
    virtual ~CodeGenerator()=0;
};

class Optimizer {
  public : 
    virtual ~Optimizer()=0;
};

Scanner::~Scanner() {}
Parser::~Parser() {}
CodeGenerator::~CodeGenerator() {}
Optimizer::~Optimizer() {}

class HPScanner : public Scanner {};
class HPParser : public Parser {};
class HPCodeGenerator : public CodeGenerator {};
class HPOptimizer : public Optimizer {};

class SunScanner : public Scanner {};
class SunParser : public Parser {};
class SunCodeGenerator : public CodeGenerator {};
class SunOptimizer : public Optimizer {};

class CompilerFactory {  
  public :    
    virtual Scanner* CreateScanner() = 0;    
    virtual Parser* CreateParser() = 0;    
    virtual CodeGenerator* CreateCodeGenerator() = 0;    
    virtual Optimizer* CreateOptimizer() = 0;  
};

class HPCompilerFactory : public CompilerFactory {  
  public :    
    Scanner* CreateScanner() { new HPScanner; }    
    Parser* CreateParser() { new HPParser; }    
    CodeGenerator* CreateCodeGenerator() { new HPCodeGenerator; }    
    Optimizer* CreateOptimizer() { new HPOptimizer; }
};

class SunCompilerFactory : public CompilerFactory {  
  public :    
    Scanner* CreateScanner() { new SunScanner; }    
    Parser* CreateParser() { new SunParser; }    
    CodeGenerator* CreateCodeGenerator() { new SunCodeGenerator; }    
    Optimizer* CreateOptimizer() { new SunOptimizer; }
};

CompilerFactory *pFactory;  

int main() {  
  struct utsname sysInfo;

  // -- OS   ϵ Ÿ    ý Լ  
  if (uname(&sysInfo) < 0) { 
    cout << "Error Occurred" << endl;
    return(-1);
  }

  if (strncasecmp(sysInfo.sysname, HPUX, strlen(HPUX)) == 0) {  
    // -- HP  ü   
    pFactory = new HPCompilerFactory;
  }
  else if (strncasecmp(sysInfo.sysname, SUNOS, strlen(SUNOS)) == 0) {  
    // -- Sun  ü   
    pFactory = new SunCompilerFactory;
  }
  else {  
    // --  ϴ ý ȯ  
    cout << sysInfo.sysname << endl;
    return(0);
  }

  Scanner *pScanner = pFactory->CreateScanner();
  Parser *pParser = pFactory->CreateParser();
  CodeGenerator *pCodeGenerator = pFactory->CreateCodeGenerator();
  Optimizer *pOptimizer = pFactory->CreateOptimizer();
}
