#include <iostream>
#include <strings.h>
#include <sys/utsname.h>
using namespace std;

#define HPUX "HPUX"
#define SUNOS "SunOS"

class Scanner {};
class Parser {};
class CodeGenerator {};
class Optimizer {};

class HPScanner : public Scanner {};
class HPParser : public Parser {};
class HPCodeGenerator : public CodeGenerator {};
class HPOptimizer : public Optimizer {};

class SunScanner : public Scanner {};
class SunParser : public Parser {};
class SunCodeGenerator : public CodeGenerator {};
class SunOptimizer : public Optimizer {};

struct utsname sysInfo;

void ScanParse()
{
  if (strncasecmp(sysInfo.sysname, HPUX, strlen(HPUX)) == 0) {  
    // -- HP  ü   
    HPScanner scanner;
    HPParser parser;
  }
  else if (strncasecmp(sysInfo.sysname, SUNOS, strlen(SUNOS)) == 0) {  
    // -- Sun  ü   
    SunScanner scanner;
    SunParser parser;
  }
  else {  
    // --  ϴ ý ȯ  
    cout << sysInfo.sysname << "does not supported" << endl;
  }
}

void CodeGenOptimize()
{
  if (strncasecmp(sysInfo.sysname, HPUX, strlen(HPUX)) == 0) {  
    // -- HP  ü   
    HPCodeGenerator codeGenerator;
    HPOptimizer optimizer;
  }
  else if (strncasecmp(sysInfo.sysname, SUNOS, strlen(SUNOS)) == 0) {  
    // -- Sun  ü   
    SunCodeGenerator codeGenerator;
    SunOptimizer optimizer;
  }
  else {  
    // --  ϴ ý ȯ  
    cout << sysInfo.sysname << "does not supported" << endl;
  }
}

int main()
{
  // -- OS   ϵ Ÿ    ý Լ  
  if (uname(&sysInfo) < 0) { 
    cout << "Error Occurred" << endl;
    return(-1);
  }

  ScanParse();
  CodeGenOptimize();
}
