/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

class TokenSequence {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.impl.TokenSequence");
    final int[] lexStarts;
    final IElementType[] lexTypes;
    final int lexemeCount;

    TokenSequence(int[] lexStarts, IElementType[] lexTypes, int lexemeCount) {
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.lexemeCount = lexemeCount;
        assert (lexemeCount < lexStarts.length);
        assert (lexemeCount < lexTypes.length);
    }

    void assertMatches(@NotNull CharSequence text2, @NotNull Lexer lexer) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/lang/impl/TokenSequence", "assertMatches"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "org/jetbrains/kotlin/com/intellij/lang/impl/TokenSequence", "assertMatches"));
        }
        TokenSequence sequence2 = new Builder(text2, lexer).performLexing();
        assert (this.lexemeCount == sequence2.lexemeCount);
        for (int j = 0; j <= this.lexemeCount; ++j) {
            if (sequence2.lexStarts[j] != this.lexStarts[j] || sequence2.lexTypes[j] != this.lexTypes[j]) assert (false);
        }
    }

    static class Builder {
        private final CharSequence myText;
        private final Lexer myLexer;
        private int[] myLexStarts;
        private IElementType[] myLexTypes;

        Builder(@NotNull CharSequence text2, @NotNull Lexer lexer) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/lang/impl/TokenSequence$Builder", "<init>"));
            }
            if (lexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "org/jetbrains/kotlin/com/intellij/lang/impl/TokenSequence$Builder", "<init>"));
            }
            this.myText = text2;
            this.myLexer = lexer;
            int approxLexCount = Math.max(10, this.myText.length() / 5);
            this.myLexStarts = new int[approxLexCount];
            this.myLexTypes = new IElementType[approxLexCount];
        }

        @NotNull
        TokenSequence performLexing() {
            IElementType type2;
            this.myLexer.start(this.myText);
            int i = 0;
            int offset2 = 0;
            while ((type2 = this.myLexer.getTokenType()) != null) {
                int tokenStart;
                if (i % 20 == 0) {
                    ProgressIndicatorProvider.checkCanceled();
                }
                if (i >= this.myLexTypes.length - 1) {
                    this.resizeLexemes(i * 3 / 2);
                }
                if ((tokenStart = this.myLexer.getTokenStart()) < offset2) {
                    this.reportDescendingOffsets(i, offset2, tokenStart);
                }
                this.myLexStarts[i] = offset2 = tokenStart;
                this.myLexTypes[i] = type2;
                ++i;
                this.myLexer.advance();
            }
            this.myLexStarts[i] = this.myText.length();
            TokenSequence tokenSequence = new TokenSequence(this.myLexStarts, this.myLexTypes, i);
            if (tokenSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/TokenSequence$Builder", "performLexing"));
            }
            return tokenSequence;
        }

        private void reportDescendingOffsets(int tokenIndex, int offset2, int tokenStart) {
            StringBuilder sb = new StringBuilder();
            IElementType tokenType = this.myLexer.getTokenType();
            sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
            if (tokenIndex > 0) {
                int prevStart = this.myLexStarts[tokenIndex - 1];
                sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset2)).append("' (").append(this.myLexTypes[tokenIndex - 1]).append(':').append(this.myLexTypes[tokenIndex - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset2);
            }
            int quoteStart = Math.max(tokenStart - 256, 0);
            int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
            sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
            LOG.error(sb);
        }

        private void resizeLexemes(int newSize) {
            this.myLexStarts = ArrayUtil.realloc(this.myLexStarts, newSize);
            this.myLexTypes = ArrayUtil.realloc(this.myLexTypes, newSize, IElementType.ARRAY_FACTORY);
        }
    }
}

