/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.HashSet;
import java.util.List;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.SubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class StrictSubtypingConstraint
implements ConstraintFormula {
    private PsiType myS;
    private PsiType myT;

    public StrictSubtypingConstraint(PsiType t, PsiType s) {
        this.myT = t;
        this.myS = s;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
        this.myS = substitutor2.substitute(this.myS);
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        HashSet<InferenceVariable> dependencies2 = new HashSet<InferenceVariable>();
        boolean reduceResult = this.doReduce(session, dependencies2, constraints);
        if (!reduceResult) {
            session.registerIncompatibleErrorMessage(dependencies2, session.getPresentableText(this.myS) + " conforms to " + session.getPresentableText(this.myT));
        }
        return reduceResult;
    }

    /*
     * WARNING - void declaration
     */
    private boolean doReduce(InferenceSession session, HashSet<InferenceVariable> dependencies2, List<ConstraintFormula> constraints) {
        PsiType lowerBound;
        if (!session.collectDependencies(this.myS, dependencies2) && !session.collectDependencies(this.myT, dependencies2)) {
            if (this.myT == null) {
                return this.myS == null || this.myS.equalsToText("java.lang.Object");
            }
            if (this.myS == null) {
                return true;
            }
            return TypeConversionUtil.isAssignable(this.myT, this.myS);
        }
        if (PsiType.NULL.equals(this.myT) || this.myT == null) {
            return false;
        }
        if (PsiType.NULL.equals(this.myS) || this.myS == null || this.myT.equalsToText("java.lang.Object")) {
            return true;
        }
        if (PsiType.VOID.equals(this.myS) ^ PsiType.VOID.equals(this.myT)) {
            return false;
        }
        InferenceVariable inferenceVariable = session.getInferenceVariable(this.myS);
        if (inferenceVariable != null) {
            InferenceVariable.addBound(this.myS, this.myT, InferenceBound.UPPER, session);
            return true;
        }
        inferenceVariable = session.getInferenceVariable(this.myT);
        if (inferenceVariable != null) {
            InferenceVariable.addBound(this.myT, this.myS, InferenceBound.LOWER, session);
            return true;
        }
        if (this.myT instanceof PsiArrayType) {
            PsiType upperBound;
            PsiType sType = this.myS;
            if (this.myS instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)this.myS).getUpperBound()) instanceof PsiArrayType) {
                sType = upperBound;
            }
            if (!(sType instanceof PsiArrayType)) {
                return false;
            }
            PsiType tComponentType = ((PsiArrayType)this.myT).getComponentType();
            PsiType sComponentType = ((PsiArrayType)sType).getComponentType();
            if (!(tComponentType instanceof PsiPrimitiveType) && !(sComponentType instanceof PsiPrimitiveType)) {
                constraints.add(new StrictSubtypingConstraint(tComponentType, sComponentType));
                return true;
            }
            return sComponentType instanceof PsiPrimitiveType && sComponentType.equals(tComponentType);
        }
        if (this.myT instanceof PsiClassType) {
            PsiClassType.ClassResolveResult TResult = ((PsiClassType)this.myT).resolveGenerics();
            PsiClass CClass = TResult.getElement();
            if (CClass != null) {
                if (CClass instanceof PsiTypeParameter) {
                    PsiType lowerBound2;
                    if (this.myS instanceof PsiIntersectionType) {
                        for (PsiType conjunct : ((PsiIntersectionType)this.myS).getConjuncts()) {
                            if (!this.myT.equals(conjunct)) continue;
                            return true;
                        }
                    }
                    if ((lowerBound2 = InferenceSession.getLowerBound(CClass)) != null) {
                        constraints.add(new StrictSubtypingConstraint(lowerBound2, this.myS));
                        return true;
                    }
                    return false;
                }
                PsiClassType sType = null;
                if (this.myS instanceof PsiIntersectionType) {
                    for (PsiType psiType : ((PsiIntersectionType)this.myS).getConjuncts()) {
                        PsiClassType.ClassResolveResult conjunctResult;
                        if (!(psiType instanceof PsiClassType) || !InheritanceUtil.isInheritorOrSelf((conjunctResult = ((PsiClassType)psiType).resolveGenerics()).getElement(), CClass, true)) continue;
                        sType = (PsiClassType)psiType;
                        break;
                    }
                } else if (this.myS instanceof PsiClassType) {
                    sType = (PsiClassType)this.myS;
                } else {
                    if (this.myS instanceof PsiArrayType) {
                        return this.myT.isAssignableFrom(this.myS);
                    }
                    if (this.myS instanceof PsiCapturedWildcardType) {
                        PsiType upperBound = ((PsiCapturedWildcardType)this.myS).getUpperBound();
                        if (upperBound instanceof PsiClassType) {
                            sType = (PsiClassType)upperBound;
                        } else if (upperBound instanceof PsiIntersectionType) {
                            void var11_28;
                            PsiType[] psiTypeArray = ((PsiIntersectionType)upperBound).getConjuncts();
                            int conjunct = psiTypeArray.length;
                            boolean bl = false;
                            while (var11_28 < conjunct) {
                                PsiType type2 = psiTypeArray[var11_28];
                                PsiClass sCandidate = PsiUtil.resolveClassInClassTypeOnly(type2);
                                if (sCandidate != null && InheritanceUtil.isInheritorOrSelf(sCandidate, CClass, true)) {
                                    sType = (PsiClassType)type2;
                                    break;
                                }
                                ++var11_28;
                            }
                        }
                    }
                }
                if (sType == null) {
                    return false;
                }
                PsiClassType.ClassResolveResult SResult = sType.resolveGenerics();
                PsiClass SClass = SResult.getElement();
                if (SClass == null) {
                    return false;
                }
                if (((PsiClassType)this.myT).isRaw()) {
                    return InheritanceUtil.isInheritorOrSelf(SClass, CClass, true);
                }
                PsiSubstitutor substitutor2 = SResult.getSubstitutor();
                for (PsiTypeParameter typeParameter : SClass.getTypeParameters()) {
                    substitutor2 = substitutor2.put(typeParameter, substitutor2.substituteWithBoundsPromotion(typeParameter));
                }
                PsiSubstitutor psiSubstitutor = TResult.getSubstitutor();
                PsiSubstitutor sSubstitutor = TypeConversionUtil.getClassSubstitutor(CClass, SClass, substitutor2);
                if (sSubstitutor != null) {
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(CClass)) {
                        PsiType sSubstituted;
                        PsiType tSubstituted = psiSubstitutor.substitute(parameter);
                        if (tSubstituted == null ^ (sSubstituted = sSubstitutor.substitute(parameter)) == null) {
                            return false;
                        }
                        constraints.add(new SubtypingConstraint(tSubstituted, sSubstituted));
                    }
                    return true;
                }
            }
            return false;
        }
        if (this.myT instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)this.myT).getConjuncts()) {
                constraints.add(new StrictSubtypingConstraint(conjunct, this.myS));
            }
            return true;
        }
        if (this.myT instanceof PsiCapturedWildcardType && (lowerBound = ((PsiCapturedWildcardType)this.myT).getLowerBound()) != PsiType.NULL) {
            constraints.add(new StrictSubtypingConstraint(lowerBound, this.myS));
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictSubtypingConstraint that = (StrictSubtypingConstraint)o;
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result2 = this.myS != null ? this.myS.hashCode() : 0;
        result2 = 31 * result2 + (this.myT != null ? this.myT.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.myT.getPresentableText() + " < " + this.myS.getPresentableText();
    }
}

