/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskUpToDateState;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.caching.internal.tasks.TaskCacheKeyCalculator;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.reflect.Instantiator;

public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final TaskHistoryRepository taskHistoryRepository;
    private final FileCollectionSnapshotterRegistry fileCollectionSnapshotterRegistry;
    private final Instantiator instantiator;
    private final FileCollectionFactory fileCollectionFactory;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final TaskCacheKeyCalculator cacheKeyCalculator;
    private final ValueSnapshotter valueSnapshotter;

    public DefaultTaskArtifactStateRepository(TaskHistoryRepository taskHistoryRepository, Instantiator instantiator, FileCollectionSnapshotterRegistry fileCollectionSnapshotterRegistry, FileCollectionFactory fileCollectionFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, TaskCacheKeyCalculator cacheKeyCalculator, ValueSnapshotter valueSnapshotter) {
        this.taskHistoryRepository = taskHistoryRepository;
        this.instantiator = instantiator;
        this.fileCollectionSnapshotterRegistry = fileCollectionSnapshotterRegistry;
        this.fileCollectionFactory = fileCollectionFactory;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.cacheKeyCalculator = cacheKeyCalculator;
        this.valueSnapshotter = valueSnapshotter;
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        return new TaskArtifactStateImpl(task, this.taskHistoryRepository.getHistory(task));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskArtifactStateImpl
    implements TaskArtifactState,
    TaskExecutionHistory {
        private final TaskInternal task;
        private final TaskHistoryRepository.History history;
        private boolean upToDate;
        private boolean outputsRemoved;
        private TaskUpToDateState states;
        private IncrementalTaskInputsInternal taskInputs;

        public TaskArtifactStateImpl(TaskInternal task, TaskHistoryRepository.History history) {
            this.task = task;
            this.history = history;
        }

        @Override
        public boolean isUpToDate(Collection<String> messages) {
            this.upToDate = true;
            for (TaskStateChange stateChange : this.getStates().getAllTaskChanges()) {
                messages.add(stateChange.getMessage());
                this.upToDate = false;
            }
            return this.upToDate;
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            assert (!this.upToDate) : "Should not be here if the task is up-to-date";
            this.taskInputs = !this.outputsRemoved && this.canPerformIncrementalBuild() ? (IncrementalTaskInputsInternal)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, new Object[]{this.getStates().getInputFilesChanges()}) : (IncrementalTaskInputsInternal)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task});
            return this.taskInputs;
        }

        private boolean canPerformIncrementalBuild() {
            return Iterables.isEmpty((Iterable)this.getStates().getRebuildChanges());
        }

        @Override
        public boolean isAllowedToUseCachedResults() {
            return true;
        }

        @Override
        public OverlappingOutputs getOverlappingOutputs() {
            this.getStates();
            return this.history.getCurrentExecution().getDetectedOverlappingOutputs();
        }

        @Override
        public TaskOutputCachingBuildCacheKey calculateCacheKey() {
            this.getStates();
            return DefaultTaskArtifactStateRepository.this.cacheKeyCalculator.calculate(this.history.getCurrentExecution());
        }

        @Override
        public FileCollection getOutputFiles() {
            TaskExecution lastExecution = this.history.getPreviousExecution();
            if (lastExecution != null && lastExecution.getOutputFilesSnapshot() != null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (FileCollectionSnapshot snapshot : lastExecution.getOutputFilesSnapshot().values()) {
                    builder.addAll(snapshot.getFiles());
                }
                return DefaultTaskArtifactStateRepository.this.fileCollectionFactory.fixed("Task " + this.task.getPath() + " outputs", (Collection<File>)builder.build());
            }
            return DefaultTaskArtifactStateRepository.this.fileCollectionFactory.empty("Task " + this.task.getPath() + " outputs");
        }

        @Override
        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        @Override
        @Nullable
        public UniqueId getOriginBuildInvocationId() {
            TaskExecution previousExecution = this.history.getPreviousExecution();
            if (previousExecution == null) {
                return null;
            }
            return previousExecution.getBuildInvocationId();
        }

        @Override
        public void ensureSnapshotBeforeTask() {
            this.getStates();
        }

        @Override
        public void afterOutputsRemovedBeforeTask() {
            this.outputsRemoved = true;
        }

        @Override
        public void afterTask(Throwable failure) {
            if (this.upToDate) {
                return;
            }
            TaskUpToDateState taskState = this.getStates();
            if (this.taskInputs != null) {
                taskState.newInputs(this.taskInputs.getDiscoveredInputs());
            }
            taskState.getAllTaskChanges().snapshotAfterTask();
            if (failure == null || taskState.hasAnyOutputFileChanges()) {
                this.history.update();
            }
        }

        private TaskUpToDateState getStates() {
            if (this.states == null) {
                this.states = new TaskUpToDateState(this.task, this.history, DefaultTaskArtifactStateRepository.this.fileCollectionSnapshotterRegistry, DefaultTaskArtifactStateRepository.this.fileCollectionFactory, DefaultTaskArtifactStateRepository.this.classLoaderHierarchyHasher, DefaultTaskArtifactStateRepository.this.valueSnapshotter);
            }
            return this.states;
        }
    }
}

