/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderSensitiveTaskFilePropertyCompareStrategy
implements TaskFilePropertyCompareStrategy.Impl {
    OrderSensitiveTaskFilePropertyCompareStrategy() {
    }

    @Override
    public Iterator<TaskStateChange> iterateContentChangesSince(Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, final String fileType, boolean isPathAbsolute, final boolean includeAdded) {
        final Iterator<Map.Entry<String, NormalizedFileSnapshot>> currentEntries = current.entrySet().iterator();
        final Iterator<Map.Entry<String, NormalizedFileSnapshot>> previousEntries = previous.entrySet().iterator();
        return new AbstractIterator<TaskStateChange>(){
            private TaskStateChange remaining;

            protected TaskStateChange computeNext() {
                if (this.remaining != null) {
                    TaskStateChange next = this.remaining;
                    this.remaining = null;
                    return next;
                }
                while (currentEntries.hasNext()) {
                    Map.Entry current = (Map.Entry)currentEntries.next();
                    String absolutePath = (String)current.getKey();
                    if (previousEntries.hasNext()) {
                        String otherNormalizedPath;
                        Map.Entry other = (Map.Entry)previousEntries.next();
                        NormalizedFileSnapshot normalizedSnapshot = (NormalizedFileSnapshot)current.getValue();
                        NormalizedFileSnapshot otherNormalizedSnapshot = (NormalizedFileSnapshot)other.getValue();
                        String normalizedPath = normalizedSnapshot.getNormalizedPath();
                        if (normalizedPath.equals(otherNormalizedPath = otherNormalizedSnapshot.getNormalizedPath())) {
                            if (normalizedSnapshot.getSnapshot().isContentUpToDate(otherNormalizedSnapshot.getSnapshot())) continue;
                            return new FileChange(absolutePath, ChangeType.MODIFIED, fileType);
                        }
                        String otherAbsolutePath = (String)other.getKey();
                        if (includeAdded) {
                            this.remaining = new FileChange(absolutePath, ChangeType.ADDED, fileType);
                        }
                        return new FileChange(otherAbsolutePath, ChangeType.REMOVED, fileType);
                    }
                    if (!includeAdded) continue;
                    return new FileChange(absolutePath, ChangeType.ADDED, fileType);
                }
                if (previousEntries.hasNext()) {
                    return new FileChange((String)((Map.Entry)previousEntries.next()).getKey(), ChangeType.REMOVED, fileType);
                }
                return (TaskStateChange)this.endOfData();
            }
        };
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        for (NormalizedFileSnapshot normalizedSnapshot : snapshots) {
            normalizedSnapshot.appendToHasher(hasher);
        }
    }
}

