/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.caching.internal.BuildCacheHasher;

public class RuntimeClasspathResourceHasher
implements ResourceHasher {
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return fileSnapshot.getContent().getContentMd5();
    }

    public HashCode hash(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        Hasher hasher = Hashing.md5().newHasher();
        ByteStreams.copy((InputStream)zipInput, (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
        return hasher.hash();
    }

    public void appendConfigurationToHasher(BuildCacheHasher hasher) {
        hasher.putString(this.getClass().getName());
    }
}

