/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyState<T>
implements PropertyState<T> {
    private static final Provider<Object> NULL_PROVIDER = new Provider<Object>(){

        @Override
        public Object get() {
            throw new IllegalStateException("No value has been specified for this provider.");
        }

        @Override
        public Object getOrNull() {
            return null;
        }

        @Override
        public boolean isPresent() {
            return false;
        }
    };
    private Provider<? extends T> provider = (Provider)Cast.uncheckedCast(NULL_PROVIDER);

    @Override
    public void set(final T value) {
        this.provider = new DefaultProvider<T>(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return value;
            }
        });
    }

    @Override
    public void set(Provider<? extends T> provider) {
        this.provider = (Provider)Preconditions.checkNotNull(provider);
    }

    @Override
    public T get() {
        return this.provider.get();
    }

    @Override
    public T getOrNull() {
        return this.provider.getOrNull();
    }

    @Override
    public boolean isPresent() {
        return this.provider.isPresent();
    }

    public String toString() {
        return String.format("value: %s", this.getOrNull());
    }
}

