/*
 * Decompiled with CFR 0.152.
 */
package com.android.flags;

import com.android.flags.FlagGroup;
import com.android.flags.Flags;

public final class Flag<T> {
    private static final ValueConverter<Boolean> BOOL_CONVERTER = new ValueConverter<Boolean>(){

        @Override
        public String serialize(Boolean value) {
            return value.toString();
        }

        @Override
        public Boolean deserialize(String strValue) {
            return Boolean.parseBoolean(strValue);
        }
    };
    private static final ValueConverter<Integer> INT_CONVERTER = new ValueConverter<Integer>(){

        @Override
        public String serialize(Integer value) {
            return Integer.toString(value);
        }

        @Override
        public Integer deserialize(String strValue) {
            return Integer.valueOf(strValue);
        }
    };
    private static final ValueConverter<String> PASSTHRU_CONVERTER = new ValueConverter<String>(){

        @Override
        public String serialize(String value) {
            return value;
        }

        @Override
        public String deserialize(String strValue) {
            return strValue;
        }
    };
    private final FlagGroup group;
    private final String name;
    private final String displayName;
    private final String description;
    private final ValueConverter<T> valueConverter;
    private final String defaultValue;

    protected Flag(FlagGroup group, String name, String displayName, String description, T defaultValue, ValueConverter<T> valueConverter) {
        this.group = group;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.valueConverter = valueConverter;
        this.defaultValue = valueConverter.serialize(defaultValue);
        Flag.verifyFlagIdFormat(this.getId());
        Flag.verifyDispayTextFormat(displayName);
        Flag.verifyDispayTextFormat(description);
        group.getFlags().verifyUniqueId(this);
    }

    public static void verifyFlagIdFormat(String id) {
        if (!id.matches("[a-z][a-z0-9]*(\\.[a-z0-9]+)*")) {
            throw new IllegalArgumentException("Invalid id: " + id);
        }
    }

    public static void verifyDispayTextFormat(String name) {
        if (name.isEmpty() || name.charAt(0) == ' ' || name.charAt(name.length() - 1) == ' ') {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
    }

    public String getId() {
        return this.group.getName() + "." + this.name;
    }

    public static Flag<Boolean> create(FlagGroup group, String name, String displayName, String description, boolean defaultValue) {
        return new Flag<Boolean>(group, name, displayName, description, defaultValue, BOOL_CONVERTER);
    }

    public static Flag<Integer> create(FlagGroup group, String name, String displayName, String description, int defaultValue) {
        return new Flag<Integer>(group, name, displayName, description, defaultValue, INT_CONVERTER);
    }

    public static Flag<String> create(FlagGroup group, String name, String displayName, String description, String defaultValue) {
        return new Flag<String>(group, name, displayName, description, defaultValue, PASSTHRU_CONVERTER);
    }

    public FlagGroup getGroup() {
        return this.group;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public T get() {
        Flags flags = this.getGroup().getFlags();
        String strValue = flags.getOverriddenValue(this);
        if (strValue == null) {
            strValue = this.defaultValue;
        }
        return this.valueConverter.deserialize(strValue);
    }

    public void override(T overrideValue) {
        this.getGroup().getFlags().getOverrides().put(this, this.valueConverter.serialize(overrideValue));
    }

    public void clearOverride() {
        this.getGroup().getFlags().getOverrides().remove(this);
    }

    public boolean isOverridden() {
        return this.getGroup().getFlags().getOverrides().get(this) != null;
    }

    private static interface ValueConverter<T> {
        public String serialize(T var1);

        public T deserialize(String var1);
    }
}

