/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.AnnotateTask;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInferNullityAnnotationAction
extends InferNullityAnnotationsAction {
    private static final Logger LOG = Logger.getInstance(AndroidInferNullityAnnotationAction.class);
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    private static final String ADD_DEPENDENCY = "Add Support Dependency";
    private static final int MIN_SDK_WITH_NULLABLE = 19;

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (!Projects.isBuildWithGradle(project)) {
            super.analyze(project, scope);
            return;
        }
        int[] fileCount = new int[]{0};
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageInfo[] usageInfos = this.findUsages(project, scope, fileCount[0]);
        if (usageInfos == null) {
            return;
        }
        Map<Module, PsiFile> modules = AndroidInferNullityAnnotationAction.findModulesFromUsage(usageInfos);
        if (!this.checkModules(project, scope, modules)) {
            return;
        }
        if (usageInfos.length < 5) {
            ApplicationManager.getApplication().invokeLater(AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> usageInfos)));
        } else {
            AndroidInferNullityAnnotationAction.showUsageView(project, usageInfos, scope, this);
        }
    }

    private static Map<Module, PsiFile> findModulesFromUsage(UsageInfo[] infos) {
        HashMap<Module, PsiFile> modules = new HashMap<Module, PsiFile>();
        for (UsageInfo info : infos) {
            PsiElement element = info.getElement();
            assert (element != null);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            PsiFile file = element.getContainingFile();
            modules.put(module, file);
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkModules(final @NotNull Project project, final @NotNull AnalysisScope scope, @NotNull Map<Module, PsiFile> modules) {
        final HashSet<Module> modulesWithoutAnnotations = new HashSet<Module>();
        HashSet<Module> modulesWithLowVersion = new HashSet<Module>();
        for (Module module : modules.keySet()) {
            GradleBuildModel buildModel;
            AndroidModuleInfo info = AndroidModuleInfo.getInstance(module);
            if (info != null && info.getBuildSdkVersion() != null && info.getBuildSdkVersion().getFeatureLevel() < 19) {
                modulesWithLowVersion.add(module);
            }
            if ((buildModel = GradleBuildModel.get(module)) == null) {
                LOG.warn("Unable to find Gradle build model for module " + module.getModuleFilePath());
                continue;
            }
            boolean dependencyFound = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            if (dependenciesModel != null) {
                String configurationName = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                for (ArtifactDependencyModel dependency : dependenciesModel.artifacts(configurationName)) {
                    String notation = dependency.compactNotation().value();
                    if (!notation.startsWith("com.android.support:appcompat-v7") && !notation.startsWith("com.android.support:support-v4") && !notation.startsWith("com.android.support:support-annotations")) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            modulesWithoutAnnotations.add(module);
        }
        if (!modulesWithLowVersion.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)String.format("Infer Nullity Annotations requires the project sdk level be set to %1$d or greater.", 19), (String)INFER_NULLITY_ANNOTATIONS);
            return false;
        }
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String moduleNames = StringUtil.join(modulesWithoutAnnotations, Module::getName, (String)", ");
        int count = modulesWithoutAnnotations.size();
        String message = String.format("The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android nullity annotations. \n\nWould you like to add the %5$s now?", StringUtil.pluralize((String)"module", (int)count), moduleNames, count > 1 ? "do" : "does", SupportLibrary.SUPPORT_ANNOTATIONS.getArtifactId(), StringUtil.pluralize((String)"dependency", (int)count));
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(ADD_DEPENDENCY);
            try {
                new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        RepositoryUrlManager manager = RepositoryUrlManager.get();
                        String annotationsLibraryCoordinate = manager.getLibraryStringCoordinate(SupportLibrary.SUPPORT_ANNOTATIONS, true);
                        for (Module module : modulesWithoutAnnotations) {
                            AndroidInferNullityAnnotationAction.addDependency(module, annotationsLibraryCoordinate);
                        }
                        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(false).setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
                        GradleSyncInvoker.getInstance().requestProjectSync(project, request, new GradleSyncListener.Adapter(){

                            @Override
                            public void syncSucceeded(@NotNull Project project) {
                                AndroidInferNullityAnnotationAction.this.restartAnalysis(project, scope);
                            }
                        });
                    }
                }.execute();
            }
            finally {
                action.finish();
            }
        }
        return false;
    }

    private static Runnable applyRunnable(final Project project, final Computable<UsageInfo[]> computable) {
        return () -> {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(INFER_NULLITY_ANNOTATIONS);
            try {
                new WriteCommandAction(project, INFER_NULLITY_ANNOTATIONS, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        UsageInfo[] infos = (UsageInfo[])computable.compute();
                        if (infos.length > 0) {
                            LinkedHashSet elements = new LinkedHashSet();
                            for (UsageInfo info : infos) {
                                PsiElement element = info.getElement();
                                if (element == null) continue;
                                ContainerUtil.addIfNotNull(elements, (Object)element.getContainingFile());
                            }
                            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                                return;
                            }
                            SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, AndroidInferNullityAnnotationAction.INFER_NULLITY_ANNOTATIONS, false);
                            progressTask.setMinIterationTime(200L);
                            progressTask.setTask((SequentialTask)new AnnotateTask(project, progressTask, infos));
                            ProgressManager.getInstance().run((Task)progressTask);
                        } else {
                            NullityInferrer.nothingFoundMessage((Project)project);
                        }
                    }
                }.execute();
            }
            finally {
                action.finish();
            }
        };
    }

    protected void restartAnalysis(Project project, AnalysisScope scope) {
        ApplicationManager.getApplication().invokeLater(() -> this.analyze(project, scope));
    }

    private static void showUsageView(@NotNull Project project, UsageInfo[] usageInfos, @NotNull AnalysisScope scope, AndroidInferNullityAnnotationAction action) {
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), "Preprocess Usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, AndroidInferNullityAnnotationAction.rerunFactory(project, scope, action));
        Runnable refactoringRunnable = AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> {
            Set infos = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
            return infos.toArray(new UsageInfo[infos.size()]);
        }));
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable, INFER_NULLITY_ANNOTATIONS, canNotMakeString, INFER_NULLITY_ANNOTATIONS, false);
    }

    @NotNull
    private static Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope, final AndroidInferNullityAnnotationAction action) {
        return () -> new UsageInfoSearcherAdapter(){

            protected UsageInfo[] findUsages() {
                return action.findUsages(project, scope, scope.getFileCount());
            }

            public void generate(@NotNull Processor<Usage> processor) {
                this.processUsages(processor, project);
            }
        };
    }

    private static void addDependency(@NotNull Module module, @Nullable String libraryCoordinate) {
        if (StringUtil.isNotEmpty((String)libraryCoordinate)) {
            ModuleRootModificationUtil.updateModel((Module)module, model -> {
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                if (buildModel != null) {
                    String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                    buildModel.dependencies().addArtifact(name, libraryCoordinate);
                    buildModel.applyChanges();
                }
            });
        }
    }

    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        JComponent panel = super.getAdditionalActionSettings(project, dialog);
        if (panel != null && GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            panel.setVisible(false);
        }
        return panel;
    }
}

