/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.npw.project.ConfigureAndroidProjectStep;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidNewProjectAction
extends AnAction
implements DumbAware {
    public AndroidNewProjectAction() {
        this("New Project...");
    }

    public AndroidNewProjectAction(@NotNull String text) {
        super(text);
    }

    public void update(@NotNull AnActionEvent e) {
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.CreateNewProject);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        if (!AndroidSdkUtils.isAndroidSdkAvailable()) {
            SdkQuickfixUtils.showSdkMissingDialog();
            return;
        }
        NewProjectModel model = new NewProjectModel();
        ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(new ConfigureAndroidProjectStep(model)).build();
        new StudioWizardDialogBuilder(wizard, "Create New Project").setUseNewUx(true).build().show();
    }
}

