/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.ide.projectView.actions.MarkLibraryRootAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SortedListModel;
import com.intellij.util.ui.FormBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLibraryFromFilesAction
extends AnAction {
    AnAction myDelegate = new MarkLibraryRootAction();

    public CreateLibraryFromFilesAction() {
        super("Add As Library...");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        if (!AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            this.myDelegate.actionPerformed(e);
            return;
        }
        List<VirtualFile> jars = CreateLibraryFromFilesAction.getRoots(e);
        if (jars.isEmpty()) {
            return;
        }
        List roots = RootDetectionUtil.detectRoots(jars, null, (Project)project, (LibraryRootsComponentDescriptor)new DefaultLibraryRootsComponentDescriptor());
        new CreateGradleLibraryFromFilesDialog(project, roots).show();
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e);
        boolean visible = false;
        if (project != null && ModuleManager.getInstance((Project)project).getModules().length > 0) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (VirtualFile root : CreateLibraryFromFilesAction.getRoots(e)) {
                if (root.isInLocalFileSystem() || !FileUtilRt.extensionEquals((String)root.getName(), (String)"jar") || fileIndex.isInLibraryClasses(root)) continue;
                visible = true;
                break;
            }
        }
        Presentation presentation = e.getPresentation();
        presentation.setVisible(visible);
        presentation.setEnabled(visible);
    }

    @NotNull
    private static List<VirtualFile> getRoots(@NotNull AnActionEvent e) {
        Project project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null || files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            VirtualFile root = JarFileSystem.getInstance().getJarRootForLocalFile(file);
            if (root == null) continue;
            roots.add(root);
        }
        return roots;
    }

    private static class CreateGradleLibraryFromFilesDialog
    extends DialogWrapper {
        public static final String COMMAND_TITLE = "Create Library";
        private final ModulesComboBox myModulesComboBox;
        private final Project myProject;
        private final JPanel myPanel;
        private final List<OrderRoot> myRoots;
        private GradleSettingsFile mySettingsFile;

        public CreateGradleLibraryFromFilesDialog(@NotNull Project project, @NotNull List<OrderRoot> roots) {
            super(project, true);
            this.setTitle(COMMAND_TITLE);
            this.myProject = project;
            this.myRoots = roots;
            this.mySettingsFile = GradleSettingsFile.get(this.myProject);
            FormBuilder builder = LibraryNameAndLevelPanel.createFormBuilder();
            this.myModulesComboBox = new ModulesComboBox();
            this.myModulesComboBox.fillModules(this.myProject);
            this.myModulesComboBox.setSelectedModule(this.findModule(roots));
            Iterator iter = ((SortedListModel)this.myModulesComboBox.getModel()).iterator();
            while (iter.hasNext()) {
                Module module = (Module)iter.next();
                String path = GradleSettingsFile.getModuleGradlePath(module);
                if (path != null && this.mySettingsFile.hasBuildFile(path)) continue;
                iter.remove();
            }
            builder.addLabeledComponent("&Add to module:", (JComponent)this.myModulesComboBox);
            this.myPanel = builder.getPanel();
            this.init();
        }

        @Nullable
        private Module findModule(List<OrderRoot> roots) {
            for (OrderRoot root : roots) {
                Module module = null;
                VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(root.getFile());
                if (local != null) {
                    module = ModuleUtilCore.findModuleForFile((VirtualFile)local, (Project)this.myProject);
                }
                if (module == null) {
                    module = ModuleUtilCore.findModuleForFile((VirtualFile)root.getFile(), (Project)this.myProject);
                }
                if (module == null) continue;
                return module;
            }
            return null;
        }

        protected void doOKAction() {
            WriteAction.run(() -> {
                Module module = this.myModulesComboBox.getSelectedModule();
                if (module == null) {
                    return;
                }
                String moduleGradlePath = GradleSettingsFile.getModuleGradlePath(module);
                if (moduleGradlePath == null) {
                    return;
                }
                final GradleBuildFile buildFile = this.mySettingsFile.getModuleBuildFile(moduleGradlePath);
                List value = (List)buildFile.getValue(BuildFileKey.DEPENDENCIES);
                final List dependencies2 = value != null ? value : new ArrayList();
                boolean added = false;
                for (OrderRoot root : this.myRoots) {
                    VirtualFile parent = buildFile.getFile().getParent();
                    VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(root.getFile());
                    if (local != null) {
                        Dependency.Scope scope;
                        Dependency newDependency;
                        String path = VfsUtilCore.getRelativePath((VirtualFile)local, (VirtualFile)parent, (char)'/');
                        if (path == null) {
                            path = local.getPath();
                        }
                        if (!dependencies2.contains(newDependency = new Dependency(scope = Dependency.Scope.getDefaultScope(this.myProject), Dependency.Type.FILES, path))) {
                            dependencies2.add(newDependency);
                            added = true;
                        }
                    }
                    if (!added) continue;
                    new WriteCommandAction<Void>(this.myProject, COMMAND_TITLE, new PsiFile[]{buildFile.getPsiFile()}){

                        protected void run(@NotNull Result<Void> result) throws Throwable {
                            buildFile.setValue(BuildFileKey.DEPENDENCIES, dependencies2);
                        }
                    }.execute();
                }
            });
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
            super.doOKAction();
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }
    }
}

