/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import java.io.IOException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSampleDataDirectory
extends AnAction {
    private static final Logger LOG = Logger.getInstance(CreateSampleDataDirectory.class);

    public CreateSampleDataDirectory() {
        super(AndroidBundle.message("new.sampledata.dir.action.title", new Object[0]), AndroidBundle.message("new.sampledata.dir.action.description", new Object[0]), PlatformIcons.DIRECTORY_CLOSED_ICON);
    }

    @Nullable
    private static AndroidFacet getFacet(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Module[] modules = project != null ? Projects.getModulesToBuildFromSelection(project, e.getDataContext()) : null;
        return modules != null && modules.length > 0 ? AndroidFacet.getInstance(modules[0]) : null;
    }

    public void update(AnActionEvent e) {
        boolean visible;
        if (!StudioFlags.NELE_SAMPLE_DATA.get().booleanValue()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        AndroidFacet facet = CreateSampleDataDirectory.getFacet(e);
        try {
            visible = facet != null && SampleDataResourceRepository.getSampleDataDir(facet, false) == null;
        }
        catch (IOException ex) {
            visible = false;
        }
        e.getPresentation().setEnabledAndVisible(visible);
    }

    public void actionPerformed(AnActionEvent e) {
        if (!StudioFlags.NELE_SAMPLE_DATA.get().booleanValue()) {
            return;
        }
        AndroidFacet facet = CreateSampleDataDirectory.getFacet(e);
        assert (facet != null);
        try {
            SampleDataResourceRepository.getSampleDataDir(facet, true);
        }
        catch (IOException ex) {
            LOG.warn("Unable to create Sample Data directory", (Throwable)ex);
        }
    }
}

