/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.MockupToggleAction;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.mockup.editor.MockUpFileChooser;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupEditAction
extends AnAction {
    private static final String EDIT_ACTION_TITLE = "Edit Mockup";
    private static final String ADD_ACTION_TITLE = "Add Mockup";
    private final MockupToggleAction myMockupToggleAction;
    private final NlDesignSurface myDesignSurface;

    public MockupEditAction(@NotNull NlDesignSurface designSurface) {
        super(ADD_ACTION_TITLE);
        if (!StudioFlags.NELE_MOCKUP_EDITOR.get().booleanValue()) {
            this.getTemplatePresentation().setEnabledAndVisible(false);
            this.myMockupToggleAction = null;
            this.myDesignSurface = null;
            return;
        }
        this.myDesignSurface = designSurface;
        this.myMockupToggleAction = new MockupToggleAction(designSurface);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (StudioFlags.NELE_MOCKUP_EDITOR.get().booleanValue()) {
            NlComponent component2 = this.getFirstSelectedComponent();
            if (component2 == null) {
                presentation.setEnabled(false);
            } else if (component2.getAttribute("http://schemas.android.com/tools", "mockup") != null) {
                presentation.setText(EDIT_ACTION_TITLE);
            } else {
                presentation.setText(ADD_ACTION_TITLE);
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        this.myMockupToggleAction.setSelected(event, true);
        NlComponent component2 = this.getFirstSelectedComponent();
        if (component2 == null) {
            return;
        }
        this.myMockupToggleAction.setSelected(event, true);
        MockUpFileChooser.INSTANCE.chooseMockUpFile(component2, path -> NlWriteCommandAction.run(component2, Strings.nullToEmpty((String)event.getPresentation().getText()), () -> {
            component2.setAttribute("http://schemas.android.com/tools", "mockup", (String)path);
            component2.setAttribute("http://schemas.android.com/tools", "mockup_crop", "");
        }));
    }

    @Nullable
    public NlComponent getFirstSelectedComponent() {
        ScreenView screenView = this.myDesignSurface.getCurrentSceneView();
        if (screenView == null) {
            return null;
        }
        ImmutableList<NlComponent> selection = screenView.getSelectionModel().getSelection();
        if (selection.isEmpty()) {
            selection = screenView.getModel().getComponents();
        }
        if (selection.isEmpty()) {
            return null;
        }
        return (NlComponent)selection.get(0);
    }
}

