/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.mockup.editor.AnimatedComponentSplitter;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.AndroidIcons;
import java.awt.Dimension;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MockupToggleAction
extends ToggleAction {
    public static final Dimension CLOSED_DIMENSION = new Dimension(0, 0);
    public static final Dimension OPEN_DIMENSION = new Dimension(200, 200);
    private final NlDesignSurface mySurface;
    private static final String SHOW_ACTION_TITLE = "Show Mockup Editor";
    private static final String HIDE_ACTION_TITLE = "Hide Mockup Editor";

    public MockupToggleAction(@NotNull NlDesignSurface surface) {
        this.mySurface = surface;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(MockupToggleAction.getDesignIcon());
        presentation.setDescription(this.getDescription());
        this.getTemplatePresentation().setEnabledAndVisible(StudioFlags.NELE_MOCKUP_EDITOR.get().booleanValue());
    }

    @NotNull
    private String getDescription() {
        return this.mySurface.isCanvasResizing() ? HIDE_ACTION_TITLE : SHOW_ACTION_TITLE;
    }

    private static Icon getDesignIcon() {
        return AndroidIcons.Mockup.Mockup;
    }

    public boolean isSelected(AnActionEvent e) {
        return this.mySurface.isMockupVisible();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        this.getTemplatePresentation().setEnabled(state);
        this.mySurface.setMockupVisible(state);
        MockupEditor mockupEditor = this.mySurface.getMockupEditor();
        if (mockupEditor != null) {
            if (mockupEditor.getParent() instanceof AnimatedComponentSplitter) {
                mockupEditor.setMaximumSize(state ? OPEN_DIMENSION : CLOSED_DIMENSION);
                AnimatedComponentSplitter animatedComponentSplitter = (AnimatedComponentSplitter)((Object)mockupEditor.getParent());
                animatedComponentSplitter.showAnimateChild(mockupEditor, state);
                animatedComponentSplitter.setDividerMouseZoneSize(state ? 1 : 0);
                animatedComponentSplitter.setDividerWidth(state ? 1 : 0);
            } else {
                mockupEditor.setSize(this.mySurface.getWidth() / 3, this.mySurface.getHeight());
            }
        }
    }

    public void update(@NotNull AnActionEvent event) {
        event.getPresentation().setIcon(MockupToggleAction.getDesignIcon());
        event.getPresentation().setDescription(this.getDescription());
    }
}

