/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ApkFacetConfiguration
implements FacetConfiguration {
    private static final FacetEditorTab[] EDITOR_TABS = new FacetEditorTab[0];
    @NonNls
    public String APK_PATH;
    @NonNls
    public String APP_PACKAGE;
    @NotNull
    public List<SetupIssue> SETUP_ISSUES = new ArrayList<SetupIssue>();
    @NotNull
    public List<NativeLibrary> NATIVE_LIBRARIES = new ArrayList<NativeLibrary>();
    @NotNull
    public Set<String> JAVA_SOURCE_FOLDER_PATHS = new HashSet<String>();

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        return EDITOR_TABS;
    }

    @NotNull
    public Collection<String> getDebugSymbolFolderPaths(@NotNull List<Abi> abis) {
        if (this.NATIVE_LIBRARIES.isEmpty() || abis.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> paths = new HashSet<String>();
        for (Abi abi : abis) {
            for (NativeLibrary library : this.NATIVE_LIBRARIES) {
                File path;
                DebuggableSharedObjectFile sharedObjectFile = library.debuggableSharedObjectFilesByAbi.get(abi);
                if (sharedObjectFile == null || !(path = FilePaths.toSystemDependentPath(sharedObjectFile.path)).exists()) continue;
                paths.add(path.getParent());
            }
        }
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        return paths;
    }

    @NotNull
    public Map<File, File> getExplicitModuleSymbolMap(@NotNull Abi abi) {
        HashMap moduleToSymbols = new HashMap();
        for (NativeLibrary library : this.NATIVE_LIBRARIES) {
            VirtualFile lib = library.sharedObjectFilesByAbi.get(abi);
            DebuggableSharedObjectFile sharedObjectFile = library.debuggableSharedObjectFilesByAbi.get(abi);
            if (sharedObjectFile == null || lib == null) continue;
            File libFile = VfsUtilCore.virtualToIoFile((VirtualFile)lib);
            File symFile = FilePaths.toSystemDependentPath(sharedObjectFile.path);
            if (!libFile.exists() || !symFile.exists()) continue;
            moduleToSymbols.put(libFile, symFile);
        }
        return moduleToSymbols;
    }

    @NotNull
    public Map<String, String> getSymbolFolderPathMappings() {
        if (this.NATIVE_LIBRARIES.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap mappings = new HashMap();
        for (NativeLibrary library : this.NATIVE_LIBRARIES) {
            mappings.putAll(library.pathMappings);
        }
        return mappings;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        XmlSerializer.deserializeInto((Object)this, (Element)element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        XmlSerializer.serializeInto((Object)this, (Element)element);
    }

    @NotNull
    public List<NativeLibrary> getLibrariesWithoutDebugSymbols() {
        if (this.NATIVE_LIBRARIES.isEmpty()) {
            return Collections.emptyList();
        }
        return this.NATIVE_LIBRARIES.stream().filter(library -> !library.hasDebugSymbols).collect(Collectors.toList());
    }

    public void removeIssues(@NotNull String category) {
        ArrayList<SetupIssue> forRemoval = new ArrayList<SetupIssue>();
        for (SetupIssue issue2 : this.SETUP_ISSUES) {
            if (!category.equals(issue2.category)) continue;
            forRemoval.add(issue2);
        }
        if (!forRemoval.isEmpty()) {
            this.SETUP_ISSUES.removeAll(forRemoval);
        }
    }
}

