/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.smali.psi.SmaliClassName;
import com.android.tools.idea.smali.psi.SmaliClassSpec;
import com.android.tools.idea.smali.psi.SmaliFile;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexSourceFiles {
    public static final String SMALI_ROOT_FOLDER_NAME = "smali";
    public static final String SMALI_OUTPUT_FOLDER_NAME = "out";
    @NotNull
    private final Project myProject;
    @NotNull
    private final File myOutputFolderPath;

    @NotNull
    public static DexSourceFiles getInstance(@NotNull Project project) {
        return (DexSourceFiles)ServiceManager.getService((Project)project, DexSourceFiles.class);
    }

    public DexSourceFiles(@NotNull Project project) {
        this.myProject = project;
        this.myOutputFolderPath = this.getDefaultSmaliOutputFolderPath();
    }

    @NotNull
    public File getDefaultSmaliOutputFolderPath() {
        return new File(Projects.getBaseDirPath(this.myProject), FileUtil.join((String[])new String[]{SMALI_ROOT_FOLDER_NAME, SMALI_OUTPUT_FOLDER_NAME}));
    }

    public boolean isJavaFile(@NotNull VirtualFile file) {
        return !file.isDirectory() && "java".equals(file.getExtension());
    }

    @Nullable
    public String findJavaClassName(@NotNull SmaliFile smaliFile) {
        SmaliClassSpec classSpec = (SmaliClassSpec)PsiTreeUtil.findChildOfType((PsiElement)smaliFile, SmaliClassSpec.class);
        if (classSpec != null) {
            SmaliClassName className = classSpec.getClassName();
            return className != null ? className.getJavaClassName() : null;
        }
        return null;
    }

    public boolean navigateToJavaFile(@NotNull String classFqn) {
        PsiClass javaPsiClass = this.findJavaPsiClass(classFqn);
        if (javaPsiClass != null) {
            NavigationUtil.openFileWithPsiElement((PsiElement)javaPsiClass, (boolean)true, (boolean)true);
            return true;
        }
        return false;
    }

    @Nullable
    public PsiClass findJavaPsiClass(@NotNull String classFqn) {
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(classFqn, GlobalSearchScope.allScope((Project)this.myProject));
    }

    @NotNull
    public List<String> findJavaClassesIn(@NotNull VirtualFile file) {
        PsiClass[] classes;
        PsiJavaFile psiFile = this.findPsiJavaFileFor(file);
        if (psiFile != null && (classes = psiFile.getClasses()).length > 0) {
            return Arrays.stream(classes).map(PsiClass::getQualifiedName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    public String findJavaPackageNameIn(@NotNull VirtualFile file) {
        PsiJavaFile psiFile = this.findPsiJavaFileFor(file);
        return psiFile != null ? psiFile.getPackageName() : null;
    }

    public boolean isSmaliFile(@NotNull VirtualFile file) {
        return !file.isDirectory() && SMALI_ROOT_FOLDER_NAME.equals(file.getExtension());
    }

    @Nullable
    private PsiJavaFile findPsiJavaFileFor(@NotNull VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        return psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
    }

    @Nullable
    public VirtualFile findSmaliFile(@NotNull String classFqn) {
        File filePath = this.findSmaliFilePathForClass(classFqn);
        if (filePath.isFile()) {
            return LocalFileSystem.getInstance().findFileByPath(filePath.getPath());
        }
        return null;
    }

    @NotNull
    public File findSmaliFilePathForClass(@NotNull String classFqn) {
        return new File(this.myOutputFolderPath, classFqn.replace('.', File.separatorChar) + ".smali");
    }

    @NotNull
    public File findSmaliFilePathForPackage(@NotNull String packageFqn) {
        return new File(this.myOutputFolderPath, packageFqn.replace('.', File.separatorChar));
    }
}

