/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.tools.idea.gradle.util.ContentEntries;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SwingWorker;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSourceFolders {
    @NotNull
    private final ModifiableRootModel myModuleModel;

    public ExternalSourceFolders(@NotNull ModifiableRootModel moduleModel) {
        this.myModuleModel = moduleModel;
    }

    @NotNull
    public List<VirtualFile> addSourceFolders(@NotNull VirtualFile[] files, @Nullable Runnable runOnFinish) {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        HashSet<ContentEntry> contentEntries = new HashSet<ContentEntry>();
        for (VirtualFile file : files) {
            ContentEntry contentEntry = ContentEntries.findParentContentEntry(VfsUtilCore.virtualToIoFile((VirtualFile)file), Arrays.stream(this.myModuleModel.getContentEntries()));
            if (contentEntry == null) {
                contentEntry = this.myModuleModel.addContentEntry(file);
            }
            contentEntries.add(contentEntry);
        }
        if (!contentEntries.isEmpty()) {
            this.addSourceRoots(contentEntries, runOnFinish);
        }
        for (ContentEntry contentEntry : contentEntries) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            roots.add(file);
        }
        return roots;
    }

    private void addSourceRoots(@NotNull Set<ContentEntry> contentEntries, @Nullable Runnable runOnFinish) {
        EmptyProgressIndicator progressIndicator;
        HashMap<ContentEntry, Object> entryToRootMap = new HashMap<ContentEntry, Object>();
        HashMap<File, ContentEntry> fileToEntryMap = new HashMap<File, ContentEntry>();
        for (ContentEntry contentEntry : contentEntries) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            entryToRootMap.put(contentEntry, null);
            fileToEntryMap.put(VfsUtilCore.virtualToIoFile((VirtualFile)file), contentEntry);
        }
        Project project = this.myModuleModel.getProject();
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (unitTestMode) {
            progressIndicator = new EmptyProgressIndicator();
        } else {
            ProgressWindow progressWindow = new ProgressWindow(true, project);
            progressWindow.setTitle(ProjectBundle.message((String)"module.paths.searching.source.roots.title", (Object[])new Object[0]));
            progressIndicator = new SmoothProgressAdapter((ProgressIndicator)progressWindow, project);
        }
        final Runnable searchTask = () -> ExternalSourceFolders.lambda$addSourceRoots$1(fileToEntryMap, (ProgressIndicator)progressIndicator, entryToRootMap);
        final Runnable addSourcesTask = () -> {
            for (ContentEntry contentEntry : contentEntries) {
                Collection suggestedRoots = (Collection)entryToRootMap.get(contentEntry);
                if (suggestedRoots == null) continue;
                for (JavaModuleSourceRoot suggestedRoot : suggestedRoots) {
                    VirtualFile sourceRoot = LocalFileSystem.getInstance().findFileByIoFile(suggestedRoot.getDirectory());
                    VirtualFile fileContent = contentEntry.getFile();
                    if (sourceRoot == null || fileContent == null || !VfsUtilCore.isAncestor((VirtualFile)fileContent, (VirtualFile)sourceRoot, (boolean)false)) continue;
                    contentEntry.addSourceFolder(sourceRoot, false, suggestedRoot.getPackagePrefix());
                }
            }
            if (runOnFinish != null) {
                runOnFinish.run();
            }
        };
        if (unitTestMode) {
            searchTask.run();
            addSourcesTask.run();
        } else {
            new SwingWorker(){

                public Object construct() {
                    searchTask.run();
                    return null;
                }

                public void finished() {
                    addSourcesTask.run();
                }
            }.start();
        }
    }

    private static /* synthetic */ void lambda$addSourceRoots$1(Map fileToEntryMap, ProgressIndicator progressIndicator, Map entryToRootMap) {
        Runnable process = () -> {
            for (File file : fileToEntryMap.keySet()) {
                progressIndicator.setText(ProjectBundle.message((String)"module.paths.searching.source.roots.progress", (Object[])new Object[]{file.getPath()}));
                Collection roots = JavaSourceRootDetectionUtil.suggestRoots((File)file);
                entryToRootMap.put(fileToEntryMap.get(file), roots);
            }
        };
        ProgressManager.getInstance().runProcess(process, progressIndicator);
    }
}

