/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Shorts;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkFileSystem
extends ArchiveFileSystem {
    public static final Set<String> EXTENSIONS = ImmutableSet.of((Object)"apk", (Object)"aar", (Object)"iapk", (Object)"atom", (Object)"zip");
    public static final String PROTOCOL = "apk";
    public static final String APK_SEPARATOR = "!/";
    private static final String APKZIP_EXT = "apkzip";
    private static final String APKZIP_SUFFIX = ".apkzip";
    private static final Key<Boolean> APKZIP_KEY = Key.create((String)"android.zip.within.apk");

    public static ApkFileSystem getInstance() {
        return (ApkFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        return StringUtil.trimEnd((String)rootPath, (String)APK_SEPARATOR);
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        return localPath + APK_SEPARATOR;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        return VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, JarHandler::new);
    }

    @NotNull
    public String getRelativePath(@NotNull VirtualFile file) {
        String path = file.getPath();
        String relativePath = path.substring(this.extractRootPath(path).length());
        return StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') ? relativePath.substring(1) : relativePath;
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        int apkSeparatorIndex = path.indexOf(APK_SEPARATOR);
        assert (apkSeparatorIndex >= 0) : "Path passed to ApkFileSystem must have apk separator '!/': " + path;
        return path.substring(0, apkSeparatorIndex + APK_SEPARATOR.length());
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull @NonNls String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        byte[] bytes = super.contentsToByteArray(file);
        if (!this.isBinaryXml(file, bytes)) {
            return bytes;
        }
        return BinaryXmlParser.decodeXml((String)file.getName(), (byte[])bytes);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (APKZIP_EXT.equals(local.getExtension()) && Boolean.TRUE.equals(local.getUserData(APKZIP_KEY))) {
            return true;
        }
        return EXTENSIONS.contains(local.getExtension());
    }

    @Nullable
    public VirtualFile extractAndGetContentRoot(VirtualFile file) {
        File tempFile;
        try {
            tempFile = FileUtil.createTempFile((String)file.getName(), (String)APKZIP_SUFFIX, (boolean)true);
        }
        catch (IOException e) {
            Logger.getInstance(ApkFileSystem.class).warn("IOException while extracting zip file from APK", (Throwable)e);
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(file.contentsToByteArray());){
            Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.getInstance(ApkFileSystem.class).warn("IOException while copying contents of zip file to temp file", (Throwable)e);
            return null;
        }
        VirtualFile vfile = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true);
        if (vfile == null) {
            return null;
        }
        vfile.putUserData(APKZIP_KEY, (Object)Boolean.TRUE);
        return ApkFileSystem.getInstance().getRootByLocal(vfile);
    }

    public boolean isBinaryXml(VirtualFile file, byte[] bytes) {
        return ApkFileSystem.isBinaryXml(this.getRelativePath(file), bytes);
    }

    public static boolean isBinaryXml(String relativePath, byte[] bytes) {
        boolean encodedXmlPath;
        if (!relativePath.endsWith(".xml")) {
            return false;
        }
        boolean bl = encodedXmlPath = relativePath.equals("AndroidManifest.xml") || relativePath.startsWith("res") && !relativePath.startsWith("res/raw");
        if (!encodedXmlPath) {
            return false;
        }
        short code = Shorts.fromBytes((byte)bytes[1], (byte)bytes[0]);
        return code == Chunk.Type.XML.code();
    }
}

