/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.ide.common.process.ProcessException;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.log.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkParser {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private final Archive myArchive;
    private final ApkSizeCalculator myApkSizeCalculator;
    private ListenableFuture<ArchiveNode> myTreeStructure;
    private ListenableFuture<Long> myCompressedFullApkSize;

    public ApkParser(@NotNull Archive archive, @NotNull ApkSizeCalculator sizeCalculator) {
        this.myArchive = archive;
        this.myApkSizeCalculator = sizeCalculator;
    }

    @NotNull
    public synchronized ListenableFuture<ArchiveNode> constructTreeStructure() {
        if (this.myTreeStructure == null) {
            this.myTreeStructure = ourExecutorService.submit(this::createTreeNode);
        }
        return this.myTreeStructure;
    }

    public ArchiveNode updateTreeWithDownloadSizes(@NotNull ArchiveNode root) {
        ArchiveTreeStructure.updateDownloadFileSizes((ArchiveNode)root, (ApkSizeCalculator)this.myApkSizeCalculator);
        return root;
    }

    @NotNull
    public synchronized ListenableFuture<AndroidApplicationInfo> getApplicationInfo(@Nullable Archive archive) {
        return ourExecutorService.submit(() -> ApkParser.getAppInfo(archive));
    }

    @NotNull
    public synchronized ListenableFuture<Long> getUncompressedApkSize() {
        return ourExecutorService.submit(() -> this.myApkSizeCalculator.getFullApkRawSize(this.myArchive.getPath()));
    }

    @NotNull
    public synchronized ListenableFuture<Long> getCompressedFullApkSize() {
        if (this.myCompressedFullApkSize == null) {
            this.myCompressedFullApkSize = ourExecutorService.submit(() -> this.myApkSizeCalculator.getFullApkDownloadSize(this.myArchive.getPath()));
        }
        return this.myCompressedFullApkSize;
    }

    @NotNull
    private ArchiveNode createTreeNode() throws IOException {
        ArchiveNode node = ArchiveTreeStructure.create((Archive)this.myArchive);
        ArchiveTreeStructure.updateRawFileSizes((ArchiveNode)node, (ApkSizeCalculator)this.myApkSizeCalculator);
        return node;
    }

    @NotNull
    public static AndroidApplicationInfo getAppInfo(@Nullable Archive archive) {
        if (archive == null) {
            return AndroidApplicationInfo.UNKNOWN;
        }
        try {
            AaptInvoker invoker = new AaptInvoker(AndroidSdks.getInstance().tryToChooseSdkHandler(), (ILogger)new LogWrapper(ApkParser.class));
            List xmlTree = invoker.getXmlTree(archive.getPath().toFile(), "AndroidManifest.xml");
            return AndroidApplicationInfo.parse((List)xmlTree);
        }
        catch (ProcessException e) {
            Logger.getInstance(ApkViewPanel.class).warn("Unable to run aapt", (Throwable)e);
            return AndroidApplicationInfo.UNKNOWN;
        }
    }
}

