/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.PercentRenderer;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApkAnalyzerStats;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkViewPanel
implements TreeSelectionListener {
    private JPanel myContainer;
    private JScrollPane myColumnTreePane;
    private SimpleColoredComponent myNameComponent;
    private SimpleColoredComponent mySizeComponent;
    private AnimatedIcon myNameAsyncIcon;
    private AnimatedIcon mySizeAsyncIcon;
    private JButton myCompareWithButton;
    private Tree myTree;
    private DefaultTreeModel myTreeModel;
    private Listener myListener;

    public ApkViewPanel(@NotNull ApkParser apkParser) {
        this.$$$setupUI$$$();
        ListenableFuture<ArchiveNode> treeStructureFuture = apkParser.constructTreeStructure();
        FutureCallBackAdapter<ArchiveNode> setRootNode = new FutureCallBackAdapter<ArchiveNode>(){

            @Override
            public void onSuccess(ArchiveNode result) {
                ApkViewPanel.this.setRootNode(result);
            }
        };
        Futures.addCallback(treeStructureFuture, (FutureCallback)setRootNode, (Executor)EdtExecutor.INSTANCE);
        ListenableFuture compressedTreeFuture = Futures.transform(treeStructureFuture, input -> {
            assert (input != null);
            return apkParser.updateTreeWithDownloadSizes((ArchiveNode)input);
        }, (Executor)PooledThreadExecutor.INSTANCE);
        Futures.addCallback((ListenableFuture)compressedTreeFuture, (FutureCallback)new FutureCallBackAdapter<ArchiveNode>(){

            @Override
            public void onSuccess(ArchiveNode result) {
                ArchiveTreeStructure.sort((ArchiveNode)result, (o1, o2) -> Longs.compare((long)o2.getData().getDownloadFileSize(), (long)o1.getData().getDownloadFileSize()));
                ApkViewPanel.this.refreshTree();
            }
        }, (Executor)EdtExecutor.INSTANCE);
        this.mySizeComponent.setToolTipText(AndroidBundle.message("apk.viewer.size.types.tooltip", new Object[0]));
        this.myContainer.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myCompareWithButton.addActionListener(e -> {
            if (this.myListener != null) {
                this.myListener.selectApkAndCompare();
            }
        });
        this.myNameAsyncIcon.setVisible(true);
        this.myNameComponent.append("Parsing Manifest");
        ListenableFuture applicationInfo = Futures.transformAsync(treeStructureFuture, input -> {
            assert (input != null);
            return apkParser.getApplicationInfo(Archives.getFirstManifestArchive((ArchiveNode)input));
        }, (Executor)PooledThreadExecutor.INSTANCE);
        Futures.addCallback((ListenableFuture)applicationInfo, (FutureCallback)new FutureCallBackAdapter<AndroidApplicationInfo>(){

            @Override
            public void onSuccess(AndroidApplicationInfo result) {
                ApkViewPanel.this.setAppInfo(result);
            }
        }, (Executor)EdtExecutor.INSTANCE);
        this.mySizeAsyncIcon.setVisible(true);
        this.mySizeComponent.append("Estimating download size..");
        ListenableFuture<Long> uncompressedApkSize = apkParser.getUncompressedApkSize();
        ListenableFuture<Long> compressedFullApkSize = apkParser.getCompressedFullApkSize();
        Futures.addCallback((ListenableFuture)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{uncompressedApkSize, compressedFullApkSize}), (FutureCallback)new FutureCallBackAdapter<List<Long>>(){

            @Override
            public void onSuccess(List<Long> result) {
                if (result != null) {
                    long uncompressed = result.get(0);
                    Long compressed = result.get(1);
                    ApkViewPanel.this.setApkSizes(uncompressed, compressed == null ? 0L : compressed);
                }
            }
        }, (Executor)EdtExecutor.INSTANCE);
        Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{uncompressedApkSize, compressedFullApkSize, applicationInfo}), (FutureCallback)new FutureCallBackAdapter<List<Object>>(){

            @Override
            public void onSuccess(@Nullable List<Object> result) {
                if (result == null) {
                    return;
                }
                int size = result.size();
                long uncompressed = size > 0 && result.get(0) instanceof Long ? (Long)result.get(0) : -1L;
                long compressed = size > 1 && result.get(1) instanceof Long ? (Long)result.get(1) : -1L;
                String applicationId = size > 2 && result.get(2) instanceof AndroidApplicationInfo ? ((AndroidApplicationInfo)result.get((int)2)).packageId : "unknown";
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APK_ANALYZER_STATS).setProjectId(AnonymizerUtil.anonymizeUtf8((String)applicationId)).setApkAnalyzerStats(ApkAnalyzerStats.newBuilder().setCompressedSize(compressed).setUncompressedSize(uncompressed).build()));
            }
        });
    }

    private void createUIComponents() {
        this.myNameAsyncIcon = new AsyncProcessIcon("aapt xmltree manifest");
        this.mySizeAsyncIcon = new AsyncProcessIcon("estimating apk size");
        this.myTreeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, path -> {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof ArchiveTreeNode)) {
                return null;
            }
            return ((ArchiveTreeNode)lastPathComponent).getData().getPath().toString();
        }, true);
        PercentRenderer.PercentProvider percentProvider = (jTree, value, row) -> {
            if (!(value instanceof ArchiveTreeNode)) {
                return 0.0;
            }
            ArchiveTreeNode entry = (ArchiveTreeNode)value;
            ArchiveTreeNode rootEntry = (ArchiveTreeNode)jTree.getModel().getRoot();
            if (entry.getData().getDownloadFileSize() < 0L) {
                return 0.0;
            }
            return (double)entry.getData().getDownloadFileSize() / (double)rootEntry.getData().getDownloadFileSize();
        };
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(600).setHeaderAlignment(10).setRenderer((ColoredTreeCellRenderer)new NameRenderer(treeSpeedSearch))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Raw File Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(false))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Download Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("% of Total Download size").setPreferredWidth(150).setHeaderAlignment(10).setRenderer((ColoredTreeCellRenderer)new PercentRenderer(percentProvider)));
        this.myColumnTreePane = (JScrollPane)builder.build();
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    public void setListener(@NotNull Listener listener) {
        this.myListener = listener;
    }

    private void setRootNode(@NotNull ArchiveNode root) {
        this.myTreeModel = new DefaultTreeModel((TreeNode)root);
        this.myTree.setPaintBusy(root.getData().getDownloadFileSize() < 0L);
        this.myTree.setRootVisible(false);
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    private void refreshTree() {
        this.myTree.setPaintBusy(false);
        this.myTree.removeTreeSelectionListener((TreeSelectionListener)this);
        TreePath[] selected = this.myTree.getSelectionPaths();
        this.myTreeModel.reload();
        this.myTree.setSelectionPaths(selected);
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    private void setApkSizes(long uncompressed, long compressedFullApk) {
        this.mySizeComponent.clear();
        if (this.mySizeAsyncIcon != null) {
            this.mySizeAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.mySizeAsyncIcon);
            this.mySizeAsyncIcon = null;
        }
        this.mySizeComponent.setIcon(AllIcons.General.BalloonInformation);
        this.mySizeComponent.append("Raw File Size: ");
        this.mySizeComponent.append(ApkViewPanel.getHumanizedSize(uncompressed), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.mySizeComponent.append(", Download Size: ");
        this.mySizeComponent.append(ApkViewPanel.getHumanizedSize(compressedFullApk), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    private void setAppInfo(@NotNull AndroidApplicationInfo appInfo) {
        this.myNameComponent.clear();
        if (this.myNameAsyncIcon != null) {
            this.myNameAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.myNameAsyncIcon);
            this.myNameAsyncIcon = null;
        }
        this.myNameComponent.append(appInfo.packageId, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.myNameComponent.append(" (version ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myNameComponent.append(appInfo.versionName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myNameComponent.append(")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    public JComponent getContainer() {
        return this.myContainer;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.myListener != null) {
            ArchiveTreeNode[] components;
            TreePath[] paths = ((Tree)e.getSource()).getSelectionPaths();
            if (paths == null) {
                components = null;
            } else {
                components = new ArchiveTreeNode[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    if (!(paths[i].getLastPathComponent() instanceof ArchiveTreeNode)) {
                        this.myListener.selectionChanged(null);
                        return;
                    }
                    components[i] = (ArchiveTreeNode)paths[i].getLastPathComponent();
                }
            }
            this.myListener.selectionChanged(components);
        }
    }

    public static String getHumanizedSize(long sizeInBytes) {
        long kilo = 1024L;
        long mega = kilo * kilo;
        DecimalFormat formatter = new DecimalFormat("#.#");
        int sign = sizeInBytes < 0L ? -1 : 1;
        if ((sizeInBytes = Math.abs(sizeInBytes)) > mega) {
            return formatter.format((double)((long)sign * sizeInBytes) / (double)mega) + " MB";
        }
        if (sizeInBytes > kilo) {
            return formatter.format((double)((long)sign * sizeInBytes) / (double)kilo) + " KB";
        }
        return (long)sign * sizeInBytes + " B";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        SimpleColoredComponent simpleColoredComponent;
        SimpleColoredComponent simpleColoredComponent2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JScrollPane jScrollPane = this.myColumnTreePane;
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myNameComponent = simpleColoredComponent2 = new SimpleColoredComponent();
        Component component2 = jPanel2.add((Component)simpleColoredComponent2);
        AnimatedIcon animatedIcon = this.myNameAsyncIcon;
        Component component3 = jPanel2.add((Component)animatedIcon);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.mySizeComponent = simpleColoredComponent = new SimpleColoredComponent();
        Component component4 = jPanel3.add((Component)simpleColoredComponent);
        AnimatedIcon animatedIcon2 = this.mySizeAsyncIcon;
        Component component5 = jPanel3.add((Component)animatedIcon2);
        this.myCompareWithButton = jButton = new JButton();
        jButton.setText("Compare with previous APK...");
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    private static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myUseDownloadSize;

        public SizeRenderer(boolean useDownloadSize) {
            this.myUseDownloadSize = useDownloadSize;
            this.setTextAlign(4);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long size;
            if (!(value instanceof ArchiveTreeNode)) {
                return;
            }
            ArchiveEntry data = ((ArchiveTreeNode)value).getData();
            long l = size = this.myUseDownloadSize ? data.getDownloadFileSize() : data.getRawFileSize();
            if (size > 0L) {
                this.append(ApkViewPanel.getHumanizedSize(size));
            }
        }
    }

    public static class NameRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        public NameRenderer(@NotNull TreeSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof ArchiveNode)) {
                this.append(value.toString());
                return;
            }
            ArchiveEntry entry = ((ArchiveNode)value).getData();
            Path path = entry.getPath();
            this.setIcon(NameRenderer.getIconFor(path));
            Path base = path.getFileName();
            String name = base == null ? "" : base.toString();
            name = StringUtil.trimEnd((String)name, (String)"/");
            SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)name, (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
        }

        @NotNull
        private static Icon getIconFor(@NotNull Path path) {
            String fileName;
            Path base = path.getFileName();
            String string = fileName = base == null ? "" : base.toString();
            if (!Files.isDirectory(path, new LinkOption[0])) {
                if (fileName == "AndroidManifest.xml") {
                    return AndroidIcons.ManifestFile;
                }
                if (fileName.endsWith(".dex")) {
                    return AllIcons.FileTypes.JavaClass;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
                Icon ftIcon = fileType.getIcon();
                return ftIcon == null ? AllIcons.FileTypes.Any_type : ftIcon;
            }
            if ((fileName = StringUtil.trimEnd((String)fileName, (String)"/")).equals("res")) {
                return AllIcons.Modules.ResourcesRoot;
            }
            return AllIcons.Modules.SourceFolder;
        }
    }

    public static class FutureCallBackAdapter<V>
    implements FutureCallback<V> {
        public void onSuccess(V result) {
        }

        public void onFailure(@NotNull Throwable t) {
        }
    }

    public static interface Listener {
        public void selectionChanged(@Nullable ArchiveTreeNode[] var1);

        public void selectApkAndCompare();
    }
}

