/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.ApkVirtualFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApkVirtualFile
extends BinaryLightVirtualFile {
    @Nullable
    private final Path parentPath;

    public ApkVirtualFile(@NotNull String filename, @Nullable Path parentPath, @NotNull byte[] content) {
        super(filename, content);
        this.parentPath = parentPath;
    }

    public VirtualFile getParent() {
        return ApkVirtualFolder.getDirectory(this.parentPath);
    }

    @Nullable
    public static ApkVirtualFile create(@NotNull Path path, @NotNull byte[] content) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            return null;
        }
        return new ApkVirtualFile(fileName.toString(), path.getParent(), content);
    }
}

