/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.diff;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.apk.analyzer.internal.ApkDiffEntry;
import com.android.tools.apk.analyzer.internal.ApkEntry;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.ddms.EdtExecutor;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.containers.Convertor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkDiffPanel {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private ListenableFuture<DefaultMutableTreeNode> myFbfTreeStructureFuture;
    private JPanel myContainer;
    private JScrollPane myColumnTreePane;
    private JCheckBox myCalculateFileByFileCheckBox;
    private final VirtualFile myOldApk;
    private final VirtualFile myNewApk;
    private Tree myTree;
    private DefaultTreeModel myTreeModel;

    public ApkDiffPanel(VirtualFile oldApk, VirtualFile newApk) {
        this.myOldApk = oldApk;
        this.myNewApk = newApk;
        this.$$$setupUI$$$();
        this.myCalculateFileByFileCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ApkDiffPanel.this.myCalculateFileByFileCheckBox.isSelected()) {
                    ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(false);
                    ApkDiffPanel.this.constructFbfTree();
                } else {
                    ApkDiffPanel.this.constructDiffTree();
                }
            }
        });
        this.constructDiffTree();
    }

    private void constructFbfTree() {
        if (this.myFbfTreeStructureFuture == null) {
            this.myFbfTreeStructureFuture = ourExecutorService.submit(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode> setRootNode = new ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode>(){

            @Override
            public void onSuccess(DefaultMutableTreeNode result) {
                ApkDiffPanel.this.setRootNode(result);
                ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(true);
            }
        };
        Futures.addCallback(this.myFbfTreeStructureFuture, (FutureCallback)setRootNode, (Executor)EdtExecutor.INSTANCE);
    }

    private void constructDiffTree() {
        ListenableFuture treeStructureFuture = ourExecutorService.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode> setRootNode = new ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode>(){

            @Override
            public void onSuccess(DefaultMutableTreeNode result) {
                ApkDiffPanel.this.setRootNode(result);
                ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(true);
            }
        };
        Futures.addCallback((ListenableFuture)treeStructureFuture, (FutureCallback)setRootNode, (Executor)EdtExecutor.INSTANCE);
    }

    private void createUIComponents() {
        this.myTreeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        Convertor<TreePath, String> convertor = new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                ApkEntry e = ApkEntry.fromNode((Object)path.getLastPathComponent());
                if (e == null) {
                    return null;
                }
                return e.getPath().toString();
            }
        };
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, (Convertor)convertor, true);
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(600).setHeaderAlignment(10).setRenderer((ColoredTreeCellRenderer)new NameRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Old Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((Function<ApkEntry, Long>)((Function)ApkDiffEntry::getOldSize)))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("New Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((Function<ApkEntry, Long>)((Function)ApkDiffEntry::getNewSize)))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Diff Size").setPreferredWidth(150).setHeaderAlignment(11).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((Function<ApkEntry, Long>)((Function)ApkEntry::getSize))));
        this.myColumnTreePane = (JScrollPane)builder.build();
    }

    @NotNull
    public JComponent getContainer() {
        return this.myContainer;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private void setRootNode(@NotNull DefaultMutableTreeNode root) {
        this.myTreeModel = new DefaultTreeModel(root);
        ApkEntry entry = ApkEntry.fromNode((Object)root);
        assert (entry != null);
        this.myTree.setPaintBusy(false);
        this.myTree.setRootVisible(true);
        this.myTree.expandPath(new TreePath(root));
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = this.myColumnTreePane;
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, new Dimension(400, -1), new Dimension(400, 300), null));
        this.myCalculateFileByFileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText("This is a size estimation for the update that Play store sends to the device");
        jCheckBox.setText("Show File-By-File patch size (may take a long time)");
        ((Component)jCheckBox).setEnabled(false);
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    static class NameRenderer
    extends ColoredTreeCellRenderer {
        NameRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ApkEntry entry = ApkEntry.fromNode((Object)value);
            ApkEntry root = ApkEntry.fromNode((Object)tree.getModel().getRoot());
            if (entry == null || root == null) {
                return;
            }
            this.append(entry.getName());
        }
    }

    public static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private Function<ApkEntry, Long> mySizeMapper;

        public SizeRenderer(Function<ApkEntry, Long> sizeMapper) {
            this.mySizeMapper = sizeMapper;
            this.setTextAlign(4);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ApkEntry entry = ApkEntry.fromNode((Object)value);
            ApkEntry root = ApkEntry.fromNode((Object)tree.getModel().getRoot());
            if (entry == null || root == null) {
                return;
            }
            this.append(ApkViewPanel.getHumanizedSize((Long)this.mySizeMapper.fun((Object)entry)));
        }
    }
}

