/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.RecipeMetadata;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RecipeUtils {
    private static Map<Pair<Recipe, Project>, List<RecipeMetadata>> myRecipeMetadataCache = new HashMap<Pair<Recipe, Project>, List<RecipeMetadata>>();

    @NotNull
    public static RecipeMetadata getRecipeMetadata(@NotNull Recipe recipe, @NotNull Module module) {
        Pair key = new Pair((Object)recipe, (Object)module.getProject());
        if (myRecipeMetadataCache.containsKey(key)) {
            List<RecipeMetadata> metadataSet = myRecipeMetadataCache.get(key);
            for (RecipeMetadata metadata : metadataSet) {
                if (!metadata.getRecipe().equals(recipe)) continue;
                return metadata;
            }
        }
        LinkedHashMultimap dependencies2 = LinkedHashMultimap.create();
        HashSet classpathEntries = Sets.newHashSet();
        HashSet plugins = Sets.newHashSet();
        ArrayList sourceFiles = Lists.newArrayList();
        ArrayList targetFiles = Lists.newArrayList();
        RecipeMetadata metadata = new RecipeMetadata(recipe, module);
        RenderingContext context = null;
        try {
            File moduleRoot = new File(module.getModuleFilePath()).getParentFile();
            File RootPath = new File(FileUtil.generateRandomTemporaryPath(), "unused");
            RootPath.deleteOnExit();
            context = RenderingContext.Builder.newContext(RootPath, module.getProject()).withOutputRoot(moduleRoot).withModuleRoot(moduleRoot).withFindOnlyReferences(true).withPerformSync(false).intoDependencies((SetMultimap<String, String>)dependencies2).intoClasspathEntries(classpathEntries).intoPlugins(plugins).intoSourceFiles(sourceFiles).intoTargetFiles(targetFiles).build();
            RecipeExecutor recipeExecutor = context.getRecipeExecutor();
            recipe.execute(recipeExecutor);
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            RecipeUtils.getLog().warn("Template processing exception with context in the following state: " + context);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String d : dependencies2.get((Object)"compile")) {
            metadata.addDependency(d);
        }
        for (String c : classpathEntries) {
            metadata.addClasspathEntry(c);
        }
        for (String p : plugins) {
            metadata.addPlugin(p);
        }
        for (File f : sourceFiles) {
            if (!f.getName().equals("AndroidManifest.xml")) continue;
            RecipeUtils.parseManifestForPermissions(f, metadata);
        }
        for (File f : targetFiles) {
            metadata.addModifiedFile(f);
        }
        return metadata;
    }

    @NotNull
    public static List<RecipeMetadata> getRecipeMetadata(@NotNull Recipe recipe, @NotNull Project project) {
        Pair key = new Pair((Object)recipe, (Object)project);
        if (!myRecipeMetadataCache.containsKey(key)) {
            ImmutableList.Builder cache = ImmutableList.builder();
            for (Module module : GradleProjectInfo.getInstance(project).getAndroidModules()) {
                cache.add((Object)RecipeUtils.getRecipeMetadata(recipe, module));
            }
            myRecipeMetadataCache.put((Pair<Recipe, Project>)key, (List<RecipeMetadata>)cache.build());
        }
        return myRecipeMetadataCache.get(key);
    }

    public static void execute(final @NotNull Recipe recipe, @NotNull Module module) {
        ArrayList filesToOpen = Lists.newArrayList();
        File moduleRoot = new File(module.getModuleFilePath()).getParentFile();
        File RootPath = null;
        try {
            RootPath = new File(FileUtil.generateRandomTemporaryPath(), "unused");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RenderingContext context = RenderingContext.Builder.newContext(RootPath, module.getProject()).withOutputRoot(moduleRoot).withModuleRoot(moduleRoot).intoOpenFiles(filesToOpen).build();
        final RecipeExecutor recipeExecutor = context.getRecipeExecutor();
        new WriteCommandAction.Simple(module.getProject(), "Executing recipe instructions", new PsiFile[0]){

            protected void run() throws Throwable {
                recipe.execute(recipeExecutor);
            }
        }.execute();
        TemplateUtils.openEditors(module.getProject(), filesToOpen, true);
    }

    private static void parseManifestForPermissions(@NotNull File f, final @NotNull RecipeMetadata metadata) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(f, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
                    if (tagName.equals("uses-permission") || tagName.equals("uses-permission-sdk-23") || tagName.equals("uses-permission-sdk-m")) {
                        String permission = attributes.getValue("android:name");
                        permission = permission.replace("android.permission.", "");
                        metadata.addPermission(permission);
                    }
                }
            });
        }
        catch (Exception e) {
            RecipeUtils.getLog().warn("Failed to read permissions from AndroidManifest.xml", (Throwable)e);
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(RecipeUtils.class);
    }
}

