/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.StatefulButtonUI;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.ide.ui.laf.intellij.MacIntelliJButtonBorder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatefulButton
extends JPanel {
    @NotNull
    final ActionButton myButton;
    @Nullable
    private final String mySuccessMessage;
    @Nullable
    private final AssistActionStateManager myStateManager;
    @NotNull
    private final ActionData myAction;
    @NotNull
    private final Project myProject;
    @Nullable
    StatefulButtonMessage myMessage;

    public StatefulButton(@NotNull ActionData action, @NotNull ActionListener listener, @Nullable AssistActionStateManager stateManager, @NotNull Project project) {
        super((LayoutManager)new VerticalLayout(5, 2));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.myAction = action;
        this.myStateManager = stateManager;
        this.myProject = project;
        this.mySuccessMessage = action.getSuccessMessage();
        this.myButton = new ActionButton(action, listener, this){

            @Override
            public void setUI(ButtonUI ui) {
                super.setUI(StatefulButtonUI.createUI(StatefulButton.this.myButton));
                JButton defaultButton = new JButton();
                Border defaultButtonBorder = defaultButton.getBorder();
                if (defaultButtonBorder instanceof MacIntelliJButtonBorder) {
                    defaultButtonBorder = new DarculaButtonPainter();
                }
                Insets insets = defaultButtonBorder.getBorderInsets(defaultButton);
                this.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            }
        };
        this.add(this.myButton);
        this.myButton.setVisible(false);
        if (this.myStateManager != null) {
            this.myStateManager.init(project, action);
            this.myMessage = this.myStateManager.getStateDisplay(project, action, this.mySuccessMessage);
            this.add(this.myMessage);
            this.myMessage.setVisible(false);
            for (Module module : GradleProjectInfo.getInstance(project).getAndroidModules()) {
                MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
                connection.subscribe(StatefulButtonNotifier.BUTTON_STATE_TOPIC, this::updateButtonState);
            }
        }
        this.updateButtonState();
    }

    @NotNull
    public ActionData getActionData() {
        return this.myAction;
    }

    public void updateButtonState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateButtonState);
            return;
        }
        if (this.myStateManager == null) {
            this.myButton.setVisible(true);
            return;
        }
        AssistActionState state = this.myStateManager.getState(this.myProject, this.myAction);
        this.revalidate();
        this.repaint();
        if (this.myMessage != null) {
            this.updateUIForState(state);
            return;
        }
    }

    private void updateUIForState(AssistActionState state) {
        this.myButton.setVisible(state.isButtonVisible());
        this.myButton.setEnabled(state.isButtonEnabled());
        this.myMessage.setVisible(state.isMessageVisible());
        if (state.isMessageVisible()) {
            this.remove(this.myMessage);
            this.myMessage = this.myStateManager.getStateDisplay(this.myProject, this.myAction, this.mySuccessMessage);
            if (this.myMessage == null) {
                return;
            }
            this.add(this.myMessage);
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public static class ActionButton
    extends JButton {
        private final String myKey;
        private final StatefulButton myButtonWrapper;

        public ActionButton(@NotNull ActionData action, @NotNull ActionListener listener, @NotNull StatefulButton wrapper) {
            super(action.getLabel());
            this.myKey = action.getKey();
            this.myButtonWrapper = wrapper;
            this.addActionListener(listener);
            this.setOpaque(false);
        }

        @NotNull
        public String getKey() {
            return this.myKey;
        }

        public void updateState() {
            this.myButtonWrapper.updateButtonState();
        }

        @NotNull
        public ActionData getActionData() {
            return this.myButtonWrapper.getActionData();
        }

        @NotNull
        public Project getProject() {
            return this.myButtonWrapper.getProject();
        }
    }
}

