/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SkinLayoutDefinition;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.DoubleProperty;
import com.android.tools.idea.observable.core.DoubleValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableDouble;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.observable.expressions.double_.DoubleExpression;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdDeviceData {
    private StringProperty myName = new StringValueProperty();
    private OptionalProperty<IdDisplay> myDeviceType = new OptionalValueProperty<IdDisplay>();
    private StringProperty myManufacturer = new StringValueProperty();
    private StringProperty myTagId = new StringValueProperty();
    private DoubleProperty myDiagonalScreenSize = new DoubleValueProperty();
    private IntProperty myScreenResolutionWidth = new IntValueProperty();
    private IntProperty myScreenResolutionHeight = new IntValueProperty();
    private ObjectProperty<Storage> myRamStorage = new ObjectValueProperty<Storage>(new Storage(0L, Storage.Unit.MiB));
    private BoolProperty myHasHardwareButtons = new BoolValueProperty();
    private BoolProperty myHasHardwareKeyboard = new BoolValueProperty();
    private OptionalProperty<Navigation> myNavigation = new OptionalValueProperty<Navigation>();
    private BoolProperty mySupportsLandscape = new BoolValueProperty();
    private BoolProperty mySupportsPortrait = new BoolValueProperty();
    private BoolProperty myNotLong = new BoolValueProperty();
    private BoolProperty myHasBackCamera = new BoolValueProperty();
    private BoolProperty myHasFrontCamera = new BoolValueProperty();
    private BoolProperty myHasAccelerometer = new BoolValueProperty();
    private BoolProperty myHasGyroscope = new BoolValueProperty();
    private BoolProperty myHasGps = new BoolValueProperty();
    private BoolProperty myHasProximitySensor = new BoolValueProperty();
    private OptionalProperty<File> myCustomSkinFile = new OptionalValueProperty<File>();
    private BoolValueProperty myIsTv = new BoolValueProperty();
    private BoolValueProperty myIsWear = new BoolValueProperty();
    private BoolValueProperty myIsScreenRound = new BoolValueProperty();
    private IntValueProperty myScreenChinSize = new IntValueProperty();
    private State myDefaultState;
    private File myLastSkinFolder;
    private Dimension myLastSkinDimension;
    private ObjectProperty<Density> myDensity = new ObjectValueProperty<Density>(Density.MEDIUM);
    private OptionalProperty<Software> mySoftware = new OptionalValueProperty<Software>();
    private DoubleExpression myScreenDpi = new DoubleExpression(new ObservableValue[]{this.myScreenResolutionWidth, this.myScreenResolutionHeight, this.myDiagonalScreenSize}){

        @Override
        @NotNull
        public Double get() {
            return AvdScreenData.calculateDpi(((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue(), ((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue(), (Double)AvdDeviceData.this.myDiagonalScreenSize.get(), AvdDeviceData.this.myIsScreenRound.get());
        }
    };
    private ObservableBool mySkinSizeIsCompatible = new BooleanExpression(new ObservableValue[]{this.myScreenResolutionWidth, this.myScreenResolutionHeight, this.myCustomSkinFile}){

        @Override
        @NotNull
        public Boolean get() {
            if (!((Optional)AvdDeviceData.this.myCustomSkinFile.get()).isPresent()) {
                return true;
            }
            Dimension dimension = AvdDeviceData.this.getSkinDimension((File)AvdDeviceData.this.myCustomSkinFile.getValueOrNull());
            return dimension == null || dimension.getWidth() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue() && dimension.getHeight() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue() || dimension.getHeight() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue() && dimension.getWidth() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue();
        }
    };

    public AvdDeviceData() {
        Software software = new Software();
        software.setLiveWallpaperSupport(true);
        software.setGlVersion("2.0");
        this.mySoftware.setValue(software);
        this.myManufacturer.set("User");
        this.initDefaultValues();
        this.myDiagonalScreenSize.addConstraint(value -> Math.max(0.1, value));
        this.myScreenResolutionWidth.addConstraint(value -> Math.max(1, value));
        this.myScreenResolutionHeight.addConstraint(value -> Math.max(1, value));
    }

    public AvdDeviceData(@Nullable Device device, @Nullable SystemImageDescription systemImage) {
        this();
        if (device != null) {
            this.updateValuesFromDevice(device, systemImage);
        }
    }

    private static String getUniqueId(@Nullable String id) {
        return DeviceManagerConnection.getDefaultDeviceManagerConnection().getUniqueId(id);
    }

    public void setUniqueName(@NotNull String name) {
        this.myName.set(AvdDeviceData.getUniqueId(name));
    }

    @NotNull
    public StringProperty name() {
        return this.myName;
    }

    @NotNull
    public OptionalProperty<IdDisplay> deviceType() {
        return this.myDeviceType;
    }

    @NotNull
    public StringProperty manufacturer() {
        return this.myManufacturer;
    }

    @NotNull
    public StringProperty tagId() {
        return this.myTagId;
    }

    @NotNull
    public DoubleProperty diagonalScreenSize() {
        return this.myDiagonalScreenSize;
    }

    @NotNull
    public IntProperty screenResolutionWidth() {
        return this.myScreenResolutionWidth;
    }

    @NotNull
    public IntProperty screenResolutionHeight() {
        return this.myScreenResolutionHeight;
    }

    @NotNull
    public ObservableDouble screenDpi() {
        return this.myScreenDpi;
    }

    @NotNull
    public ObjectProperty<Storage> ramStorage() {
        return this.myRamStorage;
    }

    @NotNull
    public BoolProperty hasHardwareButtons() {
        return this.myHasHardwareButtons;
    }

    @NotNull
    public BoolProperty hasHardwareKeyboard() {
        return this.myHasHardwareKeyboard;
    }

    @NotNull
    public OptionalProperty<Navigation> navigation() {
        return this.myNavigation;
    }

    @NotNull
    public BoolProperty supportsLandscape() {
        return this.mySupportsLandscape;
    }

    @NotNull
    public BoolProperty notLong() {
        return this.myNotLong;
    }

    @NotNull
    public BoolProperty supportsPortrait() {
        return this.mySupportsPortrait;
    }

    @NotNull
    public BoolProperty hasFrontCamera() {
        return this.myHasFrontCamera;
    }

    @NotNull
    public BoolProperty hasBackCamera() {
        return this.myHasBackCamera;
    }

    @NotNull
    public BoolProperty hasAccelerometer() {
        return this.myHasAccelerometer;
    }

    @NotNull
    public BoolProperty hasGyroscope() {
        return this.myHasGyroscope;
    }

    @NotNull
    public BoolProperty hasGps() {
        return this.myHasGps;
    }

    @NotNull
    public BoolProperty hasProximitySensor() {
        return this.myHasProximitySensor;
    }

    @NotNull
    public OptionalProperty<Software> software() {
        return this.mySoftware;
    }

    @NotNull
    public OptionalProperty<File> customSkinFile() {
        return this.myCustomSkinFile;
    }

    @NotNull
    public BoolProperty isTv() {
        return this.myIsTv;
    }

    @NotNull
    public BoolProperty isWear() {
        return this.myIsWear;
    }

    @NotNull
    public BoolProperty isScreenRound() {
        return this.myIsScreenRound;
    }

    @NotNull
    public IntProperty screenChinSize() {
        return this.myScreenChinSize;
    }

    @NotNull
    public ObservableBool compatibleSkinSize() {
        return this.mySkinSizeIsCompatible;
    }

    @NotNull
    public ObjectProperty<Density> density() {
        return this.myDensity;
    }

    private void initDefaultValues() {
        this.myName.set(AvdDeviceData.getUniqueId(null));
        this.myDiagonalScreenSize.set(5.0);
        this.myScreenResolutionWidth.set(1080);
        this.myScreenResolutionHeight.set(1920);
        this.myRamStorage.set(new Storage(2L, Storage.Unit.GiB));
        this.myHasHardwareButtons.set(false);
        this.myHasHardwareKeyboard.set(false);
        this.myNavigation.setValue(Navigation.NONAV);
        this.mySupportsPortrait.set(true);
        this.mySupportsLandscape.set(true);
        this.myNotLong.set(false);
        this.myDensity.set(Density.MEDIUM);
        this.myHasFrontCamera.set(true);
        this.myHasBackCamera.set(true);
        this.myHasAccelerometer.set(true);
        this.myHasGyroscope.set(true);
        this.myHasGps.set(true);
        this.myHasProximitySensor.set(true);
    }

    @Nullable
    private Dimension getSkinDimension(@Nullable File skinFolder) {
        if (!FileUtil.filesEqual((File)skinFolder, (File)this.myLastSkinFolder)) {
            this.myLastSkinDimension = AvdDeviceData.computeSkinDimension(skinFolder);
            this.myLastSkinFolder = skinFolder;
        }
        return this.myLastSkinDimension;
    }

    @Nullable
    private static Dimension computeSkinDimension(@Nullable File skinFolder) {
        if (skinFolder == null || FileUtil.filesEqual((File)skinFolder, (File)AvdWizardUtils.NO_SKIN)) {
            return null;
        }
        File skinLayoutFile = new File(skinFolder, "layout");
        if (!skinLayoutFile.isFile()) {
            return null;
        }
        FileOp fop = FileOpUtils.create();
        SkinLayoutDefinition skin = SkinLayoutDefinition.parseFile(skinLayoutFile, fop);
        if (skin == null) {
            return null;
        }
        int height = StringUtil.parseInt((String)skin.get("parts.device.display.height"), (int)-1);
        int width = StringUtil.parseInt((String)skin.get("parts.device.display.width"), (int)-1);
        if (height <= 0 || width <= 0) {
            return null;
        }
        return new Dimension(width, height);
    }

    public void updateValuesFromDevice(@NotNull Device device, @Nullable SystemImageDescription systemImage) {
        this.myName.set(device.getDisplayName());
        String tagId = device.getTagId();
        if (((String)this.myTagId.get()).isEmpty()) {
            this.myTagId.set(SystemImage.DEFAULT_TAG.getId());
            this.myDeviceType.setValue(SystemImage.DEFAULT_TAG);
        } else {
            for (IdDisplay tag : AvdWizardUtils.ALL_DEVICE_TAGS) {
                if (!tag.getId().equals(tagId)) continue;
                this.myDeviceType.setValue(tag);
                break;
            }
        }
        Hardware defaultHardware = device.getDefaultHardware();
        Screen screen = defaultHardware.getScreen();
        this.myDiagonalScreenSize.set(screen.getDiagonalLength());
        this.myScreenResolutionWidth.set(screen.getXDimension());
        this.myScreenResolutionHeight.set(screen.getYDimension());
        this.myRamStorage.set(AvdWizardUtils.getDefaultRam(defaultHardware));
        this.myHasHardwareButtons.set(defaultHardware.getButtonType() == ButtonType.HARD);
        this.myHasHardwareKeyboard.set(defaultHardware.getKeyboard() != Keyboard.NOKEY);
        this.myNavigation.setValue(defaultHardware.getNav());
        this.myDensity.set(defaultHardware.getScreen().getPixelDensity());
        List states = device.getAllStates();
        this.mySupportsPortrait.set(false);
        this.mySupportsLandscape.set(false);
        for (State state : states) {
            if (state.isDefaultState()) {
                this.myDefaultState = state;
            }
            if (state.getOrientation().equals((Object)ScreenOrientation.PORTRAIT)) {
                this.mySupportsPortrait.set(true);
            }
            if (state.getOrientation().equals((Object)ScreenOrientation.LANDSCAPE)) {
                this.mySupportsLandscape.set(true);
            }
            if (!state.getHardware().getScreen().getRatio().equals((Object)ScreenRatio.NOTLONG)) continue;
            this.myNotLong.set(true);
        }
        this.myHasFrontCamera.set(defaultHardware.getCamera(CameraLocation.FRONT) != null);
        this.myHasBackCamera.set(defaultHardware.getCamera(CameraLocation.BACK) != null);
        this.myHasAccelerometer.set(defaultHardware.getSensors().contains(Sensor.ACCELEROMETER));
        this.myHasGyroscope.set(defaultHardware.getSensors().contains(Sensor.GYROSCOPE));
        this.myHasGps.set(defaultHardware.getSensors().contains(Sensor.GPS));
        this.myHasProximitySensor.set(defaultHardware.getSensors().contains(Sensor.PROXIMITY_SENSOR));
        this.myIsTv.set(HardwareConfigHelper.isTv((Device)device));
        this.myIsWear.set(HardwareConfigHelper.isWear((Device)device));
        this.myIsScreenRound.set(device.isScreenRound());
        this.myScreenChinSize.set(device.getChinSize());
        this.updateSkinFromDeviceAndSystemImage(device, systemImage);
    }

    public void updateSkinFromDeviceAndSystemImage(@NotNull Device device, @Nullable SystemImageDescription systemImage) {
        Hardware defaultHardware = device.getDefaultHardware();
        File skinFile = AvdWizardUtils.resolveSkinPath(defaultHardware.getSkinFile(), systemImage, FileOpUtils.create());
        this.myCustomSkinFile.setValue(skinFile == null ? AvdWizardUtils.NO_SKIN : skinFile);
    }

    @NotNull
    public Dimension getDeviceScreenDimension() {
        int finalHeight;
        int finalWidth;
        int width = (Integer)this.myScreenResolutionWidth.get();
        int height = (Integer)this.myScreenResolutionHeight.get();
        ScreenOrientation orientation = this.getDefaultDeviceOrientation();
        assert (width > 0 && height > 0);
        if (((Boolean)this.myNotLong.get()).booleanValue()) {
            finalWidth = width;
            finalHeight = height;
        } else if (orientation == ScreenOrientation.LANDSCAPE) {
            finalWidth = Math.max(width, height);
            finalHeight = Math.min(width, height);
        } else {
            finalWidth = Math.min(width, height);
            finalHeight = Math.max(width, height);
        }
        return new Dimension(finalWidth, finalHeight);
    }

    @NotNull
    public ScreenOrientation getDefaultDeviceOrientation() {
        if (this.myDefaultState != null && this.myDefaultState.getOrientation() == ScreenOrientation.LANDSCAPE && ((Boolean)this.mySupportsLandscape.get()).booleanValue()) {
            return ScreenOrientation.LANDSCAPE;
        }
        return (Boolean)this.mySupportsPortrait.get() != false ? ScreenOrientation.PORTRAIT : ((Boolean)this.mySupportsLandscape.get() != false ? ScreenOrientation.LANDSCAPE : ScreenOrientation.SQUARE);
    }
}

