/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.ConfigureDeviceModel;
import com.android.tools.idea.avdmanager.ConfigureDeviceOptionsStep;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceUiAction
implements Action {
    @NotNull
    protected final DeviceProvider myProvider;
    @NotNull
    private final String myText;

    public DeviceUiAction(@NotNull DeviceProvider provider, @NotNull String text) {
        this.myProvider = provider;
        this.myText = text;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Override
    public Object getValue(String key) {
        return "Name".equals(key) ? this.myText : null;
    }

    @Override
    public void putValue(String key, Object value) {
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    static void showHardwareProfileWizard(ConfigureDeviceModel model) {
        ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(new ConfigureDeviceOptionsStep(model)).build();
        new StudioWizardDialogBuilder(wizard, "Hardware Profile Configuration").setProject(model.getProject()).build().show();
    }

    public static interface DeviceProvider {
        @Nullable
        public Device getDevice();

        public void refreshDevices();

        public void setDevice(@Nullable Device var1);

        public void selectDefaultDevice();

        @Nullable
        public Project getProject();
    }
}

