/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.avdmanager.EmulatorProcessHandler;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorRunner {
    private final GeneralCommandLine myCommandLine;
    private ProcessHandler myProcessHandler;
    private final List<ProcessListener> myExtraListeners = new ArrayList<ProcessListener>();

    public EmulatorRunner(@NotNull GeneralCommandLine commandLine, @Nullable AvdInfo avdInfo) {
        this.myCommandLine = commandLine;
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.DEPLOYMENT_TO_EMULATOR);
        if (avdInfo != null) {
            event.setDeviceInfo(DeviceInfo.newBuilder().setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)avdInfo.getAbiType())).setBuildApiLevelFull(avdInfo.getAndroidVersion().toString()));
        }
        UsageTracker.getInstance().log(event);
    }

    public ProcessHandler start() throws ExecutionException {
        Process process = this.myCommandLine.createProcess();
        this.myProcessHandler = new EmulatorProcessHandler(process, this.myCommandLine);
        this.myProcessHandler.startNotify();
        return this.myProcessHandler;
    }

    public void addProcessListener(@NotNull ProcessListener listener) {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.addProcessListener(listener);
        } else {
            this.myExtraListeners.add(listener);
        }
    }

    public static class ProcessOutputCollector
    extends ProcessAdapter {
        private final StringBuilder sb = new StringBuilder();

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            this.sb.append(event.getText());
        }

        public String getText() {
            return this.sb.toString();
        }
    }
}

